#ifndef _flick_aoi_h
#define _flick_aoi_h

#include <rpc/types.h>
#include <rpc/xdr.h>

typedef int aoi_ref;
bool_t xdr_aoi_ref();

#define aoi_ref_null -1

typedef struct aoi_type_u *aoi_type;
bool_t xdr_aoi_type();


typedef struct aoi_const_u *aoi_const;
bool_t xdr_aoi_const();


typedef long aoi_const_int;
bool_t xdr_aoi_const_int();


typedef char aoi_const_char;
bool_t xdr_aoi_const_char();


typedef double aoi_const_float;
bool_t xdr_aoi_const_float();


typedef struct {
	u_int aoi_const_struct_len;
	aoi_const *aoi_const_struct_val;
} aoi_const_struct;
bool_t xdr_aoi_const_struct();


typedef struct {
	u_int aoi_const_array_len;
	aoi_const *aoi_const_array_val;
} aoi_const_array;
bool_t xdr_aoi_const_array();


enum aoi_const_kind {
	AOI_CONST_INT = 1,
	AOI_CONST_CHAR = 2,
	AOI_CONST_FLOAT = 3,
	AOI_CONST_STRUCT = 4,
	AOI_CONST_ARRAY = 5,
};
typedef enum aoi_const_kind aoi_const_kind;
bool_t xdr_aoi_const_kind();


struct aoi_const_u {
	aoi_const_kind kind;
	union {
		aoi_const_int const_int;
		aoi_const_char const_char;
		aoi_const_float const_float;
		aoi_const_struct const_struct;
		aoi_const_array const_array;
	} aoi_const_u_u;
};
typedef struct aoi_const_u aoi_const_u;
bool_t xdr_aoi_const_u();


struct aoi_field {
	char *name;
	aoi_type type;
};
typedef struct aoi_field aoi_field;
bool_t xdr_aoi_field();


struct aoi_integer {
	int min;
	u_int range;
};
typedef struct aoi_integer aoi_integer;
bool_t xdr_aoi_integer();


struct aoi_float {
	int bits;
};
typedef struct aoi_float aoi_float;
bool_t xdr_aoi_float();

typedef u_int aoi_char_flags;
bool_t xdr_aoi_char_flags();

#define AOI_CHAR_FLAG_NONE 0
#define AOI_CHAR_FLAG_SIGNED 1
#define AOI_CHAR_FLAG_UNSIGNED 2

struct aoi_char {
	int bits;
	aoi_char_flags flags;
};
typedef struct aoi_char aoi_char;
bool_t xdr_aoi_char();


typedef u_int aoi_scalar_flags;
bool_t xdr_aoi_scalar_flags();

#define AOI_SCALAR_FLAG_NONE 0
#define AOI_SCALAR_FLAG_SIGNED 1
#define AOI_SCALAR_FLAG_UNSIGNED 2

struct aoi_scalar {
	int bits;
	aoi_scalar_flags flags;
};
typedef struct aoi_scalar aoi_scalar;
bool_t xdr_aoi_scalar();


typedef u_int aoi_array_flags;
bool_t xdr_aoi_array_flags();

#define AOI_ARRAY_FLAG_NONE 0x00000000
#define AOI_ARRAY_FLAG_NULL_TERMINATED_STRING 0x00000001
#define AOI_ARRAY_FLAG_OPAQUE 0x00000002
#define AOI_ARRAY_FLAG_ALL 0x00000003

struct aoi_array {
	aoi_type element_type;
	aoi_type length_type;
	aoi_array_flags flgs;
};
typedef struct aoi_array aoi_array;
bool_t xdr_aoi_array();


typedef aoi_field aoi_struct_slot;
bool_t xdr_aoi_struct_slot();


struct aoi_struct {
	struct {
		u_int slots_len;
		aoi_struct_slot *slots_val;
	} slots;
};
typedef struct aoi_struct aoi_struct;
bool_t xdr_aoi_struct();


struct aoi_union_case {
	aoi_const val;
	aoi_field var;
};
typedef struct aoi_union_case aoi_union_case;
bool_t xdr_aoi_union_case();


struct aoi_union {
	aoi_field discriminator;
	char *union_label;
	struct {
		u_int cases_len;
		aoi_union_case *cases_val;
	} cases;
	aoi_field *dfault;
};
typedef struct aoi_union aoi_union;
bool_t xdr_aoi_union();


enum aoi_direction {
	AOI_DIR_IN = 1,
	AOI_DIR_OUT = 2,
	AOI_DIR_INOUT = 3,
	AOI_DIR_RET = 4,
};
typedef enum aoi_direction aoi_direction;
bool_t xdr_aoi_direction();


struct aoi_parameter {
	char *name;
	aoi_direction direction;
	aoi_type type;
};
typedef struct aoi_parameter aoi_parameter;
bool_t xdr_aoi_parameter();


typedef u_int aoi_op_flags;
bool_t xdr_aoi_op_flags();

#define AOI_OP_FLAG_NONE 0x00000000
#define AOI_OP_FLAG_ONEWAY 0x00000001
#define AOI_OP_FLAG_IDEMPOTENT 0x00000002

struct aoi_operation {
	char *name;
	aoi_const request_code;
	aoi_const reply_code;
	aoi_op_flags flags;
	struct {
		u_int params_len;
		aoi_parameter *params_val;
	} params;
	aoi_type return_type;
	struct {
		u_int exceps_len;
		aoi_type *exceps_val;
	} exceps;
};
typedef struct aoi_operation aoi_operation;
bool_t xdr_aoi_operation();


struct aoi_attribute {
	char *name;
	aoi_const read_request_code;
	aoi_const read_reply_code;
	aoi_const write_request_code;
	aoi_const write_reply_code;
	aoi_type type;
	bool_t readonly;
};
typedef struct aoi_attribute aoi_attribute;
bool_t xdr_aoi_attribute();


typedef aoi_field aoi_exception_slot;
bool_t xdr_aoi_exception_slot();


struct aoi_exception {
	struct {
		u_int slots_len;
		aoi_exception_slot *slots_val;
	} slots;
};
typedef struct aoi_exception aoi_exception;
bool_t xdr_aoi_exception();


enum aoi_idl_id {
	AOI_IDL_CORBA = 1,
	AOI_IDL_MIG = 2,
	AOI_IDL_SUN = 3,
	AOI_IDL_DCE = 4,
};
typedef enum aoi_idl_id aoi_idl_id;
bool_t xdr_aoi_idl_id();


struct aoi_interface {
	aoi_idl_id idl;
	aoi_type code_type;
	aoi_const code;
	struct {
		u_int parents_len;
		aoi_type *parents_val;
	} parents;
	aoi_type op_code_type;
	struct {
		u_int ops_len;
		aoi_operation *ops_val;
	} ops;
	struct {
		u_int attribs_len;
		aoi_attribute *attribs_val;
	} attribs;
	struct {
		u_int excepts_len;
		aoi_type *excepts_val;
	} excepts;
};
typedef struct aoi_interface aoi_interface;
bool_t xdr_aoi_interface();


struct aoi_enum {
	char *enum_label;
	struct {
		u_int defs_len;
		struct aoi_field *defs_val;
	} defs;
};
typedef struct aoi_enum aoi_enum;
bool_t xdr_aoi_enum();


struct aoi_optional {
	aoi_type type;
};
typedef struct aoi_optional aoi_optional;
bool_t xdr_aoi_optional();


enum aoi_kind {
	AOI_INDIRECT = 1,
	AOI_INTEGER = 2,
	AOI_FLOAT = 3,
	AOI_CHAR = 4,
	AOI_ARRAY = 5,
	AOI_STRUCT = 6,
	AOI_UNION = 7,
	AOI_INTERFACE = 8,
	AOI_EXCEPTION = 9,
	AOI_ENUM = 10,
	AOI_VOID = 11,
	AOI_CONST = 12,
	AOI_NAMESPACE = 13,
	AOI_OPTIONAL = 14,
	AOI_FWD_INTRFC = 15,
	AOI_ANY = 16,
	AOI_ERROR = 17,
	AOI_SCALAR = 18,
	AOI_FPAGE = 19,
	AOI_L4STRING = 20,
	AOI_INTRFC = 21,   /* this is the encryption-type */
};
typedef enum aoi_kind aoi_kind;
bool_t xdr_aoi_kind();


struct aoi_type_u {
	aoi_kind kind;
	union {
		aoi_ref indirect_ref;
		aoi_integer integer_def;
		aoi_float float_def;
		aoi_char char_def;
		aoi_array array_def;
		aoi_struct struct_def;
		aoi_union union_def;
		aoi_interface interface_def;
		aoi_exception exception_def;
		aoi_enum enum_def;
		aoi_const const_def;
		aoi_optional optional_def;
		aoi_scalar scalar_def;
	} aoi_type_u_u;
};
typedef struct aoi_type_u aoi_type_u;
bool_t xdr_aoi_type_u();


enum inclusion {
	NOT_INCLUDED = 0,
	INCLUDED = 1,
	IMPLIED = 2,
};
typedef enum inclusion inclusion;
bool_t xdr_inclusion();


struct aoi_def {
	char *name;
	int scope;
	inclusion included;
	aoi_type binding;
};
typedef struct aoi_def aoi_def;
bool_t xdr_aoi_def();


typedef struct {
	u_int aoi_len;
	aoi_def *aoi_val;
} aoi;
bool_t xdr_aoi();

#endif /* _flick_aoi_h */
