/*
 * Copyright (c) 1995, 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#ifndef _mom_libcast_h_
#define _mom_libcast_h_

#ifdef __cplusplus
extern "C" {
#endif

#include <mom/cast.h>

int cast_add_def(cast_scope *scope);
int cast_add_func_def(cast_scope *scope, char *name, int params);
	
int cast_find_def(cast_scope *scope, const char *name);
cast_type cast_find_typedef_type(cast_scope *scope, cast_type name_ctype);
cast_enum_type *cast_find_enum_type(cast_scope *scope, cast_type ctype);
cast_struct_type *cast_find_struct_type(cast_scope *scope, cast_type ctype);
cast_union_type *cast_find_union_type(cast_scope *scope, cast_type ctype);

int cast_func_add_param(cast_func_type *func);
int cast_call_add_param(cast_expr call_expr);

void cast_block_add_stmt(cast_block *b, cast_stmt st);
void cast_struct_add_slot(cast_type type, char *slot_name, cast_type slot_type);
void cast_union_add_case(cast_type type, char *case_name, cast_type case_type);


/* Routines to cons up various common cast nodes.  */
cast_type cast_new_type_name(char *name);
cast_type cast_new_prim_type(cast_primitive_kind kind, cast_primitive_modifier mod);
cast_type cast_new_prim_alias(cast_primitive_kind kind, cast_primitive_modifier mod, const char *name);
cast_type cast_new_struct_type(int slots);
cast_type cast_new_union_type(int cases);
cast_type cast_new_array_type(cast_expr length, cast_type element_type);
cast_type cast_new_pointer_type(cast_type target_type);
cast_type cast_new_fuction_type(cast_type return_type, int params);
cast_type cast_new_qualified_type(cast_type actual, cast_type_qualifier qual);
cast_type cast_new_type(cast_type_kind kind);

cast_expr cast_new_expr_name(char *name);
cast_expr cast_new_expr_lit_char(char val, cast_primitive_modifier mod);
cast_expr cast_new_expr_lit_int(long long val, cast_primitive_modifier mod);
cast_expr cast_new_expr_lit_float(float val);
cast_expr cast_new_expr_lit_double(double val, cast_primitive_modifier mod);
cast_expr cast_new_expr_lit_string(char *str);
cast_expr cast_new_expr_assign_to_zero(cast_expr expr, cast_type ctype,
				       cast_scope *scope);
cast_expr cast_new_unary_expr(cast_unary_op op, cast_expr sub);
cast_expr cast_new_binary_expr(cast_binary_op op, cast_expr a, cast_expr b);
cast_expr cast_new_expr_op_assign(cast_binary_op op, cast_expr a, cast_expr b);
cast_expr cast_new_expr_assign(cast_expr to, cast_expr from);
cast_expr cast_new_expr_call(cast_expr func, int params);
cast_expr cast_new_expr_call_0(cast_expr func);
cast_expr cast_new_expr_call_1(cast_expr func,
			       cast_expr p0);
cast_expr cast_new_expr_call_2(cast_expr func,
			       cast_expr p0, cast_expr p1);
cast_expr cast_new_expr_call_3(cast_expr func,
			       cast_expr p0, cast_expr p1, cast_expr p2);
cast_expr cast_new_expr_call_4(cast_expr func,
			       cast_expr p0, cast_expr p1, cast_expr p2,
			       cast_expr p3);
cast_expr cast_new_expr_call_5(cast_expr func,
			       cast_expr p0, cast_expr p1, cast_expr p2,
			       cast_expr p3, cast_expr p4);
cast_expr cast_new_expr_sel(cast_expr var_expr, char *member);
cast_expr cast_new_expr_sizeof_expr(cast_expr expr);
cast_expr cast_new_expr_sizeof_type(cast_type type);
cast_expr cast_new_expr_cast(cast_expr expr, cast_type type);
cast_expr cast_new_expr_cond(cast_expr test,
			     cast_expr true_expr, cast_expr false_expr);
cast_expr cast_new_expr(cast_expr_kind kind);

cast_stmt cast_new_stmt_expr(cast_expr expr);
cast_stmt cast_new_block(int defs, int stmts);
cast_stmt cast_new_break(void);
cast_stmt cast_new_label(char *name, cast_stmt sub_stmt);
cast_stmt cast_new_case(cast_expr expr, cast_stmt sub_stmt);
cast_stmt cast_new_default(cast_stmt sub_stmt);
cast_stmt cast_new_if(cast_expr test, cast_stmt true_stmt, cast_stmt false_stmt);
cast_stmt cast_new_switch(cast_expr test, cast_stmt body);
cast_stmt cast_new_while(cast_expr test, cast_stmt body);
cast_stmt cast_new_do(cast_expr test, cast_stmt body);
cast_stmt cast_new_for(cast_expr init, cast_expr test, cast_expr iter, cast_stmt body);
cast_stmt cast_new_goto(char *label);
cast_stmt cast_new_return(cast_expr return_val);
cast_stmt cast_new_stmt(cast_stmt_kind kind);


/* Check various cast constructs for consistency and completeness, using assert().  */
void cast_check_primitive_type(cast_primitive_kind kind, cast_primitive_modifier mod);
void cast_check_struct_type(cast_struct_type *stype);
void cast_check_union_type(cast_union_type *utype);
void cast_check_func_type(cast_func_type *ftype);
void cast_check_type(cast_type type);
void cast_check_expr(cast_expr expr);
void cast_check_block(cast_block *block);
void cast_check_stmt(cast_stmt stmt);
void cast_check_init(cast_init init);
void cast_check_def(cast_def *def);
void cast_check_enum(cast_enum_type *et);
void cast_check(cast_scope *scope);


/* Routines to deep-compare cast trees to see if they are equivalent.
   The value returned is ordered, as with strcmp;
   thus it is possible to use this routine to sort cast trees.  */
int cast_cmp_type(cast_type a, cast_type b);


/* Routine to dereference any CAST_TYPE_NAME ctype references. */
cast_type cast_dename(cast_1 *cast, cast_type c);

/* Routines to output cast trees as C code.  */
void cast_w_type(char *name, cast_type d, int indent);
void cast_w_func_type(char *name, cast_func_type *fd, int indent);
void cast_w_def(cast_scope *scope, int def_idx/*XXX*/, int indent);
void cast_w_scope(cast_scope *scope, int indent);

void cast_w_expr_noncomma(cast_expr expr, int indent);
void cast_w_expr(cast_expr expr, int indent);

void cast_w_init(cast_init init, int indent);

void cast_w_block(cast_block *block, int indent);
void cast_w_stmt(cast_stmt st, int indent);


#ifdef __cplusplus
}
#endif

#endif _mom_libcast_h_
