/*
 * Copyright (c) 1995, 1996, 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#ifndef _mom_libpres_c_h_
#define _mom_libpres_c_h_

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>

#include <mom/pres_c.h>


void pres_c_1_check(pres_c_1 *pres);
void pres_c_1_readfh(pres_c_1 *dest, FILE *fh);
void pres_c_1_writefh(pres_c_1 *src, FILE *fh);


/* Constructors for pres_c nodes.  */
pres_c_inline pres_c_new_inline_atom(pres_c_inline_index idx, pres_c_mapping map);
pres_c_inline pres_c_new_inline_struct(int slots);
pres_c_inline pres_c_new_inline_func_params_struct(int slots);
pres_c_inline pres_c_new_inline_struct_union(int mappings);
pres_c_inline pres_c_new_inline_virtual_union(int mappings);
pres_c_inline pres_c_new_inline(pres_c_inline_kind kind);
pres_c_mapping pres_c_new_mapping(pres_c_mapping_kind kind);


/* Add a new slot to the specified pres_c_inline_struct, and return its index.  */
int pres_c_add_inline_struct_slot(pres_c_inline inl);


/* Given a simple MINT itype, this returns the name of a corresponding MOM ctype.  */
char *mint_to_ctype_name(mint_1 *mint, mint_ref itype);

/* Given a simple MINT type,
   produce a ctype appropriate for storing that itype.  */
cast_type mint_to_ctype(mint_1 *mint, mint_ref itype);

/* Given an initial itype which must be a MINT_UNION
   and a pres_c_inline which must be a PRES_C_INLINE_COLLAPSED_UNION,
   find the appropriate case in the union selected by the presentation
   and return the new itype and pres_c_inline corresponding to it.
   Note that `itypep' and `inlp' are in-out parameters.  */
void descend_collapsed_union(pres_c_1 *pres, mint_ref *itypep, pres_c_inline *inlp);

/* Upon encountering a PRES_C_MAPPING_STUB node while descending a mapping tree,
   this routine finds a stub that can marshal/unmarshal between the itype and the ctype.
   Returns -1 if none found.  */
int pres_c_find_mu_stub(pres_c_1 *pres, mint_ref itype, cast_type ctype, pres_c_mapping map,
			pres_c_stub_kind stub_kind);

/* Given an itype, ctype, and PRES_C_MAPPING_STUB,
   this routine finds a stub that can marshal/unmarshal between the itype and ctype,
   and bumps the mapping and ctype pointers to point into the stub's mapping and ctype,
   essentially dereferencing through the level of indirection.
   Note that this shouldn't be done blindly and unconditionally,
   because there can be recursion through stub mappings.  */
void pres_descend_mapping_stub(pres_c_1 *pres, mint_ref itype,
				cast_type *ctypep, pres_c_mapping *mapp);


/* Given a ctype and mapping,
   return a new ctype and mapping which is identical
   except that it imposes one additional level of pointer indirection.
   `ptr_alloc_flags' defines the allocation semantics for the new pointer,
   and `ptr_allocator' defines the allocator to use for allocation.  */
void pres_c_interpose_pointer(cast_type *inout_ctype, pres_c_mapping *inout_mapping,
			      int ptr_alloc_flags, char *ptr_allocator);

/*
 * Given a mapping, return a new mapping that encapsulates the original mapping
 * but which tells the back end what kind of parameter the mapping corresponds
 * to: `in', `out', etc.
 */
void pres_c_interpose_direction(pres_c_mapping *inout_mapping,
				aoi_direction aoi_dir);

/*
 * Given a mapping, return a new mapping that encapsulates the original
 * mapping but indicates a storage place is (will be) reserved for the
 * expression and type of the data, which will be used elsewhere.
 */
void pres_c_interpose_argument(pres_c_mapping *inout_mapping,
			       const char *name);

#ifdef __cplusplus
}
#endif

#endif _mom_libpres_c_h_
