/*
 * Copyright (c) 1995, 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#ifndef _mom_c_pbe_target_h_
#define _mom_c_pbe_target_h_

#include <mom/types.h>
#include <mom/c/pbe.hh>



/* Target reference marshaler.
   This is a very simple mu_state class
   that can be handy for dealing with the `target_i' fields
   found in most of the stub presentations in pres_c.
   When it digs the object reference out of the C function parameters (or whatever),
   it simply invokes a macro/function "flick_<be>_<op>_target".  */
struct target_mu_state : public mu_state
{
	target_mu_state(pres_c_1 *_pres, mu_state_op _op, int _assumptions, char *which);

	/* We should never need these when marshaling an object target,
	   so provide implementations that simply panic when called.
	   That way subclasses don't have to define them needlessly.  */
	virtual mu_state *another(mu_state_op _op);
	virtual int get_most_packable() 
	{
		return 1;
	}
	
	virtual void mu_mapping_simple(cast_expr expr, cast_type ctype, mint_ref itype);

	virtual void mu_mapping_reference(cast_expr expr, cast_type ctype, mint_ref itype,
					  pres_c_mapping_reference *rmap);
	
	virtual void mu_mapping_string(cast_expr /*ptr*/,
				       cast_type /*ptr_ctype*/,
				       mint_array_def */*arr*/,
				       pres_c_allocation */*mem_alloc*/) {};
	
	virtual target_mu_state *mu_make_target_mu_state(pres_c_1 *pres,
							 mu_state_op op,
							 int assumptions,
							 char *which);
	virtual client_mu_state *mu_make_client_mu_state(pres_c_1 *pres,
							 mu_state_op op,
							 int assumptions,
							 char *which);
};



#endif _mom_c_pbe_target_h_
