#ifndef _flick_cast_h
#define _flick_cast_h

#include <rpc/types.h>
#include <rpc/xdr.h>
#include <mom/aoi.h>

typedef struct cast_type_u *cast_type;
bool_t xdr_cast_type();


typedef struct cast_expr_u *cast_expr;
bool_t xdr_cast_expr();


typedef struct cast_stmt_u *cast_stmt;
bool_t xdr_cast_stmt();


typedef struct cast_init_u *cast_init;
bool_t xdr_cast_init();


typedef struct {
	u_int cast_scope_len;
	struct cast_def *cast_scope_val;
} cast_scope;
bool_t xdr_cast_scope();


struct cast_field {
	char *name;
	cast_type type;
};
typedef struct cast_field cast_field;
bool_t xdr_cast_field();


enum cast_primitive_kind {
	CAST_PRIM_CHAR = 1,
	CAST_PRIM_INT = 2,
	CAST_PRIM_FLOAT = 3,
	CAST_PRIM_DOUBLE = 4,
};
typedef enum cast_primitive_kind cast_primitive_kind;
bool_t xdr_cast_primitive_kind();


typedef char *alias;
bool_t xdr_alias();


typedef u_int cast_primitive_modifier;
bool_t xdr_cast_primitive_modifier();

#define CAST_MOD_SIGNED 0x0001
#define CAST_MOD_UNSIGNED 0x0002
#define CAST_MOD_SHORT 0x0010
#define CAST_MOD_LONG 0x0020
#define CAST_MOD_LONG_LONG 0x0040
#define CAST_MOD_SHORT4 0x0080
#define CAST_MOD_SHORT2 0x0100
#define CAST_MOD_SHORT1 0x0200

struct cast_primitive_type {
	cast_primitive_kind kind;
	cast_primitive_modifier mod;
	alias *name;
};
typedef struct cast_primitive_type cast_primitive_type;
bool_t xdr_cast_primitive_type();


typedef cast_field cast_struct_slot;
bool_t xdr_cast_struct_slot();


struct cast_enum_field {
	char *name;
	cast_expr val;
};
typedef struct cast_enum_field cast_enum_field;
bool_t xdr_cast_enum_field();


struct cast_enum_type {
	char *name;
	struct {
		u_int slots_len;
		cast_enum_field *slots_val;
	} slots;
};
typedef struct cast_enum_type cast_enum_type;
bool_t xdr_cast_enum_type();


struct cast_struct_type {
	char *name;
	struct {
		u_int slots_len;
		cast_struct_slot *slots_val;
	} slots;
};
typedef struct cast_struct_type cast_struct_type;
bool_t xdr_cast_struct_type();


struct cast_array_type {
	cast_expr length;
	cast_type element_type;
};
typedef struct cast_array_type cast_array_type;
bool_t xdr_cast_array_type();


typedef cast_field cast_union_case;
bool_t xdr_cast_union_case();


struct cast_union_type {
	char *name;
	struct {
		u_int cases_len;
		cast_union_case *cases_val;
	} cases;
};
typedef struct cast_union_type cast_union_type;
bool_t xdr_cast_union_type();


struct cast_pointer_type {
	cast_type target;
};
typedef struct cast_pointer_type cast_pointer_type;
bool_t xdr_cast_pointer_type();


typedef cast_field cast_func_param;
bool_t xdr_cast_func_param();


struct cast_func_type {
	struct {
		u_int params_len;
		cast_func_param *params_val;
	} params;
	cast_type return_type;
};
typedef struct cast_func_type cast_func_type;
bool_t xdr_cast_func_type();


typedef int cast_type_qualifier;
bool_t xdr_cast_type_qualifier();

#define CAST_TQ_CONST 0x01
#define CAST_TQ_VOLATILE 0x02

struct cast_qualified_type {
	cast_type_qualifier qual;
	cast_type actual;
};
typedef struct cast_qualified_type cast_qualified_type;
bool_t xdr_cast_qualified_type();


enum cast_type_kind {
	CAST_TYPE_NAME = 1,
	CAST_TYPE_PRIMITIVE = 2,
	CAST_TYPE_STRUCT = 3,
	CAST_TYPE_UNION = 4,
	CAST_TYPE_ARRAY = 5,
	CAST_TYPE_POINTER = 6,
	CAST_TYPE_FUNCTION = 7,
	CAST_TYPE_ENUM = 8,
	CAST_TYPE_STRUCT_NAME = 9,
	CAST_TYPE_UNION_NAME = 10,
	CAST_TYPE_ENUM_NAME = 11,
	CAST_TYPE_VOID = 12,
	CAST_TYPE_QUALIFIED = 13,
	CAST_TYPE_FPAGE = 14,
	CAST_TYPE_L4STRING = 15,
	CAST_TYPE_INTRFC = 16,
};
typedef enum cast_type_kind cast_type_kind;
bool_t xdr_cast_type_kind();


struct cast_type_u {
	cast_type_kind kind;
	union {
		char *name;
		cast_primitive_type primitive_type;
		cast_struct_type struct_type;
		cast_union_type union_type;
		cast_pointer_type pointer_type;
		cast_array_type array_type;
		cast_func_type func_type;
		cast_enum_type enum_type;
		char *struct_name;
		char *union_name;
		char *enum_name;
		cast_qualified_type qualified;
	} cast_type_u_u;
};
typedef struct cast_type_u cast_type_u;
bool_t xdr_cast_type_u();


struct cast_lit_prim_u {
	cast_primitive_kind kind;
	union {
		char c;
		long i;
		float f;
		double d;
	} cast_lit_prim_u_u;
};
typedef struct cast_lit_prim_u cast_lit_prim_u;
bool_t xdr_cast_lit_prim_u();


struct cast_lit_prim {
	cast_primitive_modifier mod;
	cast_lit_prim_u u;
};
typedef struct cast_lit_prim cast_lit_prim;
bool_t xdr_cast_lit_prim();


struct cast_expr_call {
	cast_expr func;
	struct {
		u_int params_len;
		cast_expr *params_val;
	} params;
};
typedef struct cast_expr_call cast_expr_call;
bool_t xdr_cast_expr_call();


struct cast_expr_sel {
	cast_expr var;
	char *member;
};
typedef struct cast_expr_sel cast_expr_sel;
bool_t xdr_cast_expr_sel();


enum cast_unary_op {
	CAST_UNARY_DEREF = 1,
	CAST_UNARY_ADDR = 2,
	CAST_UNARY_NEG = 3,
	CAST_UNARY_LNOT = 4,
	CAST_UNARY_BNOT = 5,
	CAST_UNARY_PRE_INC = 6,
	CAST_UNARY_PRE_DEC = 7,
	CAST_UNARY_POST_INC = 8,
	CAST_UNARY_POST_DEC = 9,
};
typedef enum cast_unary_op cast_unary_op;
bool_t xdr_cast_unary_op();


struct cast_unary_expr {
	cast_unary_op op;
	cast_expr expr;
};
typedef struct cast_unary_expr cast_unary_expr;
bool_t xdr_cast_unary_expr();


struct cast_expr_cast {
	cast_expr expr;
	cast_type type;
};
typedef struct cast_expr_cast cast_expr_cast;
bool_t xdr_cast_expr_cast();


enum cast_binary_op {
	CAST_BINARY_MUL = 1,
	CAST_BINARY_DIV = 2,
	CAST_BINARY_MOD = 3,
	CAST_BINARY_ADD = 4,
	CAST_BINARY_SUB = 5,
	CAST_BINARY_SHL = 6,
	CAST_BINARY_SHR = 7,
	CAST_BINARY_LT = 8,
	CAST_BINARY_GT = 9,
	CAST_BINARY_LE = 10,
	CAST_BINARY_GE = 11,
	CAST_BINARY_EQ = 12,
	CAST_BINARY_NE = 13,
	CAST_BINARY_BAND = 14,
	CAST_BINARY_BXOR = 15,
	CAST_BINARY_BOR = 16,
	CAST_BINARY_LAND = 17,
	CAST_BINARY_LOR = 18,
	CAST_BINARY_ASSIGN = 19,
	CAST_BINARY_COMMA = 20,
};
typedef enum cast_binary_op cast_binary_op;
bool_t xdr_cast_binary_op();


struct cast_binary_expr {
	cast_binary_op op;
	cast_expr expr[2];
};
typedef struct cast_binary_expr cast_binary_expr;
bool_t xdr_cast_binary_expr();


struct cast_cond_expr {
	cast_expr test;
	cast_expr true_expr;
	cast_expr false_expr;
};
typedef struct cast_cond_expr cast_cond_expr;
bool_t xdr_cast_cond_expr();


enum cast_expr_kind {
	CAST_EXPR_NAME = 1,
	CAST_EXPR_LIT_PRIM = 2,
	CAST_EXPR_LIT_STRING = 3,
	CAST_EXPR_CALL = 4,
	CAST_EXPR_SEL = 5,
	CAST_EXPR_UNARY = 6,
	CAST_EXPR_CAST = 7,
	CAST_EXPR_SIZEOF_EXPR = 8,
	CAST_EXPR_SIZEOF_TYPE = 9,
	CAST_EXPR_BINARY = 10,
	CAST_EXPR_OP_ASSIGN = 11,
	CAST_EXPR_COND = 12,
};
typedef enum cast_expr_kind cast_expr_kind;
bool_t xdr_cast_expr_kind();


struct cast_expr_u {
	cast_expr_kind kind;
	union {
		char *name;
		cast_lit_prim lit_prim;
		char *lit_string;
		cast_expr_call call;
		cast_expr_sel sel;
		cast_unary_expr unary;
		cast_expr_cast cast;
		cast_expr sizeof_expr;
		cast_type sizeof_type;
		cast_binary_expr binary;
		cast_binary_expr op_assign;
		cast_cond_expr cond;
	} cast_expr_u_u;
};
typedef struct cast_expr_u cast_expr_u;
bool_t xdr_cast_expr_u();


struct cast_block {
	cast_scope scope;
	struct {
		u_int stmts_len;
		cast_stmt *stmts_val;
	} stmts;
};
typedef struct cast_block cast_block;
bool_t xdr_cast_block();


struct cast_if {
	cast_expr test;
	cast_stmt true_stmt;
	cast_stmt false_stmt;
};
typedef struct cast_if cast_if;
bool_t xdr_cast_if();


struct cast_while {
	cast_expr test;
	cast_stmt stmt;
};
typedef struct cast_while cast_while;
bool_t xdr_cast_while();


struct cast_for {
	cast_expr init;
	cast_expr test;
	cast_expr iter;
	cast_stmt stmt;
};
typedef struct cast_for cast_for;
bool_t xdr_cast_for();


struct cast_switch {
	cast_expr test;
	cast_stmt stmt;
};
typedef struct cast_switch cast_switch;
bool_t xdr_cast_switch();


struct cast_label {
	char *label;
	cast_stmt stmt;
};
typedef struct cast_label cast_label;
bool_t xdr_cast_label();


struct cast_case {
	cast_expr label;
	cast_stmt stmt;
};
typedef struct cast_case cast_case;
bool_t xdr_cast_case();


enum cast_stmt_kind {
	CAST_STMT_EXPR = 1,
	CAST_STMT_BLOCK = 2,
	CAST_STMT_IF = 3,
	CAST_STMT_WHILE = 4,
	CAST_STMT_DO_WHILE = 5,
	CAST_STMT_FOR = 6,
	CAST_STMT_SWITCH = 7,
	CAST_STMT_BREAK = 8,
	CAST_STMT_CONTINUE = 9,
	CAST_STMT_GOTO = 10,
	CAST_STMT_LABEL = 11,
	CAST_STMT_CASE = 12,
	CAST_STMT_DEFAULT = 13,
	CAST_STMT_RETURN = 14,
	CAST_STMT_TEXT = 15,
	CAST_STMT_NULL = 16,
};
typedef enum cast_stmt_kind cast_stmt_kind;
bool_t xdr_cast_stmt_kind();


struct cast_stmt_u {
	cast_stmt_kind kind;
	union {
		cast_expr expr;
		cast_block block;
		cast_if s_if;
		cast_while s_while;
		cast_while s_do_while;
		cast_for s_for;
		cast_switch s_switch;
		char *goto_label;
		cast_label s_label;
		cast_case s_case;
		cast_stmt default_stmt;
		cast_expr return_expr;
		char *text;
	} cast_stmt_u_u;
};
typedef struct cast_stmt_u cast_stmt_u;
bool_t xdr_cast_stmt_u();


struct cast_func_def {
	cast_func_type type;
	cast_block block;
};
typedef struct cast_func_def cast_func_def;
bool_t xdr_cast_func_def();


enum cast_init_kind {
	CAST_INIT_EXPR = 1,
	CAST_INIT_AGGREGATE = 2,
};
typedef enum cast_init_kind cast_init_kind;
bool_t xdr_cast_init_kind();


struct cast_init_u {
	cast_init_kind kind;
	union {
		cast_expr expr;
		struct {
			u_int subs_len;
			cast_init *subs_val;
		} subs;
	} cast_init_u_u;
};
typedef struct cast_init_u cast_init_u;
bool_t xdr_cast_init_u();


struct cast_var_def {
	cast_type type;
	cast_init init;
};
typedef struct cast_var_def cast_var_def;
bool_t xdr_cast_var_def();


struct cast_include {
	char *filename;
	bool_t system_only;
};
typedef struct cast_include cast_include;
bool_t xdr_cast_include();


struct cast_direct {
	char *code_string;
};
typedef struct cast_direct cast_direct;
bool_t xdr_cast_direct();


enum cast_storage_class {
	CAST_SC_NONE = 0,
	CAST_SC_AUTO = 1,
	CAST_SC_STATIC = 2,
	CAST_SC_EXTERN = 3,
	CAST_SC_REGISTER = 4,
};
typedef enum cast_storage_class cast_storage_class;
bool_t xdr_cast_storage_class();


enum cast_def_kind {
	CAST_TYPEDEF = 1,
	CAST_STRUCT = 2,
	CAST_UNION = 3,
	CAST_ENUM = 4,
	CAST_FUNC_DECL = 6,
	CAST_FUNC_DEF = 7,
	CAST_VAR_DECL = 8,
	CAST_VAR_DEF = 9,
	CAST_DEFINE = 10,
	CAST_INCLUDE = 11,
	CAST_DIRECT_CODE = 12,
};
typedef enum cast_def_kind cast_def_kind;
bool_t xdr_cast_def_kind();


struct cast_def_u {
	cast_def_kind kind;
	union {
		cast_type typedef_type;
		cast_struct_type struct_type;
		cast_union_type union_type;
		cast_enum_type enum_type;
		cast_func_type func_type;
		cast_func_def func_def;
		cast_type var_type;
		cast_var_def var_def;
		cast_expr define_as;
		cast_include include;
		cast_direct direct;
	} cast_def_u_u;
};
typedef struct cast_def_u cast_def_u;
bool_t xdr_cast_def_u();


struct cast_def {
	char *name;
	cast_storage_class sc;
	cast_def_u u;
	inclusion included;
};
typedef struct cast_def cast_def;
bool_t xdr_cast_def();


typedef cast_scope cast_1;
bool_t xdr_cast_1();

#endif /* _flick_cast_h */
