#ifndef _flick_pres_c_h
#define _flick_pres_c_h

#include <rpc/types.h>
#include <rpc/xdr.h>
#include <mom/mint.h>
#include <mom/cast.h>
#include <mom/aoi.h>

typedef int cast_ref;
bool_t xdr_cast_ref();


typedef struct pres_c_inline_u *pres_c_inline;
bool_t xdr_pres_c_inline();


typedef struct pres_c_mapping_u *pres_c_mapping;
bool_t xdr_pres_c_mapping();


typedef u_int pres_c_alloc_flags;
bool_t xdr_pres_c_alloc_flags();

#define PRES_C_ALLOC_NEVER 0x00000000
#define PRES_C_ALLOC_IF_NULL 0x00000001
#define PRES_C_ALLOC_IF_TOO_SMALL 0x00000002
#define PRES_C_ALLOC_IF_TOO_LARGE 0x00000004
#define PRES_C_ALLOC_ALWAYS 0x00000008
#define PRES_C_ALLOC_EVER 0x0000000f
#define PRES_C_ALLOC_CLEAR 0x00000010
#define PRES_C_REALLOC_IF_TOO_SMALL 0x00000200
#define PRES_C_REALLOC_IF_TOO_LARGE 0x00000400
#define PRES_C_REALLOC_ALWAYS 0x00000800
#define PRES_C_REALLOC_EVER 0x00000f00
#define PRES_C_REALLOC_CLEAR 0x00001000
#define PRES_C_FAIL_IF_TOO_SMALL 0x00002000
#define PRES_C_DEALLOC_NEVER 0x00000000
#define PRES_C_DEALLOC_ALWAYS 0x00080000
#define PRES_C_DEALLOC_EVER 0x000f0000
#define PRES_C_DEALLOC_NULLIFY 0x00100000

struct pres_c_allocation {
	pres_c_alloc_flags flags;
	char *allocator;
};
typedef struct pres_c_allocation pres_c_allocation;
bool_t xdr_pres_c_allocation();


typedef int pres_c_inline_index;
bool_t xdr_pres_c_inline_index();


struct pres_c_inline_atom {
	pres_c_inline_index index;
	pres_c_mapping mapping;
};
typedef struct pres_c_inline_atom pres_c_inline_atom;
bool_t xdr_pres_c_inline_atom();


struct pres_c_inline_struct_slot {
	int mint_struct_slot_index;
	pres_c_inline inl;
};
typedef struct pres_c_inline_struct_slot pres_c_inline_struct_slot;
bool_t xdr_pres_c_inline_struct_slot();


struct pres_c_inline_struct {
	struct {
		u_int slots_len;
		pres_c_inline_struct_slot *slots_val;
	} slots;
};
typedef struct pres_c_inline_struct pres_c_inline_struct;
bool_t xdr_pres_c_inline_struct();


struct pres_c_inline_func_params_struct {
	struct {
		u_int slots_len;
		pres_c_inline_struct_slot *slots_val;
	} slots;
	pres_c_inline_struct_slot *return_slot;
};
typedef struct pres_c_inline_func_params_struct pres_c_inline_func_params_struct;
bool_t xdr_pres_c_inline_func_params_struct();


struct pres_c_inline_struct_union_case {
	int index;
	pres_c_mapping mapping;
};
typedef struct pres_c_inline_struct_union_case pres_c_inline_struct_union_case;
bool_t xdr_pres_c_inline_struct_union_case();


struct pres_c_inline_struct_union {
	pres_c_inline_atom discrim;
	pres_c_inline_index union_index;
	struct {
		u_int cases_len;
		pres_c_inline_struct_union_case *cases_val;
	} cases;
	pres_c_inline_struct_union_case *dfault;
};
typedef struct pres_c_inline_struct_union pres_c_inline_struct_union;
bool_t xdr_pres_c_inline_struct_union();


struct pres_c_inline_void_union_case {
	cast_expr case_value;
	cast_type type;
	pres_c_mapping mapping;
};
typedef struct pres_c_inline_void_union_case pres_c_inline_void_union_case;
bool_t xdr_pres_c_inline_void_union_case();


struct pres_c_inline_void_union {
	pres_c_inline_atom discrim;
	pres_c_inline_index void_index;
	struct {
		u_int cases_len;
		pres_c_inline_void_union_case *cases_val;
	} cases;
	pres_c_inline_void_union_case *dfault;
};
typedef struct pres_c_inline_void_union pres_c_inline_void_union;
bool_t xdr_pres_c_inline_void_union();


struct pres_c_inline_expanded_union {
	pres_c_inline_atom discrim;
	struct {
		u_int cases_len;
		pres_c_inline *cases_val;
	} cases;
	pres_c_inline dfault;
};
typedef struct pres_c_inline_expanded_union pres_c_inline_expanded_union;
bool_t xdr_pres_c_inline_expanded_union();


struct pres_c_inline_collapsed_union {
	mint_const discrim_val;
	pres_c_inline selected_case;
};
typedef struct pres_c_inline_collapsed_union pres_c_inline_collapsed_union;
bool_t xdr_pres_c_inline_collapsed_union();


struct pres_c_inline_virtual_union_case {
	cast_type ctype;
	pres_c_mapping map;
	char *name;
};
typedef struct pres_c_inline_virtual_union_case pres_c_inline_virtual_union_case;
bool_t xdr_pres_c_inline_virtual_union_case();


struct pres_c_inline_virtual_union {
	pres_c_inline_virtual_union_case discrim;
	struct {
		u_int cases_len;
		pres_c_inline_virtual_union_case *cases_val;
	} cases;
	pres_c_inline_virtual_union_case *dfault;
};
typedef struct pres_c_inline_virtual_union pres_c_inline_virtual_union;
bool_t xdr_pres_c_inline_virtual_union();


struct pres_c_inline_typed {
	pres_c_inline tag;
	pres_c_inline inl;
};
typedef struct pres_c_inline_typed pres_c_inline_typed;
bool_t xdr_pres_c_inline_typed();


struct pres_c_inline_counted_array {
	pres_c_inline len;
	pres_c_inline max;
	pres_c_inline_atom ptr;
	int ptr_levels;
};
typedef struct pres_c_inline_counted_array pres_c_inline_counted_array;
bool_t xdr_pres_c_inline_counted_array();


struct pres_c_inline_terminated_array {
	int terminator;
	pres_c_inline max;
	pres_c_inline_atom ptr;
	pres_c_allocation alloc;
};
typedef struct pres_c_inline_terminated_array pres_c_inline_terminated_array;
bool_t xdr_pres_c_inline_terminated_array();


struct pres_c_inline_xlate {
	pres_c_inline sub;
	pres_c_inline_index index;
	cast_type internal_ctype;
	pres_c_alloc_flags alloc_flags;
	char *translator;
	char *destructor;
};
typedef struct pres_c_inline_xlate pres_c_inline_xlate;
bool_t xdr_pres_c_inline_xlate();


struct pres_c_inline_assign {
	pres_c_inline sub;
	pres_c_inline_index index;
	cast_expr value;
};
typedef struct pres_c_inline_assign pres_c_inline_assign;
bool_t xdr_pres_c_inline_assign();


struct pres_c_inline_cond {
	pres_c_inline_index index;
	pres_c_inline true_inl;
	pres_c_inline false_inl;
};
typedef struct pres_c_inline_cond pres_c_inline_cond;
bool_t xdr_pres_c_inline_cond();


enum pres_c_message_attribute_kind {
	PRES_C_MESSAGE_ATTRIBUTE_FLAGS = 0,
	PRES_C_MESSAGE_ATTRIBUTE_TIMEOUT = 1,
	PRES_C_MESSAGE_ATTRIBUTE_SEQUENCE_RECEIVED = 2,
	PRES_C_MESSAGE_ATTRIBUTE_CLIENT_REFERENCE = 3,
	PRES_C_MESSAGE_ATTRIBUTE_SERVERCOPY = 4,
};
typedef enum pres_c_message_attribute_kind pres_c_message_attribute_kind;
bool_t xdr_pres_c_message_attribute_kind();


struct pres_c_inline_message_attribute {
	pres_c_message_attribute_kind kind;
};
typedef struct pres_c_inline_message_attribute pres_c_inline_message_attribute;
bool_t xdr_pres_c_inline_message_attribute();


enum pres_c_inline_kind {
	PRES_C_INLINE_ATOM = 1,
	PRES_C_INLINE_STRUCT = 2,
	PRES_C_INLINE_FUNC_PARAMS_STRUCT = 3,
	PRES_C_INLINE_STRUCT_UNION = 5,
	PRES_C_INLINE_EXPANDED_UNION = 6,
	PRES_C_INLINE_VOID_UNION = 7,
	PRES_C_INLINE_COLLAPSED_UNION = 8,
	PRES_C_INLINE_EMBEDDED_ARRAY = 10,
	PRES_C_INLINE_EOS_ARRAY = 11,
	PRES_C_INLINE_COUNTED_ARRAY = 12,
	PRES_C_INLINE_TERMINATED_ARRAY = 13,
	PRES_C_INLINE_LIST_ARRAY = 14,
	PRES_C_INLINE_TYPED = 15,
	PRES_C_INLINE_THROWAWAY = 16,
	PRES_C_INLINE_XLATE = 17,
	PRES_C_INLINE_ASSIGN = 18,
	PRES_C_INLINE_COND = 19,
	PRES_C_INLINE_VIRTUAL_UNION = 20,
	PRES_C_INLINE_MESSAGE_ATTRIBUTE = 21,
};
typedef enum pres_c_inline_kind pres_c_inline_kind;
bool_t xdr_pres_c_inline_kind();


struct pres_c_inline_u {
	pres_c_inline_kind kind;
	union {
		pres_c_inline_atom atom;
		pres_c_inline_struct struct_i;
		pres_c_inline_func_params_struct func_params_i;
		pres_c_inline_struct_union struct_union;
		pres_c_inline_expanded_union expanded_union;
		pres_c_inline_void_union void_union;
		pres_c_inline_collapsed_union collapsed_union;
		pres_c_inline_virtual_union virtual_union;
		pres_c_inline_typed typed;
		pres_c_inline_counted_array counted_array;
		pres_c_inline_terminated_array terminated_array;
		pres_c_inline_xlate xlate;
		pres_c_inline_assign assign;
		pres_c_inline_cond cond;
		pres_c_inline_message_attribute msg_attr;
	} pres_c_inline_u_u;
};
typedef struct pres_c_inline_u pres_c_inline_u;
bool_t xdr_pres_c_inline_u();


struct pres_c_mapping_stub {
	int mapping_stub_index;
};
typedef struct pres_c_mapping_stub pres_c_mapping_stub;
bool_t xdr_pres_c_mapping_stub();


enum pres_c_direction {
	PRES_C_DIRECTION_UNKNOWN = 0,
	PRES_C_DIRECTION_IN = 1,
	PRES_C_DIRECTION_INOUT = 2,
	PRES_C_DIRECTION_OUT = 3,
	PRES_C_DIRECTION_RETURN = 4,
};
typedef enum pres_c_direction pres_c_direction;
bool_t xdr_pres_c_direction();


struct pres_c_mapping_direction {
	pres_c_direction dir;
	pres_c_mapping mapping;
};
typedef struct pres_c_mapping_direction pres_c_mapping_direction;
bool_t xdr_pres_c_mapping_direction();


struct pres_c_mapping_pointer {
	pres_c_allocation alloc;
	pres_c_mapping target;
};
typedef struct pres_c_mapping_pointer pres_c_mapping_pointer;
bool_t xdr_pres_c_mapping_pointer();


struct pres_c_mapping_optional_pointer {
	pres_c_allocation alloc;
	pres_c_mapping target;
};
typedef struct pres_c_mapping_optional_pointer pres_c_mapping_optional_pointer;
bool_t xdr_pres_c_mapping_optional_pointer();


typedef pres_c_inline pres_c_mapping_struct;
bool_t xdr_pres_c_mapping_struct();


struct pres_c_mapping_fixed_array {
	pres_c_allocation alloc;
	u_int length;
	pres_c_mapping element_mapping;
};
typedef struct pres_c_mapping_fixed_array pres_c_mapping_fixed_array;
bool_t xdr_pres_c_mapping_fixed_array();


struct pres_c_mapping_terminated_array {
	pres_c_allocation alloc;
	int terminator;
	u_int max;
	pres_c_mapping element_mapping;
};
typedef struct pres_c_mapping_terminated_array pres_c_mapping_terminated_array;
bool_t xdr_pres_c_mapping_terminated_array();


struct pres_c_mapping_flat_union {
	pres_c_mapping discrim;
	struct {
		u_int cases_len;
		pres_c_mapping *cases_val;
	} cases;
	pres_c_mapping dfault;
};
typedef struct pres_c_mapping_flat_union pres_c_mapping_flat_union;
bool_t xdr_pres_c_mapping_flat_union();


struct pres_c_mapping_special {
	char *marshaler_name;
};
typedef struct pres_c_mapping_special pres_c_mapping_special;
bool_t xdr_pres_c_mapping_special();


struct pres_c_mapping_xlate {
	cast_type internal_ctype;
	pres_c_mapping internal_mapping;
	pres_c_alloc_flags alloc_flags;
	char *translator;
	char *destructor;
};
typedef struct pres_c_mapping_xlate pres_c_mapping_xlate;
bool_t xdr_pres_c_mapping_xlate();


enum pres_c_reference_kind {
	PRES_C_REFERENCE_COPY = 0,
	PRES_C_REFERENCE_MOVE = 1,
	PRES_C_REFERENCE_COPY_AND_CONVERT = 2,
};
typedef enum pres_c_reference_kind pres_c_reference_kind;
bool_t xdr_pres_c_reference_kind();


struct pres_c_mapping_reference {
	pres_c_reference_kind kind;
	int ref_count;
};
typedef struct pres_c_mapping_reference pres_c_mapping_reference;
bool_t xdr_pres_c_mapping_reference();


enum pres_c_sid_kind {
	PRES_C_SID_CLIENT = 0,
	PRES_C_SID_SERVER = 1,
};
typedef enum pres_c_sid_kind pres_c_sid_kind;
bool_t xdr_pres_c_sid_kind();


struct pres_c_mapping_sid {
	pres_c_sid_kind kind;
};
typedef struct pres_c_mapping_sid pres_c_mapping_sid;
bool_t xdr_pres_c_mapping_sid();


struct pres_c_mapping_message_attribute {
	pres_c_message_attribute_kind kind;
};
typedef struct pres_c_mapping_message_attribute pres_c_mapping_message_attribute;
bool_t xdr_pres_c_mapping_message_attribute();


struct pres_c_mapping_argument {
	char *arg_name;
	pres_c_mapping map;
};
typedef struct pres_c_mapping_argument pres_c_mapping_argument;
bool_t xdr_pres_c_mapping_argument();


enum pres_c_mapping_kind {
	PRES_C_MAPPING_DIRECT = 0,
	PRES_C_MAPPING_STUB = 1,
	PRES_C_MAPPING_POINTER = 2,
	PRES_C_MAPPING_FIXED_ARRAY = 3,
	PRES_C_MAPPING_TERMINATED_ARRAY = 4,
	PRES_C_MAPPING_STRUCT = 5,
	PRES_C_MAPPING_FLAT_UNION = 6,
	PRES_C_MAPPING_SPECIAL = 7,
	PRES_C_MAPPING_XLATE = 8,
	PRES_C_MAPPING_REFERENCE = 9,
	PRES_C_MAPPING_TYPE_TAG = 10,
	PRES_C_MAPPING_OPTIONAL_POINTER = 11,
	PRES_C_MAPPING_IGNORE = 12,
	PRES_C_MAPPING_SYSTEM_EXCEPTION = 13,
	PRES_C_MAPPING_DIRECTION = 14,
	PRES_C_MAPPING_SID = 15,
	PRES_C_MAPPING_ARGUMENT = 16,
	PRES_C_MAPPING_MESSAGE_ATTRIBUTE = 17,
};
typedef enum pres_c_mapping_kind pres_c_mapping_kind;
bool_t xdr_pres_c_mapping_kind();


struct pres_c_mapping_u {
	pres_c_mapping_kind kind;
	union {
		pres_c_mapping_stub mapping_stub;
		pres_c_mapping_pointer pointer;
		pres_c_mapping_fixed_array fixed_array;
		pres_c_mapping_terminated_array terminated_array;
		pres_c_mapping_struct struct_i;
		pres_c_mapping_flat_union flat_union;
		pres_c_mapping_special special;
		pres_c_mapping_xlate xlate;
		pres_c_mapping_reference ref;
		pres_c_mapping_optional_pointer optional_pointer;
		pres_c_mapping_direction direction;
		pres_c_mapping_sid sid;
		pres_c_mapping_argument argument;
		pres_c_mapping_message_attribute message_attribute;
	} pres_c_mapping_u_u;
};
typedef struct pres_c_mapping_u pres_c_mapping_u;
bool_t xdr_pres_c_mapping_u();

#define pres_c_func_return_index -1

struct pres_c_marshal_stub {
	cast_ref c_func;
	mint_ref itype;
	pres_c_inline i;
	pres_c_inline target_i;
	pres_c_mapping seethru_map;
};
typedef struct pres_c_marshal_stub pres_c_marshal_stub;
bool_t xdr_pres_c_marshal_stub();


typedef u_int pres_c_stub_op_flags;
bool_t xdr_pres_c_stub_op_flags();

#define PRES_C_STUB_OP_FLAG_NONE        0x00000000
#define PRES_C_STUB_OP_FLAG_ONEWAY      0x00000001
#define PRES_C_STUB_OP_FLAG_IDEMPOTENT  0x00000002
#define PRES_C_STUB_OP_FLAG_PROPAGATE   0x00000004

struct pres_c_client_stub {
	cast_ref c_func;
	pres_c_stub_op_flags op_flags;
	mint_ref request_itype;
	mint_ref reply_itype;
	pres_c_inline request_i;
	pres_c_inline reply_i;
	mint_ref target_itype;
	pres_c_inline target_i;
	mint_ref client_itype;
	pres_c_inline client_i;
	mint_ref error_itype;
	pres_c_inline error_i;
};
typedef struct pres_c_client_stub pres_c_client_stub;
bool_t xdr_pres_c_client_stub();


struct pres_c_server_func {
	cast_ref c_func;
	pres_c_stub_op_flags op_flags;
	pres_c_inline request_i;
	pres_c_inline reply_i;
	mint_ref target_itype;
	pres_c_inline target_i;
	mint_ref client_itype;
	pres_c_inline client_i;
	mint_ref error_itype;
	pres_c_inline error_i;
};
typedef struct pres_c_server_func pres_c_server_func;
bool_t xdr_pres_c_server_func();


struct pres_c_server_skel {
	cast_ref c_def;
	mint_ref request_itype;
	mint_ref reply_itype;
	struct {
		u_int funcs_len;
		pres_c_server_func *funcs_val;
	} funcs;
};
typedef struct pres_c_server_skel pres_c_server_skel;
bool_t xdr_pres_c_server_skel();


struct pres_c_msg_stub {
	cast_ref c_func;
	mint_ref msg_itype;
	pres_c_inline msg_i;
	mint_ref target_itype;
	pres_c_inline target_i;
};
typedef struct pres_c_msg_stub pres_c_msg_stub;
bool_t xdr_pres_c_msg_stub();


typedef pres_c_msg_stub pres_c_send_stub;
bool_t xdr_pres_c_send_stub();


typedef pres_c_msg_stub pres_c_reply_stub;
bool_t xdr_pres_c_reply_stub();


enum pres_c_stub_kind {
	PRES_C_MARSHAL_STUB = 1,
	PRES_C_UNMARSHAL_STUB = 2,
	PRES_C_CLIENT_STUB = 3,
	PRES_C_SERVER_SKEL = 4,
	PRES_C_SEND_STUB = 5,
	PRES_C_RECEIVE_FUNC = 6,
	PRES_C_REPLY_STUB = 7,
};
typedef enum pres_c_stub_kind pres_c_stub_kind;
bool_t xdr_pres_c_stub_kind();


struct pres_c_stub {
	pres_c_stub_kind kind;
	union {
		pres_c_marshal_stub mstub;
		pres_c_marshal_stub ustub;
		pres_c_client_stub cstub;
		pres_c_server_skel sskel;
		pres_c_send_stub send_stub;
		pres_c_reply_stub reply_stub;
	} pres_c_stub_u;
};
typedef struct pres_c_stub pres_c_stub;
bool_t xdr_pres_c_stub();


struct pres_c_1 {
	mint_1 mint;
	cast_1 cast;
	aoi a;
	struct {
		u_int stubs_len;
		pres_c_stub *stubs_val;
	} stubs;
	char *pres_context;
};
typedef struct pres_c_1 pres_c_1;
bool_t xdr_pres_c_1();

#endif /* _flick_pres_c_h_ */
