/*
 * Copyright (c) 1995, 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#ifdef RPC_HDR
%#ifndef _flick_pres_c_h
%#define _flick_pres_c_h
%
%#include <rpc/types.h>
%#include <rpc/xdr.h>
%#include <mom/mint.h>
%#include <mom/cast.h>
%#include <mom/aoi.h>
#endif
/* itype: interface type.
   ptype: presentation type.
*/

/* Things to add maybe:
	* Way to throwaway values upon receipt, producing constants upon send.
	  Not sure of the usefulness.
	  (Or maybe check values against constants upon receipt.)
*/

/* In many cases a pres_c_decl does not directly map to any interface construct,
   but is used as part of a pres_c_decl or pres_c_inline that _does_ map to some interface.
   For example, a pres_c_inline_counted_array specifies the index number of a variable
   which must be a pointer to the appropriate type.
   The pres_c_decl for the pointer variable's type itself does not have any mapping,
   but it is understood by its context
   that it is part of a presentation that does have a mapping.  */

/* It is not generally necessary or desirable
   for presentation mappings to indicate which interface type they map.
   Only the "top-level" presentation declarations
   that directly cause the PBE to produce something need this.
   In all other cases, the interface type can easily be found based on context.
   Conveniently, this allows a single ptype to map multiple itypes -
   e.g. a C 'int' ptype that maps multiple integerish itypes.
   However, this "feature" is very limited,
   since the kind and format of the presentation mapping
   must simultaneously match all interface types it is supposed to map.  */

/* Possible ways to deal with exceptions on the client side:
   1 Invoke a non-returning function.
   2 Invoke a returning function, and return its result as an error/status code.  (May be void.)
   3 Throw an exception using the MOM runtime library's exception mechanism.
     Really just #1 with some sugar coating.
     But decoding is done on the way down through the stack, not initially...?
   4 Invoke a returning function, and retry the call, possibly with different arguments?
   5 Fill in an 'exception' out parameter and return a status code.
   6 Just return a status code.

   As far as client-side stub generation is concerned,
   the only thing it ever has to do is call a particular routine
   if an encoding/decoding error occurs or if an unexpected reply is received.

   Possible ways to deal with exceptions on the server side:
   1 Call a generic/specific routine to set the exception status before returning.
   2 Call a generic/specific non-returning "throw" routine.
   3 Fill an 'exception' out parameter and return a status code.
   4 Just return a status code.
*/


typedef int cast_ref;


/* These are kludges to get around the limitations of current C language mappings.  */
typedef struct pres_c_inline_u *pres_c_inline;
typedef struct pres_c_mapping_u *pres_c_mapping;



typedef u_int pres_c_alloc_flags;

/* These are applied just before the RPC system "produces" some data
   into the memory pointed to by a C pointer.  */
const PRES_C_ALLOC_NEVER		= 0x00000000;
const PRES_C_ALLOC_IF_NULL		= 0x00000001;
const PRES_C_ALLOC_IF_TOO_SMALL		= 0x00000002;
const PRES_C_ALLOC_IF_TOO_LARGE		= 0x00000004;
const PRES_C_ALLOC_ALWAYS		= 0x00000008;
const PRES_C_ALLOC_EVER			= 0x0000000f;
const PRES_C_ALLOC_CLEAR		= 0x00000010;
const PRES_C_REALLOC_IF_TOO_SMALL	= 0x00000200;
const PRES_C_REALLOC_IF_TOO_LARGE	= 0x00000400;
const PRES_C_REALLOC_ALWAYS		= 0x00000800;
const PRES_C_REALLOC_EVER		= 0x00000f00;
const PRES_C_REALLOC_CLEAR		= 0x00001000;
const PRES_C_FAIL_IF_TOO_SMALL		= 0x00002000;

/* These are applied just after the RPC system has "consumed" some C data
   from the memory pointed to by the C pointer.  */
const PRES_C_DEALLOC_NEVER		= 0x00000000;
const PRES_C_DEALLOC_ALWAYS		= 0x00080000;
const PRES_C_DEALLOC_EVER		= 0x000f0000;
const PRES_C_DEALLOC_NULLIFY		= 0x00100000;

struct pres_c_allocation
{
	/* Flags specifying the allocation/deallocation behavior for a pointer.  */
	pres_c_alloc_flags	flags;

	/* Name of allocator to use when allocating or deallocating instances of this ptype.
	   Could be made more flexible (e.g. refer to a function prototype),
	   but that's probably not needed.  */
	string			allocator<>;
};



/***** Inlines *****/


/*
 * C structure slot/function parameter index to which a particular inlined atom
 * is mapped.  Each slot must be referred to exactly once in the inline tree.
 */
typedef int pres_c_inline_index;

struct pres_c_inline_atom
{
	/* Which slot/parameter maps this itype.  */
	pres_c_inline_index	index;

	/* How that slot/parameter's ptype maps to this itype.  */
	pres_c_mapping		mapping;
};

struct pres_c_inline_struct_slot
{
	/*
	 * `mint_struct_slot_index' indicates which slot in the MINT structure
	 * corresponds to the `pres_c_inline' contained in this PRES_C node.
	 * If the value of this field is `mint_slot_index_null' (-1), then
	 * there is no underlying MINT.
	 *
	 * Previously, when `pres_c_inline_structs' were used to handle stub
	 * parameters, there was an implicit assocation between `slot[i]' in
	 * the `pres_c_inline_struct' and `slot[i]' in the MINT structure type.
	 * But this proved to be a problem: If we wanted to handle a parameter
	 * via PRES_C, we *had* to have an underlying MINT slot for the param.
	 *
	 * Why was this a problem?  Because some parameters, such as SIDs, are
	 * presentation-only notions, and should not be represented by anything
	 * in the MINT.  MINT should describe *only* IDL-specified interfaces
	 * (as represented by AOI), and should *not* need to be modified in
	 * order for a presentation generator to insert special parameters such
	 * as SIDs.
	 *
	 * So, previously, in order to add SID parameters to a stub signature,
	 * the presentation generator was forced to modify the underlying MINT
	 * structure and insert a slot, so that `mu_state::mu_inline_struct'
	 * could make the correct PRES_C node <--> MINT node associations.
	 *
	 * The addition of `mint_struct_slot_index' solves this problem.  We
	 * can now create arbitrary PRES_C slot <--> MINT slot associations,
	 * and create PRES_C nodes to handle stub parameters for which there is
	 * no underlying MINT.
	 */
	int			mint_struct_slot_index;
	pres_c_inline		inl;
};

/*
 * One might be tempted to do this:
 *     typedef pres_c_inline_struct_slot pres_c_inline_struct_slots<>;
 * until one remembers that the names of the structure slots would be:
 *     pres_c_inline_struct_slots_{len,val}
 * and you think about your poor fingers.  On the whole, it's easier to just
 * declare the sequence types inline in `pres_c_inline_*_struct', below.
 */

struct pres_c_inline_struct
{
	/*
	 * One for each slot in the interface-defined structure.
	 */
	pres_c_inline_struct_slot	slots<>;
};

/*
 * A `pres_c_inline_func_params_struct' connects a CAST function declaration
 * (the parameter list and return value) with a MINT_STRUCT representing the
 * set of parameter and return values contained within a request or reply
 * message.
 *
 * Previously, Flick just used a `pres_c_inline_struct' to connect the CAST and
 * MINT for a function signature.  But this made it difficult to distinguish
 * the return value from the other function parameters, and different message
 * formats may position a return value at different places in the message (i.e.
 * before or after the `out' and `inout' values).  So now, the PG creates a
 * `pres_c_inline_func_params_struct' instead, so that the return value can be
 * easily distinguished.
 */
struct pres_c_inline_func_params_struct
{
	/*
	 * One element for each parameter contained in this message.
	 */
	pres_c_inline_struct_slot	slots<>;
	
	/*
	 * And in replies, an slot for the return value as well.
	 */
	pres_c_inline_struct_slot	*return_slot;
};

/* This is used for struct-unions and void*-unions.  */
struct pres_c_inline_struct_union_case
{
	/* `index' indicates which member of the union CAST type we should
	   use in this case.  In other words, it tells us which slot of the
	   CAST union we should make reference to.  Note that `index' is an
	   `int' and not a `pres_c_inline_index' because conceptually, we are
	   *mapping*, not *inlining*, the union case.  As a practical matter,
	   however, it doesn't really make a difference.
	   */
	int			index;
	
	/* `mapping' tells us how this case's ptype and itype are related. */
	pres_c_mapping		mapping;
};

struct pres_c_inline_struct_union
{
	pres_c_inline_atom			discrim;
	pres_c_inline_index			union_index;
	pres_c_inline_struct_union_case		cases<>;
	pres_c_inline_struct_union_case		*dfault;
};

struct pres_c_inline_void_union_case
{
	/* 
	 * this is the CAST literal value of the discriminator in this
	 * branch.  It is needed when the discriminated value is used
         * in the presentation and not just when deciphering the message.
	 * This is only used when the discriminator uses
	 * PRES_C_MAPPING_IGNORE.  Otherwise, it is nil.
         */ 
	cast_expr case_value;

	/* the type is the cast_type to cast the void* to */
	cast_type type;
	pres_c_mapping mapping;
};

struct pres_c_inline_void_union
{
	pres_c_inline_atom			discrim;
	pres_c_inline_index			void_index;
	pres_c_inline_void_union_case		cases<>;
	pres_c_inline_void_union_case		*dfault;
};

struct pres_c_inline_expanded_union
{
	pres_c_inline_atom	discrim;
	pres_c_inline		cases<>;
	pres_c_inline		dfault;
};
/* A collapsed union presentation is valid
   only for one specific, constant union branch.
   A union sent from this presentation always has a particular discriminator;
   receiving a union into a presentation of this kind
   causes unions with any other discriminator value to be rejected.
   This is commonly used to differentiate between different "remote procedures"
   that might be called through a single message data type.  */
struct pres_c_inline_collapsed_union
{
	mint_const		discrim_val;
	pres_c_inline		selected_case;
};

/* A virtual union (I prefer arbitrary, but it's harder to type than virtual)
   specifies a union that is essentially arbitrary.
   It's sole reason for being (at this writing) is to allow
   mapping of exceptions instead of the 'normal' return result.
   Currently, the discriminator is pitched after it has been switched on,
   and it is and integer.  The back end should deal with it...
*/

struct pres_c_inline_virtual_union_case {
	cast_type ctype;
	pres_c_mapping map;
	string name<>;
};

struct pres_c_inline_virtual_union
{
	pres_c_inline_virtual_union_case discrim;
	pres_c_inline_virtual_union_case cases<>;
	pres_c_inline_virtual_union_case *dfault;
};

struct pres_c_inline_typed
{
	pres_c_inline		tag;
	pres_c_inline		inl;
};

struct pres_c_inline_counted_array
{
	pres_c_inline		len;
	pres_c_inline		max;

	/* ptr.mapping must be (at least one level of) PRES_C_MAPPING_POINTER.
	   ptr_levels indicates how many _additional_ levels of pointer indirection
	   there are before we reach the pointer to the actual elements of the array.
	   For example, if ptr_levels is 1,
	   then ptr.mapping contains a pointer mapping,
	   which contains another pointer mapping,
	   which contains the mapping for an individual array element.  */
	pres_c_inline_atom	ptr;
	int			ptr_levels;
};


struct pres_c_inline_terminated_array
{
	int			terminator;
	pres_c_inline		max;
	pres_c_inline_atom	ptr;
	pres_c_allocation	alloc;
};

struct pres_c_inline_xlate
{
	/* the _real_ pres_c_inline... */
	pres_c_inline		sub;

	pres_c_inline_index	index;
	cast_type		internal_ctype;

	pres_c_alloc_flags	alloc_flags;

	string			translator<>;
	string			destructor<>;
};

struct pres_c_inline_assign
{
	/* the _real_ pres_c_inline... */
	pres_c_inline		sub;

	pres_c_inline_index     index;
	cast_expr		value;
};

struct pres_c_inline_cond
{
	/* This index must refer to a boolean C variable
	   (or at least an integerish type that can be used as a boolean).
	   At runtime, if the value of that C variable(/parameter/slot) is true,
	   marshal using true_inl; otherwise use false_inl.  */
	pres_c_inline_index     index;
	pres_c_inline		true_inl;
	pres_c_inline		false_inl;
};

/*
 * A `pres_c_inline_message_attribute' tells us that the corresponding data
 * will access/change an attribute of the message being sent or received.
 * The difference between the inline and mapping versions of this is
 * that the inline has no corresponding CAST.  The inline node is used
 * simply to encode/decode a known message attribute into/from the message.
 * The mapping node is used to [un]marshal a parameter as a message attribute.
 * Currently this is only implemented for MIG.
 */
enum pres_c_message_attribute_kind
{
	/* sets some attribute flags */
	PRES_C_MESSAGE_ATTRIBUTE_FLAGS = 0,

	/* how long to wait for reply */
	PRES_C_MESSAGE_ATTRIBUTE_TIMEOUT = 1,

	/* index of when received */
	PRES_C_MESSAGE_ATTRIBUTE_SEQUENCE_RECEIVED = 2,

	/* client reference */
	PRES_C_MESSAGE_ATTRIBUTE_CLIENT_REFERENCE = 3,

	/* flag indicating work function should make its own copy of
	   the data if it wants to keep it */
	PRES_C_MESSAGE_ATTRIBUTE_SERVERCOPY = 4

	/* maybe in the future, SID will be moved here */
};

struct pres_c_inline_message_attribute
{
	pres_c_message_attribute_kind	kind;
};

enum pres_c_inline_kind
{
	/* Non-inlined instance of an arbitrary ptype.  */
	PRES_C_INLINE_ATOM			= 1,

	/* Inlined struct.  Corresponding itype must be MINT_STRUCT.  */
	PRES_C_INLINE_STRUCT			= 2,
	PRES_C_INLINE_FUNC_PARAMS_STRUCT	= 3,
	
	/* Union presentations.  Corresponding itype must be MINT_UNION.  */
	PRES_C_INLINE_STRUCT_UNION		= 5,
	PRES_C_INLINE_EXPANDED_UNION		= 6,
	PRES_C_INLINE_VOID_UNION		= 7,
	PRES_C_INLINE_COLLAPSED_UNION		= 8,

	/* Array presentations.  Corresponding itype must be MINT_ARRAY.  */
	PRES_C_INLINE_EMBEDDED_ARRAY		= 10,
	PRES_C_INLINE_EOS_ARRAY			= 11,
	PRES_C_INLINE_COUNTED_ARRAY		= 12,
	PRES_C_INLINE_TERMINATED_ARRAY		= 13,
	PRES_C_INLINE_LIST_ARRAY		= 14,

	/* Typed presentation.  Corresponding itype must be MINT_TYPED.  */
	PRES_C_INLINE_TYPED			= 15,

	/* Only valid for receive-only mappings: throw away the received value.  */
	PRES_C_INLINE_THROWAWAY			= 16,

	PRES_C_INLINE_XLATE			= 17,
	PRES_C_INLINE_ASSIGN			= 18,
	PRES_C_INLINE_COND			= 19,
	PRES_C_INLINE_VIRTUAL_UNION		= 20,
	PRES_C_INLINE_MESSAGE_ATTRIBUTE		= 21
};

/* Defines the inlined mapping of a particular interface type
   onto the members of a C struct.  */
union pres_c_inline_u
switch (pres_c_inline_kind kind)
{
	case PRES_C_INLINE_ATOM:
		pres_c_inline_atom			atom;

	case PRES_C_INLINE_STRUCT:
		pres_c_inline_struct			struct_i;
	case PRES_C_INLINE_FUNC_PARAMS_STRUCT:
		pres_c_inline_func_params_struct	func_params_i;

	case PRES_C_INLINE_STRUCT_UNION:
		pres_c_inline_struct_union		struct_union;
	case PRES_C_INLINE_EXPANDED_UNION:
		pres_c_inline_expanded_union		expanded_union;
	case PRES_C_INLINE_VOID_UNION:
		pres_c_inline_void_union		void_union;
	case PRES_C_INLINE_COLLAPSED_UNION:
		pres_c_inline_collapsed_union		collapsed_union;
	case PRES_C_INLINE_VIRTUAL_UNION:
		pres_c_inline_virtual_union		virtual_union;

	case PRES_C_INLINE_TYPED:
		pres_c_inline_typed			typed;
	case PRES_C_INLINE_COUNTED_ARRAY:
		pres_c_inline_counted_array		counted_array;
	case PRES_C_INLINE_TERMINATED_ARRAY:
		pres_c_inline_terminated_array		terminated_array;

	case PRES_C_INLINE_THROWAWAY:
		void;

	case PRES_C_INLINE_XLATE:
		pres_c_inline_xlate			xlate;
	case PRES_C_INLINE_ASSIGN:
		pres_c_inline_assign			assign;
	case PRES_C_INLINE_COND:
		pres_c_inline_cond			cond;
	case PRES_C_INLINE_MESSAGE_ATTRIBUTE:
		pres_c_inline_message_attribute		msg_attr;
};





/***** Mappings *****/
/* These define how a particular ptype is mapped to a particular itype.  */

/* For PRES_C_MAPPING_DIRECT,
   the itype and ptype must be primitive types
   that have an "obvious" mapping.  */

/* For PRES_C_MAPPING_STUB, the ptype must be a CAST_TYPE_NAME;
   The mapping_stub_index value is an index into the stubs<> sequence field
   in a pres_c_1 type.  It is for the index to the corresponding
   marshal/unmarshal stub.  */
struct pres_c_mapping_stub
{
	int	mapping_stub_index;
};

/*
 * A `pres_c_mapping_direction' node contains information for the back end: is
 * the data below this node `in', `inout', `out', `return', or unknown?  The
 * back end sometimes needs this information in order to optimize allocation,
 * etc.  (E.g., `in' parameters can be allocated on the runtime stack.)
 *
 * Fundamentally, the need for `direction' nodes points to a shortcoming in
 * the presentation generator: the PG phase is driven almost exclusively by
 * types, not by how the data is being used.  The role of the data, however,
 * determines certain things such as allocation semantics.  If the presentation
 * generator was more careful to consider the roles of data when generating
 * PRES_C, it could generate PRES_C without resorting to `direction' nodes
 * which need to be interpreted by the back end.
 */
enum pres_c_direction
{
	PRES_C_DIRECTION_UNKNOWN = 0,
	PRES_C_DIRECTION_IN = 1,
	PRES_C_DIRECTION_INOUT = 2,
	PRES_C_DIRECTION_OUT = 3,
	PRES_C_DIRECTION_RETURN = 4
};

struct pres_c_mapping_direction
{
	pres_c_direction dir;
	pres_c_mapping   mapping;
};

/* One of these serves to "eat up" one level of C pointer indirection in the ptype,
   without descending any further in the itype.  */
struct pres_c_mapping_pointer
{
	/* How and when the memory pointed to should be allocated or deallocated.  */
	pres_c_allocation	alloc;

	/* Mapping for the itype and the ptype the pointer points to.  */
	pres_c_mapping		target;
};

/* A `pres_c_mapping_optional_pointer' is unlike a `pres_c_mapping_pointer' in
   that an optional pointer doesn't just "eat up" one level of C pointer
   indirection.  An optional pointer is a presentation mechanism that embodies
   semantics --- the value of the pointer (NULL or non-NULL) is determined by
   the presence of the optional datum.  A simple `pres_c_mapping_pointer', on
   the other hand, doesn't have any semantics to speak of --- it's simply a
   way of presenting data. */
struct pres_c_mapping_optional_pointer
{
	pres_c_allocation	alloc;
	pres_c_mapping		target;
};

/* The current itype, whatever it is (not necessarily a struct)
   maps onto the elements of the current struct ctype,
   as defined by the pres_c_inline tree that begins here.  */
typedef pres_c_inline pres_c_mapping_struct;

/*
 * A `pres_c_mapping_fixed_array' describes a presentation consisting of an
 * array containing a fixed number of elements.  The associated MINT type must
 * be an array, although the length of the MINT array might be different from
 * the `length' specified by the mapping, or the MINT array might be variable
 * length.  The associated CAST type must be an array (possibly with a length
 * greater than that specified by the `length' field of the mapping) or a
 * pointer.
 *
 * Note that fixed array mappings used to just consist of an element mapping;
 * the length was determined from the associated CAST (array) type.  But now
 * that MINT arrays can be presented by C pointers, we must keep the length in
 * the mapping data structure itself.  Plus, by keeping the array length in the
 * mapping, we have more freedom in terms of C presentation.
 */
struct pres_c_mapping_fixed_array
{
	/*
	 * How and when the memory pointed to should be allocated/deallocated.
	 *
	 * Note that `alloc' applies *only* when the associated CAST type is a
	 * pointer type.  If the associated CAST type is an array type, then we
	 * assume that something else takes care of managing the array memory.
	 * (For instance, the array might be allocated on the stack as a local
	 * variable, or might be contained in some larger, already-allocated
	 * structure.)
	 */
	pres_c_allocation	alloc;
	
	u_int			length;
	pres_c_mapping		element_mapping;
	/*
	 * XXX --- We should have a `padding' field, too, describing how to
	 * fill unused space in the presented C data.
	 */
};

/* Gobbles up a level of pointer indirection in the ctype.  */
struct pres_c_mapping_terminated_array
{
	pres_c_allocation	alloc;
	
	int			terminator;

	/*
	 * XXX --- We really shouldn't need the maximum length here.
	 * The max field of terminated arrays technically belongs in the
	 * MINT structure, and not the PRES_C.  However, when generating
	 * the server skeleton function, MINT_VOIDs are used to allocate
	 * space for out parameters without [un]marshaling anything.
	 * Unfortunately, this means the original MINT containing the
	 * maximum length is not available at allocation time!  Thus, to
	 * solve the problem, the max is *also* stored here.
	 * This is currently only used by the Mach3/MIG back end.
	 */
	u_int			max;
	pres_c_mapping		element_mapping;
};

/* The current ptype presents a union itype all by itself.
   The first case must be an integerish variable containing the discriminator,
   and all the other cases must be structs with that variable in the first slot.
   The default case, if any, must be last in the C union.  */
struct pres_c_mapping_flat_union
{
	pres_c_mapping	discrim;
	pres_c_mapping	cases<>;
	pres_c_mapping	dfault;
};

struct pres_c_mapping_special
{
	string marshaler_name<>;
};

struct pres_c_mapping_xlate
{
	cast_type		internal_ctype;
	pres_c_mapping		internal_mapping;

	pres_c_alloc_flags	alloc_flags;

	string			translator<>;
	string			destructor<>;
};

enum pres_c_reference_kind
{
	PRES_C_REFERENCE_COPY	          = 0,	/* send a copy      */
	PRES_C_REFERENCE_MOVE	          = 1,	/* send my instance */
	PRES_C_REFERENCE_COPY_AND_CONVERT = 2	/* send a converted copy.
				                 * This corresponds to 
						 * MIG's MAKE, since the OS
						 * converts a RECV right
						 * to a SEND right
						 */
};

/* This is the type of mapping typically used for object references.  */
struct pres_c_mapping_reference
{
	/* 
	 * kind refers to the semantic: either copy, move, or MIG's
	 * copy_and_convert (make).  ref_count is how many references we
	 * are working with (currently it's always 1).
	 */		
 	pres_c_reference_kind kind; 
	int ref_count;
};

/*
 * A `pres_c_mapping_sid' tells us that the corresponding data is a security
 * identifier (SID).  Like object references, the implementation of a SID is
 * inherently tied to the services used to implement communication.
 */
enum pres_c_sid_kind
{
	PRES_C_SID_CLIENT	= 0,	/* effective SID of the client */
	PRES_C_SID_SERVER	= 1	/* required SID of the server  */
};

struct pres_c_mapping_sid
{
	pres_c_sid_kind kind;
};


/*
 * A `pres_c_mapping_message_attribute' tells us that the corresponding data
 * will access/change an attribute of the message being sent or received.
 * See comment for `pres_c_inline_message_attribute'.
 * Currently this is only implemented for MIG.
 */
struct pres_c_mapping_message_attribute
{
	pres_c_message_attribute_kind kind;
};

/*
 * A `pres_c_mapping_argument' tells the back end to save the information about
 * the current CAST storage location (a `cast_expr' that names the location,
 * and a `cast_type' describing its type).  This is how certain PRES_C nodes
 * collect information from their children.
 *
 * `arg_name' is the ``key'' under which the CAST information is stored.  This
 * key generally described the argument's purpose, e.g., "length".
 *
 * `map' is the internal mapping for this node; it allows the back end to
 * continue generating code after the corresponding CAST information has been
 * saved off.
 */
struct pres_c_mapping_argument
{
	string		arg_name<>;
	pres_c_mapping	map;
};

enum pres_c_mapping_kind
{
	PRES_C_MAPPING_DIRECT		= 0,
	PRES_C_MAPPING_STUB		= 1,
	PRES_C_MAPPING_POINTER		= 2,
	PRES_C_MAPPING_FIXED_ARRAY	= 3,
	PRES_C_MAPPING_TERMINATED_ARRAY	= 4,
	PRES_C_MAPPING_STRUCT		= 5,
	PRES_C_MAPPING_FLAT_UNION	= 6,
	PRES_C_MAPPING_SPECIAL		= 7,
	PRES_C_MAPPING_XLATE		= 8,
	PRES_C_MAPPING_REFERENCE	= 9,
	PRES_C_MAPPING_TYPE_TAG		= 10,
	PRES_C_MAPPING_OPTIONAL_POINTER	= 11,
	/*
	 * This is for tossing stuff on the CAST side (i.e., no corresponding
	 * MINT stuff to decode).
	 */
	PRES_C_MAPPING_IGNORE		= 12,
	PRES_C_MAPPING_SYSTEM_EXCEPTION	= 13,
	PRES_C_MAPPING_DIRECTION	= 14,
	PRES_C_MAPPING_SID		= 15,
	PRES_C_MAPPING_ARGUMENT		= 16,
	PRES_C_MAPPING_MESSAGE_ATTRIBUTE= 17
};

union pres_c_mapping_u
switch (pres_c_mapping_kind kind)
{
	case PRES_C_MAPPING_DIRECT:		void;
	case PRES_C_MAPPING_STUB:		pres_c_mapping_stub		mapping_stub;
	case PRES_C_MAPPING_POINTER:		pres_c_mapping_pointer		pointer;
	case PRES_C_MAPPING_FIXED_ARRAY:	pres_c_mapping_fixed_array	fixed_array;
	case PRES_C_MAPPING_TERMINATED_ARRAY:	pres_c_mapping_terminated_array	terminated_array;
	case PRES_C_MAPPING_STRUCT:		pres_c_mapping_struct		struct_i;
	case PRES_C_MAPPING_FLAT_UNION:		pres_c_mapping_flat_union	flat_union;
	case PRES_C_MAPPING_SPECIAL:		pres_c_mapping_special		special;
	case PRES_C_MAPPING_XLATE:		pres_c_mapping_xlate		xlate;
	case PRES_C_MAPPING_REFERENCE:		pres_c_mapping_reference	ref;
	case PRES_C_MAPPING_TYPE_TAG:		void;
	case PRES_C_MAPPING_OPTIONAL_POINTER:	pres_c_mapping_optional_pointer optional_pointer;
	case PRES_C_MAPPING_IGNORE:		void;
	case PRES_C_MAPPING_SYSTEM_EXCEPTION:	void;
	case PRES_C_MAPPING_DIRECTION:		pres_c_mapping_direction direction;
	case PRES_C_MAPPING_SID:		pres_c_mapping_sid sid;
	case PRES_C_MAPPING_ARGUMENT:		pres_c_mapping_argument		argument;
	case PRES_C_MAPPING_MESSAGE_ATTRIBUTE:	pres_c_mapping_message_attribute message_attribute;
};



/***** Stubs *****/


/* Stub functions are treated much like structs for mapping purposes.
   Index numbers >= 0 indicate parameters;
   index -1 indicates the return value.  */
const pres_c_func_return_index = -1;


struct pres_c_marshal_stub
{
	/* This is an index into the cast's top-level scope,
	   indicating which C function declaration we're talking about.  */
	cast_ref	c_func;

	/* Interface data type this stub is supposed to marshal.  */
	mint_ref	itype;

	/* How the parameters of the stub map to the interface data.  */
	pres_c_inline	i;

	/* How the connection to marshal to is specified.  */
	pres_c_inline	target_i;

	/* The PRES_C mapping that allows us to "see through" or "see into"
	   this stub.  We need this maping when we want to inline the body of
	   this marshal stub into a client stub, a server function, etc. */
	pres_c_mapping seethru_map;
};

typedef u_int pres_c_stub_op_flags;
/*
 * These are flag bits that may be and'ed and or'ed together.
 */
const PRES_C_STUB_OP_FLAG_NONE		= 0x00000000;
const PRES_C_STUB_OP_FLAG_ONEWAY	= 0x00000001;
const PRES_C_STUB_OP_FLAG_IDEMPOTENT	= 0x00000002;

struct pres_c_client_stub
{
	/* This is an index into the cast's top-level scope,
	   indicating which C function declaration we're talking about.  */
	cast_ref	c_func;

         /* op_flags is used to indicate if a function is oneway.  If so, there 
            are no inout parameters, out parameters, or return value, and no Reply
	    is received.
	 */
	pres_c_stub_op_flags 	op_flags;

	/* The function arguments are the data sources,
	   and the return value is the only data sink.
	   Memory can be allocated from the stack
	   for data that only has to stick around until the reply is received;
	   this generally means message buffers and such, but not returned data.  */

	/* Interface data types for request and reply messages.
	   Normally these point to the "mom_request" and "mom_reply" union typess, respectively.  */
	mint_ref	request_itype;
	mint_ref	reply_itype;

	/* How the parameters of the stub map to request and reply data.  */
	pres_c_inline	request_i;
	pres_c_inline	reply_i;

	/* If the reply_i can't handle the actual reply received,
	   we call it an exception and handle it this way... */
	/* XXX */

	/* How the target object to call is specified.  */
	mint_ref	target_itype;
	pres_c_inline	target_i;

	/* How the client "object" is specified.  */
	mint_ref	client_itype;
	pres_c_inline	client_i;

	/* How errors will be reported to the caller.  */
	mint_ref	error_itype;
	pres_c_inline	error_i;
};

struct pres_c_server_func
{
	/* For each server function that can be dispatched to,
	   the function arguments are the data sinks,
	   and the return value is the only data source.
	   Memory can be allocated from the stack
	   for data that only has to stick around until the reply is sent;
	   this generally means incoming and outgoing unpacked data, but not message buffers.
	   (XXX maybe message buffers, in some cases?)  */

	/* This is an index into the cast's top-level scope,
	   indicating the C function declaration for the server function.  */
	cast_ref	c_func;

         /* op_flags is used to indicate if a function is oneway.  If so, there 
            are no inout parameters, out parameters, or return value, and no Reply
	    is sent.
	 */
	pres_c_stub_op_flags 	op_flags;

	/* How the parameters of the stub map to request and reply data.
	   reply_i corresponds to the the "expected" reply message type;
	   the server can return a reply that doesn't conform to the constraints of reply_i
	   by throwing an exception.  */
	pres_c_inline	request_i;
	pres_c_inline	reply_i;

	/* How the target object the request was directed to is indicated to the server.  */
	mint_ref	target_itype;
	pres_c_inline	target_i;

	/* How the client "object" is indicated.  */
	mint_ref	client_itype;
	pres_c_inline	client_i;

	/* How the work function is expected to report errors.  */
	mint_ref	error_itype;
	pres_c_inline	error_i;
};

/* A "server stub" is really a static data structure produced by a MOM PBE
   that represents a server implementation that can receive MOM object invocations.
   The local C code can call `mob_create' or an equivalent function
   (e.g. `BOA_create' in a CORBA Basic-Object-Adaptor environment)
   with the server stub as the ImplementationDef parameter;
   that will allow the server to start receiving object invocations.  */
struct pres_c_server_skel
{
	/* This is an index into the cast's top-level scope,
	   indicating which C declaration we're talking about.  */
	cast_ref	c_def;

	/* Interface data types for request and reply messages.
	   Normally these point to the "mom_request" and "mom_reply" union typess, respectively.  */
	mint_ref	request_itype;
	mint_ref	reply_itype;

	/* List of C functions the server stub can invocations dispatch to.
	   If multiple functions match, the most specifialized one will be chosen.  */
	pres_c_server_func	funcs<>;
};

struct pres_c_msg_stub
{
	/* This is an index into the cast's top-level scope,
	   indicating which C function declaration we're talking about.  */
	cast_ref	c_func;

	/* The function arguments are the data sources,
	   and the return value is the only data sink.
	   Memory can be allocated from the stack
	   for data that only has to stick around until the reply is received;
	   this generally means message buffers and such, but not returned data.  */

	/* Interface data types for request and reply messages.
	   Normally these point to the "mom_request" and "mom_reply" union typess, respectively.  */
	mint_ref	msg_itype;

	/* How the parameters of the stub map to request and reply data.  */
	pres_c_inline	msg_i;

	/* How the target object to call is specified.  */
	mint_ref	target_itype;
	pres_c_inline	target_i;
};
typedef pres_c_msg_stub pres_c_send_stub;
typedef pres_c_msg_stub pres_c_reply_stub;

enum pres_c_stub_kind
{
	/* A stub that marshals a data structure.  */
	PRES_C_MARSHAL_STUB	= 1,

	/* Same, but unmarshals a data structure instead.  */
	PRES_C_UNMARSHAL_STUB	= 2,

	/* This function represents a client stub
	   that packs a message, sends it off, waits for a response,
	   and unpacks the response.  */
	PRES_C_CLIENT_STUB	= 3,

	/* This represents a server stub
	   that waits for a message, unpacks it, dispatches to a server function,
	   packages up the reply, and sends it off.  */
	PRES_C_SERVER_SKEL	= 4,

	/* XXX exception handler functions, e.g. for authentication?  */

	/* This function represents a stub
	   that packs a one-way message and sends it off,
	   possibly either asynchronously or batched.  */
	/* XXX corresponding server-side mapping?  */
	/* XXX what about two-way RPCs used asynchronously?  */
	PRES_C_SEND_STUB	= 5,

	/* Like SERVER_FUNC, but does not produce a reply after the function returns.
	   Instead, (if the interface specifies that a reply is in order)
	   the server must call a REPLY_STUB later when it's ready to reply.  */
	PRES_C_RECEIVE_FUNC	= 6,

	PRES_C_REPLY_STUB	= 7
};
union pres_c_stub
switch (pres_c_stub_kind kind)
{
	case PRES_C_MARSHAL_STUB:	pres_c_marshal_stub	mstub;
	case PRES_C_UNMARSHAL_STUB:	pres_c_marshal_stub	ustub;
	case PRES_C_CLIENT_STUB:	pres_c_client_stub	cstub;
	case PRES_C_SERVER_SKEL:	pres_c_server_skel	sskel;
	case PRES_C_SEND_STUB:		pres_c_send_stub	send_stub;
	case PRES_C_REPLY_STUB:		pres_c_reply_stub	reply_stub;
};

struct pres_c_1
{
	mint_1		mint;
	cast_1		cast;
	/*
	 * XXX --- `a' is here for the sole benefit of the Sun BE, so that it
	 * can generate program and version numbers for non-ONC RPC IDL derived
	 * interfaces.  See `c/pbe/sun/misc.cc' and `c/pbe/sun/server_main.cc'.
	 *
	 * The proper solution is to change MINT so that the BE has enough
	 * context from which to generate the interface/object keys that are
	 * required by the message encoding format.  But until we change MINT,
	 * we have AOI...
	 */
	aoi		a;
	pres_c_stub	stubs<>;
	string		pres_context<>;
};

#ifdef RPC_HDR
%#endif /* _flick_pres_c_h_ */
#endif
