/*
 * Copyright (c) 1996, 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

/* 
 * Modified by Uwe Dannowski, Dresden University of Technology
 */

#ifndef __flick_encode_l4_h
#define __flick_encode_l4_h

#include <flick/encode/all.h>

/* Begin encoding macros */

#define flick_l4_encode_scalar(_ofs, _data, type)				\
	*(type *)(_buf_current + (_ofs)) = (type)(_data)

#define flick_l4_encode_char8(_ofs, _data)				\
	flick_l4_encode_scalar(_ofs, _data, char)
#define flick_l4_encode_signed8(_ofs, _data)				\
	flick_l4_encode_scalar(_ofs, _data, char)
#define flick_l4_encode_unsigned8(_ofs, _data)			\
	flick_l4_encode_scalar(_ofs, _data, unsigned char)
#define flick_l4_encode_signed16(_ofs, _data)			        \
	flick_l4_encode_scalar(_ofs, _data, short)
#define flick_l4_encode_unsigned16(_ofs, _data)			\
	flick_l4_encode_scalar(_ofs, _data, unsigned short)
#define flick_l4_encode_signed32(_ofs, _data)			        \
	flick_l4_encode_scalar(_ofs, (_data), int)
#define flick_l4_encode_unsigned32(_ofs, _data)			\
	flick_l4_encode_scalar(_ofs, _data, unsigned int)
#define flick_l4_encode_float32(_ofs, _data)				\
	flick_l4_encode_scalar(_ofs, _data, float)
#define flick_l4_encode_float64(_ofs, _data)				\
	flick_l4_encode_scalar(_ofs, _data, double)

#define flick_l4_encode_alloced_string(_data, _link, _size)	{	\
	int _temp_iter = 0;						\
        flick_##_link##_encode_new_glob((_size) + 8);			\
	_buf_current =						\
		(void *) ((((unsigned int) _buf_current) + 3)	\
			  & ~3);					\
	while((_data)[_temp_iter]) {					\
		((char *) _buf_current)[_temp_iter + 4] =	\
			((char *) (_data))[_temp_iter];			\
		_temp_iter++;						\
	}								\
	((char *) _buf_current)[_temp_iter + 4] = 0;		\
	*((int *) _buf_current) = _temp_iter + 1;		\
	flick_##_link##_encode_new_chunk(_temp_iter + 5);		\
	flick_##_link##_encode_end_chunk(_temp_iter + 5);		\
	flick_##_link##_encode_end_glob((_size) + 8);			\
}

#define flick_l4_encode_string(_data, _dealloc, _link, _size) {	\
	flick_l4_encode_alloced_string(_data, ##_link, _size);		\
	_dealloc((_data));						\
}

#define flick_l4_encode_longstring(_data, _dealloc, _link) {		\
	int _temp_len, _temp_iter;					\
	for(_temp_len = 0; ((char *) (_data))[_temp_len]; _temp_len++);	\
	flick_##_link##_encode_new_glob(_temp_len + 8);			\
	_buf_current =						\
		(void *) ((((unsigned int) _buf_current + 3)	\
			   & ~3));					\
	flick_##_link##_encode_new_chunk(4);				\
	flick_l4_encode_unsigned32(0, (_temp_len + 1));		\
	flick_##_link##_encode_end_chunk(4);				\
	flick_##_link##_encode_new_chunk(_temp_len + 1);		\
	for (_temp_iter = 0; _temp_iter <= _temp_len; ++_temp_iter)	\
		*(((char *) _buf_current) + _temp_iter)		\
			= *(((char *) (_data)) + _temp_iter);		\
	flick_##_link##_encode_end_chunk(_temp_len + 1);		\
	_dealloc((_data));						\
	flick_##_link##_encode_end_glob(_temp_len + 8);			\
}

#define flick_l4_swap_encode_longstring(_data, _dealloc, _link) 	\
        flick_l4_encode_longstring(_data, _dealloc, _link)
		
#define flick_l4_encode_bcopy(_ofs, _src, _qty) {	\
	(void) bcopy((void *) (_src),			\
		     (char *) _buf_current + _ofs,	\
		     (_qty));				\
}

#define flick_l4_encode_l4sndfpage(_ofs, _data) {                      \
	*(dword_t *)(_buf_current + (_ofs)) = (_data).snd_base;        \
        *(dword_t *)(_buf_current + (_ofs + 4)) = (_data).fpage.fpage; \
        _msgbuf->nr_fpages++;                                          \
}

#define flick_l4_encode_zerofpage(_ofs) {                            \
        *(dword_t *)(_buf_current + (_ofs)) = 0;                     \
        *(dword_t *)(_buf_current + (_ofs+ 4)) = 0;                  \
}

// alignment is 16 and 4 offset for version X
// probably not optimal for some cases
#define flick_l4_encode_l4strdope(_ofs, _data) {                     \
        *(dword_t *)(_buf_current + (_ofs + 4)) = (_data).snd_size;  \
        *(dword_t *)(_buf_current + (_ofs + 8)) = (_data).snd_str;   \
        *(dword_t *)(_buf_current + (_ofs + 12)) = 0;                \
        *(dword_t *)(_buf_current + (_ofs + 16)) = 0;                \
        if ((_data).rcv_size) {                                      \
	    _msgbuf->str_dope[_msgbuf->nr_rcv_strings].rcv_size = (_data).rcv_size; \
	    _msgbuf->str_dope[_msgbuf->nr_rcv_strings].rcv_str = (_data).rcv_str;  \
	    _msgbuf->nr_rcv_strings++;                               \
	}                                                            \
        if ((_data).snd_size) _msgbuf->nr_snd_strings++;             \
}
        

/* ---------- */
/* Decoding macros */

#define flick_l4_decode(_ofs, _data, type)				\
	(_data) = (*(type *)(_buf_current + (_ofs)))

#define flick_l4_decode_char8(_ofs, _data)				\
	flick_l4_decode(_ofs, _data, char)
#define flick_l4_decode_signed8(_ofs, _data)				\
	flick_l4_decode(_ofs, _data, signed char)
#define flick_l4_decode_unsigned8(_ofs, _data)				\
	flick_l4_decode(_ofs, _data, unsigned char)
#define flick_l4_decode_signed16(_ofs, _data)				\
	flick_l4_decode(_ofs, _data, short)
#define flick_l4_decode_unsigned16(_ofs, _data)			\
	flick_l4_decode(_ofs, _data, signed short)
#define flick_l4_decode_signed32(_ofs, _data)				\
	flick_l4_decode(_ofs, _data, signed int)
#define flick_l4_decode_unsigned32(_ofs, _data)			\
	flick_l4_decode(_ofs, _data, unsigned int)
#define flick_l4_decode_float32(_ofs, _data)				\
	flick_l4_decode(_ofs, _data, float)
#define flick_l4_decode_float64(_ofs, _data)				\
	flick_l4_decode(_ofs, _data, double)

#define flick_l4_decode_l4sndfpage(_ofs, _data) {                      \
        (_data).snd_base = *(dword_t *)(_buf_current + (_ofs));        \
        (_data).fpage.fpage = *(dword_t *)(_buf_current + (_ofs +4));  \
}

#define flick_l4_decode_zerofpage(_ofs)

#define flick_l4_decode_l4strdope(_ofs, _data)                         \
        (_data).snd_size = *(dword_t *)(buf_current + (_ofs + 4));     \
	(_data).snd_str  = *(dword_t *)(buf_current + (_ofs + 8));     

#define flick_l4_decode_msgptr(_ofs, _ptr) {				\
	(_ptr) = (void *)((char *)_buf_current + (_ofs));	\
}

#define flick_l4_decode_bcopy(_ofs, _dest, _qty) {	\
	(void) bcopy((char *)_buf_current + _ofs,	\
		     (void *) (_dest),			\
		     (_qty));				\
}

#define flick_l4_decode_stringlen(_data, _link) {		\
	flick_##_link##_decode_new_glob(7);			\
	flick_##_link##_decode_new_chunk_align(4, 2, 0, 0);	\
	flick_l4_decode_unsigned32(0, _data);			\
	flick_##_link##_decode_end_chunk(4);			\
	flick_##_link##_decode_end_glob(7);			\
}

#define flick_l4_decode_alloced_string(_data, _link, _size) {	   \
	int _temp_len, _temp_iter;					   \
									   \
	flick_l4_decode_stringlen(_temp_len, _link);		   \
	flick_##_link##_decode_new_glob(_temp_len);			   \
	flick_##_link##_decode_new_chunk(_temp_len);			   \
	for (_temp_iter = 0; _temp_iter < _temp_len; ++_temp_iter)	   \
		*(((char *) (_data)) + _temp_iter)			   \
			= *(((char *) _buf_current) + _temp_iter); \
	flick_##_link##_decode_end_chunk(_temp_len);			   \
	flick_##_link##_decode_end_glob(_temp_len);			   \
}

/* This is only used for 'in' strings.  Since L4 encodes the final zero,
 * we can return a pointer directly into the buffer.
 */
#define flick_l4_decode_auto_string(_data, _alloc, _link) {	\
	int _temp_len;						\
	flick_l4_decode_stringlen(_temp_len, _link);	\
	flick_##_link##_decode_new_glob(_temp_len);		\
	flick_##_link##_decode_new_chunk(_temp_len);		\
	(_data) = (char *)(_buf_current);		\
	flick_##_link##_decode_end_chunk(_temp_len);		\
	flick_##_link##_decode_end_glob(_temp_len);		\
}

#ifdef AUTO_ALLOC

#define flick_l4_decode_longstring(_data, _alloc, _link) {		   \
	int _temp_len, _temp_iter;					   \
									   \
	flick_l4_decode_stringlen(_temp_len, _link);		           \
	flick_##_link##_decode_new_glob(_temp_len);			   \
	flick_##_link##_decode_new_chunk(_temp_len);			   \
	(_data) = _alloc(_temp_len);					   \
	for (_temp_iter = 0; _temp_iter < _temp_len; ++_temp_iter)	   \
		*(((char *) (_data)) + _temp_iter)			   \
			= *(((char *) _buf_current) + _temp_iter);         \
	flick_##_link##_decode_end_chunk(_temp_len);			   \
	flick_##_link##_decode_end_glob(_temp_len);			   \
}

#else

#define flick_l4_decode_longstring(_data, _alloc, _link) {		   \
	int _temp_len, _temp_iter;					   \
									   \
	flick_l4_decode_stringlen(_temp_len, _link);		           \
	flick_##_link##_decode_new_glob(_temp_len);			   \
	flick_##_link##_decode_new_chunk(_temp_len);			   \
	for (_temp_iter = 0; _temp_iter < _temp_len; ++_temp_iter)	   \
		*(((char *) (_data)) + _temp_iter)			   \
			= *(((char *) _buf_current) + _temp_iter);         \
	flick_##_link##_decode_end_chunk(_temp_len);			   \
	flick_##_link##_decode_end_glob(_temp_len);			   \
}

#endif 


#define flick_l4_decode_string(_data, _alloc, _link, _size)		\
	flick_l4_decode_longstring(_data, _alloc, _link)


/* End decoding section */

#endif /* __flick_encode_l4_h */

/* End of file. */

