/*
 * Copyright (c) 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation.
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#ifndef __flick_pres_all_h
#define __flick_pres_all_h

/* This include is only for memset() when outputted by
   cast_new_expr_assign_to_zero() to initialize the _return value to 0 in the
   case of arrays/structs/unions/named types */
#include <string.h>

#if 0
/* Dough-head error reporting */
/* These 2 includes are only for the dough-header error reporting... */
#include <stdio.h>
#include <unistd.h>
#define flick_error(_pres, _phase, _stub) {			\
	printf("ERROR Process #%d, Line #%d, File '%s'!\n",	\
	       (int)getpid(), __LINE__, __FILE__);		\
	printf("Presentation:\t%s\nPhase:\t\t%s\nFrom:\t\t%s",	\
	       _pres, _phase, _stub);				\
	exit(1);						\
}
#else

#define flick_error(_pres, _phase, _stub) 

#endif

/* This is used when no allocation/deallocation is necessary */
#define null_flick_alloc(a)
#define null_flick_free(a)

/* This is used when automatic deallocation on function exit is wanted */
#define auto_flick_alloc(a) alloca(a)
#define auto_flick_free(a)

#define FLICK_ERROR_CONSTANT		1
#define FLICK_ERROR_VIRTUAL_UNION	2
#define FLICK_ERROR_STRUCT_UNION	3
#define FLICK_ERROR_DECODE_SWITCH	4
#define FLICK_ERROR_COLLAPSED_UNION	5
#define FLICK_ERROR_VOID_UNION		6
#define FLICK_ERROR_COMMUNICATION	7
#define FLICK_ERROR_OUT_OF_BOUNDS	8
#define FLICK_ERROR_INVALID_TARGET	9

#endif /* __flick_pres_all_h */
