/*
 * Copyright (c) 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation.
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

/* 
 * Modified by Uwe Dannowski, Dresden University of Technology
 */

#ifndef __flick_pres_l4_h
#define __flick_pres_l4_h

#define PRESNAME l4

#include <flick/pres/all.h>
#include <l4/types.h>

typedef struct {
	int _type;
	void *_except;
} SmExcpt;

/*
 * The Fluke allocator, invoked by the Fluke presentation generator.
 */
#ifdef AUTO_ALLOC
#error auto allocation not implemented yet!
#else
// ugly but necessary - the exception pointers use l4_flick_alloc
#define l4_flick_alloc(a) 0
#define l4_flick_free(a)  0
#endif

/* These are all the error macros */
#define exc_l4_no_exception      (0)
#define exc_l4_system_exception (-1)
#define exc_data_notfound       (-2)
#define exc_l4_propagation      (-3)

#define flick_l4_init_environment()		\
{						\
	_ev->_type = exc_l4_no_exception;	\
}

#define flick_l4_encode_system_exception(loc, ENCNAME, LINKNAME)	\
{									\
	flick_##LINKNAME##_encode_new_chunk(4);				\
	flick_##ENCNAME##_encode_signed32(0, (int) ((loc)->_except));	\
	flick_##LINKNAME##_encode_end_chunk(4);				\
}

#define flick_l4_decode_system_exception(loc, ENCNAME, LINKNAME)	\
{									\
	flick_##LINKNAME##_decode_new_chunk(4);				\
	flick_##ENCNAME##_decode_signed32(0, (int) ((loc)->_except));	\
	flick_##LINKNAME##_decode_end_chunk(4);				\
}

#define flick_l4_server_error(retname, errval, ENCNAME, LINKNAME, START)\
{									\
	flick_##LINKNAME##_server_##START##_encode();			\
	flick_##LINKNAME##_encode_new_glob_plain(8);			\
	flick_##LINKNAME##_encode_new_chunk_plain(8);			\
	flick_##ENCNAME##_encode_signed32(0, exc_l4_system_exception);	\
	flick_##ENCNAME##_encode_signed32(4, (int) (errval));		\
	flick_##LINKNAME##_encode_end_chunk_plain(8);			\
	flick_##LINKNAME##_encode_end_glob_plain(8);			\
	flick_##LINKNAME##_server_end_encode();				\
	retname;							\
}

// we can use start here, since we don't allocate memory
// the normal implementation would be restart...
#define flick_l4_encode_server_error(retname, errval, ENCNAME, LINKNAME) \
	flick_l4_server_error(retname, EINVAL, ##ENCNAME, ##LINKNAME, start)

#define flick_l4_decode_server_error(retname, errval, ENCNAME, LINKNAME) \
	flick_l4_server_error(retname, EINVAL, ##ENCNAME, ##LINKNAME, start)

#define flick_l4_memory_server_error(retname, errval, ENCNAME, LINKNAME) \
	flick_l4_server_error(retname, EINVAL, ##ENCNAME, ##LINKNAME, start)

// if we are in propagation mode - return!
#define flick_l4_return_if_propagating() \
	if (_ev->_type == exc_l4_propagation) return FLICK_OPERATION_PROPAGATING;

/* The client errors are easy - just set the value, and return */
#define flick_l4_encode_client_error(retname, errval, ENCNAME, LINKNAME) \
{									  \
	_ev->_type = exc_l4_system_exception;				  \
        _ev->_except = (void *) EINVAL;					  \
	retname;							  \
}

#define flick_l4_decode_client_error(retname, errval, ENCNAME, LINKNAME) \
{									  \
	_ev->_type = exc_l4_system_exception;				  \
	_ev->_except = (void *) EIO;					  \
	retname;							  \
}

#define flick_l4_memory_client_error(retname, errval, ENCNAME, LINKNAME) \
{									  \
	_ev->_type = exc_l4_system_exception;				  \
        _ev->_except = (void *) EINVAL;					  \
	retname;							  \
}

/* These things are pretty brain-dead right now... */
#define flick_l4_encode_mu_error(retname, errval, ENCNAME, LINKNAME) \
	flick_error("L4/Fluke", "encode", "stub")
#define flick_l4_decode_mu_error(retname, errval, ENCNAME, LINKNAME) \
	flick_error("L4/Fluke", "decode", "stub")
#define flick_l4_memory_mu_error(retname, errval, ENCNAME, LINKNAME) \
	flick_error("L4/Fluke", "other", "stub")

#endif /* __flick_pres_l4_h */

/* End of file. */
	






