/*
 * Copyright (c) 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation.
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#include <assert.h>
#include "iiop-link.h"

/* needed only for flick_check_byte_order */
#include <flick/encode/cdr.h>

CORBA_boolean CORBA_Object_is_nil(FLICK_CLIENT ths, CORBA_Environment *ev)
{
	CORBA_BOA_set_exception((ths ? ths->boa : 0) /* XXX */, ev,
				CORBA_NO_EXCEPTION, 0, 0);
	
	return !ths;
}

FLICK_CLIENT CORBA_Object_duplicate(FLICK_CLIENT ths, CORBA_Environment *ev)
{
	FLICK_CLIENT res;
	
	if (!ths) {
		/*
		 * We can't use `CORBA_BOA_set_exception' here, because our
		 * nil object doesn't have a BOA.  (Is this wrong?)
		 */
		ev->_major = CORBA_NO_EXCEPTION;
		return ths;
	}
	
	res = t_malloc(FLICK_CLIENT_STRUCT, 1);
	if (!res) {			
		flick_set_exception(ths->boa, ev, ex_CORBA_NO_MEMORY,
				    0, CORBA_COMPLETED_NO);
		return 0 /* nil FLICK_CLIENT */;
	}
	
	res->boa = ths->boa;
	res->server_func = ths->server_func;
	
	res->key._buffer = t_malloc(char, ths->key._length);
	if (!res->key._buffer) {
		flick_set_exception(ths->boa, ev, ex_CORBA_NO_MEMORY,
				    0, CORBA_COMPLETED_NO);
		free(res);
		return 0 /* nil FLICK_CLIENT */;
	}
	res->key._maximum = ths->key._length;
	res->key._length = ths->key._length;
	memcpy(res->key._buffer, ths->key._buffer, ths->key._length);
	
	res->type_id = t_malloc(char, (ths->type_id_len + 1));
	if (!res->type_id) {
		flick_set_exception(ths->boa, ev, ex_CORBA_NO_MEMORY,
				    0, CORBA_COMPLETED_NO);
		free(res->key._buffer);
		free(res);
		return 0 /* nil FLICK_CLIENT */;
	}
	strncpy((char *) res->type_id, ths->type_id, (ths->type_id_len + 1));
	
	res->type_id_len = ths->type_id_len;
	
	res->ior = t_malloc(char, ths->ior_len);
	if (!res->ior) {
		flick_set_exception(ths->boa, ev, ex_CORBA_NO_MEMORY,
				    0, CORBA_COMPLETED_NO);
		free((char *) res->type_id);
		free(res->key._buffer);
		free(res);
		return 0 /* nil FLICK_CLIENT */;
	}
	memcpy((char *) res->ior, ths->ior, ths->ior_len);
	
	res->ior_len = ths->ior_len;
	CORBA_BOA_set_exception(ths->boa, ev, CORBA_NO_EXCEPTION, 0, 0);
	return res;
}

void CORBA_Object_release(FLICK_CLIENT ths, CORBA_Environment *ev)
{
	CORBA_BOA_set_exception((ths ? ths->boa : 0), ev,
				CORBA_NO_EXCEPTION, 0, 0);
	
	if (ths) {
		if (ths->key._buffer)
			free(ths->key._buffer);
		if (ths->type_id)
			free((char *) ths->type_id);
		if (ths->ior)
			free((char *) ths->ior);
		free(ths);
	}
}

CORBA_unsigned_long CORBA_Object_hash(FLICK_CLIENT ths,
				      CORBA_unsigned_long maximum,
				      CORBA_Environment *ev)
{
	unsigned long hash = 0;
	unsigned int i;
	
	if (!ths) {
		/* No object --> no BOA --> no `CORBA_BOA_set_exception'. */
		ev->_major = CORBA_NO_EXCEPTION;
		return hash;
	}
	
	for (i = 0; i < ths->key._length; i++) {
		hash = hash + (unsigned long)ths->key._buffer[i];
		hash = hash << 8;
		hash = hash % (maximum + 1);
	}
	CORBA_BOA_set_exception(ths->boa, ev, CORBA_NO_EXCEPTION, 0, 0);
	return hash;
}

CORBA_boolean CORBA_Object_is_equivalent(FLICK_CLIENT ths,
					 FLICK_CLIENT other_object,
					 CORBA_Environment *ev)
{
	unsigned int i;
	
	/*
	 * XXX --- should null object references cause us to signal an error?
	 */
	CORBA_BOA_set_exception((ths ? ths->boa : 0), ev,
				CORBA_NO_EXCEPTION, 0, 0);
	
	if (ths == other_object)
		return 1;
	if (!ths || !other_object)
		return 0;
	if (ths->boa != other_object->boa)
		return 0;
	if (ths->server_func != other_object->server_func)
		return 0;
	if (ths->type_id_len != other_object->type_id_len)
		return 0;
	for (i = 0; i < ths->type_id_len; i++)
		if (ths->type_id[i] != other_object->type_id[i])
			return 0;
	if (ths->key._length != other_object->key._length)
		return 0;
	for (i = 0; i < ths->key._length; i++)
		if (ths->key._buffer[i] != other_object->key._buffer[i])
			return 0;
	return 1;
}

/* not implemented yet. currently causes an exception */
CORBA_ImplementationDef CORBA_Object_get_implementation(FLICK_CLIENT ths,
							CORBA_Environment *ev) 
{
	flick_set_exception(ths ? (ths->boa) : 0 /*XXX*/, ev,
			    ex_CORBA_BAD_OPERATION,
			    0, CORBA_COMPLETED_NO);
	return 0;
}

/* not implemented yet. currently causes an exception */
CORBA_InterfaceDef CORBA_Object_get_interface(FLICK_CLIENT ths,
					      CORBA_Environment *ev) 
{
	flick_set_exception(ths ? (ths->boa) : 0 /*XXX*/, ev,
			    ex_CORBA_BAD_OPERATION,
			    0, CORBA_COMPLETED_NO);
	return 0;
}

/*
 * tests to see if an object is descended from a given type
 * XXX not implemented yet. currently returns false
 * XXX needs to be implemented for remote calls
 * Currently simply returns true.
 */
CORBA_boolean CORBA_Object_is_a(FLICK_CLIENT ths,
				CORBA_char *logical_type_id,
				CORBA_Environment *ev)
{
	CORBA_BOA_set_exception((ths ? ths->boa : 0) /* XXX */, ev,
				CORBA_NO_EXCEPTION, 0, 0);
	return 1;
}

/* returns true if the object referred to no longer exists */
/* XXX Currently just returns true if the reference is CORBA_NIL */
/* XXX needs to be implemented to use a remote call */
CORBA_boolean CORBA_Object_non_existent(FLICK_CLIENT ths,
					CORBA_Environment *ev)
{
	return CORBA_Object_is_nil(ths, ev);
}

/* End of file. */

