/*
 * Copyright (c) 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation.
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#include "suntcp-link.h"

/* This is the first attempt at a generic flick runtime.
   It's patterned after the Sun RPC transport, right now
   cuz that's what it's going to be used for
   */

/* This one must be used by the client to open a connection to the server */
int
flick_client_create(FLICK_CLIENT client, FLICK_SERVER_LOCATION server)
{
	struct sockaddr_in addr;
	
#ifdef _POSIX_TIMERS
	struct timespec now;
#else
	struct timeval now;
#endif
	
	struct hostent *he = gethostbyname(server.server_name);
	if(!he)
		return 0;
	
	memset(&addr, 0, sizeof(addr));
	addr.sin_addr.s_addr = *(long*)*he->h_addr_list;
	addr.sin_family = AF_INET;
  	addr.sin_port = 0;
	
#ifdef _POSIX_TIMERS
	(void)clock_gettime(CLOCK_REALTIME, &now);
	client->header.xid = htonl(getpid() ^ now.tv_sec ^ now.tv_nsec);
#else	
	(void)gettimeofday(&now, (struct timezone *)0);
	client->header.xid = htonl(getpid() ^ now.tv_sec ^ now.tv_usec);
#endif
	client->header.dir = htonl(CALL);
	client->header.rpcvers = htonl(2);
	client->header.prog = htonl(server.prog_num);
	client->header.vers = htonl(server.vers_num);
	
	client->port = htons(pmap_getport(&addr,
					  server.prog_num,
					  server.vers_num,
					  IPPROTO_TCP));
	if (client->port == 0)
		return 0;
	
	addr.sin_port = client->port;
	client->socket_fd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if (client->socket_fd < 0) {
		perror("socket");
		return 0;
	}
	
	{
		int val = SOCKET_BUF_SIZE;
		errno = 0;
#ifdef SO_SNDBUF
		printf("Client sendbuf: %d %d %d\n", setsockopt(client->socket_fd, SOL_SOCKET, SO_SNDBUF, &val, sizeof(val)), errno, val);
#else
		printf("Client sendbuf: Using default settings\n");
#endif
#ifdef SO_RCVBUF
		printf("Client recvbuf: %d %d %d\n", setsockopt(client->socket_fd, SOL_SOCKET, SO_RCVBUF, &val, sizeof(val)), errno, val);
#else
		printf("Client recvbuf: %Using default settings\n");
#endif
	}
	if (connect(client->socket_fd,
		    (struct sockaddr *) &addr, sizeof(addr)) < 0) {
		perror("connect");
		close(client->socket_fd);
		return 0;
	}
	
	/* Grab the buffers for this client */
	client->in = (FLICK_BUFFER *)malloc(sizeof(FLICK_BUFFER));
	client->out = (FLICK_BUFFER *)malloc(sizeof(FLICK_BUFFER));
	if (!(client->in && client->out))
		return 0;
	
	client->in->real_buf_start = client->in->buf_read
				   = client->in->real_buf_end = 0;
	client->in->buf_current = client->in->buf_start = (void *)calloc(8192, 1);
	client->in->buf_end = client->in->buf_start + 8188;
	client->out->buf_current = client->out->real_buf_start
				 = client->out->buf_read
				 = client->out->buf_start
				 = (void *)calloc(8192, 1);
	client->out->buf_end = client->out->real_buf_end
			     = client->out->buf_start + 8188;
	
	return client->in->buf_current && client->out->buf_current;
}

/* This one must be used by the client to close a connection to the server */
void
flick_client_destroy(FLICK_CLIENT client)
{
	close(client->socket_fd);
	free(client->in->real_buf_start);
	free(client->out->buf_start);
	free(client->in);
	free(client->out);
}


int
flick_client_send_request(FLICK_CLIENT in_cli, FLICK_BUFFER *in_buf)
{
	return flick_write_buf(in_buf, in_cli->socket_fd);
}

int
flick_client_get_reply(FLICK_CLIENT in_cli, FLICK_BUFFER *out_buf)
{
	return flick_read_buf(out_buf, in_cli->socket_fd);
}

/* End of file. */

