/*
 * Copyright (c) 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation.
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#define FLICK_PROTOCOL_TRAPEZE
#include "trapeze-link.h"
#include <flick/encode/cdr.h> /* only used for sending exceptions */

#if 0
#define RPC_DEBUG
#endif

/*****************************************************************************/

#ifdef RPC_DEBUG
static void printbuf(FLICK_BUFFER buf)
{
	int i;
	int size = 120;
	char *start = tpz_mtod(buf);
	printf("Buffer size: %06x", size);
	for (i = 0; i < size; i++) {
		if (!(i & 15))
			printf("\n%06x:", i);
		if (!(i & 7))
			printf(" ");
		printf("%02x ", ((int)(start[i])) & 0xFF);
	}
	for (i = 0; i < size; i++) {
		char c = start[i];
		if ((c & 128) ||
		    !(c & ~31))
			c = '?';
		if (!(i & 15))
			printf("\n%06x:", i);
		if (!(i & 7))
			printf(" ");
		printf(" %c ", c);
	}
	printf("\n");
	fflush(stdout);
}
#endif


/*****************************************************************************/

int flick_trapeze_client_rpc_receiving_payload(FLICK_CLIENT in_cli,
					       FLICK_BUFFER *_msg_buf,
					       tpz_msgspec_t specifier,
					       void *out_payload_buf)
{
	tpz_replytoken_t replytoken =
		tpz_get_replytoken(
			(vm_offset_t)
			((int)DBLOCK[0] +
			 ((int)out_payload_buf - (int)(UBLOCK[0]))));
	if (replytoken == TPZ_REPLY_NOSLOT)
		return 0;
	((unsigned int *)(tpz_mtod(*_msg_buf)))[3] = replytoken;
	tpz_aim(*_msg_buf, in_cli->dest, specifier);
#ifdef RPC_DEBUG
	printbuf(*_msg_buf);
#endif
	tpz_release_sendmsg(*_msg_buf);
	*_msg_buf = tpz_get_rcvmsg_spinwait();
	tpz_release_replytoken(replytoken);
	return (*_msg_buf != NULL);
}

int flick_trapeze_client_rpc(FLICK_CLIENT in_cli,
			     FLICK_BUFFER *_msg_buf,
			     tpz_msgspec_t specifier)
{
	tpz_aim(*_msg_buf, in_cli->dest, specifier/*CTRL_MSG/UNSOL_MSG*/);
#ifdef RPC_DEBUG
	printbuf(*_msg_buf);
#endif
	tpz_release_sendmsg(*_msg_buf);
#ifdef RPC_DEBUG
	printf("client sent.\n");
#endif
	*_msg_buf = tpz_get_rcvmsg_spinwait();	
#ifdef RPC_DEBUG
	printf("Client received message!\n");	
#endif
	return (*_msg_buf != NULL);
}

int flick_trapeze_client_send(FLICK_CLIENT in_cli,
			      FLICK_BUFFER _msg_buf,
			      tpz_msgspec_t specifier)
{
	tpz_aim(_msg_buf, in_cli->dest, specifier);
	tpz_release_sendmsg(_msg_buf);
	return 1;
}

int flick_trapeze_server_get_request(FLICK_BUFFER *_msg_buf)
{  
	*_msg_buf = tpz_get_rcvmsg_spinwait();
	return (*_msg_buf != NULL);
}

int flick_trapeze_server_send_reply(FLICK_BUFFER _msg_buf,
				    tpz_msgspec_t specifier)
{  /* should never be called.  All is handled by start_encode and end_encode */
	return 1;
}

void flick_trapeze_server_send_exception(FLICK_BUFFER _msg_buf,
					const char *exception_type)	
{
	caddr_t _buf_start;
	register void *_buf_current;
	CORBA_Environment _ev;
	FLICK_CLIENT_STRUCT obj;
	FLICK_CLIENT _this_obj = &obj;
	tpz_msgspec_t  _replytoken = TPZ_CTRL;
	
	/* fabricate an object, since we don't really have one
	   (so we can reuse the server macros) */
	obj.u.info.boa = 0;
	obj.u.info.key = 0;
	obj.u.info.type_id = 0;
	obj.u.info.type_id_len = 0;
	_buf_start = tpz_mtod(_msg_buf);
	obj.dest = ((short *)_buf_start)[1];
	obj.host = 2; /* XXX - host shouldn't be hardcoded */
	obj.server_func = 0;
	/* release the received message */
	tpz_release_rcvmsg(_msg_buf);
	
	flick_set_exception(0 /*boa*/, &_ev, exception_type,
			    0, CORBA_COMPLETED_NO);
	
	flick_trapeze_server_start_encode(); /* get message from send ring */
	flick_trapeze_server_encode_target(_this_obj, 0, cdr);
	flick_corba_encode_exception_type(_ev._major, cdr, trapeze);
	flick_corba_encode_system_exception(&_ev, cdr, trapeze);
	flick_trapeze_server_end_encode(); /* actually sends reply */
}

/* End of file. */
