/*
 * Copyright (c) 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation.
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#define FLICK_PROTOCOL_TRAPEZE
#include <assert.h>
#include "trapeze-link.h"

/* needed only for flick_check_byte_order */
#include <flick/encode/cdr.h>

CORBA_boolean CORBA_Object_is_nil(FLICK_CLIENT ths, CORBA_Environment *ev)
{
	CORBA_BOA_set_exception((ths ? ths->u.info.boa : 0) /* XXX */, ev,
				CORBA_NO_EXCEPTION, 0, 0);
	
	return !ths;
}

FLICK_CLIENT CORBA_Object_duplicate(FLICK_CLIENT ths, CORBA_Environment *ev)
{
	FLICK_CLIENT res;
	
	if (!ths) {
		/*
		 * We can't use `CORBA_BOA_set_exception' here, because our
		 * nil object doesn't have a BOA.  (Is this wrong?)
		 */
		ev->_major = CORBA_NO_EXCEPTION;
		return ths;
	}
	
	res = t_malloc(FLICK_CLIENT_STRUCT, 1);
	if (!res) {			
		flick_set_exception(ths->u.info.boa, ev, ex_CORBA_NO_MEMORY,
				    0, CORBA_COMPLETED_NO);
		return 0 /* nil FLICK_CLIENT */;
	}
	
	res->u.info.boa = ths->u.info.boa;
	
	res->dest = ths->dest;
	res->u.info.key = ths->u.info.key;
	res->server_func = ths->server_func;
	
	res->u.info.type_id = t_malloc(char, (ths->u.info.type_id_len + 1));
	if (!res->u.info.type_id) {
		flick_set_exception(ths->u.info.boa, ev, ex_CORBA_NO_MEMORY,
				    0, CORBA_COMPLETED_NO);
		free(res);
		return 0 /* nil FLICK_CLIENT */;
	}
	strncpy((char *) res->u.info.type_id, ths->u.info.type_id, (ths->u.info.type_id_len + 1));
	
	res->u.info.type_id_len = ths->u.info.type_id_len;
	
	CORBA_BOA_set_exception(ths->u.info.boa, ev, CORBA_NO_EXCEPTION, 0, 0);
	return res;
}

void CORBA_Object_release(FLICK_CLIENT ths, CORBA_Environment *ev)
{
	CORBA_BOA_set_exception((ths ? ths->u.info.boa : 0), ev,
				CORBA_NO_EXCEPTION, 0, 0);
	
	if (ths && ths->u.info.type_id)
		free((char *) ths->u.info.type_id);
	if (ths)
		free(ths);
}

CORBA_unsigned_long CORBA_Object_hash(FLICK_CLIENT ths,
				      CORBA_unsigned_long maximum,
				      CORBA_Environment *ev)
{
	unsigned long hash = 0;
//	unsigned int i;
	
	if (!ths) {
		/* No object --> no BOA --> no `CORBA_BOA_set_exception'. */
		ev->_major = CORBA_NO_EXCEPTION;
		return hash;
	}
	
	hash = ths->u.info.key % maximum;
	CORBA_BOA_set_exception(ths->u.info.boa, ev, CORBA_NO_EXCEPTION, 0, 0);
	return hash;
}

CORBA_boolean CORBA_Object_is_equivalent(FLICK_CLIENT ths,
					 FLICK_CLIENT other_object,
					 CORBA_Environment *ev)
{
//	unsigned int i;
	
	/*
	 * XXX --- should null object references cause us to signal an error?
	 */
	CORBA_BOA_set_exception((ths ? ths->u.info.boa : 0), ev,
				CORBA_NO_EXCEPTION, 0, 0);
	
	if (ths == other_object)
		return 1;
	if (!ths || !other_object)
		return 0;
	if (ths->u.info.boa != other_object->u.info.boa)
		return 0;
	if (ths->server_func != other_object->server_func)
		return 0;
	if (ths->u.info.key != other_object->u.info.key)
		return 0;
	return 1;
}

/* End of file. */

