# 1 "../shared_src/fsys_ext2fs.c"
 



















# 1 "../shared_src/shared.h" 1
 


















 



 





 







 



 






 






 





















 














 


















 















 




























 




static inline unsigned char
inb(unsigned short port)
{
        unsigned char data;

        __asm __volatile("inb %1,%0" : "=a" (data) : "d" (port));
        return data;
}

static inline void
outb(unsigned short port, unsigned char val)
{
        __asm __volatile("outb %0,%1" : :"a" (val), "d" (port));
}


 

# 1 "../shared_src/mb_header.h" 1
 


















 



struct multiboot_header
{
   
  unsigned magic;

   
  unsigned flags;

   




  unsigned checksum;

   
  unsigned header_addr;
  unsigned load_addr;
  unsigned load_end_addr;
  unsigned bss_end_addr;
  unsigned entry_addr;
};

 










 


 






 


 


 


 


# 180 "../shared_src/shared.h" 2

# 1 "../shared_src/mb_info.h" 1
 


















 



struct mod_list
{
   
  unsigned long mod_start;
  unsigned long mod_end;

   
  unsigned long cmdline;

   
  unsigned long pad;
};


 






struct AddrRangeDesc
{
  unsigned long size;
  unsigned long BaseAddrLow;
  unsigned long BaseAddrHigh;
  unsigned long LengthLow;
  unsigned long LengthHigh;
  unsigned long Type;

   
};

 



 






struct multiboot_info
{
   
  unsigned long flags;

   
  unsigned long mem_lower;
  unsigned long mem_upper;

   
  unsigned long boot_device;

   
  unsigned long cmdline;

   
  unsigned long mods_count;
  unsigned long mods_addr;

  union
  {
    struct
    {
       
      unsigned long tabsize;
      unsigned long strsize;
      unsigned long addr;
      unsigned long pad;
    } a;

    struct
    {
       
      unsigned long num;
      unsigned long size;
      unsigned long addr;
      unsigned long shndx;
    } e;
  } syms;

   
  unsigned long mmap_length;
  unsigned long mmap_addr;
};

 



 

 

 

 


 

 

 


 


 





# 181 "../shared_src/shared.h" 2


extern char end[];     

 
void cmain(void) __attribute__ ((noreturn));




 



extern unsigned long install_partition;
extern unsigned long boot_drive;
extern char version_string[];
extern char config_file[];

 
void chain_stage1(int segment, int offset, int part_table_addr)
     __attribute__ ((noreturn));
void chain_stage2(int segment, int offset) __attribute__ ((noreturn));

 
void linux_boot(void) __attribute__ ((noreturn));

 
void multi_boot(int start, int mbi) __attribute__ ((noreturn));

 
void gateA20(int linear);

 
int get_memsize(int type);
int get_eisamemsize(void);
int get_mmap_entry(int buf, int cont);

 
int getrtsecs(void);

 
void cls(void);
int getxy(void);      
void gotoxy(int x, int y);

 











void putchar(int c);

 












int asm_getkey(void);

 


 
int checkkey(void);

 


void set_attrib(int attr);

 
int get_diskinfo(int drive);
int biosdisk(int subfunc, int drive, int geometry,
	     int sector, int nsec, int segment);
void stop_floppy(void);


 





extern int fallback;
extern int protected;
extern char commands[];



char *skip_to(int after_equal, char *cmdline);
void init_cmdline(void);
int enter_cmdline(char *script, char *heap);


 





int special_attribute;

































 












int getkey(void);   


void init_page(void);
void print_error(void);
char *convert_to_ascii(char *buf, int c, ...);
void printf(char *format, ... );
int sprintf(char *buffer, char *format, ... );
int get_cmdline(char *prompt, char *commands, char *cmdline, int maxlen);
int tolower(int c);
int isspace(int c);
int strncat(char *s1, char *s2, int n);
int strcmp(char *s1, char *s2);
char *strstr(char *s1, char *s2);
int bcopy(char *from, char *to, int len);
int bzero(char *start, int len);
int get_based_digit(int c, int base);
int safe_parse_maxint(char **str_ptr, int *myint_ptr);
int memcheck(int start, int len);


 





extern int no_decompression;
extern int compressed_file;



int gunzip_test_header(void);
int gunzip_read(int addr, int len);


 











extern unsigned long current_drive;
extern unsigned long current_partition;

extern int fsys_type;





extern long part_start;
extern long part_length;

extern int current_slice;

extern int buf_drive;
extern int buf_track;
extern int buf_geom;

 
extern int filepos;
extern int filemax;



int rawread(int drive, int sector, int byte_offset, int byte_len, int addr);
int devread(int sector, int byte_offset, int byte_len, int addr);

char *set_device(char *device);   

int open_device(void);
int make_saved_active(void);    


int open(char *filename);
int read(int addr, int len);   

int dir(char *dirname);        

int set_bootdev(int hdbias);
void print_fsys_type(void);    

void print_completions(char *filename);  

void copy_current_part_entry(int addr);  



 



 
typedef void
(*entry_func)(int, int, int, int, int, int) __attribute__ ((noreturn));



extern char *cur_cmdline;
extern entry_func entry_addr;



void bsd_boot(int type, int bootdev) __attribute__ ((noreturn));
int load_image(void);
int load_module(void);


 






 



extern struct multiboot_info mbi;
extern unsigned long saved_drive;
extern unsigned long saved_partition;
extern unsigned long saved_mem_upper;

 



extern int errnum;
extern char *err_list[];



void init_bios_info(void) __attribute__ ((noreturn));


# 21 "../shared_src/fsys_ext2fs.c" 2





# 1 "../shared_src/filesys.h" 1
 


















# 1 "../shared_src/pc_slice.h" 1
 





















 












 



















































 






 










  




 

















 









































 












 


















# 20 "../shared_src/filesys.h" 2







 



 
















# 56 "../shared_src/filesys.h"






int ext2fs_mount(void);
int ext2fs_read(int addr, int len);
int ext2fs_dir(char *dirname);




























 
# 103 "../shared_src/filesys.h"


 

struct fsys_entry
{
  char *name;
  int (*mount_func)(void);
  int (*read_func)(int addr, int len);
  int (*dir_func)(char *dirname);
};



extern int fsmax;
extern int print_possibilities;
extern struct fsys_entry fsys_table[( 0  + 0  + 1  + 0  + 0 ) +1];

# 150 "../shared_src/filesys.h"


# 26 "../shared_src/fsys_ext2fs.c" 2



static int mapblock1, mapblock2;

 


 

 

 


 
typedef __signed__ char __s8;
typedef unsigned char __u8;
typedef __signed__ short __s16;
typedef unsigned short __u16;
typedef __signed__ int __s32;
typedef unsigned int __u32;

 








 
struct ext2_super_block {
        __u32   s_inodes_count;          
        __u32   s_blocks_count;          
        __u32   s_r_blocks_count;        
        __u32   s_free_blocks_count;     
        __u32   s_free_inodes_count;     
        __u32   s_first_data_block;      
        __u32   s_log_block_size;        
        __s32   s_log_frag_size;         
        __u32   s_blocks_per_group;      
        __u32   s_frags_per_group;       
        __u32   s_inodes_per_group;      
        __u32   s_mtime;                 
        __u32   s_wtime;                 
        __u16   s_mnt_count;             
        __s16   s_max_mnt_count;         
        __u16   s_magic;                 
        __u16   s_state;                 
        __u16   s_errors;                
        __u16   s_pad;
        __u32   s_lastcheck;             
        __u32   s_checkinterval;         
        __u32   s_creator_os;            
        __u32   s_rev_level;             
        __u16   s_def_resuid;            
        __u16   s_def_resgid;            
        __u32   s_reserved[235];         
};

struct ext2_group_desc
{
        __u32   bg_block_bitmap;                 
        __u32   bg_inode_bitmap;                 
        __u32   bg_inode_table;          
        __u16   bg_free_blocks_count;    
        __u16   bg_free_inodes_count;    
        __u16   bg_used_dirs_count;      
        __u16   bg_pad;
        __u32   bg_reserved[3];
};

struct ext2_inode {
        __u16   i_mode;          
        __u16   i_uid;           
        __u32   i_size;          
        __u32   i_atime;         
        __u32   i_ctime;         
        __u32   i_mtime;         
        __u32   i_dtime;         
        __u16   i_gid;           
        __u16   i_links_count;   
        __u32   i_blocks;        
        __u32   i_flags;         
        union {
                struct {
                        __u32  l_i_reserved1;
                } linux1;
                struct {
                        __u32  h_i_translator;
                } hurd1;
                struct {
                        __u32  m_i_reserved1;
                } masix1;
        } osd1;                          
        __u32   i_block[(((12   + 1)  + 1)  + 1) ]; 
        __u32   i_version;       
        __u32   i_file_acl;      
        __u32   i_dir_acl;       
        __u32   i_faddr;         
        union {
                struct {
                        __u8    l_i_frag;        
                        __u8    l_i_fsize;       
                        __u16   i_pad1;
                        __u32   l_i_reserved2[2];
                } linux2;
                struct {
                        __u8    h_i_frag;        
                        __u8    h_i_fsize;       
                        __u16   h_i_mode_high;
                        __u16   h_i_uid_high;
                        __u16   h_i_gid_high;
                        __u32   h_i_author;
                } hurd2;
                struct {
                        __u8    m_i_frag;        
                        __u8    m_i_fsize;       
                        __u16   m_pad1;
                        __u32   m_i_reserved2[2];
                } masix2;
        } osd2;                          
};

 


 
typedef long off_t;

 

struct ext2_dir_entry {
        __u32   inode;                   
        __u16   rec_len;                 
        __u16   name_len;                
        char    name[255 ];     
};

 
 










 





 
 












 



 

 

 


 






 
 



__inline__ unsigned long ffz(unsigned long word)
{
        __asm__("bsfl %1,%0"
                :"=r" (word)
                :"r" (~word));
        return word;
}

 
int
ext2fs_mount(void)
{
  int retval = 1;

  if ( (((current_drive & 0x80) || (current_slice != 0))
	&& (current_slice != 0x83 )
	&& (current_slice != (0xa5  | (10 <<8))))
       || part_length < ((1  * 1024  / 512 )  + (sizeof(struct ext2_super_block)/ 512 ))
       || !devread((1  * 1024  / 512 ) , 0, sizeof(struct ext2_super_block), (int)((struct ext2_super_block *)(0x68000 )) )
       || ((struct ext2_super_block *)(0x68000 )) ->s_magic != 0xEF53 )
    retval = 0;

  return retval;
}

 


int
ext2_rdfsb (int fsblock, int buffer) {



  return devread(fsblock * (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) )  / 512 , 0,
                 (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) , (int)buffer);
}

 


 


int
ext2fs_block_map(int logical_block)
{

# 280 "../shared_src/fsys_ext2fs.c"


   
  if (logical_block < 12 ) {




    return ((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) )) ->i_block[logical_block];
  }
   
  logical_block -= 12 ;
   
  if (logical_block < ((1 << ((   ((struct ext2_super_block *)(0x68000 ))    )->s_log_block_size + 10) )  / sizeof (__u32)) ) {
    if ( mapblock1 != 1
	 && !ext2_rdfsb(((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) )) ->i_block[12  ], ((int)((int)((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) ))  + sizeof(struct ext2_inode))) )) {
      errnum = (((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
      return -1;
    }
    mapblock1 = 1;
    return ((__u32 *)((int)((int)((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) ))  + sizeof(struct ext2_inode))) )[logical_block];
  }
   
  logical_block -= ((1 << ((   ((struct ext2_super_block *)(0x68000 ))    )->s_log_block_size + 10) )  / sizeof (__u32)) ;
   
  if (logical_block < (1 << ((ffz(~( ((1 << ((    ((struct ext2_super_block *)(0x68000 ))     )->s_log_block_size + 10) )  / sizeof (__u32))  )) )  * 2))) {
    int bnum;
    if ( mapblock1 != 2
	 && !ext2_rdfsb(((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) )) ->i_block[(12   + 1) ], ((int)((int)((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) ))  + sizeof(struct ext2_inode))) )) {
      errnum = (((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
      return -1;
    }
    mapblock1 = 2;
    if ( (bnum = (((__u32 *)((int)((int)((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) ))  + sizeof(struct ext2_inode))) )
		  [logical_block >> (ffz(~( ((1 << ((    ((struct ext2_super_block *)(0x68000 ))     )->s_log_block_size + 10) )  / sizeof (__u32))  )) ) ]))
	 != mapblock2
	 && !ext2_rdfsb(bnum, ((int)((int)((int)((int)((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) ))  + sizeof(struct ext2_inode)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) )) )) {
      errnum = (((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
      return -1;
    }
    mapblock2 = bnum;
    return ((__u32 *)((int)((int)((int)((int)((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) ))  + sizeof(struct ext2_inode)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) )) )
            [logical_block & (((1 << ((   ((struct ext2_super_block *)(0x68000 ))    )->s_log_block_size + 10) )  / sizeof (__u32))  - 1)];
  }
   
  mapblock2 = -1;
  logical_block -= (1 << ((ffz(~( ((1 << ((    ((struct ext2_super_block *)(0x68000 ))     )->s_log_block_size + 10) )  / sizeof (__u32))  )) )  * 2));
  if ( mapblock1 != 3
       && !ext2_rdfsb(((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) )) ->i_block[((12   + 1)  + 1) ], ((int)((int)((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) ))  + sizeof(struct ext2_inode))) )) {
    errnum = (((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
    return -1;
  }
  mapblock1 = 3;
  if (!ext2_rdfsb(((__u32 *)((int)((int)((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) ))  + sizeof(struct ext2_inode))) )
                  [logical_block >> ((ffz(~( ((1 << ((    ((struct ext2_super_block *)(0x68000 ))     )->s_log_block_size + 10) )  / sizeof (__u32))  )) ) *2)],
                  ((int)((int)((int)((int)((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) ))  + sizeof(struct ext2_inode)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) )) )) {
    errnum = (((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
    return -1;
  }
  if (!ext2_rdfsb(((__u32 *)((int)((int)((int)((int)((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) ))  + sizeof(struct ext2_inode)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) )) )
                  [(logical_block >> (ffz(~( ((1 << ((    ((struct ext2_super_block *)(0x68000 ))     )->s_log_block_size + 10) )  / sizeof (__u32))  )) ) )
                   & (((1 << ((   ((struct ext2_super_block *)(0x68000 ))    )->s_log_block_size + 10) )  / sizeof (__u32))  - 1)],
                  ((int)((int)((int)((int)((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) ))  + sizeof(struct ext2_inode)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) )) )) {
    errnum = (((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
    return -1;
  }
  return ((__u32 *)((int)((int)((int)((int)((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) ))  + sizeof(struct ext2_inode)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) )) )
    [logical_block & (((1 << ((   ((struct ext2_super_block *)(0x68000 ))    )->s_log_block_size + 10) )  / sizeof (__u32)) -1)];
}

 
int
ext2fs_read(int addr, int len)
{
  int logical_block;
  int offset;
  int map;
  int ret = 0;
  int size = 0;

# 370 "../shared_src/fsys_ext2fs.c"

  while(len > 0) {
     
    logical_block = filepos >> (( ((struct ext2_super_block *)(0x68000 ))  )->s_log_block_size + 10) ;
    offset = filepos & ((1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) )  - 1);
    map = ext2fs_block_map(logical_block);



    if (map < 0)
      break;

    size = (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) ;
    size -= offset;
    if (size > len)
      size = len;





    devread(map * (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) )  / 512 ,
	    offset, size, addr);
 




    addr += size;
    len -= size;
    filepos += size;
    ret += size;
  }

  if (errnum)
    ret = 0;

  return ret;
}


 






















 






int
ext2fs_dir(char *dirname)
{
  int current_ino = 2 ;  
  int group_id;  
  int group_desc;   
  int desc;  
  int ino_blk;  
  int str_chk;  
  struct ext2_group_desc * gdp;
  struct ext2_inode * raw_inode;  

  char *rest;
  char ch;  

  int off;  
  int loc;  
  int blk;  
  long map;  
  struct ext2_dir_entry *dp;  




   





  while (1) {





     
    group_id = (current_ino - 1) / (((struct ext2_super_block *)(0x68000 )) ->s_inodes_per_group);
    group_desc = group_id >> ffz(~( ((1 << ((   ((struct ext2_super_block *)(0x68000 ))    )->s_log_block_size + 10) )  / sizeof (struct ext2_group_desc))  )) ;
    desc = group_id & (((1 << ((   ((struct ext2_super_block *)(0x68000 ))    )->s_log_block_size + 10) )  / sizeof (struct ext2_group_desc))  - 1);





    if (!ext2_rdfsb((1  + group_desc + 1), (int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block))) )) {
      return 0;
    }
    gdp = ((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block))) ;
    ino_blk = gdp[desc].bg_inode_table +
      (((current_ino - 1) % (((struct ext2_super_block *)(0x68000 )) ->s_inodes_per_group))
       >> ffz(~( (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) )  / sizeof(struct ext2_inode) )) );



    if (!ext2_rdfsb(ino_blk, (int)((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) )) )) {
      return 0;
    }

     
    mapblock2 = mapblock1 = -1;

    raw_inode = ((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) ))  +
      ((current_ino - 1)
       & ((1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) )  / sizeof(struct ext2_inode) - 1));
# 519 "../shared_src/fsys_ext2fs.c"


     
    bcopy((void *)raw_inode, (void *)((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) )) , sizeof(struct ext2_inode));





     
    if (!*dirname || isspace(*dirname))
      {
	if (! ((( ((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) )) ->i_mode ) & 00170000 ) == 0100000 ) )
	  {
	    errnum = ((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
	    return 0;
	  }

	filemax = (((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) )) ->i_size);
	return 1;
      }

     

     
    while (*dirname == '/')
      dirname++;

     
    if (!(((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) )) ->i_size) || ! ((( ((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) )) ->i_mode ) & 00170000 ) == 0040000 ) )
      {
	errnum = ((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
	return 0;
      }

     
    for (rest = dirname; (ch = *rest) && !isspace(ch) && ch != '/'; rest++) ;

     
     
    *rest = 0;
    loc = 0;

    do {





       

      if (loc >= ((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) )) ->i_size) {
	if (print_possibilities < 0) {
	  putchar('\n');
	}
	else {    
	  errnum = (((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
	  *rest = ch;
	}
	return (print_possibilities < 0);
      }

       
      blk = loc >> (( ((struct ext2_super_block *)(0x68000 ))  )->s_log_block_size + 10) ;

       


      map = ext2fs_block_map(blk);



      mapblock2 = -1;
      if ((map < 0) || !ext2_rdfsb(map, ((int)((int)((int)((int)((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) ))  + sizeof(struct ext2_inode)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) )) )) {
        errnum = (((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
        *rest = ch;
        return 0;
      }
      off = loc & ((1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) )  - 1);
      dp = (struct ext2_dir_entry *)(((int)((int)((int)((int)((struct ext2_inode *)((int)((struct ext2_group_desc *) ((int)((struct ext2_super_block *)(0x68000 ))  + sizeof(struct ext2_super_block)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) ))  + sizeof(struct ext2_inode)))  + (1 << ((  ((struct ext2_super_block *)(0x68000 ))   )->s_log_block_size + 10) ) ))  + off);
       
      loc += dp->rec_len;

       







      if (dp->inode)
	{
	  int saved_c = dp->name[dp->name_len];

	  dp->name[dp->name_len] = 0;
	  str_chk = strcmp(dirname, dp->name);

	  if (print_possibilities && ch != '/'
	      && (!*dirname || str_chk <= 0))
	    {
	      if (print_possibilities > 0)
		print_possibilities = -print_possibilities;
	      printf("  %s", dp->name);
	    }

	  dp->name[dp->name_len] = saved_c;
	}

    } while (!dp->inode || (str_chk || (print_possibilities && ch != '/')) );

    current_ino = dp->inode;
    *(dirname = rest) = ch;
  }
   
}
