# 1 "../shared_src/char_io.c"
 





















# 1 "../shared_src/shared.h" 1
 


















 



 





 







 



 






 






 





















 














 


















 















 




























 




static inline unsigned char
inb(unsigned short port)
{
        unsigned char data;

        __asm __volatile("inb %1,%0" : "=a" (data) : "d" (port));
        return data;
}

static inline void
outb(unsigned short port, unsigned char val)
{
        __asm __volatile("outb %0,%1" : :"a" (val), "d" (port));
}


 

# 1 "../shared_src/mb_header.h" 1
 


















 



struct multiboot_header
{
   
  unsigned magic;

   
  unsigned flags;

   




  unsigned checksum;

   
  unsigned header_addr;
  unsigned load_addr;
  unsigned load_end_addr;
  unsigned bss_end_addr;
  unsigned entry_addr;
};

 










 


 






 


 


 


 


# 180 "../shared_src/shared.h" 2

# 1 "../shared_src/mb_info.h" 1
 


















 



struct mod_list
{
   
  unsigned long mod_start;
  unsigned long mod_end;

   
  unsigned long cmdline;

   
  unsigned long pad;
};


 






struct AddrRangeDesc
{
  unsigned long size;
  unsigned long BaseAddrLow;
  unsigned long BaseAddrHigh;
  unsigned long LengthLow;
  unsigned long LengthHigh;
  unsigned long Type;

   
};

 



 






struct multiboot_info
{
   
  unsigned long flags;

   
  unsigned long mem_lower;
  unsigned long mem_upper;

   
  unsigned long boot_device;

   
  unsigned long cmdline;

   
  unsigned long mods_count;
  unsigned long mods_addr;

  union
  {
    struct
    {
       
      unsigned long tabsize;
      unsigned long strsize;
      unsigned long addr;
      unsigned long pad;
    } a;

    struct
    {
       
      unsigned long num;
      unsigned long size;
      unsigned long addr;
      unsigned long shndx;
    } e;
  } syms;

   
  unsigned long mmap_length;
  unsigned long mmap_addr;
};

 



 

 

 

 


 

 

 


 


 





# 181 "../shared_src/shared.h" 2


extern char end[];     

 
void cmain(void) __attribute__ ((noreturn));




 



extern unsigned long install_partition;
extern unsigned long boot_drive;
extern char version_string[];
extern char config_file[];

 
void chain_stage1(int segment, int offset, int part_table_addr)
     __attribute__ ((noreturn));
void chain_stage2(int segment, int offset) __attribute__ ((noreturn));

 
void linux_boot(void) __attribute__ ((noreturn));

 
void multi_boot(int start, int mbi) __attribute__ ((noreturn));

 
void gateA20(int linear);

 
int get_memsize(int type);
int get_eisamemsize(void);
int get_mmap_entry(int buf, int cont);

 
int getrtsecs(void);

 
void cls(void);
int getxy(void);      
void gotoxy(int x, int y);

 











void putchar(int c);

 












int asm_getkey(void);

 


 
int checkkey(void);

 


void set_attrib(int attr);

 
int get_diskinfo(int drive);
int biosdisk(int subfunc, int drive, int geometry,
	     int sector, int nsec, int segment);
void stop_floppy(void);


 





extern int fallback;
extern int protected;
extern char commands[];



char *skip_to(int after_equal, char *cmdline);
void init_cmdline(void);
int enter_cmdline(char *script, char *heap);


 







































 












int getkey(void);   


void init_page(void);
void print_error(void);
char *convert_to_ascii(char *buf, int c, ...);
void printf(char *format, ... );
int sprintf(char *buffer, char *format, ... );
int get_cmdline(char *prompt, char *commands, char *cmdline, int maxlen);
int tolower(int c);
int isspace(int c);
int strncat(char *s1, char *s2, int n);
int strcmp(char *s1, char *s2);
char *strstr(char *s1, char *s2);
int bcopy(char *from, char *to, int len);
int bzero(char *start, int len);
int get_based_digit(int c, int base);
int safe_parse_maxint(char **str_ptr, int *myint_ptr);
int memcheck(int start, int len);


 





extern int no_decompression;
extern int compressed_file;



int gunzip_test_header(void);
int gunzip_read(int addr, int len);


 











extern unsigned long current_drive;
extern unsigned long current_partition;

extern int fsys_type;





extern long part_start;
extern long part_length;

extern int current_slice;

extern int buf_drive;
extern int buf_track;
extern int buf_geom;

 
extern int filepos;
extern int filemax;



int rawread(int drive, int sector, int byte_offset, int byte_len, int addr);
int devread(int sector, int byte_offset, int byte_len, int addr);

char *set_device(char *device);   

int open_device(void);
int make_saved_active(void);    


int open(char *filename);
int read(int addr, int len);   

int dir(char *dirname);        

int set_bootdev(int hdbias);
void print_fsys_type(void);    

void print_completions(char *filename);  

void copy_current_part_entry(int addr);  



 



 
typedef void
(*entry_func)(int, int, int, int, int, int) __attribute__ ((noreturn));



extern char *cur_cmdline;
extern entry_func entry_addr;



void bsd_boot(int type, int bootdev) __attribute__ ((noreturn));
int load_image(void);
int load_module(void);


 






 



extern struct multiboot_info mbi;
extern unsigned long saved_drive;
extern unsigned long saved_partition;
extern unsigned long saved_mem_upper;

 



extern int errnum;
extern char *err_list[];



void init_bios_info(void) __attribute__ ((noreturn));


# 23 "../shared_src/char_io.c" 2












void
print_error(void)
{
  if (errnum > 0  && errnum < ((((((((((((((((((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) )




    printf("Error: %d\n", errnum);


  errnum = 0 ;
}


char *
convert_to_ascii(char *buf, int c, ...)
{
  unsigned long num = *((&c) + 1), mult = 10;
  char *ptr = buf;

  if (c == 'x')
    mult = 16;

  if ((num & 0x80000000uL) && c == 'd')
    {
      num = (~num)+1;
      *(ptr++) = '-';
      buf++;
    }

  do
    {
      int dig = num % mult;
      *(ptr++) = ( (dig > 9) ? dig + 'a' - 10 : '0' + dig );
    }
  while (num /= mult);

   
  {
    char *ptr1 = ptr-1;
    char *ptr2 = buf;
    while (ptr1 > ptr2)
      {
	int c = *ptr1;
	*ptr1 = *ptr2;
	*ptr2 = c;
	ptr1--;
	ptr2++;
      }
  }

  return ptr;
}


void
printf(char *format, ... )
{
  int *dataptr = (int *) &format;
  char c, *ptr, str[16];

  dataptr++;

  while (c = *(format++))
    {
      if (c != '%')
	putchar(c);
      else
	switch (c = *(format++))
	  {
	  case 'd': case 'u': case 'x':
	    *convert_to_ascii(str, c, *((unsigned long *) dataptr++)) = 0;

	    ptr = str;

	    while (*ptr)
	      putchar(*(ptr++));
	    break;

	  case 'c': putchar((*(dataptr++))&0xff); break;

	  case 's':
	    ptr = (char *)(*(dataptr++));

	    while (c = *(ptr++))
	      putchar(c);
	    break;
	  }
    }
}

int
sprintf(char *buffer, char *format, ... )
{
   

  int *dataptr = (int *) &format;
  char c, *ptr, str[16];
  char *bp = buffer;

  dataptr++;

  while (c = *(format++))
    {
      if (c != '%')
	*bp++ = c;  
      else
	switch (c = *(format++))
	  {
	  case 'd': case 'u': case 'x':
	    *convert_to_ascii(str, c, *((unsigned long *) dataptr++)) = 0;

	    ptr = str;

	    while (*ptr)
	      *bp++ = *(ptr++);  
	    break;

	  case 'c': *bp++ = (*(dataptr++))&0xff;
	      
	    break;

	  case 's':
	    ptr = (char *)(*(dataptr++));

	    while (c = *(ptr++))
	      *bp++ = c;  
	    break;
	  }
    }

  *bp = 0;
  return bp - buffer;
}

# 454 "../shared_src/char_io.c"



int
get_based_digit(int c, int base)
{
  int digit = -1;

   
  c = tolower(c);

   


  if (base > 0 && c >= '0' && c <= '9' && c < (base + '0'))
    {
      digit = c - '0';
    }

   


  if (base > 10 && c >= 'a' && c <= 'z' && c < ((base - 10) + 'a'))
    {
      digit = c - 'a' + 10;
    }

  return digit;
}


int
safe_parse_maxint(char **str_ptr, int *myint_ptr)
{
  register char *ptr = *str_ptr;
  register int myint = 0, digit;
  int mult = 10, found = 0;

   


  if (*ptr == '0' && tolower(*(ptr+1)) == 'x')
    {
      ptr += 2;
      mult = 16;
    }

  while ((digit = get_based_digit(*ptr, mult)) != -1)
    {
      found = 1;
      if (myint > ((0x7FFFFFFF  - digit)/mult))
	{
	  errnum = (((((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
	  return 0;
	}
      myint = (myint * mult) + digit;
      ptr++;
    }

  if (!found)
    {
      errnum = (((((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
      return 0;
    }

  *str_ptr = ptr;
  *myint_ptr = myint;

  return 1;
}


int
tolower(int c)
{
  if (c >= 'A' && c <= 'Z')
    return (c + ('a' - 'A'));

  return c;
}


int
isspace(int c)
{
  if (c == ' ' || c == '\t' || c == '\n')
    return 1;

  return 0;
}


int
strncat(char *s1, char *s2, int n)
{
  int i = -1;

  while (++i < n && s1[i] != 0);

  while (i < n && (s1[i++] = *(s2++)) != 0);

  s1[n-1] = 0;

  if (i >= n)
    return 0;

  s1[i] = 0;

  return 1;
}


int
strcmp(char *s1, char *s2)
{
  while (*s1 == *s2)
    {
      if (!*(s1++))
	return 0;
      s2++;
    }

  if (*s1 == 0)
    return -1;

  return 1;
}


char *
strstr(char *s1, char *s2)
{
  char *ptr, *tmp;

  while (*s1)
    {
      ptr = s1;
      tmp = s2;

      while (*s1 && *s1++ == *tmp++);

      if (tmp > s2 && !*(tmp-1))
	return ptr;
    }

  return 0;
}


int
memcheck(int start, int len)
{
  if ( (start < 0x1000) || (start < 0x100000
			   && (mbi.mem_lower * 1024) < (start+len))
       || (start >= 0x100000
	   && (mbi.mem_upper * 1024) < ((start-0x100000)+len)) )
    errnum = (0  + 1) ;

  return (!errnum);
}


int
bcopy(char *from, char *to, int len)
{
  if (memcheck((int)to, len))
    {
      if ((to >= from+len) || (to <= from))
	{
	  while (len > 3)
	    {
	      len -= 4;
	      *(((unsigned long *)to)++) = *(((unsigned long *)from)++);
	    }
	  while (len-- > 0)
	    *(to++) = *(from++);
	}
      else
	{
	  while (len-- > 0)
	    to[len] = from[len];
	}
    }

  return (!errnum);
}


int
bzero(char *start, int len)
{
  if (memcheck((int)start, len))
    {
      while (len-- > 0)
	*(start++) = 0;
    }

  return (!errnum);
}


