# 1 "../shared_src/disk_io.c"
 





















# 1 "../shared_src/shared.h" 1
 


















 



 





 







 



 






 






 





















 














 


















 















 




























 




static inline unsigned char
inb(unsigned short port)
{
        unsigned char data;

        __asm __volatile("inb %1,%0" : "=a" (data) : "d" (port));
        return data;
}

static inline void
outb(unsigned short port, unsigned char val)
{
        __asm __volatile("outb %0,%1" : :"a" (val), "d" (port));
}


 

# 1 "../shared_src/mb_header.h" 1
 


















 



struct multiboot_header
{
   
  unsigned magic;

   
  unsigned flags;

   




  unsigned checksum;

   
  unsigned header_addr;
  unsigned load_addr;
  unsigned load_end_addr;
  unsigned bss_end_addr;
  unsigned entry_addr;
};

 










 


 






 


 


 


 


# 180 "../shared_src/shared.h" 2

# 1 "../shared_src/mb_info.h" 1
 


















 



struct mod_list
{
   
  unsigned long mod_start;
  unsigned long mod_end;

   
  unsigned long cmdline;

   
  unsigned long pad;
};


 






struct AddrRangeDesc
{
  unsigned long size;
  unsigned long BaseAddrLow;
  unsigned long BaseAddrHigh;
  unsigned long LengthLow;
  unsigned long LengthHigh;
  unsigned long Type;

   
};

 



 






struct multiboot_info
{
   
  unsigned long flags;

   
  unsigned long mem_lower;
  unsigned long mem_upper;

   
  unsigned long boot_device;

   
  unsigned long cmdline;

   
  unsigned long mods_count;
  unsigned long mods_addr;

  union
  {
    struct
    {
       
      unsigned long tabsize;
      unsigned long strsize;
      unsigned long addr;
      unsigned long pad;
    } a;

    struct
    {
       
      unsigned long num;
      unsigned long size;
      unsigned long addr;
      unsigned long shndx;
    } e;
  } syms;

   
  unsigned long mmap_length;
  unsigned long mmap_addr;
};

 



 

 

 

 


 

 

 


 


 





# 181 "../shared_src/shared.h" 2


extern char end[];     

 
void cmain(void) __attribute__ ((noreturn));




 



extern unsigned long install_partition;
extern unsigned long boot_drive;
extern char version_string[];
extern char config_file[];

 
void chain_stage1(int segment, int offset, int part_table_addr)
     __attribute__ ((noreturn));
void chain_stage2(int segment, int offset) __attribute__ ((noreturn));

 
void linux_boot(void) __attribute__ ((noreturn));

 
void multi_boot(int start, int mbi) __attribute__ ((noreturn));

 
void gateA20(int linear);

 
int get_memsize(int type);
int get_eisamemsize(void);
int get_mmap_entry(int buf, int cont);

 
int getrtsecs(void);

 
void cls(void);
int getxy(void);      
void gotoxy(int x, int y);

 











void putchar(int c);

 












int asm_getkey(void);

 


 
int checkkey(void);

 


void set_attrib(int attr);

 
int get_diskinfo(int drive);
int biosdisk(int subfunc, int drive, int geometry,
	     int sector, int nsec, int segment);
void stop_floppy(void);


 





extern int fallback;
extern int protected;
extern char commands[];



char *skip_to(int after_equal, char *cmdline);
void init_cmdline(void);
int enter_cmdline(char *script, char *heap);


 





int special_attribute;

































 












int getkey(void);   


void init_page(void);
void print_error(void);
char *convert_to_ascii(char *buf, int c, ...);
void printf(char *format, ... );
int sprintf(char *buffer, char *format, ... );
int get_cmdline(char *prompt, char *commands, char *cmdline, int maxlen);
int tolower(int c);
int isspace(int c);
int strncat(char *s1, char *s2, int n);
int strcmp(char *s1, char *s2);
char *strstr(char *s1, char *s2);
int bcopy(char *from, char *to, int len);
int bzero(char *start, int len);
int get_based_digit(int c, int base);
int safe_parse_maxint(char **str_ptr, int *myint_ptr);
int memcheck(int start, int len);


 





extern int no_decompression;
extern int compressed_file;



int gunzip_test_header(void);
int gunzip_read(int addr, int len);


 



# 414 "../shared_src/shared.h"


int rawread(int drive, int sector, int byte_offset, int byte_len, int addr);
int devread(int sector, int byte_offset, int byte_len, int addr);

char *set_device(char *device);   

int open_device(void);
int make_saved_active(void);    


int open(char *filename);
int read(int addr, int len);   

int dir(char *dirname);        

int set_bootdev(int hdbias);
void print_fsys_type(void);    

void print_completions(char *filename);  

void copy_current_part_entry(int addr);  



 



 
typedef void
(*entry_func)(int, int, int, int, int, int) __attribute__ ((noreturn));



extern char *cur_cmdline;
extern entry_func entry_addr;



void bsd_boot(int type, int bootdev) __attribute__ ((noreturn));
int load_image(void);
int load_module(void);


 






 



extern struct multiboot_info mbi;
extern unsigned long saved_drive;
extern unsigned long saved_partition;
extern unsigned long saved_mem_upper;

 



extern int errnum;
extern char *err_list[];



void init_bios_info(void) __attribute__ ((noreturn));


# 23 "../shared_src/disk_io.c" 2


# 1 "../shared_src/filesys.h" 1
 


















# 1 "../shared_src/pc_slice.h" 1
 





















 












 



















































 






 










  




 

















 









































 












 


















# 20 "../shared_src/filesys.h" 2







 



 









int ffs_mount(void);
int ffs_read(int addr, int len);
int ffs_dir(char *dirname);




# 56 "../shared_src/filesys.h"





































 
# 103 "../shared_src/filesys.h"


 

struct fsys_entry
{
  char *name;
  int (*mount_func)(void);
  int (*read_func)(int addr, int len);
  int (*dir_func)(char *dirname);
};









int fsmax;
int print_possibilities;
struct fsys_entry fsys_table[( 1  + 0  + 0  + 0  + 0 ) +1] =
{
   









   


  { "ffs", ffs_mount, ffs_read, ffs_dir },






  { 0, 0, 0, 0 }
};



# 25 "../shared_src/disk_io.c" 2


 
# 1 "../shared_src/freebsd.h" 1
 


















 













 



 

























 




 




struct bootinfo {
        unsigned int            bi_version;
        unsigned char           *bi_kernelname;
        struct nfs_diskless     *bi_nfs_diskless;
                                 

        unsigned int            bi_n_bios_used;
        unsigned long           bi_bios_geom[8 ];
        unsigned int            bi_size;
        unsigned char           bi_memsizes_valid;
        unsigned char           bi_pad[3];
        unsigned long           bi_basemem;
        unsigned long           bi_extmem;
        unsigned long           bi_symtab;
        unsigned long           bi_esymtab;
};

# 28 "../shared_src/disk_io.c" 2








 

unsigned long current_drive = 0xFF;
unsigned long current_partition;

 



 
int bsd_evil_hack;

 
int fsys_type = ( 1  + 0  + 0  + 0  + 0 ) ;




 
long part_start;
long part_length;

int current_slice;

 
int buf_drive = -1;
int buf_track;
int buf_geom;

 
int filepos;
int filemax;


int
rawread(int drive, int sector, int byte_offset, int byte_len, int addr)
{
  int slen = (byte_offset+byte_len+511)/ 0x200 ;

  if (byte_len <= 0)
    return 1;

  while (byte_len > 0 && !errnum)
    {
      int soff, num_sect, bufaddr, track, size = byte_len;

       



      if (buf_drive != drive)
	{
	  buf_geom = get_diskinfo(drive);
	  buf_drive = drive;
	  buf_track = -1;
	}

      if (buf_geom == 0)
	{
	  errnum = ((0  + 1)  + 1) ;
	  return 0;
	}

       
      soff = sector % ( ( buf_geom ) & 0xFF ) ;
      track = sector - soff;
      num_sect = ( ( buf_geom ) & 0xFF )  - soff;
      bufaddr = 0x70000  + (soff * 0x200 ) + byte_offset;

      if (track != buf_track)
	{
	  int bios_err, read_start = track, read_len = ( ( buf_geom ) & 0xFF ) ;

	   




	  if (slen > num_sect)
	    {
	      read_start = sector;
	      read_len = num_sect;
	      bufaddr = 0x70000  + byte_offset;
	    }

	  if (bios_err = biosdisk(0x2 , drive, buf_geom,
				  read_start, read_len, 0x7000 ))
	    {
	      buf_track = -1;

	      if (bios_err == 0x100 )
		errnum = (((((0  + 1)  + 1)  + 1)  + 1)  + 1) ;
	      else
		{
		   



		  if (slen > num_sect
		      || biosdisk(0x2 , drive, buf_geom,
				  sector, slen, 0x7000 ))
		    errnum = (((0  + 1)  + 1)  + 1) ;

		  bufaddr = 0x7000  + byte_offset;
		}
	    }
	  else
	    buf_track = track;
	}

# 158 "../shared_src/disk_io.c"


      if (size > ((num_sect * 0x200 ) - byte_offset))
	size = (num_sect * 0x200 ) - byte_offset;

      bcopy((char *)bufaddr, (char *)addr, size);

      addr += size;
      byte_len -= size;
      sector += num_sect;
      slen -= num_sect;
      byte_offset = 0;
    }

  return (!errnum);
}


int
devread(int sector, int byte_offset, int byte_len, int addr)
{
   


  if (sector < 0
      || (sector + ((byte_offset+byte_len-1)/ 0x200 )) >= part_length)
    {
      errnum = ((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
      return 0;
    }

   


  while (byte_offset >= 0x200 )
    {
      byte_offset -= 0x200 ;
      sector++;
    }






   








  return rawread(current_drive, part_start+sector, byte_offset,
		 byte_len, addr);
}


int
sane_partition(void)
{
  if (current_drive == 0x20)
    return 1;

  if ( !(current_partition & 0xFF000000uL)
       && (current_drive & 0xFFFFFF7F) < 8
       && (current_partition & 0xFF) == 0xFF
       && ( (current_partition & 0xFF00) == 0xFF00
	    || (current_partition & 0xFF00) < 0x800 )
       && ( (current_partition >> 16) == 0xFF
	    || (current_drive & 0x80) ) )
    return 1;

  errnum = (((((((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
  return 0;
}


static void
attempt_mount(void)
{
  for ( fsys_type = 0; fsys_type < ( 1  + 0  + 0  + 0  + 0 ) 
	  && (*(fsys_table[fsys_type].mount_func))() != 1; fsys_type++);

  if (fsys_type == ( 1  + 0  + 0  + 0  + 0 )  && errnum == 0 )
    errnum = ((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
}


# 299 "../shared_src/disk_io.c"



static int
check_BSD_parts(int flags)
{
  char label_buf[0x200 ];
  int part_no, got_part = 0;

  if ( part_length < (1 +1) )
    {
      errnum = (((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
      return 0;
    }

  if (!rawread(current_drive, part_start + 1 ,
	       0, 0x200 , (int) label_buf))
    return 0;

  if ( ( *( (unsigned long *) (((int)  label_buf ) + 0 ) ) == ( (unsigned long) 0x82564557  ) )  )
    {
      for (part_no = 0; part_no < ( *( (unsigned short *) (((int)  label_buf ) + 138 ) ) ) ; part_no++)
	{
	  if (( *( (unsigned char *) (((int)  label_buf ) + 148  + 12 + (  part_no  << 4)) ) ) )
	    {
	       

	      current_slice = ((( *( (unsigned char *) (((int)  label_buf ) + 148  + 12 + (  part_no  << 4)) ) )  << 8)
			       | 0xa5 );
	      part_start = ( *( (unsigned long *) (((int)  label_buf ) + 148  + 4 + (  part_no  << 4)) ) ) ;
	      part_length = ( *( (unsigned long *) (((int)  label_buf ) + 148  + (  part_no  << 4)) ) ) ;

# 343 "../shared_src/disk_io.c"

		if (part_no == ((current_partition >> 8) & 0xFF))
		  break;
	    }
	}

      if (part_no >= ( *( (unsigned short *) (((int)  label_buf ) + 138 ) ) )  && !got_part)
	{
	  errnum = ((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
	  return 0;
	}

      if ((current_drive & 0x80)
	  && ( *( (unsigned short *) (((int)  label_buf ) + 0  + 4) ) )  == 4 )
	bsd_evil_hack = 4;

      return 1;
    }

  errnum = (((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
  return 0;
}


static char cur_part_desc[16];

static int
real_open_partition(int flags)
{
  char mbr_buf[0x200 ];
  int i, part_no, slice_no, ext = 0, part_offset = 0;

  if (current_drive == 0x20)
    return 1;			 

   



  if ( !sane_partition()
       || !rawread(current_drive, 0, 0, 0x200 , (int) mbr_buf) )
    return 0;

  bsd_evil_hack = 0;
  current_slice = 0;
  part_start = 0;
  part_length = ( ( buf_geom ) & 0xFF )  * ( ( ( ( buf_geom ) >> 8 ) & 0xFF ) + 1 )  * ( ( ( ( buf_geom ) >> 16 ) & 0x3FF ) + 1 ) ;

  if (current_drive & 0x80)
    {
       



      int ext_offset = 0, part_offset = 0;
      part_no = (current_partition >> 16);
      slice_no = 0;

       
      if (!flags && current_partition == 0xFFFFFFuL)
	return 1;

       


      while ( slice_no < 255 && ext >= 0
	      && (part_no == 0xFF || slice_no <= part_no)
	      && rawread(current_drive, part_offset,
			 0, 0x200 , (int) mbr_buf) )
	{
	   


	  if ( ! ( *( (unsigned short *) (((int)  mbr_buf ) + 510 ) ) == 0xaa55  )  )
	    {
	      errnum = (((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
	      return 0;
	    }

	  ext = -1;

	   


	  for (i = 0; i < 4 ; i++)
	    {
	      current_partition = ((slice_no << 16)
		                   | (current_partition & 0xFFFF));
	      current_slice = ( *( (unsigned char *) (((int)  mbr_buf ) + 446  + 4 + (  i  << 4)) ) ) ;
	      part_start = part_offset + ( *( (unsigned long *) (((int)  mbr_buf ) + 446  + 8 + (  i  << 4)) ) ) ;
	      part_length = ( *( (unsigned long *) (((int)  mbr_buf ) + 446  + 12 + (  i  << 4)) ) ) ;
	      bcopy(mbr_buf+ 446 +(i<<4), cur_part_desc, 16);

	       


	      if (current_slice)
		{
		   


		  if (current_slice == 5 )
		    {
		      if (ext == -1)
			{
			  ext = i;
			}
		    }
# 465 "../shared_src/disk_io.c"

		   


		  else if (part_no == slice_no
			   || (part_no == 0xFF
			       && current_slice == 0xa5 ))
		    {
		      if ((current_partition & 0xFF00) != 0xFF00)
			{
			  if (current_slice == 0xa5 )
			    check_BSD_parts(0);
			  else
			    errnum = ((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
			}

		      ext = -2;
		      break;
		    }
		}

	       




	      if (slice_no < 4 
		  || (current_slice != 5 
		      && current_slice != 0 ))
		slice_no++;
	    }

	  part_offset = ext_offset + ( *( (unsigned long *) (((int)  mbr_buf ) + 446  + 8 + (  ext  << 4)) ) ) ;
	  if (!ext_offset)
	    ext_offset = part_offset;
	}
    }
  else
    {
       


      ext = -1;
      if ((flags || (current_partition & 0xFF00) != 0xFF00)
	  && check_BSD_parts(flags))
	ext = -2;
      else
	{
	  errnum = 0;
	  if (!flags)
	    {
	      if (current_partition == 0xFFFFFF
		  || current_partition == 0xFF00FF)
		{
		  current_partition == 0xFFFFFF;
		  ext = -2;
		}
	    }








	}
    }

  if (!flags && (ext != -2) && (errnum == 0 ))
    errnum = ((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;

  if (errnum != 0 )
    return 0;

  return 1;
}


int
open_partition(void)
{
  return real_open_partition(0);
}


 
static int incomplete, disk_choice, part_choice;


char *
set_device(char *device)
{
   
  char *retval = 0;

  incomplete = 0;
  disk_choice = 1;
  part_choice = 0;
  current_drive = saved_drive;
  current_partition = 0xFFFFFF;

  if (*device == '(' && *(++device))
    {
      if (*device != ',' && *device != ')')
	{
	  char ch = *device;

	  if ((*device == 'f' || *device == 'h' || *device == 'n')
	      && (device += 2, (*(device-1) != 'd')))
	    errnum = (((((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;

	  if (ch == 'n')
	    {
	      current_drive = 0x20;
	    }
	  else
	    {
	      safe_parse_maxint(&device, (int*)&current_drive);

	      disk_choice = 0;
	      if (ch == 'h')
		current_drive += 0x80;
	    }
	}

      if (errnum)
	return 0;

      if (*device == ')')
	{
	  part_choice = 2;
	  retval++;
	}
      if (*device == ',')
	{
	  disk_choice = 0;
	  part_choice++;
	  device++;

	  if (*device >= '0' && *device <= '9')
	    {
	      part_choice++;
	      current_partition = 0;

	      if (!(current_drive & 0x80)
		  || !safe_parse_maxint(&device, (int*)&current_partition)
		  || current_partition > 254)
		{
		  errnum = ((((((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
		  return 0;
		}

	      current_partition = (current_partition << 16) + 0xFFFF;

	      if (*device == ','
		  && *(device+1) >= 'a' && *(device+1) <= 'h')
		{
		  device++;
		  current_partition = (((*(device++) - 'a') << 8)
				       | (current_partition & 0xFF00FF));
		}
	    }
	  else if (*device >= 'a' && *device <= 'h')
	    {
	      part_choice++;
	      current_partition = ((*(device++) - 'a') << 8) | 0xFF00FF;
	    }

	  if (*device == ')')
	    {
	      if (part_choice == 1)
		{
		  current_partition = saved_partition;
		  part_choice++;
		}

	      retval++;
	    }
	}
    }

  if (retval)
    retval = device + 1;
  else
    {
      if (!*device)
	incomplete = 1;
      errnum = ((((((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
    }

  return retval;
}


 




int
open_device(void)
{
  if (open_partition())
    attempt_mount();

  if (errnum != 0 )
    return 0;

  return 1;
}


# 707 "../shared_src/disk_io.c"



static char *
setup_part(char *filename)
{
  if (*filename == '(')
    {
      if ( (filename = set_device(filename)) == 0 )
        {
          current_drive = 0xFF;
          return 0;
        }





        open_device();
    }
  else if (saved_drive != current_drive
           || saved_partition != current_partition
	   || (*filename == '/' && fsys_type == ( 1  + 0  + 0  + 0  + 0 ) )
	   || buf_drive == -1)
    {
      current_drive = saved_drive;
      current_partition = saved_partition;
       






        open_device();
    }

  if (errnum && (*filename == '/' || errnum != ((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ))
    return 0;
  else
    errnum = 0;

  if (!sane_partition())
    return 0;

  return filename;
}


# 841 "../shared_src/disk_io.c"



 



int
open(char *filename)
{




   

  filepos = 0;

  if (!(filename = setup_part(filename)))
    return 0;





   
  fsmax = 0x7FFFFFFF ;

  if (*filename != '/')
    {
# 932 "../shared_src/disk_io.c"

      errnum = (((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;

    }

  if (!errnum && fsys_type == ( 1  + 0  + 0  + 0  + 0 ) )
    errnum = ((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;

   
  print_possibilities = 0;

  if (!errnum && (*(fsys_table[fsys_type].dir_func))(filename))
    {



      return 1;

    }

  return 0;
}


int
read(int addr, int len)
{
   
  if ((filepos < 0) | (filepos > filemax))
    filepos = filemax;

   
  if ((len < 0) | (len > (filemax - filepos)))
    len = filemax - filepos;

   


  if (filepos+len > fsmax)
    {
      errnum = ((((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
      return 0;
    }






# 1044 "../shared_src/disk_io.c"


  if (fsys_type == ( 1  + 0  + 0  + 0  + 0 ) )
    {
      errnum = ((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
      return 0;
    }

  return (*(fsys_table[fsys_type].read_func))(addr, len);
}


int
dir(char *dirname)
{




  if (!(dirname = setup_part(dirname)))
    return 0;

  if (*dirname != '/')
    errnum = (((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;

  if (fsys_type == ( 1  + 0  + 0  + 0  + 0 ) )
    errnum = ((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;

  if (errnum)
    return 0;

   
  print_possibilities = 1;

  return (*(fsys_table[fsys_type].dir_func))(dirname);
}

