# 1 "../shared_src/fsys_ffs.c"
 


















 






 






























# 1 "../shared_src/shared.h" 1
 


















 



 





 







 



 






 






 





















 














 


















 















 




























 




static inline unsigned char
inb(unsigned short port)
{
        unsigned char data;

        __asm __volatile("inb %1,%0" : "=a" (data) : "d" (port));
        return data;
}

static inline void
outb(unsigned short port, unsigned char val)
{
        __asm __volatile("outb %0,%1" : :"a" (val), "d" (port));
}


 

# 1 "../shared_src/mb_header.h" 1
 


















 



struct multiboot_header
{
   
  unsigned magic;

   
  unsigned flags;

   




  unsigned checksum;

   
  unsigned header_addr;
  unsigned load_addr;
  unsigned load_end_addr;
  unsigned bss_end_addr;
  unsigned entry_addr;
};

 










 


 






 


 


 


 


# 180 "../shared_src/shared.h" 2

# 1 "../shared_src/mb_info.h" 1
 


















 



struct mod_list
{
   
  unsigned long mod_start;
  unsigned long mod_end;

   
  unsigned long cmdline;

   
  unsigned long pad;
};


 






struct AddrRangeDesc
{
  unsigned long size;
  unsigned long BaseAddrLow;
  unsigned long BaseAddrHigh;
  unsigned long LengthLow;
  unsigned long LengthHigh;
  unsigned long Type;

   
};

 



 






struct multiboot_info
{
   
  unsigned long flags;

   
  unsigned long mem_lower;
  unsigned long mem_upper;

   
  unsigned long boot_device;

   
  unsigned long cmdline;

   
  unsigned long mods_count;
  unsigned long mods_addr;

  union
  {
    struct
    {
       
      unsigned long tabsize;
      unsigned long strsize;
      unsigned long addr;
      unsigned long pad;
    } a;

    struct
    {
       
      unsigned long num;
      unsigned long size;
      unsigned long addr;
      unsigned long shndx;
    } e;
  } syms;

   
  unsigned long mmap_length;
  unsigned long mmap_addr;
};

 



 

 

 

 


 

 

 


 


 





# 181 "../shared_src/shared.h" 2


extern char end[];     

 
void cmain(void) __attribute__ ((noreturn));




 



extern unsigned long install_partition;
extern unsigned long boot_drive;
extern char version_string[];
extern char config_file[];

 
void chain_stage1(int segment, int offset, int part_table_addr)
     __attribute__ ((noreturn));
void chain_stage2(int segment, int offset) __attribute__ ((noreturn));

 
void linux_boot(void) __attribute__ ((noreturn));

 
void multi_boot(int start, int mbi) __attribute__ ((noreturn));

 
void gateA20(int linear);

 
int get_memsize(int type);
int get_eisamemsize(void);
int get_mmap_entry(int buf, int cont);

 
int getrtsecs(void);

 
void cls(void);
int getxy(void);      
void gotoxy(int x, int y);

 











void putchar(int c);

 












int asm_getkey(void);

 


 
int checkkey(void);

 


void set_attrib(int attr);

 
int get_diskinfo(int drive);
int biosdisk(int subfunc, int drive, int geometry,
	     int sector, int nsec, int segment);
void stop_floppy(void);


 





extern int fallback;
extern int protected;
extern char commands[];



char *skip_to(int after_equal, char *cmdline);
void init_cmdline(void);
int enter_cmdline(char *script, char *heap);


 





int special_attribute;

































 












int getkey(void);   


void init_page(void);
void print_error(void);
char *convert_to_ascii(char *buf, int c, ...);
void printf(char *format, ... );
int sprintf(char *buffer, char *format, ... );
int get_cmdline(char *prompt, char *commands, char *cmdline, int maxlen);
int tolower(int c);
int isspace(int c);
int strncat(char *s1, char *s2, int n);
int strcmp(char *s1, char *s2);
char *strstr(char *s1, char *s2);
int bcopy(char *from, char *to, int len);
int bzero(char *start, int len);
int get_based_digit(int c, int base);
int safe_parse_maxint(char **str_ptr, int *myint_ptr);
int memcheck(int start, int len);


 





extern int no_decompression;
extern int compressed_file;



int gunzip_test_header(void);
int gunzip_read(int addr, int len);


 











extern unsigned long current_drive;
extern unsigned long current_partition;

extern int fsys_type;





extern long part_start;
extern long part_length;

extern int current_slice;

extern int buf_drive;
extern int buf_track;
extern int buf_geom;

 
extern int filepos;
extern int filemax;



int rawread(int drive, int sector, int byte_offset, int byte_len, int addr);
int devread(int sector, int byte_offset, int byte_len, int addr);

char *set_device(char *device);   

int open_device(void);
int make_saved_active(void);    


int open(char *filename);
int read(int addr, int len);   

int dir(char *dirname);        

int set_bootdev(int hdbias);
void print_fsys_type(void);    

void print_completions(char *filename);  

void copy_current_part_entry(int addr);  



 



 
typedef void
(*entry_func)(int, int, int, int, int, int) __attribute__ ((noreturn));



extern char *cur_cmdline;
extern entry_func entry_addr;



void bsd_boot(int type, int bootdev) __attribute__ ((noreturn));
int load_image(void);
int load_module(void);


 






 



extern struct multiboot_info mbi;
extern unsigned long saved_drive;
extern unsigned long saved_partition;
extern unsigned long saved_mem_upper;

 



extern int errnum;
extern char *err_list[];



void init_bios_info(void) __attribute__ ((noreturn));


# 58 "../shared_src/fsys_ffs.c" 2


# 1 "../shared_src/filesys.h" 1
 


















# 1 "../shared_src/pc_slice.h" 1
 





















 












 



















































 






 










  




 

















 









































 












 


















# 20 "../shared_src/filesys.h" 2







 



 









int ffs_mount(void);
int ffs_read(int addr, int len);
int ffs_dir(char *dirname);




# 56 "../shared_src/filesys.h"





































 
# 103 "../shared_src/filesys.h"


 

struct fsys_entry
{
  char *name;
  int (*mount_func)(void);
  int (*read_func)(int addr, int len);
  int (*dir_func)(char *dirname);
};



extern int fsmax;
extern int print_possibilities;
extern struct fsys_entry fsys_table[( 1  + 0  + 0  + 0  + 0 ) +1];

# 150 "../shared_src/filesys.h"


# 60 "../shared_src/fsys_ffs.c" 2


# 1 "../shared_src/defs.h" 1
 
























 



 



 




 





 



typedef	unsigned char	u_char;		 
typedef	unsigned short	u_short;	 
typedef	unsigned int	u_int;		 

typedef struct _quad_ {
	unsigned int	val[2];		 
} quad;					 

typedef	unsigned int	time_t;		 
typedef unsigned int	daddr_t;	 
typedef	unsigned int	off_t;		 

typedef	unsigned short	uid_t;
typedef	unsigned short	gid_t;
typedef	unsigned int	ino_t;



 













 












# 62 "../shared_src/fsys_ffs.c" 2

# 1 "../shared_src/disk_inode.h" 1
 
























 





















 












struct 	icommon {
	u_short	ic_mode;	 
	short	ic_nlink;	 
	uid_t	ic_uid;		 
	gid_t	ic_gid;		 
	quad	ic_size;	 
	time_t	ic_atime;	 
	int	ic_atspare;
	time_t	ic_mtime;	 
	int	ic_mtspare;
	time_t	ic_ctime;	 
	int	ic_ctspare;
	union {
	    struct {
		daddr_t	Mb_db[12 ];	 
		daddr_t	Mb_ib[3 ];	 
	    } ic_Mb;
	    char	ic_Msymlink[((12  + 3 ) * sizeof(daddr_t)) ];
					 
	} ic_Mun;



	int	ic_flags;	 
	int	ic_blocks;	 
	int	ic_gen;		 
	int	ic_spare[4];	 
} i_ic;

 


struct dinode {
	union {
	    struct icommon	di_com;
	    char		di_char[128];
	} di_un;
};



# 63 "../shared_src/fsys_ffs.c" 2

# 1 "../shared_src/disk_inode_ffs.h" 1
 
























 
















































 


























# 64 "../shared_src/fsys_ffs.c" 2

# 1 "../shared_src/dir.h" 1
 
























 





















 



























struct	direct {
	u_int	d_ino;			 
	u_short	d_reclen;		 
	u_short	d_namlen;		 
	char	d_name[255  + 1];	 
};

 









# 109 "../shared_src/dir.h"


 








 


typedef struct _dirdesc {
	int	dd_fd;
	int	dd_loc;
	int	dd_size;
	char	dd_buf[512  ];
} DIR;






extern	DIR *opendir();
extern	struct direct *readdir();
extern	int telldir();
extern	void seekdir();

extern	void closedir();


# 65 "../shared_src/fsys_ffs.c" 2

# 1 "../shared_src/fs.h" 1
 
























 


















 






























 


























 










 










 








struct csum {
	int	cs_ndir;	 
	int	cs_nbfree;	 
	int	cs_nifree;	 
	int	cs_nffree;	 
};

 



struct	fs
{
	int	xxx1;			 
	int	xxx2;			 
	daddr_t	fs_sblkno;		 
	daddr_t	fs_cblkno;		 
	daddr_t	fs_iblkno;		 
	daddr_t	fs_dblkno;		 
	int	fs_cgoffset;		 
	int	fs_cgmask;		 
	time_t 	fs_time;    		 
	int	fs_size;		 
	int	fs_dsize;		 
	int	fs_ncg;			 
	int	fs_bsize;		 
	int	fs_fsize;		 
	int	fs_frag;		 
 
	int	fs_minfree;		 
	int	fs_rotdelay;		 
	int	fs_rps;			 
 
	int	fs_bmask;		 
	int	fs_fmask;		 
	int	fs_bshift;		 
	int	fs_fshift;		 
 
	int	fs_maxcontig;		 
	int	fs_maxbpg;		 
 
	int	fs_fragshift;		 
	int	fs_fsbtodb;		 
	int	fs_sbsize;		 
	int	fs_csmask;		 
	int	fs_csshift;		 
	int	fs_nindir;		 
	int	fs_inopb;		 
	int	fs_nspf;		 
 
	int	fs_optim;		 
 
	int	fs_npsect;		 
	int	fs_interleave;		 
	int	fs_trackskew;		 
	int	fs_headswitch;		 
	int	fs_trkseek;		 
 
	daddr_t fs_csaddr;		 
	int	fs_cssize;		 
	int	fs_cgsize;		 
 
	int	fs_ntrak;		 
	int	fs_nsect;		 
	int  	fs_spc;   		 
 
	int	fs_ncyl;   		 
 
	int	fs_cpg;			 
	int	fs_ipg;			 
	int	fs_fpg;			 
 
	struct	csum fs_cstotal;	 
 
	char   	fs_fmod;    		 
	char   	fs_clean;    		 
	char   	fs_ronly;   		 
	char   	fs_flags;   		 
	char	fs_fsmnt[512 ];	 
 
	int	fs_cgrotor;		 

	int	was_fs_csp[32 ];



	int	fs_cpc;			 
	short	fs_opostbl[16][8];	 
	long	fs_sparecon[50];	 
	long	fs_contigsumsize;	  
	long	fs_maxsymlinklen;	 
	long	fs_inodefmt;		 
	quad	fs_maxfilesize;		 
	quad	fs_qbmask;		 
	quad	fs_qfmask;		 
	long    fs_state;                
	int	fs_postblformat;	 
	int	fs_nrpos;		 
	int	fs_postbloff;		 
	int	fs_rotbloff;		 
	int	fs_magic;		 
	u_char	fs_space[1];		 
 
};
 





 




 











 







 



struct	cg {
	int	xxx1;			 
	int	cg_magic;		 
	time_t	cg_time;		 
	int	cg_cgx;			 
	short	cg_ncyl;		 
	short	cg_niblk;		 
	int	cg_ndblk;		 
	struct	csum cg_cs;		 
	int	cg_rotor;		 
	int	cg_frotor;		 
	int	cg_irotor;		 
	int	cg_frsum[8 ];	 
	int	cg_btotoff;		 
	int	cg_boff;		 
	int	cg_iusedoff;		 
	int	cg_freeoff;		 
	int	cg_nextfreeoff;		 
	int	cg_sparecon[16];	 
	u_char	cg_space[1];		 
 
};
 





















 



struct	ocg {
	int	xxx1;			 
	int	xxx2;			 
	time_t	cg_time;		 
	int	cg_cgx;			 
	short	cg_ncyl;		 
	short	cg_niblk;		 
	int	cg_ndblk;		 
	struct	csum cg_cs;		 
	int	cg_rotor;		 
	int	cg_frotor;		 
	int	cg_irotor;		 
	int	cg_frsum[8];		 
	int	cg_btot[32];		 
	short	cg_b[32][8];		 
	char	cg_iused[256];		 
	int	cg_magic;		 
	u_char	cg_free[1];		 
 
};

 






 











 











 






 












 

























 







 











 





 





 




# 66 "../shared_src/fsys_ffs.c" 2


 
static int mapblock;

 





int
ffs_mount(void)
{
  int retval = 1;

  if ( (((current_drive & 0x80) || (current_slice != 0))
	&& current_slice != (0xa5  | (7 <<8)))
       || part_length < (((daddr_t)(((daddr_t)(0))  + 8192  / 512 ))  + (8192 / 512 ))
       || !devread(((daddr_t)(((daddr_t)(0))  + 8192  / 512 )) , 0, 8192 , (int) ((struct fs *) ( 0x68000  + 8192 )) )
       || ((struct fs *) ( 0x68000  + 8192 )) ->fs_magic != 0x011954  )
    retval = 0;

  mapblock = -1;

  return retval;
}

int
block_map(int file_block)
{
  int bnum;

  if (file_block < 12  )
    return(((struct icommon *) ( 0x68000  + 16384 )) -> ic_Mun.ic_Mb.Mb_db  [file_block]);

  if ( (bnum = ((  ((struct icommon *) ( 0x68000  + 16384 )) -> ic_Mun.ic_Mb.Mb_ib  [0] ) << ( ((struct fs *) ( 0x68000  + 8192 ))  )->fs_fsbtodb) ) != mapblock )
    {
      if (!devread(bnum, 0, ((struct fs *) ( 0x68000  + 8192 )) ->fs_bsize, ( 0x68000  + 24576 ) ))
	{
	  mapblock = -1;
	  errnum = (((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
	  return -1;
	}

      mapblock = bnum;
    }

  return (((int *)( 0x68000  + 24576 ) )[(file_block - 12  ) % (( ((struct fs *) ( 0x68000  + 8192 ))  )->fs_nindir) ]);
}


int
ffs_read(int addr, int len)
{
  int logno, off, size, map, ret = 0;

  while (len && !errnum)
    {
      off = ((  filepos ) & ~( ((struct fs *) ( 0x68000  + 8192 ))  )->fs_bmask) ;
      logno = ((  filepos ) >> ( ((struct fs *) ( 0x68000  + 8192 ))  )->fs_bshift) ;
      size = (((  logno ) >= 12   || (  ((struct icommon *) ( 0x68000  + 16384 ))  )-> ic_size.val[0]  >= ((  logno ) + 1) << ( ((struct fs *) ( 0x68000  + 8192 ))  )->fs_bshift) ? ( ((struct fs *) ( 0x68000  + 8192 ))  )->fs_bsize : ((((  ((  (  ((struct icommon *) ( 0x68000  + 16384 ))  )-> ic_size.val[0]  ) & ~(  ((struct fs *) ( 0x68000  + 8192 ))   )->fs_bmask)  ) + (  ((struct fs *) ( 0x68000  + 8192 ))   )->fs_fsize - 1) & (  ((struct fs *) ( 0x68000  + 8192 ))   )->fs_fmask) )) ;

      if ((map = block_map(logno)) < 0)
	break;

      size -= off;

      if (size > len)
	size = len;





      devread(((  map ) << ( ((struct fs *) ( 0x68000  + 8192 ))  )->fs_fsbtodb) , off, size, addr);





      addr += size;
      len -= size;
      filepos += size;
      ret += size;
    }

  if (errnum)
    ret = 0;

  return ret;
}


int
ffs_dir(char *dirname)
{
  char *rest, ch;
  int block, off, loc, map, ino = ((ino_t)2) ;
  struct direct *dp;

 
loop:

   

  if (!devread((( ((daddr_t)(((((daddr_t)((    ((struct fs *) ( 0x68000  + 8192 ))     )->fs_fpg * (      ((   ino  ) / (  ((struct fs *) ( 0x68000  + 8192 ))   )->fs_ipg)    )))  + (   ((struct fs *) ( 0x68000  + 8192 ))    )->fs_cgoffset * ((    ((   ino  ) / (  ((struct fs *) ( 0x68000  + 8192 ))   )->fs_ipg)   ) & ~((   ((struct fs *) ( 0x68000  + 8192 ))    )->fs_cgmask)))  + (  ((struct fs *) ( 0x68000  + 8192 ))   )->fs_iblkno)  + (((  ((( ino ) % ( ((struct fs *) ( 0x68000  + 8192 ))  )->fs_ipg) / ((  ((struct fs *) ( 0x68000  + 8192 ))   )->fs_inopb) ) ) << ( ( ((struct fs *) ( 0x68000  + 8192 ))  ) )->fs_fragshift) )))  ) << ( ((struct fs *) ( 0x68000  + 8192 ))  )->fs_fsbtodb) ,
	       0, ((struct fs *) ( 0x68000  + 8192 )) ->fs_bsize, 0x68000 ))
    return 0;   

  bcopy((void *)&(((struct dinode *)0x68000 )[ino % (((struct fs *) ( 0x68000  + 8192 )) ->fs_inopb)]),
	(void *)((struct icommon *) ( 0x68000  + 16384 )) , sizeof (struct dinode));

   


  if (!*dirname || isspace(*dirname))
    {
      if ((((struct icommon *) ( 0x68000  + 16384 )) -> ic_mode  & 0xf000 ) != 0x8000 )
	{
	  errnum = ((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
	  return 0;
	}

      filemax = ((struct icommon *) ( 0x68000  + 16384 )) -> ic_size.val[0] ;

       
      fsmax = (12   + (( ((struct fs *) ( 0x68000  + 8192 ))  )->fs_nindir) ) * ((struct fs *) ( 0x68000  + 8192 )) ->fs_bsize;
      return 1;
    }

   

  while (*dirname == '/')
    dirname++;

  if (!(((struct icommon *) ( 0x68000  + 16384 )) -> ic_size.val[0] ) || ((((struct icommon *) ( 0x68000  + 16384 )) -> ic_mode  & 0xf000 ) != 0x4000 ))
    {
      errnum = ((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
      return 0;
    }

  for (rest = dirname; (ch = *rest) && !isspace(ch) && ch != '/'; rest++) ;

  *rest = 0;
  loc = 0;

   

  do
    {
      if (loc >= ((struct icommon *) ( 0x68000  + 16384 )) -> ic_size.val[0] )
	{
	  putchar('\n');

	  if (print_possibilities < 0)
	    return 1;

	  errnum = (((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
	  *rest = ch;
	  return 0;
	}

      if (!(off = ((  loc ) & ~( ((struct fs *) ( 0x68000  + 8192 ))  )->fs_bmask) ))
	{
	  block = ((  loc ) >> ( ((struct fs *) ( 0x68000  + 8192 ))  )->fs_bshift) ;

	  if ( (map = block_map(block)) < 0
		|| !devread(((  map ) << ( ((struct fs *) ( 0x68000  + 8192 ))  )->fs_fsbtodb) , 0,
			    (((  block ) >= 12   || (  ((struct icommon *) ( 0x68000  + 16384 ))  )-> ic_size.val[0]  >= ((  block ) + 1) << ( ((struct fs *) ( 0x68000  + 8192 ))  )->fs_bshift) ? ( ((struct fs *) ( 0x68000  + 8192 ))  )->fs_bsize : ((((  ((  (  ((struct icommon *) ( 0x68000  + 16384 ))  )-> ic_size.val[0]  ) & ~(  ((struct fs *) ( 0x68000  + 8192 ))   )->fs_bmask)  ) + (  ((struct fs *) ( 0x68000  + 8192 ))   )->fs_fsize - 1) & (  ((struct fs *) ( 0x68000  + 8192 ))   )->fs_fmask) )) , 0x68000 ) )
	    {
	      errnum = (((((((((((((0  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1)  + 1) ;
	      *rest = ch;
	      return 0;
	    }
	}

      dp = (struct direct *)(0x68000  + off);
      loc += dp->d_reclen;

      if (dp->d_ino && print_possibilities && ch != '/'
	  && (!*dirname || strcmp(dirname, dp->d_name) <= 0))
	{
	  if (print_possibilities > 0)
	    print_possibilities = -print_possibilities;

	  printf("  %s", dp->d_name);
	}
    }
  while (!dp->d_ino || (strcmp(dirname, dp->d_name) != 0
			|| (print_possibilities && ch != '/')) );

   

  ino = dp->d_ino;
  *(dirname = rest) = ch;

   
  goto loop;
}


