#include "filesys.h"
#include "shared.h"

/* use GRUB's file system buffer */
#define BUFSIZE (32*1024)
#define buf ((char *)(FSYS_BUF))

static int buf_read = 0, buf_eof = 0;
static unsigned long buf_fileoff;

// static int buf_fill(void);

int serial_init() 
{
  return 1;
}

int buf_fill() {
  return 0;
}

int serial_mount(void)
{
  printf("serial_mount!");
  if (!serial_init()) return 0;
  return 1;
}

int serial_read1(int addr, int size)
{
  printf("serial_read: %x, %d\n", addr, size);
  getkey();
  filepos+=10;
  return 10;
}


int serial_read(int addr, int size)
{
  int ret = 0;

  if (filepos < buf_fileoff)
    {
      printf("serial_read: can't read from filepos=%d, buf_fileoff=%d\n",
	     filepos, buf_fileoff);
      errnum = ERR_BOOT_FAILURE;
      return 0;
    }

  while (size > 0)
    {
      if (filepos < buf_fileoff + buf_read)
	{
	  /* can copy stuff from buffer */
	  int tocopy = buf_fileoff + buf_read - filepos;
	  if (tocopy > size) tocopy = size;
	  bcopy(buf + (filepos - buf_fileoff), (void*) addr, tocopy);
	  size -= tocopy;
	  addr += tocopy;
	  filepos += tocopy;
	  ret += tocopy;
	  
	  if (buf_eof && (filepos + size >= buf_fileoff + buf_read))
	    break;		/* end of file */
	      
	  continue;
	}
      else if ((filepos == buf_fileoff + buf_read) && buf_eof)
	break;			/* end of file */
	
      if (buf_eof)		/* filepos beyond end of file */
	{
	  errnum = ERR_READ;
	  return 0;
	}

      /* move buffer contents forward by 1/2 buffer size */
      bcopy(buf + BUFSIZE/2, buf, BUFSIZE/2);
      buf_fileoff += BUFSIZE/2;
      buf_read -= BUFSIZE/2;

      if (! buf_fill())		/* read more data */
	{
	  errnum = ERR_READ;
	  return 0;
	}
    }

  return ret;
}

int serial_dir(char* dirname)
{
  if (print_possibilities)
    {
      printf("serial doesn't support listing the directory!\n");
      return 1;
    }
  printf("serial_dir: %s", dirname);
  // send request!
  filemax = 1024*1024*16;// test!!!
  return 1;
}



