/*
**
**	L4 Alpha Kernel
**
*/

#include <l4/types.h>
#include <l4/syscalls.h>

#include <l4/kdebug.h>

void __memory(void);
void __instruction(void);
void __arithmetic(void);
void __unaligned (void);

l4_alphaidt_t idt = {
  __memory,
  __instruction,
  __arithmetic,
  __unaligned
};
  
void
l4_set_idt(l4_alphaidt_t *idt)
{
  __asm__       
    __volatile__ (
                  save_gp
                  "ldiq $16, %0         \n\t"
                  "bis  %1, %1, $17     \n\t"
                  ".long 0xb7           \n\t"
                  load_gp
                  :
                  : "i"(0),
                    "r"(idt)
                  : "$16", "$17", "$26"
                  );
}


/*
int main (void)
{
  l4_threadid_t myself;

  l4_set_idt (&idt);
  
  print_string ("Raise unaligned exception 5 times\n\r");
  __asm__ ("ldq	$0, 2($30)\n");
}
*/

void unaligned_trap (void)
{
    print_string ("User level unaligned access\n\r");
    
    enter_kdebug ();
}

void instruction_trap (void)
{
    print_string ("Instruction trap\n\r");
    
    enter_kdebug ();
}

void arithmetic_trap (void)
{
    print_string ("Arith trap\n\r");
    
    enter_kdebug ();

}

void memory_trap (void)
{
    print_string ("Memory trap\n\r");
    
    enter_kdebug ();
}
