/* This is the (pseudo) serial (output) driver.
 * It accepts 64 bytes (short message) worth of data to print out COM2
 */

#include <l4/types.h>
#include <l4/ipc.h>
#include <l4/syscalls.h>
#include <thread.h>

#include <l4/kdebug.h>

#include <stdio.h>

static qword_t rcv_stack[128];

void rcv_thread(void);

extern l4_alphaidt_t idt;

/* main()
 *  starts up rcv_thread and acts sender (serial output)
 */
void main(void) {
    l4_threadid_t tid, preempter, pager, from;
    l4_ipcregs_t regs; 
    char d;
    qword_t i;
    l4_ipc_reg_msg_t msg;
    l4_msgdope_t result;

    tid = l4_myself();
    preempter = pager = L4_INVALID_ID;

    l4_set_idt (&idt);

    print_string("SERIAL: My Id = "); print_hex(tid.thread_id, 64);
    print_string("\n\r");

#if 0
    l4_thread_ex_regs(tid.thread_id,
		      (qword_t) -1,
		      (qword_t) -1,
		      &preempter,
		      &pager,
		      (qword_t *)&msg.reg[0],   /* dummy */
		      (qword_t *)&msg.reg[0]);
#endif

    tid.id.lthread++;

#if 0 /* Currently not in use */
    print_string("SERIAL: Starting serial input thread\n\r");
  
    l4_thread_ex_regs(tid,
		      (qword_t) rcv_thread,
		      (qword_t) &rcv_stack[127],
		      &preempter,
		      &pager,
		      (qword_t *)&msg.reg[0],   /* dummy */
		      (qword_t *)&msg.reg[0]);
    
    print_string("SERIAL: Input thread started\n\r");
#endif


    while(1) {
	l4_alpha_ipc_wait (&from,
			   NULL,
			   &regs,
			   L4_IPC_NEVER,
			   &result);

	/* ok, we are a hack for now, one day we will be a real driver */
	print_string((char *)&regs);
    }


}

void rcv_thread(void)
{
  int r;
  char c;
  l4_ipc_reg_msg_t msg;
  l4_msgdope_t result;
//  ConfigEntry    *q;
//  q = &ConfigTable[0];

    
    /* wait to transmit */
//    while(!(*q->handler) (OP_RXRDY, q->devinfo, 0))
//      l4_thread_switch(L4_NIL_ID);
//    c =  pmpsc( OP_RX, q->devinfo, 0,0);

    /* we are now the input handler of the serial driver, so we need to 
     * wait for characters from the serial driver and send them on to the guy
     * who wants them.
     */
    
    print_string("SERIALINPUT: Hi\n\r");

    while(1);

    /*
    if (rcvtid.ID != 0)
    {
      if (c == '\r')
      {
        msg.reg[0] = '\n';
      }
      else
      {
        msg.reg[0] = c;
      }
      r = l4_mips_ipc_send(rcvtid, L4_IPC_SHORT_MSG, &msg,
                           L4_IPC_NEVER, &result);
      if (r != 0)
      {
        rcvtid.ID = 0;
      }
    }
    */
    
}

