/* 
 * $Id: dit.h,v 5.2 1999/11/09 00:45:52 danielp Exp $
 *
 * Proportions of this file are taken from L4/MIPS dit.h. L4 on Alpha
 * attempts to make use of the same structures to make programming
 * easier.  
 */

#ifndef ALPHA_DIT_H
#define ALPHA_DIT_H

#include <l4/types.h>

#define DIT_RUN         0x01
#define DIT_MANAGER     0x02

#define DIT_NIDENT      4
#define DIT_NPNAME      16

typedef unsigned int Dit_uint;

typedef struct {
  char d_ident[DIT_NIDENT];
  Dit_uint d_phoff;
  Dit_uint d_phsize;
  Dit_uint d_phnum;
  Dit_uint d_fileend;
  Dit_uint d_vaddrend;
} Dit_Dhdr;             /* L4 DIT Header */

typedef struct {
  Dit_uint p_base;
  Dit_uint p_size;
  Dit_uint p_entry;
  Dit_uint p_flags;
  char p_name[DIT_NPNAME];
} Dit_Phdr;             /* L4 DIT File entry */

#endif
