/* 
 * $Id: ipc.h,v 5.2 1999/11/09 00:45:52 danielp Exp $
 */

#ifndef __L4_IPC_H__ 
#define __L4_IPC_H__ 

/*
 * L4 ipc
 */

#include <l4/compiler.h>
#include <l4/types.h>

/*
 * IPC parameters
 */

/* 
 * Structure used to describe destination and true source if a chief
 * wants to deceit 
 */

typedef struct {
    l4_threadid_t dest, true_src;
} l4_ipc_deceit_ids_t;


#define L4_IPC_MAX_REG_MSG 8

/* lets not use l4_ipcregs_t in future
 */
typedef union {
    qword_t val[L4_IPC_MAX_REG_MSG];
    qword_t reg[L4_IPC_MAX_REG_MSG];  // compatibility with L4/MIPS
} l4_ipcregs_t;


/*typedef struct {
  qword_t reg[L4_IPC_MAX_REG_MSG];
} l4_ipc_reg_msg_t;
*/

typedef l4_ipcregs_t l4_ipc_reg_msg_t;  // compatibility with L4/MIPS

/* 
 * Defines used for Parameters 
 */

#define L4_IPC_SHORT_MSG 	0

/*
 * Defines used to build Parameters
 */

#define L4_IPC_STRING_SHIFT 8
#define L4_IPC_DWORD_SHIFT 13
#define L4_IPC_SHORT_FPAGE ((void *)2)

#define L4_IPC_DOPE(dwords, strings) \
( (l4_msgdope_t) {md: {0, 0, 0, 0, 0, 0, strings, dwords }})


#define L4_IPC_TIMEOUT(snd_man, snd_exp, rcv_man, rcv_exp, snd_pflt, rcv_pflt)\
     ( (l4_timeout_t) \
       {to: { rcv_exp, rcv_pflt, rcv_man, snd_exp, snd_pflt, snd_man} } )

#define L4_IPC_NEVER ((l4_timeout_t) {timeout : 0})
#define L4_IPC_MAPMSG(address, size)  \
     ((void *)(qword_t)( ((address) & L4_PAGEMASK) | ((size) << 2) \
			 | (unsigned long)L4_IPC_SHORT_FPAGE)) 

/* 
 * Some macros to make result checking easier
 */

#define L4_IPC_ERROR_MASK 	0xF0
#define L4_IPC_DECEIT_MASK	0x01
#define L4_IPC_FPAGE_MASK	0x02
#define L4_IPC_REDIRECT_MASK	0x04
#define L4_IPC_SRC_MASK		0x08
#define L4_IPC_SND_ERR_MASK	0x10

#define L4_IPC_IS_ERROR(x)		(((x).msgdope) & L4_IPC_ERROR_MASK)
#define L4_IPC_MSG_DECEITED(x) 		(((x).msgdope) & L4_IPC_DECEIT_MASK)
#define L4_IPC_MSG_REDIRECTED(x)	(((x).msgdope) & L4_IPC_REDIRECT_MASK)
#define L4_IPC_SRC_INSIDE(x)		(((x).msgdope) & L4_IPC_SRC_MASK)
#define L4_IPC_SND_ERROR(x)		(((x).msgdope) & L4_IPC_SND_ERR_MASK)
#define L4_IPC_MSG_TRANSFER_STARTED \
				((((x).msgdope) & L4_IPC_ERROR_MASK) < 5)


#define push_most	\
	"subq $30,8*8,$30;"\
	"stq  $1, 0x00($30);stq $2, 0x08($30);stq $3, 0x10($30);stq $4, 0x18($30);"\
	"stq  $5, 0x20($30);stq $6, 0x28($30);stq $7, 0x30($30);stq $27, 0x38($30);"

#define pop_most	\
	"ldq  $1, 0x00($30);ldq $2, 0x08($30);ldq $3, 0x10($30);ldq $4, 0x18($30);"\
	"ldq  $5, 0x20($30);ldq $6, 0x28($30);ldq $7, 0x30($30);ldq $27, 0x38($30);"\
	"addq $30,8*8,$30;"



/*
 * Prototypes
 */


L4_INLINE int
l4_alpha_ipc_call(l4_threadid_t dest, 
		  const void *snd_msg,
		  const l4_ipcregs_t *snd_regs,
		  void *rcv_msg, 
		  l4_ipcregs_t *rcv_regs,
		  l4_timeout_t timeout,
    		  l4_msgdope_t *result);

L4_INLINE int
l4_alpha_ipc_reply_and_wait(l4_threadid_t dest, 
			    const void *snd_msg, 
			    const l4_ipcregs_t *snd_regs,
			    l4_threadid_t *src,
			    void *rcv_msg, 
			    l4_ipcregs_t *rcv_regs,
			    l4_timeout_t timeout,
    			    l4_msgdope_t *result);

L4_INLINE l4_msgdope_t
l4_i386_ipc_reply_deceiting_and_wait(const l4_ipc_deceit_ids_t ids,
				     const void *snd_msg, 
				     dword_t snd_dword0, dword_t snd_dword1,
				     l4_threadid_t *src,
				     void *rcv_msg, 
				     dword_t *rcv_dword0, dword_t *rcv_dword1, 
				     l4_timeout_t timeout, 
				     l4_msgdope_t *result);

L4_INLINE int
l4_alpha_ipc_reply_deceiting_and_wait(l4_threadid_t dest, 
	       			      l4_threadid_t vsend,
				      const void *snd_msg,
				      l4_ipcregs_t *snd_reg,
				      l4_threadid_t *src,
				      void *rcv_msg,
				      l4_ipcregs_t *rcv_reg,
				      l4_timeout_t timeout,
				      l4_msgdope_t *result); 


L4_INLINE int
l4_alpha_ipc_send(l4_threadid_t dest, 
		  const void *snd_msg,
		  const l4_ipcregs_t *snd_regs,
		  l4_timeout_t timeout, l4_msgdope_t *result);


L4_INLINE l4_msgdope_t
l4_i386_ipc_send_deceiting(l4_ipc_deceit_ids_t ids,
			   const void *snd_msg, 
			   dword_t snd_dword0, dword_t snd_dword1, 
			   l4_timeout_t timeout, l4_msgdope_t *result);
L4_INLINE int
l4_alpha_ipc_send_deceiting(l4_threadid_t dest, 
                            l4_threadid_t vsend,
                            const void *snd_msg,
                            l4_ipcregs_t *snd_reg,
                            l4_timeout_t timeout,
                            l4_msgdope_t *result); 



L4_INLINE int
l4_alpha_ipc_wait(l4_threadid_t *src,
		  void *rcv_msg,
		  l4_ipcregs_t *rcv_regs,
		  l4_timeout_t timeout,
    		  l4_msgdope_t *result);

L4_INLINE int
l4_alpha_ipc_receive(l4_threadid_t src,
		     void *rcv_msg,
		     l4_ipcregs_t *rcv_regs,
		     l4_timeout_t timeout,
    		     l4_msgdope_t *result);

/* new API calls to support knowledge of real_dst on deceit calls */
L4_INLINE int
l4_alpha_ipc_chief_wait(l4_threadid_t *src,
		       l4_threadid_t *real_dst,
 		       void *rcv_msg,
 		       l4_ipc_reg_msg_t *rcv_reg,
 		       l4_timeout_t timeout,
 		       l4_msgdope_t *result);



L4_INLINE int
l4_alpha_ipc_chief_receive(l4_threadid_t src,
 			  l4_threadid_t *real_dst,
 			  void *rcv_msg,
 			  l4_ipc_reg_msg_t *rcv_reg,
 			  l4_timeout_t timeout,
 			  l4_msgdope_t *result);

L4_INLINE int
l4_alpha_ipc_chief_call(l4_threadid_t dest,
 		       l4_threadid_t vsend,
 		       const void *snd_msg,
 		       l4_ipc_reg_msg_t *snd_reg,
 		       l4_threadid_t *real_dst,
 		       void *rcv_msg,
 		       l4_ipc_reg_msg_t *rcv_reg,
 		       l4_timeout_t timeout,
 		       l4_msgdope_t *result);

L4_INLINE int
l4_alpha_ipc_chief_reply_and_wait(l4_threadid_t dest,
 				 l4_threadid_t vsend,
 				 const void *snd_msg,
 				 l4_ipc_reg_msg_t *snd_reg,
 				 l4_threadid_t *src,
 				 l4_threadid_t *real_dst,
 				 void *rcv_msg,
 				 l4_ipc_reg_msg_t *rcv_reg,
 				 l4_timeout_t timeout,
 				 l4_msgdope_t *result);

L4_INLINE int
l4_alpha_ipc_chief_send(l4_threadid_t dest,
 		       l4_threadid_t vsend,
 		       const void *snd_msg,
 		       l4_ipc_reg_msg_t *snd_reg,
 		       l4_timeout_t timeout,
 		       l4_msgdope_t *result);

#if 0
L4_INLINE int l4_ipc_fpage_received(l4_msgdope_t msgdope);
L4_INLINE int l4_ipc_is_fpage_granted(l4_fpage_t fp);
L4_INLINE int l4_ipc_is_fpage_writable(l4_fpage_t fp);



/*
 *
 */

L4_INLINE int l4_ipc_fpage_received(l4_msgdope_t msgdope)
{
  return msgdope.md.fpage_received != 0;
}
L4_INLINE int l4_ipc_is_fpage_granted(l4_fpage_t fp)
{
  return fp.fp.grant != 0;
}
L4_INLINE int l4_ipc_is_fpage_writable(l4_fpage_t fp)
{
  return fp.fp.write != 0;
}

/*
 * IPC results
 */

#endif

#define L4_IPC_ERROR(x)			(((x).msgdope) & L4_IPC_ERROR_MASK)
#define L4_IPC_ENOT_EXISTENT		0x10
#define L4_IPC_RETIMEOUT		0x20
#define L4_IPC_SETIMEOUT		0x30
#define L4_IPC_RECANCELED		0x40
#define L4_IPC_SECANCELED		0x50
#define L4_IPC_REMAPFAILED		0x60
#define L4_IPC_SEMAPFAILED		0x70
#define L4_IPC_RESNDPFTO		L4_IPC_ENTRY
#define L4_IPC_SERCVPFTO		0x90
#define L4_IPC_REABORTED		0xA0
#define L4_IPC_SEABORTED		0xB0
#define L4_IPC_REMSGCUT			0xE0
#define L4_IPC_SEMSGCUT			0xF0


/*
 * Internal defines used to build IPC parameters for the L4 kernel
 */

#define L4_IPC_NIL_DESCRIPTOR 	(-1)
#define L4_IPC_DECEIT 		1
#define L4_IPC_OPEN_IPC 	1


/*
 * Implementation
 */

#define SCRATCH 1
#define SCRATCH_MEMORY 1

#define SCRREG  "$8","$9","$10","$11","$12","$13","$14","$15","$16","$17","$18","$19","$26","$29","27","memory"


#ifdef GOOD_GCC
L4_INLINE l4_msgdope_t
l4_alpha_ipc_call(l4_threadid_t dest, 
		  const void *snd_msg,
		  const l4_ipcregs_t *snd_regs,
		  void *rcv_msg, 
		  l4_ipcregs_t *rcv_regs,
		  l4_timeout_t timeout)
{
  l4_msgdope_t result;

  if (snd_regs && rcv_regs) {
    __asm__
      __volatile__ (
		    save_gp
		    push_most
		    "ldq	$1, 0x00(%6)   	\n\t"
		    "ldq	$2, 0x08(%6)   	\n\t"
		    "ldq	$3, 0x10(%6)   	\n\t"
		    "ldq	$4, 0x18(%6)   	\n\t"
		    "ldq	$5, 0x20(%6)   	\n\t"
		    "ldq	$6, 0x28(%6)   	\n\t"
		    "ldq	$7, 0x30(%6)   	\n\t"

		    "bis	%2, $31, $16	\n\t"
		    "subq	%3, 0, $17	\n\t"
		    "bis	%4, 0, $18	\n\t"
		    "bis	%5, $31, $19	\n\t"
		    ".long	L4_IPC_ENTRY	# receive	\n\t"
		    "bis	$0, $31, %0	\n\t"

		    "stq	$1, 0x00(%1)   	\n\t"
		    "stq	$2, 0x08(%1)   	\n\t"
		    "stq	$3, 0x10(%1)   	\n\t"
		    "stq	$4, 0x18(%1)   	\n\t"
		    "stq	$5, 0x20(%1)   	\n\t"
		    "stq	$6, 0x28(%1)   	\n\t"
		    "stq	$7, 0x30(%1)   	\n\t"

		    pop_most
		    load_gp
		    : "=r"(result)
		   		    
		    : "r"(&(rcv_regs->val)),

		      "r"(dest.thread_id), 
		      "r"((qword_t)snd_msg),  
		      "r"((qword_t)rcv_msg & ~0x07),  
		      "r"(timeout.timeout),
  	  	      "r"(&(snd_regs->val))
		    : "$0","$1","$2","$3","$4","$5","$6","$7","$16","$17","$18","$19","$26","$29","27","memory");
  } else if (snd_regs) {
    __asm__
      __volatile__ (
		    save_gp
		    push_most
		    "ldq	$1, 0x00(%6)   	\n\t"
		    "ldq	$2, 0x08(%6)   	\n\t"
		    "ldq	$3, 0x10(%6)   	\n\t"
		    "ldq	$4, 0x18(%6)   	\n\t"
		    "ldq	$5, 0x20(%6)   	\n\t"
		    "ldq	$6, 0x28(%6)   	\n\t"
		    "ldq	$7, 0x30(%6)   	\n\t"

		    "bis	%2, $31, $16	\n\t"
		    "subq	%3, 0, $17	\n\t"
		    "bis	%4, 0, $18	\n\t"
		    "bis	%5, $31, $19	\n\t"
		    ".long	L4_IPC_ENTRY	# receive	\n\t"
		    "bis	$0, $31, %0	\n\t"

		    pop_most
		    load_gp
		    : "=r"(result)
		    
		    : "r"(&(rcv_regs->val)),
		      "r"(dest.thread_id), 
		      "r"((qword_t)snd_msg),  
		      "r"((qword_t)rcv_msg & ~0x07),  
		      "r"(timeout.timeout),
		    
  	  	      "r"(&(snd_regs->val))

		    : "$0","$1","$2","$3","$4","$5","$6","$7","$16","$17","$18","$19","$26","$29","27","memory");
  } else if (rcv_regs) {
    __asm__
      __volatile__ (
		    save_gp
		    push_most
		    "bis	%2, $31, $16	\n\t"
		    "subq	%3, 0, $17	\n\t"
		    "bis	%4, 0, $18	\n\t"
		    "bis	%5, $31, $19	\n\t"
		    ".long	L4_IPC_ENTRY	# receive	\n\t"
		    "bis	$0, $31, %0	\n\t"

		    "stq	$1, 0x00(%1)   	\n\t"
		    "stq	$2, 0x08(%1)   	\n\t"
		    "stq	$3, 0x10(%1)   	\n\t"
		    "stq	$4, 0x18(%1)   	\n\t"
		    "stq	$5, 0x20(%1)   	\n\t"
		    "stq	$6, 0x28(%1)   	\n\t"
		    "stq	$7, 0x30(%1)   	\n\t"

		    pop_most
		    load_gp
		    : "=r"(result)

		    : "r"(&(rcv_regs->val)),
		      "r"(dest.thread_id), 
		      "r"((qword_t)snd_msg),  
		      "r"((qword_t)rcv_msg & ~0x07),  
		      "r"(timeout.timeout),
		    
  	  	      "r"(&(snd_regs->val))
		    
                     : "$0","$1","$2","$3","$4","$5","$6","$7","$16","$17","$18","$19","$26","$29","27","memory");

  } else {
    __asm__
      __volatile__ (
		    save_gp
		    push_most

		    "bis	%2, $31, $16	\n\t"
		    "subq	%3, 0, $17	\n\t"
		    "bis	%4, 0, $18	\n\t"
		    "bis	%5, $31, $19	\n\t"
		    ".long	L4_IPC_ENTRY	# receive	\n\t"
		    "bis	$0, $31, %0	\n\t"

		    pop_most
		    load_gp
		    : "=r"(result)

		    : "r"(&(rcv_regs->val)),
		      "r"(dest.thread_id), 
		      "r"((qword_t)snd_msg),  
		      "r"((qword_t)rcv_msg & ~0x07),  
		      "r"(timeout.timeout),
		    
  	  	      "r"(&(snd_regs->val))
		    : "$0","$1","$2","$3","$4","$5","$6","$7","$16","$17","$18","$19","$26","$29","27","memory");
#if 0

#endif
  }
  return result;
}



L4_INLINE l4_msgdope_t
l4_alpha_ipc_reply_and_wait(l4_threadid_t dest, 
			    const void *snd_msg, 
			    const l4_ipcregs_t *snd_regs,
			    l4_threadid_t *src,
			    void *rcv_msg, 
			    l4_ipcregs_t *rcv_regs,
			    l4_timeout_t timeout)
{
  l4_msgdope_t result;

  if (snd_regs && rcv_regs) {
    __asm__
      __volatile__ (
		    save_gp
		    push_most
		    "ldq	$1, 0x00(%6)   	\n\t"
		    "ldq	$2, 0x08(%6)   	\n\t"
		    "ldq	$3, 0x10(%6)   	\n\t"
		    "ldq	$4, 0x18(%6)   	\n\t"
		    "ldq	$5, 0x20(%6)   	\n\t"
		    "ldq	$6, 0x28(%6)   	\n\t"
		    "ldq	$7, 0x30(%6)   	\n\t"

		    "bis	%2, $31, $16	\n\t"
		    "subq	%3, 0, $17	\n\t"
		    "bis	%4, 1, $18	\n\t"
		    "bis	%5, $31, $19	\n\t"
		    ".long	L4_IPC_ENTRY	# receive	\n\t"
		    "bis	$0, $31, %0	\n\t"

		    "stq	$1, 0x00(%1)   	\n\t"
		    "stq	$2, 0x08(%1)   	\n\t"
		    "stq	$3, 0x10(%1)   	\n\t"
		    "stq	$4, 0x18(%1)   	\n\t"
		    "stq	$5, 0x20(%1)   	\n\t"
		    "stq	$6, 0x28(%1)   	\n\t"
		    "stq	$7, 0x30(%1)   	\n\t"

		    pop_most
		    load_gp
		    : "=r"(result)
		      
		    : "r"(&(rcv_regs->val)),
		      "r"(dest.thread_id), 
		      "r"((qword_t)snd_msg),  
		      "r"((qword_t)rcv_msg & ~0x07),  
		      "r"(timeout.timeout),
		    
  	  	      "r"(&(snd_regs->val))

		    : "$0","$1","$2","$3","$4","$5","$6","$7","$16","$17","$18","$19","$26","$29","27","memory");
  } else if (snd_regs) {
    __asm__
      __volatile__ (
		    save_gp
		    push_most
		    "ldq	$1, 0x00(%6)   	\n\t"
		    "ldq	$2, 0x08(%6)   	\n\t"
		    "ldq	$3, 0x10(%6)   	\n\t"
		    "ldq	$4, 0x18(%6)   	\n\t"
		    "ldq	$5, 0x20(%6)   	\n\t"
		    "ldq	$6, 0x28(%6)   	\n\t"
		    "ldq	$7, 0x30(%6)   	\n\t"

		    "bis	%2, $31, $16	\n\t"
		    "subq	%3, 0, $17	\n\t"
		    "bis	%4, 1, $18	\n\t"
		    "bis	%5, $31, $19	\n\t"
		    ".long	L4_IPC_ENTRY	# receive	\n\t"
		    "bis	$0, $31, %0	\n\t"

		    pop_most
		    load_gp
		    : "=r"(result)
		    
		    : "r"(&(rcv_regs->val)),
		      "r"(dest.thread_id), 
		      "r"((qword_t)snd_msg),  
		      "r"((qword_t)rcv_msg & ~0x07),  
		      "r"(timeout.timeout),
		    
  	  	      "r"(&(snd_regs->val))

		    : "$0","$1","$2","$3","$4","$5","$6","$7","$16","$17","$18","$19","$26","$29","27","memory");
  } else if (rcv_regs) {
    __asm__
      __volatile__ (
		    save_gp
		    push_most
		    "bis	%2, $31, $16	\n\t"
		    "subq	%3, 0, $17	\n\t"
		    "bis	%4, 1, $18	\n\t"
		    "bis	%5, $31, $19	\n\t"
		    ".long	L4_IPC_ENTRY	# receive	\n\t"
		    "bis	$0, $31, %0	\n\t"

		    "stq	$1, 0x00(%1)   	\n\t"
		    "stq	$2, 0x08(%1)   	\n\t"
		    "stq	$3, 0x10(%1)   	\n\t"
		    "stq	$4, 0x18(%1)   	\n\t"
		    "stq	$5, 0x20(%1)   	\n\t"
		    "stq	$6, 0x28(%1)   	\n\t"
		    "stq	$7, 0x30(%1)   	\n\t"

		    pop_most
		    load_gp
		    : "=r"(result)
		    
		    : "r"(&(rcv_regs->val)),
		      "r"(dest.thread_id), 
		      "r"((qword_t)snd_msg),  
		      "r"((qword_t)rcv_msg & ~0x07),  
		      "r"(timeout.timeout),
		    
  	  	      "r"(&(snd_regs->val))

		    : "$0","$1","$2","$3","$4","$5","$6","$7","$16","$17","$18","$19","$26","$29","27","memory");
  } else {
    __asm__
      __volatile__ (
		    save_gp
		    push_most
		    "bis	%2, $31, $16	\n\t"
		    "subq	%3, 0, $17	\n\t"
		    "bis	%4, 1, $18	\n\t"
		    "bis	%5, $31, $19	\n\t"
		    ".long	L4_IPC_ENTRY	# receive	\n\t"
		    "bis	$0, $31, %0	\n\t"

		    pop_most
		    load_gp
		    : "=r"(result)
		    
		    : "r"(&(rcv_regs->val)),
		      "r"(dest.thread_id), 
		      "r"((qword_t)snd_msg),  
		      "r"((qword_t)rcv_msg & ~0x07),  
		      "r"(timeout.timeout),
		    
  	  	      "r"(&(snd_regs->val))

		    : "$0","$1","$2","$3","$4","$5","$6","$7","$16","$17","$18","$19","$26","$29","27");
  }
  return result;
}

L4_INLINE l4_msgdope_t
l4_i386_ipc_reply_deceiting_and_wait(l4_ipc_deceit_ids_t ids,
				     const void *snd_msg, 
				     dword_t snd_dword0, dword_t snd_dword1,
				     l4_threadid_t *src,
				     void *rcv_msg, 
				     dword_t *rcv_dword0, dword_t *rcv_dword1, 
				     l4_timeout_t timeout, 
				     l4_msgdope_t *result)
{
  return L4_IPC_ERROR(*result);
}


L4_INLINE l4_msgdope_t 
l4_alpha_ipc_send(l4_threadid_t dest, 
		  const void *snd_msg,
		  const l4_ipcregs_t *snd_regs,
		  l4_timeout_t timeout)
{
  l4_msgdope_t result;

  if (snd_regs) {
    __asm__
      __volatile__ (
		    save_gp
		    push_most
		    "bis	%1, %1, $16	\n\t"
		    "bis	%2,  0, $17	\n\t"
		    "subq	$31, 1, $18	\n\t"
		    "bis	%3, %3, $19	\n\t"
		    
		    "bis	%4, $31, $1	\n\t"
		    "bis	%5, $31, $2	\n\t"
		    "bis	%6, $31, $3	\n\t"
		    "bis	%7, $31, $4	\n\t"
		    "bis	%8, $31, $5	\n\t"
		    "bis	%9, $31, $6	\n\t"
		    "bis	%10, $31, $7	\n\t"
		    ".long	L4_IPC_ENTRY	# send	\n\t"
		    "bis	$0,$0,%0	\n\t"

		    pop_most
		    load_gp
		    : "=r"(result)

		    : "r"(dest.thread_id), 
 		      "r"((qword_t)snd_msg),  
		      "r"(timeout.timeout),
		      "r"(snd_regs->val[0]),
		      "r"(snd_regs->val[1]),
		      "r"(snd_regs->val[2]),
		      "r"(snd_regs->val[3]),
		      "r"(snd_regs->val[4]),
		      "r"(snd_regs->val[5]),
		      "r"(snd_regs->val[6])
		  : "$0","$1","$2","$3","$4","$5","$6","$7","$16","$17","$18","$19","$26","$29","27"
		  );
  } else {
    __asm__
      __volatile__ (
		    save_gp
		    push_most
		    "bis	%1, %1, $16     \n\t"
		    "bis	%2,  0, $17     \n\t"
		    "subq	$31, 1, $18     \n\t"
		    "bis	%3, %3, $19     \n\t"
		    ".long    L4_IPC_ENTRY # send     \n\t"
		    "bis  $0,$0,%0		\n\t"

		    pop_most
		    load_gp
		    : "=r"(result)
		    
		    : "r"(dest.thread_id), 
		      "r"((qword_t)snd_msg),  
		      "r"(timeout.timeout)

		    : "$0","$1","$2","$3","$4","$5","$6","$7","$16","$17","$18","$19","$26","$29","27"
		    );
  }
  return result;
};

L4_INLINE l4_msgdope_t
l4_i386_ipc_send_deceiting(l4_ipc_deceit_ids_t ids,
			   const void *snd_msg, 
			   dword_t snd_dword0, dword_t snd_dword1, 
			   l4_timeout_t timeout, l4_msgdope_t *result)
{
  return L4_IPC_ERROR(*result);
};

L4_INLINE l4_msgdope_t
l4_alpha_ipc_receive(l4_threadid_t src,
		     void *rcv_msg,
		     l4_ipcregs_t *rcv_regs,
		     l4_timeout_t timeout)
{
  l4_msgdope_t result;


  if (rcv_regs) {
    __asm__
      __volatile__ (
		    save_gp
		    push_most
		    "bis	%8, $31, $16	\n\t"
		    "subq	$31, 1, $17	\n\t"
		    "bis	%9,  0, $18	\n\t"
		    "bis	%10, $31, $19	\n\t"
		    ".long      L4_IPC_ENTRY	# receive	\n\t"
		    "bis	$0, $31, %0	\n\t"
		    "bis	$1, $31, %1	\n\t"
		    "bis	$2, $31, %2	\n\t"
		    "bis	$3, $31, %3	\n\t"
		    "bis	$4, $31, %4	\n\t"
		    "bis	$5, $31, %5	\n\t"
		    "bis	$6, $31, %6	\n\t"
		    "bis	$7, $31, %7	\n\t"

		    pop_most
		    load_gp

		    : "=r"(result),
		    
		      "=r"(rcv_regs->val[0]),
		      "=r"(rcv_regs->val[1]),
		      "=r"(rcv_regs->val[2]),
		      "=r"(rcv_regs->val[3]),
		      "=r"(rcv_regs->val[4]),
 		      "=r"(rcv_regs->val[5]),
		      "=r"(rcv_regs->val[6]) 

		    : "r"(src.thread_id), 
		      "r"((qword_t)rcv_msg & ~0x07),  
		      "r"(timeout.timeout)
		    : SCRREG);
  } else {
    __asm__
      __volatile__ (
		    save_gp
		    push_most
		    "bis	%1, $31, $16	\n\t"
		    "subq	$31, 1, $17	\n\t"
		    "bis	%2,  0, $18	\n\t"
		    "bis	%3, $31, $19	\n\t"
		    ".long	L4_IPC_ENTRY	# receive	\n\t"
		    "bis	$0, $31, %0	\n\t"

		    pop_most
		    load_gp
		    : "=r"(result)
		    
		    : "r"(src.thread_id), 
		      "r"((qword_t)rcv_msg & ~0x07),  
		      "r"(timeout.timeout)
		    
		    : SCRREG
		    );
  }
  return result;
}


L4_INLINE l4_msgdope_t 
l4_alpha_ipc_wait(l4_threadid_t *src,
		  void *rcv_msg,
		  l4_ipcregs_t *rcv_regs,
		  l4_timeout_t timeout)
{
  l4_msgdope_t result;
  
  if (rcv_regs) {
    __asm__
      __volatile__ (
		    save_gp
		    push_most
		    "subq	$31, 1, $17	\n\t"
		    "bis	%9,  1, $18	\n\t"
		    "bis	%10, $31, $19	\n\t"
		    ".long	L4_IPC_ENTRY	# wait	\n\t"
		    "bis	$0, $31, %0	\n\t"
		    "bis	$1, $31, %1	\n\t"
		    "bis	$2, $31, %2	\n\t"
		    "bis	$3, $31, %3	\n\t"
		    "bis	$4, $31, %4	\n\t"
		    "bis	$5, $31, %5	\n\t"
		    "bis	$6, $31, %6	\n\t"
		    "bis	$7, $31, %7	\n\t"
		    "bis	$27, $31, %8	\n\t"

		    pop_most
		    load_gp
		    : "=r"(result),

  		      "=r"(rcv_regs->val[0]),
		      "=r"(rcv_regs->val[1]),
		      "=r"(rcv_regs->val[2]),
		      "=r"(rcv_regs->val[3]),
		      "=r"(rcv_regs->val[4]),
		      "=r"(rcv_regs->val[5]),
		      "=r"(rcv_regs->val[6]),
		      
		      "=r"(src->thread_id)

		    : "r"((qword_t)rcv_msg & ~0x07),  
  		      "r"(timeout.timeout)

		    : SCRREG
		  );
  } else {
    __asm__
      __volatile__ (
		    save_gp
		    push_most
		    "subq	$31, 1, $17     \n\t"
		    "bis	%2,  1, $18     \n\t"
		    "bis	%3, %3, $19     \n\t"
		    ".long	L4_IPC_ENTRY	# wait  \n\t"
		    "bis	$0,$0,%0        \n\t"
		    "bis	$27, $27, %1    \n\t"

		    pop_most
		    load_gp
		    : "=r"(result),
                      "=r"(src->thread_id)
		    
		    : "r"((qword_t)rcv_msg & ~0x07),  
                      "r"(timeout.timeout)

		    : SCRREG
		    );
  }
  return result;
}

#endif


#endif /* __L4_IPC__ */











