/* 
 * $Id: kdebug.h,v 5.1 1999/11/09 00:45:52 danielp Exp $
 *
 * kdebug.h provides some useful macros to acces the functionality 
 * of the kernel debugger
 */

#ifndef __L4_KDEBUG_H__ 
#define __L4_KDEBUG_H__ 

#include <l4/compiler.h>
#include <l4/../../pal/palcalls.h>

extern void l4dbg_write_string (const char *);
extern void l4dbg_print_hex(qword_t , qword_t);
extern void l4dbg_print_char(char c);

L4_INLINE void 
halt (void);

L4_INLINE void 
enter_kdebug (void);

L4_INLINE void 
print_string (const char *str);

L4_INLINE void 
print_hex (qword_t x, qword_t  bits);

L4_INLINE void 
print_char (char c);

L4_INLINE void
nop (void);


L4_INLINE void 
halt (void)
{
  __asm__
    __volatile__ (
		  ".long %0\n\t": :"i"(UDBG_SYSHALT)
		  );
}

L4_INLINE void 
enter_kdebug (void)
{
  __asm__
    __volatile__ (
		  ".long %0\n\t": :"i"(UDBG_DEBUG)
		  );
}
      

L4_INLINE void 
print_string (const char *str)
{
#if 1
  l4dbg_write_string (str);
#else
  __asm__ 
    __volatile__ (
	   save_gp
	   "bis		%0, $31, $16	\n\t"
	   ".long	%1\n"

	   load_gp
	   :
	   : "r"(str),
	     "i"(UDBG_PRINT_STR)
	   : "$16","$17","$26","$29"
	   );
#endif
}


L4_INLINE void 
print_hex (qword_t x, qword_t  bits)
{
#if 1
  l4dbg_print_hex (x, bits);
#else
  __asm__ 
     __volatile__ (
	   save_gp
	   "bis		%0, $31, $16	\n\t"
	   "bis		%1, $31, $17	\n\t"
	   ".long	%2\n"
	   load_gp
	   :
	   : "r"(x),
	     "r"(bits),
	     "i"(UDBG_PRINT_HEX)
	   : "$16","$17","$26","$29"
	   );
#endif
}

L4_INLINE void 
print_char (char c)
{
#if 1
  l4dbg_print_char (c);
#else
  __asm__ 
     __volatile__ (
	   save_gp
	   "bis		%0, $31, $16	\n\t"
	   ".long	%1\n"
	   load_gp
	   :
	   : "r"(c),
             "i"(UDBG_PRINT_CHAR)
	   : "$16","$26","$29"
	   );
#endif
}


L4_INLINE void
nop (void)
{
  __asm__
    __volatile__ (
		  "nop\n\t");
}


#endif /* __L4_KDEBUG_H__ */


