/* 
 * $Id: kernel.h,v 5.0 1999/03/01 05:25:46 danielp Exp $
 */
#ifndef __L4_KERNEL_H__ 
#define __L4_KERNEL_H__ 

#include <l4/types.h>

typedef struct 
{
  dword_t magic;
  dword_t version;
  byte_t offset_version_strings;
  byte_t reserved[7 + 5 * 16];
  l4_low_high_t main_memory;
  l4_low_high_t reserved0, reserved1;
  l4_low_high_t semi_reserved;
  l4_low_high_t dedicated[4];
  dword_t clock;
} l4_kernel_info_t;

#define L4_KERNEL_INFO_MAGIC (0x4BE6344CL) /* "L4K" */

#endif
