/* 
 * $Id: syscalls.h,v 5.2 1999/11/09 00:45:53 danielp Exp $
 */

#ifndef __L4_SYSCALLS_H__ 
#define __L4_SYSCALLS_H__ 

#include <l4/compiler.h>
#include <l4/types.h>


#if 0
#include <pal/l4pal.h>
#endif

#define L4_FP_REMAP_PAGE	0x02	/* Page is set to read only */
#define L4_FP_FLUSH_PAGE	0x00	/* Page is flushed completly */
#define L4_FP_OTHER_SPACES	0x00	/* Page is flushed in all other */
					/* address spaces */
#define L4_FP_ALL_SPACES	0x01
					/* Page is flushed in own address */ 
					/* space too */

#define L4_NC_SAME_CLAN		0x00	/* destination resides within the */
					/* same clan */
#define L4_NC_INNER_CLAN	0x0C	/* destination is in an inner clan */
#define L4_NC_OUTER_CLAN	0x04	/* destination is outside the */
					/* invoker's clan */

#define L4_CT_LIMITED_IO	0
#define L4_CT_UNLIMITED_IO	1
#define L4_CT_DI_FORBIDDEN	0
#define L4_CT_DI_ALLOWED	1

/*
 * prototypes
 */
L4_INLINE void 
l4_fpage_unmap(l4_fpage_t fpage, dword_t map_mask);

L4_INLINE void
l4_fpage_unmap_easy(qword_t VAddr, qword_t ld_pages, int bIncluding, int bReadOnly);

L4_INLINE l4_threadid_t 
l4_myself(void);

L4_INLINE l4_threadid_t 
l4_nchief(l4_threadid_t destination, l4_threadid_t *next_chief);


L4_INLINE int 
l4_id_nearest(l4_threadid_t destination, l4_threadid_t *next_chief);


L4_INLINE void
l4_thread_ex_regs(l4_threadid_t destination, qword_t pc, qword_t sp,
		  l4_threadid_t *preempter, l4_threadid_t *pager,
		  qword_t *old_pc, qword_t *old_sp);
L4_INLINE void
l4_thread_switch(l4_threadid_t destination);

L4_INLINE cpu_time_t
l4_thread_schedule(l4_threadid_t dest, l4_sched_param_t param,
		   l4_threadid_t *ext_preempter, l4_threadid_t *partner,
		   l4_sched_param_t *old_param);

L4_INLINE void
l4_schedule (l4_threadid_t dest, l4_threadid_t preempter, qword_t par2);

L4_INLINE l4_taskid_t 
l4_task_new(l4_taskid_t destination, qword_t mcp_or_new_chief, 
	    qword_t sp, qword_t pc, l4_threadid_t pager);



typedef struct {
	void (*idt_memory)(void);
	void (*idt_instruction)(void);
	void (*idt_arithmetic)(void);
	void (*idt_unaligned)(void);
} l4_alphaidt_t;


/*L4_INLINE*/ void
l4_set_idt(l4_alphaidt_t *idt);		/* HACKED at the moment */




#ifdef GOOD_GCC
/*
 * L4 flex page unmap
 */

L4_INLINE void
l4_fpage_unmap(l4_fpage_t fpage, dword_t map_mask)
{  
  __asm__
    __volatile__
      ("mov	%0, $16		    	\n\t"
       "mov	%1, $17			\n\t"
       ".long	0x81			\n\t"
       :
       :"r" (fpage.fpage),
        "r" (map_mask)
       : "$16","$17","$26","$29"
       );
};



/*
 * L4 id myself
 */

#define L4_ID_NEAREST_ENTRY L4_ID_MYSELF_ENTRY

L4_INLINE l4_threadid_t
l4_myself(void)
{
  l4_threadid_t temp_id;

  __asm__
    __volatile__
      ("subq	$31, 1, $16	      	\n\t"
       ".long	0x82			\n\t"
       "bis	$0, $0, %0		\n\t"
       : "=r" (temp_id.thread_id)
       : 
       : "$16","$26","$29"
       );
  return temp_id;
}

/*
 * L4 id next chief
 */


L4_INLINE l4_threadid_t
l4_nchief(l4_threadid_t destination, l4_threadid_t *next_chief)
{
  l4_threadid_t temp_id;

  __asm__
    __volatile__
      ("bis	$31, %1, $16	      	\n\t"
       ".long	0x82			\n\t"
       "bis	$0, $0, %0		\n\t"
       : "=r" (temp_id.thread_id)
       : "r"(destination.thread_id)
       : "$16","$26","$29"
       );
  if (next_chief)
    *next_chief = temp_id;
  return temp_id;
}

/*
 * L4 lthread_ex_regs
 */
L4_INLINE void
l4_thread_ex_regs(qword_t destination, qword_t pc, qword_t sp,
		  l4_threadid_t *preempter, l4_threadid_t *pager,
		  qword_t *old_pc, qword_t *old_sp)
{
  __asm__
    __volatile__ (
		  save_gp
		  "bis	%4,%4,$16	\n\t"
		  "bis	%5,%5,$17	\n\t"
		  "bis	%6,%6,$18	\n\t"
		  "bis	%7,%7,$19	\n\t"
		  "bis	%8,%8,$20	\n\t"
		  ".long 0x85		\n\t"
		  "bis  $17,$31,%0	\n\t"
		  "bis  $18,$31,%1	\n\t"
		  "bis  $19,$31,%2	\n\t"
		  "bis  $20,$31,%3	\n\t"
		  load_gp

		  : "=r"(preempter->thread_id),
		    "=r"(pager->thread_id),
		    "=r"(*old_pc),
		    "=r"(*old_sp)
		  : "r"(destination),
		    "r"(preempter->thread_id),
		    "r"(pager->thread_id),
		    "r"(pc),
		    "r"(sp)
		  : "$0","$1","$2","$3","$4","$5","$16","$17","$18","$19","$20","$26","$27","$29"
		  );
}


/*
 * L4 thread switch
 */

#define save_reg(nr) "subq $30,8,$30;stq $"##nr##", 0($30)\n\t");
#define rest_reg(nr) "ldq $##nr##, 0($30); addq $30, 8, $30\n\t");

L4_INLINE void
l4_thread_switch(l4_threadid_t destination)
{
  __asm__
    __volatile__(
		 save_gp
		 "bis	%0, %0, $16	\n\t"
		 ".long 0x83		\n\t"
		 load_gp
		 :
		 : "r"(destination.thread_id)
		 : "$0","$1","$2","$3","$4","$5","$6","$7","$8","$9",
 		   "$10","$11","$12","$13","$14","$15","$16","$17","$18","$19",
		   "$20","$21","$22","$23","$24","$25","$26","$27","$28");
}

/*
 * L4 thread schedule
 */

L4_INLINE cpu_time_t
l4_thread_schedule(l4_threadid_t dest, l4_sched_param_t param,
		   l4_threadid_t *ext_preempter, l4_threadid_t *partner,
		   l4_sched_param_t *old_param)
{
}

  
  
/*
 * L4 task new
 */
L4_INLINE l4_taskid_t 
l4_task_new(l4_taskid_t destination, qword_t mcp_or_new_chief, 
	    qword_t pc, l4_threadid_t pager)
{
  l4_taskid_t id;

  __asm__
    __volatile__(
		 save_gp
		 "bis	%1, %1, $16	\n\t"
		 "bis	%2, %2, $17	\n\t"
		 "bis	%3, %3, $18	\n\t"
		 "bis	%4, %4, $19	\n\t"
		 ".long	0x87		\n\t"
		 "bis	$0, $0, %0	\n\t"
		 load_gp
		 : "=r"(id.thread_id)
		 : "r"(destination),
		   "r"(mcp_or_new_chief),
		   "r"(pager.thread_id),
		   "r"(pc)
		 : "$0","$1","$2","$3","$4","$5","$6","$7",
 		   "$16","$17","$18","$19",
		   "$26","$27","$29");
  return id;
}

L4_INLINE void
l4_set_idt(l4_alphaidt_t *idt)
{
  __asm__	
    __volatile__ (
		  save_gp
		  "ldiq $16, %0		\n\t"
		  "bis	%1, %1, $17	\n\t"
		  ".long 0x88		\n\t"
		  load_gp
		  :
		  : "i"(0),
		    "r"(idt)
		  : "$16", "$17", "$26"
		  );
}

#endif


#endif



