 /* 
 * $Id: types.h,v 5.1 1999/11/09 00:45:53 danielp Exp $
 */

#ifndef __L4_TYPES_H__ 
#define __L4_TYPES_H__ 


#include <l4/compiler.h>

typedef unsigned char       byte_t;
typedef unsigned short int  word_t;
typedef unsigned int        dword_t;
typedef unsigned long long  qword_t;		
typedef long long	    cpu_time_t;

#ifdef L4_EXTRA_TYPES  /* MOVE SOMEWHERE ELSE */
typedef unsigned char		_Bool; /* part of new C standard */
typedef signed char		int8_t;
typedef unsigned char		uint8_t;
typedef short			int16_t;
typedef unsigned short		uint16_t;
typedef int			int32_t;
typedef unsigned int		uint32_t;
typedef long      		int64_t;
typedef unsigned long     	uint64_t;
typedef uint64_t 		size_t;
typedef int64_t			ssize_t;
typedef uint64_t 		uintptr_t;
#endif

/* 
 * L4 unique identifiers 
 */

typedef struct {
  unsigned version_low:11 PACK;
  unsigned lthread:8	  PACK;
  unsigned task:10        PACK;
  unsigned version_high:4 PACK;
  unsigned site:16        PACK;
  unsigned chief:10       PACK;
  unsigned nest:4         PACK;		// code assumes on this order.
} l4_threadid_struct_t ;

typedef union {
  qword_t thread_id;
    qword_t ID;			// Compatibility with L4/MIPS
  l4_threadid_struct_t id;
} l4_threadid_t;

typedef l4_threadid_t l4_taskid_t;

typedef struct {
  unsigned MBZ1:11	PACK;
  unsigned intr:8	PACK;
  long MBZ2:45		PACK;
} l4_intrid_struct_t;

typedef union {
  qword_t intrid;
  l4_intrid_struct_t id;
} l4_intrid_t;

#define L4_NIL_ID 		((l4_threadid_t){thread_id:0x0000000000000000})
#define L4_INVALID_ID		((l4_threadid_t){thread_id:0xffffffffffffffff})

/*
 * L4 flex pages
 */

typedef struct {
  unsigned grant:1	PACK;
  unsigned write:1	PACK;
  unsigned size:6	PACK;
  unsigned zero:5	PACK;
  qword_t page:51	PACK;
} l4_fpage_struct_t;

typedef union {
  qword_t fpage;
  l4_fpage_struct_t fp;
} l4_fpage_t;

#define L4_PAGESIZE 	(0x2000)
#define L4_PAGEMASK	(~(L4_PAGESIZE - 1))
#define L4_LOG2_PAGESIZE (13)
#define L4_WHOLE_ADDRESS_SPACE (63)
#define L4_FPAGE_RO	0
#define L4_FPAGE_RW	1
#define L4_FPAGE_MAP	0
#define L4_FPAGE_GRANT	1

typedef struct {
  qword_t snd_base;
  l4_fpage_t fpage;
} l4_snd_fpage_t;

/*
 * L4 message dopes
 */

typedef struct {
  unsigned msg_deceited:1	PACK;
  unsigned fpage_received:1	PACK;
  unsigned msg_redirected:1	PACK;
  unsigned src_inside:1		PACK;
  unsigned snd_error:1		PACK;
  unsigned error_code:3		PACK;
  unsigned strings:5		PACK;
  qword_t dwords:51		PACK;
} l4_msgdope_struct_t;

typedef union {
  qword_t msgdope;
  l4_msgdope_struct_t md;
} l4_msgdope_t;

/*
 * L4 string dopes
 */

typedef struct {
  qword_t snd_size;
  qword_t snd_str;
  qword_t rcv_size;
  qword_t rcv_str;
} l4_strdope_t;

/*
 * L4 message header - currently unsupported.
 */

typedef struct {
    l4_fpage_t rcv_fpage;
    l4_msgdope_t size_dope;
    l4_msgdope_t snd_dope;
} l4_msghdr_t;


/*
 * L4 timeouts
 */

typedef struct {
  unsigned rcv_exp:8	PACK;
  unsigned rcv_pfault:8	PACK;
  unsigned rcv_man:16	PACK;

  unsigned snd_exp:8	PACK;
  unsigned snd_pfault:8	PACK;
  unsigned snd_man:16	PACK;

} l4_timeout_struct_t;

typedef union {
  qword_t timeout;
  l4_timeout_struct_t to;
} l4_timeout_t;

/*
 * l4_schedule param word
 */

typedef struct {
  unsigned prio:8	PACK;
  unsigned small:8	PACK;
  unsigned zero:4	PACK;
  unsigned time_exp:4	PACK;
  unsigned time_man:8	PACK;
} l4_sched_param_struct_t;

typedef union {
  qword_t sched_param;
  l4_sched_param_struct_t sp;
} l4_sched_param_t;

#define L4_SMALL_SPACE(size_mb, nr) ((size_mb >> 2) + nr * (size_mb >> 1))

/*
 * Some useful operations and test functions for id's and types
 */
#if 1
L4_INLINE int l4_is_nil_id(l4_threadid_t id);
L4_INLINE int l4_is_invalid_id(l4_threadid_t id);
L4_INLINE l4_fpage_t l4_fpage(unsigned long address, unsigned int size, 
				  unsigned char write, unsigned char grant);
L4_INLINE l4_threadid_t get_taskid(l4_threadid_t t);
L4_INLINE int thread_equal(l4_threadid_t t1,l4_threadid_t t2);
L4_INLINE int task_equal(l4_threadid_t t1,l4_threadid_t t2);


L4_INLINE int l4_is_nil_id(l4_threadid_t id)
{
  return id.thread_id == 0;
}

L4_INLINE int l4_is_invalid_id(l4_threadid_t id)
{
  return id.thread_id == 0xffffffffffffffff;
}

L4_INLINE l4_fpage_t l4_fpage(unsigned long address, unsigned int size, 
				  unsigned char write, unsigned char grant)
{
  return ((l4_fpage_t){fp:{grant, write, size, 0, 
			     (address & L4_PAGEMASK) >> L4_LOG2_PAGESIZE }});
}

L4_INLINE l4_threadid_t 
get_taskid(l4_threadid_t t)
{
  t.id.lthread = 0;
  return t; 
}

L4_INLINE int
thread_equal(l4_threadid_t t1,l4_threadid_t t2)
{
  return ((t1.thread_id == t2.thread_id));
}


L4_INLINE int
task_equal(l4_threadid_t t1,l4_threadid_t t2)
{
  return ((t1.thread_id & ~0x3ffff) == 
	  (t2.thread_id & ~0x3ffff));
}

#endif
#endif /* __L4TYPES_H__ */ 


