/* -*- asm -*- */
/*
**	MACROS for gasp
**
**	PREPROCESS BEFORE GASP !
*/

#ifndef __GASP_H
#define __GASP_H

.MACRO Xpush mask, opc
	/* pushmask \mask */
tmask .ASSIGNA \mask
count .ASSIGNA 0
.AWHILE \&tmask GT 0
bit .ASSIGNA \&tmask-(\&tmask/2*2)
tmask .ASSIGNA \&tmask/2
.AIF \&bit NE 0
count .ASSIGNA \&count+1
.AENDI
.AENDW
count .ASSIGNA \&count*8
	lda	sp, -\&count(sp)
tmask .ASSIGNA \mask
count .ASSIGNA 0
place .ASSIGNA 0
.AWHILE \&tmask GT 0
bit .ASSIGNA \&tmask-(\&tmask/2*2)
tmask .ASSIGNA \&tmask/2
.AIF \&bit NE 0
xplace .ASSIGNA \&place*8
	\opc	$\&count, \&xplace(sp)
place .ASSIGNA \&place+1
.AENDI
count .ASSIGNA \&count+1
.AENDW
.ENDM

  
.MACRO Xpop mask, opc
	/* popmask \mask */
tmask .ASSIGNA \mask
count .ASSIGNA 0
place .ASSIGNA 0
.AWHILE \&tmask GT 0
bit .ASSIGNA \&tmask-(\&tmask/2*2)
tmask .ASSIGNA \&tmask/2
.AIF \&bit NE 0
xplace .ASSIGNA \&place*8
	\opc	$\&count, \&xplace(sp)
place .ASSIGNA \&place+1
.AENDI
count .ASSIGNA \&count+1
.AENDW
count .ASSIGNA (\&place)*8
	lda	sp, \&count(sp)
.ENDM
 
.MACRO push mask
	Xpush	\mask, stq_a
.ENDM

.MACRO pop mask
	Xpop	\mask, ldq_a
.ENDM


p_v0            .REG (1)
p_t0            .REG (2)
p_t1            .REG (4)
p_t2            .REG (8)
p_t3            .REG (16)
p_t4            .REG (32)
p_t5            .REG (64)
p_t6            .REG (128)
p_t7            .REG (256)
p_s0            .REG (512)
p_s1            .REG (1024)
p_s2            .REG (2048)
p_s3            .REG (4096)
p_s4            .REG (8192)
p_s5            .REG (16384)
p_fp            .REG (32768)
p_s6            .REG (32768)
p_a0            .REG (65536)		
p_a1            .REG (131072)
p_a2            .REG (262144)
p_a3            .REG (524288)
p_a4            .REG (1048576)
p_a5            .REG (2097152)
p_t8            .REG (4194304)
p_t9            .REG (8388608)
p_t10           .REG (16777216)
p_t11           .REG (33554432)
p_ra            .REG (67108864)
p_pv            .REG (134217728)
p_t12           .REG (134217728)
p_AT            .REG (268435456)
p_gp            .REG (536870912)
p_sp            .REG (1073741824)




p_r0            .REG (1)
p_r1            .REG (2)
p_r2            .REG (4)
p_r3            .REG (8)
p_r4            .REG (16)
p_r5            .REG (32)
p_r6            .REG (64)
p_r7            .REG (128)
p_r8            .REG (256)
p_r9            .REG (512)
p_r10           .REG (1024)
p_r11           .REG (2048)
p_r12           .REG (4096)
p_r13           .REG (8192)
p_r14           .REG (16384)
p_r15           .REG (32768)
p_r16           .REG (65536)		
p_r17           .REG (131072)
p_r18           .REG (262144)
p_r19           .REG (524288)
p_r20           .REG (1048576)
p_r21           .REG (2097152)
p_r22           .REG (4194304)
p_r23           .REG (8388608)
p_r24           .REG (16777216)
p_r25           .REG (33554432)
p_r26           .REG (67108864)
p_r27           .REG (134217728)
p_r28           .REG (268435456)
p_r29           .REG (536870912)
p_r30           .REG (1073741824)

p_all           .REG (1073741823)


p_p0            .REG (p_r8)
p_p1            .REG (p_r9)
p_p2            .REG (p_r10)
p_p3            .REG (p_r11)
p_p4            .REG (p_r12)
p_p5            .REG (p_r13)
p_p6            .REG (p_r14)
p_p7            .REG (p_r25)


.MACRO kmsg string
	push p_a0
	br	a0, 9f
	.asciz	"\string"
	.align	3
9:	pal	UDBG_PRINT_STR
	pop p_a0
.ENDM

.MACRO pmsg string
	br	a0, 9f
	.asciz	"\string"
	.align	3
9:	ldah	a0, 0xf000(a0)
	zap	a0, 0x08, a0
	pal	UDBG_PRINT_STR
.ENDM


.MACRO khex reg,size=64
	push	p_a0|p_a1
	bis	\reg, \reg, a0
	ldiq	a1, \size
9:	pal	UDBG_PRINT_HEX
	pop	p_a0|p_a1
.ENDM

.MACRO sys_halt error
	lda	$0, \error($31)
	ldah	$0, 0xbad($0)
	br	sys_halt
.ENDM

/* Extracted code segments to be called */

xlable_name .ASSIGNC ""

.MACRO xxCALL  cmd, reg, lable_name 
	\cmd	\reg, XINV_\lable_name
XRET_\lable_name:
.ENDM

.MACRO XHEAD lable_name
XINV_\lable_name:
xlable_name .ASSIGNC "\lable_name"
.ENDM

.MACRO xxRET cmd, reg
	\cmd	\reg, XRET_\&xlable_name
.ENDM

/* == */
.MACRO XCALL lable_name
	xxCALL br, zero, \lable_name
.ENDM

.MACRO RETX
	xxRET br, zero
.ENDM

.MACRO RETIF reg
	xxRET bne, \reg 
.ENDM

.MACRO RETIFZ reg
	xxRET beq, \reg 
.ENDM
.MACRO RETIFLBS reg
	xxRET blbs, \reg 
.ENDM

.MACRO RETIFLBC reg
	xxRET blbc, \reg 
.ENDM


/* Conditionals */

icount .ASSIGNA 0
ival .ASSIGNA 0

#ifdef IF_COUNT
MAXIF .REG (IF_COUNT)
#else
MAXIF .REG (128)
#endif

/* Maximal IF = MAXIF */


.MACRO xIF cmd, reg
icount .ASSIGNA \&icount+1
ival .ASSIGNA \&ival*MAXIF+\&icount
	\cmd	\reg, I\&icount
icount .ASSIGNA \&icount+1
.ENDM

.MACRO ELSE lable_name=""
x1 .ASSIGNA \&ival-(\&ival/MAXIF*MAXIF)
ival .ASSIGNA \&ival+1
x2 .ASSIGNA \&ival-(\&ival/MAXIF*MAXIF)
	br	I\&x2

	ALIGN_BRANCH
I\&x1:
.ENDM

.MACRO ENDIF
x .ASSIGNA \&ival-(\&ival/MAXIF*MAXIF)
I\&x:
ival .ASSIGNA \&ival/MAXIF
.ENDM

.MACRO XENDIF
	ALIGN_BRANCH
	ENDIF
.ENDM


.MACRO IF reg, lable_name=""
.AIF "\lable_name" EQ ""
	xIF	beq, \reg
.AELSE
	xxCALL	bne, \reg, \lable_name
.AENDI
.ENDM

.MACRO IFZ reg, lable_name=""
.AIF "\lable_name" EQ ""
	xIF	bne, \reg
.AELSE
	xxCALL	beq, \reg, \lable_name
.AENDI
.ENDM

.MACRO IFLT reg, lable_name=""
.AIF "\lable_name" EQ ""
	xIF	bge, \reg
.AELSE
	xxCALL	blt, \reg, \lable_name
.AENDI
.ENDM

.MACRO IFLE reg, lable_name=""
.AIF "\lable_name" EQ ""
	xIF	bgt, \reg
.AELSE
	xxCALL	ble, \reg, \lable_name
.AENDI
.ENDM

.MACRO IFGT reg, lable_name=""
.AIF "\lable_name" EQ ""
	xIF	ble, \reg
.AELSE
	xxCALL	bgt, \reg, \lable_name
.AENDI
.ENDM

.MACRO IFGE reg, lable_name=""
.AIF "\lable_name" EQ ""
	xIF	blt, \reg
.AELSE
	xxCALL	bge, \reg, \lable_name
.AENDI
.ENDM

/* IFN is equal to IFZ (If NOT == IF Zero) */ 
.MACRO IFN reg, lable_name=""
	IFZ \reg, \lable_name
.ENDM

.MACRO IFLBS reg, lable_name=""
.AIF "\lable_name" EQ ""
	xIF	blbc, \reg
.AELSE
	xxCALL	blbs, \reg, \lable_name
.AENDI
.ENDM

.MACRO IFLBC reg, lable_name=""
.AIF "\lable_name" EQ ""
	xIF	blbs, \reg
.AELSE
	xxCALL	blbc, \reg, \lable_name
.AENDI
.ENDM


rcount .ASSIGNA 0
rval .ASSIGNA 0

#ifdef REP_COUNT
MAXREP .REG (REP_COUNT)
#else 
MAXREP .REG (128)
#endif

/* Maximal REPEAT = MAXREP */
.MACRO REPEAT 
R\&rcount:
rcount .ASSIGNA \&rcount+2
rval .ASSIGNA \&rval*MAXREP+\&rcount
.ENDM

.MACRO ENDR
x .ASSIGNA \&rval-(\&rval/MAXREP*MAXREP)-1
R\&x:
rval .ASSIGNA \&rval/MAXIF
.ENDM


.MACRO xCONT cmd, reg 
x .ASSIGNA \&rval-(\&rval/MAXREP*MAXREP)-2
	\cmd	\reg, R\&x	
.ENDM

.MACRO xEXIT cmd, reg 
x .ASSIGNA \&rval-(\&rval/MAXREP*MAXREP)-1
	\cmd	\reg, R\&x
.ENDM


.MACRO CONT reg=""
.AIF "\reg" EQ ""
	xCONT	br, zero
.AELSE
	xCONT	bne, \reg
.AENDI
.ENDM

.MACRO CONTZ reg
	xCONT	beq, \reg
.ENDM

.MACRO CONTLBS reg
	xCONT	blbs, \reg
.ENDM

.MACRO CONTLBC reg
	xCONT	blbc, \reg
.ENDM


.MACRO EXIT reg=""
.AIF "\reg" EQ ""
	xEXIT	br, zero
.AELSE
	xEXIT	bne, \reg
.AENDI
.ENDM

.MACRO EXITZ reg
	xEXIT	beq, \reg
.ENDM

.MACRO EXITLBS reg
	xEXIT	blbs, \reg
.ENDM

.MACRO EXITLBC reg
	xEXIT	blbc, \reg
.ENDM




/* Universal macros */

/* enable interrupt */
.MACRO enable_int
	mtpr	zero, ipl; NOP; NOP
.ENDM

/* disable interrupt */
.MACRO disable_int tmp=AT
	bis	zero, 0x1f, \tmp; mtpr \tmp, ipl; NOP; NOP	
.ENDM


.MACRO unop
	ldq_u	$31, 0($31)
.ENDM

.MACRO bsrret reg="ra"
	ret	zero, (\reg)
.ENDM


/* Get's current TCB on base of KSP register */

.MACRO tcb tr
	lda	\tr, TCB_MASK(zero)
	bic	sp, \tr, \tr
.ENDM


.MACRO task_nr tcb_or_tid, res        
	sll     \tcb_or_tid, 64-TID_S_VER1, \res
        srl     \res, 64-10, \res       
.ENDM

.MACRO task_nr_guell tcb_or_tid, res 
	ldah	\res, 0x1ff8(zero)
	and	\tcb_or_tid, \res, \res
	srl	\res, TID_S_TASK, \res
.ENDM

.MACRO tcb_ptr id, tcb
	ldah	\tcb, TCB_KBASE(zero)
	lda	AT, TID_M_VER0 (zero)
	or	\tcb, \id, \tcb
	bic	\tcb, AT, \tcb
.ENDM


/* Get the dispatcher TCB, i.e. task 0, thread 0, or the idle loop */
.MACRO tcb_dispatcher tcb
	ldah	\tcb, TCB_KBASE(zero)
.ENDM

        


/* Mark thread tcb busy and insert it after */
/* Vielleicht faellt uns mal was bessres ein !! */
#define enqueue_busy(tcb, t1, t2, t3)           \
        ldl_a   t1, TCB_LIST_STATE (tcb);       \
        and     t1, LLS_BUSY_QUEUE, t2;         \
        bne     t2, 9f;                         \
        or      t1, LLS_BUSY_QUEUE, t1;         \
        stl_a   t1, TCB_LIST_STATE (tcb);       \
        .base zero              ;               \
        lda    t2, thread_priorities;       \
        .base gp                ;               \
        ldl_a   t1, TCB_SCHED_SCP(tcb);        \
        s4addq  t1, t2, t2;                     \
        ldl_p   t1, 0(t2)       ;               \
	beq	t1, 8f;				\
	  ldq_a  t1, TCB_BUSY_PREV (t1);	\
          insert_ll (tcb, t1, t3, TCB_BUSY_QUEUE);\
	  br	9f		;		\
8:	stq_a	tcb, TCB_BUSY_NEXT (tcb);	\
	stq_a	tcb, TCB_BUSY_PREV (tcb);	\
	stl_p   tcb, 0(t2)       ;               \
9:                              ; 
        
/* Unmark and delete from busy queue, HAVE TO BE in queue ! */
#define dequeue_busy(tcb, tmp1, tmp2, tmp3)             \
        ldl_a   tmp1, TCB_SCHED_SCP (tcb);     \
        .base zero              ;               \
        lda     tmp2, thread_priorities;       \
        .base gp                ;               \
        s4addq  tmp1, tmp2, tmp1;               \
        ldl_p   tmp2, 0(tmp1)   ;               \
        cmpeq   tcb, tmp2, tmp2;               \
        beq     tmp2, 9f        ;               \
        ldq_a   tmp2, TCB_BUSY_NEXT (tcb);      \
        cmpeq   tmp2, tcb, tmp3 ;               \
        cmovne  tmp3, zero, tmp2;               \
        stl_p   tmp2, 0(tmp1)   ;               \
9:                              ;		\
        delete_ll (tcb, tmp1, tmp2, TCB_BUSY_QUEUE);\
        ldl_a   tmp1, TCB_LIST_STATE (tcb);     \
        bic     tmp1, LLS_BUSY_QUEUE, tmp1;     \
        stl_a   tmp1, TCB_LIST_STATE (tcb);     


/* 
** Linked List Support 
** insert tcb's entry after and use tmp into list 
** if entry and after point to the list itself, use ISLIST as list 
*/

#define ISLIST		0

#define insert_ll(entry, after, tmp, list)	\
	ldq_a	tmp, list (after);		\
	stq_a	entry, list (after);		\
	stq_a	tmp, list (entry);		\
	stq_a	after, (list+8) (entry);	\
	stq_a	entry, (list+8) (tmp);

/* delete entry from llist, use t1, t2 as temp */
#define delete_ll(entry, t1, t2, list)		\
	ldq_a	t1, (list+8)(entry);		\
	ldq_a	t2, list(entry);		\
	stq_a	t2, list(t1);			\
	stq_a	t1, (list+8)(t2);		

/* insert entry after and use tmp */
#define insert_l(entry, after, tmp, list)	\
	ldq_a	tmp, list(after);		\
	stq_a	tmp, list(entry);		\
	stq_a	entry, list(after);

/* delete entry from list */
#define delete_l(entry, pred, tmp, list)	\
	ldq_a	tmp, list(entry);		\
	stq_a	tmp, list(pred);


/* remove first of sender of tcb's queue */
#define first_sender(entry, tcb, t1, t2)	\
	lda	t1, TCB_SEND_ROOT(tcb);		\
	ldq_a	entry, 0(t1);			\
	ldq_a	t2, 0(entry);			\
	stq_a	t2, 0(t1);			\
	ldq_a   t1, 8(entry);			\
	stq_a	t1, 8(t2);

/* insert into send queue, later at the END ! */
#define insert_sender(entry, tcb, tm1, tm2)	\
	ldq_a	tm1, TCB_SEND_ROOT(tcb);	\
	stq_a	tm1, TCB_SEND_QUEUE(entry);	\
						\
	lda	tm2, TCB_SEND_QUEUE(entry);	\
	stq_a	tm2, 8(tm1);			\
	stq_a	tm2, TCB_SEND_ROOT(tcb);	\
	lda	tm1, TCB_SEND_ROOT(tcb);	\
	stq_a	tm1, 8(tm2);			\
						\
	ldl_a	tm1, TCB_LIST_STATE (entry);	\
	bis	tm1, LLS_POLLING_QUEUE, tm1;	\
	stl_a	tm1, TCB_LIST_STATE (entry);	\
	ldl_a	tm1, TCB_LIST_STATE (tcb);	\
	bis	tm1, LLS_POLLED_QUEUE, tm1;	\
	stl_a	tm1, TCB_LIST_STATE (tcb);	



/* 164 store and load macro for stack */
#define store(nr)	subq	sp, (nr*8), sp
#define	kpush(reg, nr)	stq	reg, (nr * 8)(sp)
#define	ppush(reg, nr)	stq_a	reg, (nr * 8)(sp)

#define load(nr)	addq	sp, (nr*8), sp
#define kpop(reg, nr)	ldq	reg, (nr * 8)(sp)
#define ppop(reg, nr)	ldq_a	reg, (nr * 8)(sp)


/* 164 Switches to kernel mode, set gp valid ! */
.MACRO kernel addr
	mtpr	zero, dtbCm
	ldah	p0, 0x8000(zero)
	mtpr	zero, ips
	addq	p0, p0, gp
	.base	gp
	lda	p0, \addr
	.base	zero
	mtpr	p0, excAddr
	STALL
	nop
	hw_rei_stall
.ENDM	

.MACRO return addr
	pal_addr AT, \addr
	pal	PAL_RETPAL_ENTRY
.ENDM

.MACRO return_reg reg
	bis	\reg, zero, AT
	pal	PAL_RETPAL_ENTRY
.ENDM
	
.MACRO return_frame		  
	pal	PAL_RETURN_ENTRY
.ENDM


.MACRO pal_addr reg, addr
	.base	zero
	lda	\reg, \addr
	.base	gp
.ENDM

	
/* 164 Load an address for virtual access call useful only from PAL mode */
.MACRO krn_addr reg, addr
	ldah	\reg, 0x8000(zero)
	addq	\reg, \reg, \reg
	.base	\reg
	lda	\reg, \addr
	.base	gp
.ENDM


/*
** Frame looks like this
**
**	+----------------+
**	| user sp        | ksp + 16	/24
**	+----------------+
**	| old mode       | ksp + 8	/16
**	+----------------+
**	| excAddr        | ksp + 0	/8
**      +~~~~~~~~~~~~~~~~+
**	| schedule in    | ksp (if dispatching, stored here)
**	+----------------+
**
**	The sp is only switched, if previous mode != kernel mode 
*/

.MACRO open_frame
	mfpr	p1, ips
	mfpr	p0, excAddr
	mfpr	p2, ptKSP
	beq	p1, 9f

	stq_a	sp, -8(p2)
	subq	p2, 8, sp

9:	stq_a	p1, -8(sp)
	subq	sp, 16, sp
	stq_a	p0, 0(sp)
	mtpr	zero, ips
.ENDM


.MACRO close_frame
#ifdef DBG_ERROR
	ldl_a	p0, 0(sp)
	ldiq	p1, 0x200000
	subq	p0, p1, p0
	bge	p0, 9f
	halt
9:
#endif	
	ldl_a	p1, 8(sp)
	ldq_a	p0, 0(sp)
	beq	p1, 9f
	mtpr	p1, ips

	addq	sp, 24, sp
	mtpr	sp, ptKSP
	ldq_a	sp, -8(sp)
	mtpr	p0, excAddr

	mtpr	p1, dtbCm	
	nop
	nop
	hw_rei_stall

	ALIGN_BRANCH
9:	mtpr	p0, excAddr
	addq	sp, 16, sp
	STALL
	hw_rei_stall
.ENDM

#ifndef USE_NOASN_REGS

/* 164 Switch to another context, if neccesary */
.MACRO switch_context tcb, tx
	xor	\tcb, sp, \tx
	srl	\tx, TID_S_TASK, \tx
	beq	\tx, 9f
		task_nr	\tcb, \tx
		pal_addr AT, pal_ptroots
		s8addq	\tx, AT, AT
		ldl_p	AT, 0(AT)
		sll	\tx, 4, \tx
		mtpr	\tx, itbAsn
		sll	\tx,57-4,\tx
		mtpr	\tx, dtbAsn
		nop
		mtpr	AT, ptPageBase
		nop
		nop
		nop
		nop
		nop
9:
.ENDM

#else

/* 164 Switch to another context, if neccesary */
.MACRO switch_context tcb, tx
	xor	\tcb, sp, \tx
	srl	\tx, TID_S_TASK, \tx
	nop
	beq	\tx, 9f
	task_nr	\tcb, \tx
	pal_addr AT, pal_ptroots
	s8addq	\tx, AT, AT
	ldl_p	AT, 0(AT)
	mtpr	zero, itbIap
	mtpr	zero, dtbIap
	nop
	nop
	nop
	nop
	nop
	mtpr	AT, ptPageBase
9:
.ENDM

#endif


/*--------------------------------
** Fast Thread Switch
** Do a necessary context switch BEFORE switch_thread() !
**
**	Store switch in Address
**	Current TCB	
**	pushed switch_in
**	Store Current KSP  
**	Load Stack Pointer of switch_to thread
**	Poped return address
**	Branch to address of target thread
**
*/

.MACRO  switch_dispatcher tcb_from, label	
	pal_addr AT, \label+1
        stq_a   sp, TCB_KSP (\tcb_from)
	stq_a	AT, TCB_RESTART (\tcb_from)
        /* SWITCH ! */
	tcb_dispatcher AT
        ldq_a   sp, TCB_KSP (AT)
        ldq_a   AT, TCB_RESTART(AT)
	mtpr zero, dtbCm; mtpr	zero, ips
	mtpr	AT, excAddr
	STALL; STALL
#ifdef DBG_ERROR
	br	AT, 9f
9:	
	stq_p	AT, 0x60(zero)
#endif
	
	hw_rei
.ENDM

.MACRO switch_thread_pal tcb_from, tcb_to, label
#ifdef DBG_ERROR
	xor	\tcb_from, \tcb_to, p6
	bne	p6, 9f
	sys_halt	0xee01
9:
	br	p6, 9f
9:	stq_p	p6, 0x60(zero)
#endif	
        ldq_a   AT, TCB_RESTART(\tcb_to)

#ifdef DBG_ERROR
	pal_addr p6, thread_error+1
	stq_a	p6, TCB_RESTART(\tcb_to)
#endif	
	
	pal_addr p6, \label+1
        ldq_a   p7, TCB_KSP (\tcb_to)
        stq_a   sp, TCB_KSP (\tcb_from)
	mov	p7, sp
	stq_a   p6, TCB_RESTART (\tcb_from)
        /* SWITCH ! */ 
	blbc	AT, 9f
	ret     zero, (AT)
	ALIGN_BRANCH
9:	mtpr	AT, excAddr
	mtpr	zero, dtbCm; mtpr zero, ips
	STALL; STALL
	hw_rei
.ENDM

.MACRO switch_thread_ipc tcb_from, tcb_to, label, hint
#ifdef DBG_ERROR
	xor	\tcb_from, \tcb_to, p6
	bne	p6, 9f
	sys_halt	0xee02
9:
	br	p6, 9f
9:	stq_p	p6, 0x60(zero)
	
#endif	
	
        ldq_a   AT, TCB_RESTART(\tcb_to)
#ifdef DBG_ERROR
	pal_addr p6, thread_error+1
	stq_a	p6, TCB_RESTART(\tcb_to)
#endif	
	
	pal_addr p6, \label+1
        ldq_a   p7, TCB_KSP (\tcb_to)
        stq_a   sp, TCB_KSP (\tcb_from)
	mov	p7, sp
	stq_a   p6, TCB_RESTART (\tcb_from)
        /* SWITCH ! */ 
	jmp	zero, (AT), \hint
.ENDM


/* switch to another thread from kernel to pal/kernel */
.MACRO switch_thread_kernel tcb_to, label
	ldiq	p5, TCB_MASK
	bic	sp, p5, p5
#ifdef DBG_ERROR
	xor	p5, \tcb_to, p6
	bne	p6, 9f
	sys_halt	0xee03
9:
	br	p6, 9f
9:	stq_p	p6, 0x60(zero)
	
#endif	
        ldq     AT , TCB_RESTART (\tcb_to)
#ifdef DBG_ERROR
	pal_addr p6, thread_error+1
	stq_a	p6, TCB_RESTART(\tcb_to)
#endif	
	
        ldq     p7, TCB_KSP (\tcb_to)
	lda	p6, \label
        stq     sp, TCB_KSP (p5)
        stq     p6, TCB_RESTART (p5)
        /* SWITCH ! */
	mov	p7, sp
	blbs	AT , 9f
        ret     zero, (AT)
	ALIGN_BRANCH
9:	pal	PAL_RETPAL_ENTRY
.ENDM

/* vu: lock and busy-waiting, until lock - flag is unset */
.MACRO lock BIT, tmp1=t0, tmp2=t1
9:      ldq_lp  \tmp1, L4_LOCK(zero)
        and     \tmp1, \BIT, \tmp2
        bne     \tmp2, 9b                // busy-waiting, until the bit is cleared             
        bis     \tmp1, \BIT, \tmp1
        stq_cp  \tmp1, L4_LOCK(zero)        
        beq     \tmp1, 9b                // error while locking
.ENDM

/* vu: unlock a set locking */
.MACRO unlock BIT, tmp=t0
9:      ldq_lp  \tmp, L4_LOCK(zero)
        bic     \tmp, \BIT, \tmp
        stq_cp  \tmp, L4_LOCK(zero)
	beq	\tmp, 9b
.ENDM 

/* vu: if the lockbit is set reg is not 0 */
.MACRO islocked BIT, reg 
        ldq_p   t0, L4_LOCK(zero)
        and     t0, \BIT, \reg
.ENDM

	/* danielp */
/* Warning:  does not update state bits */	
.MACRO insert_soon_wakeup_timeout tcb, timeout, tm1, tm2
	krn_addr \tm1, system_cb
	lda	\tm1, SCB_SOON_WAKEUP(\tm1)
	mov	\tm1, \tm2
1:	ldq_a	\tm2, 0(\tm2)
	cmpeq	\tm2, zero, AT
	bne	AT, 2f
	ldq_a	AT, -8(\tm2)
	cmplt	\timeout, AT, AT
	cmoveq	AT, \tm2, \tm1
	beq	AT, 1b
2:	lda	AT, TCB_WAKEUP_QUEUE(\tcb)
	stq_a	\tm2, 0(AT)
	stq_a	AT, 0(\tm1)
.ENDM	
	
/* MUST BE IN QUEUE!! */
/* Warning:  does not update state bits */	
.MACRO remove_soon_wakeup_timeout tcb, tm1, tm2, tm3
	krn_addr \tm1, system_cb
	lda	\tm2, SCB_SOON_WAKEUP(\tm1)
	lda	\tm3, TCB_WAKEUP_QUEUE(\tcb)
1:	ldq_a	\tm1, 0(\tm2)
	cmpeq	\tm1, \tm3, AT
	cmoveq	AT, \tm1, \tm2
	beq	AT, 1b
	ldq_a	AT, 0(\tm3)
	stq_a	AT, 0(\tm2)
.ENDM

#endif