/*
 * $Id: sys_ruffian.h,v 1.2 1999/04/17 07:45:52 danielp Exp $
 *
 * INT0 and INT22 ACK HANDLER for RUFFIAN
 */

    
#include <pal/pyxis.h>
#include <pal/platform.h>

#ifdef INT22_ACK_HANDLER
#error "INT22_ACK_HANDLER already defined!"
#else

/* lots to do here. We have to also add routines to redirect int0 to int22
 * or treat int0 as int22 on the UX 
 *
 * This is NOT really an int22 interrupt ack but it gets called in
 * this code as this is usually the place timer interrupts are handled.
 * We end up jumping to sys_int22_handler from sys_int21_handler when
 * we work out that we have recieved a timer interrupt (int0). The
 * code below should take care of it.
 *
 * The last bit is probably OverKill (tm)
 */

#define INT22_ACK_HANDLER(tmp0, tmp1)      \
        ldiq	tmp0, (1<<7)             ; \
	ldiq	tmp1, P_INT_BASE_B       ; \
	sll	tmp1, P_INT_BASE_S, tmp1 ; \
	stq_p	tmp0, PO_INT_REQ(tmp1)   ; \
	mb                               ; \
	ldq_p   tmp0, PO_INT_REQ(tmp1)   ; \
	OutPortByte(PIC1_OCW2,0x20,tmp0,tmp1) ; \
        ldiq	tmp0, (1<<7)             ; \
	ldiq	tmp1, P_INT_BASE_B       ; \
	sll	tmp1, P_INT_BASE_S, tmp1 ; \
	stq_p	tmp0, PO_INT_REQ(tmp1)   ; \
	mb                               ; \
	ldq_p   tmp0, PO_INT_REQ(tmp1)
	
#endif /* INT22_HANDLER for RUFFIAN */ 

#ifdef INT0_ACK_HANDLER
#error "INT0_ACK_HANDLER already defined!"
#else

/* The Ruffian gets timer interrupts on int0, we need to install a handler.
 */

#define INT0_ACK_HANDLER(tmp0)

/* NOTE we can test that the other init code works if we get a halt executed 
 * when int0 is thrown - without any handler.
 * Seeing that this code is quite complex, we could place it in platform.S
 * with #defines around it..
 */

#endif
