/*
**	Copyright (c) 1995, Sebastian Schoenberg 
**	E-mail : ss10@irz.inf.tu-dresden.de
**
**	University of Technology Dresden, Department of Computer Science
**	Inistute for Operating Systems, Databases and Computer Networks
**
**	$Id: l4pal.h,v 5.2 1999/11/09 00:46:13 danielp Exp $
**
**	DC 21164 Version
**
*/

#ifndef __L4PAL_H__
#define __L4PAL_H__


#include <pal/palcalls.h>

#ifndef __LANGUAGE_C__ 
/* Alpha Hardware Data */
#define PAGESIZE		8192
#define PAGEMASK                0x1fff
#define PAGEBITS		13


#define halt		        pal	PAL_HALT_ENTRY
#define debug			pal	UDBG_DEBUG

#define NOSTALL


#define PRIV_UNDEF(vector)				\
	. = (PAL_CALL_PAL_PRIV_ENTRY+(vector<<6));	\
privpal##vector:					\
	STALL; STALL; mfpr $0, excAddr;			\
	debug;

#define UNPRIV_UNDEF(vector)			\
	. = (PAL_CALL_PAL_UNPRIV_ENTRY+((vector&0x3F)<<6)); \
unprivpal##vector:				\
	ldiq	p0, IDT_INSTRUCTION;		\
	br	l4_do_exception


/* Physical addresses and offsets */
#define P_PALBASE		0x200000
#define P_PTBASE		0x208000
#define P_PTROOTS		0x20E000

#define P_SIGMA0BASE		0x220000

#define O_PALBASE		0x000000
#define O_PTBASE		0x008000
#define O_PTROOTS		0x00E000


// use with ldah rx, xxxx(zero) to get start address
#define MDB_KBASE		0xd000
#define TCB_KBASE		0xe000


/* Locking Bit and memory address
** in use with:
** ldq_lp	rx, L4_LOCK(zero)
** stq_cp 	rx, L4_LOCK(zero)
*/

#define L4_LOCK			0x40

#define LCK_MMT_FREELIST	0x01
#define LCK_bit1		0x02
#define LCK_bit2		0x04
#define LCK_bit3		0x08
#define LCK_bit4		0x10
#define LCK_bit5		0x20
#define LCK_bit6		0x40
#define LCK_bit7		0x80



/* Page Table Attributes */
#define PP_INTREE		(0x01 << 6)		/* 0x040 */
#define PP_WRITABLE		(0x02 << 6)		/* 0x080 */
#define PP_EXECUTABLE		(0x04 << 6)		/* 0x100 */ 
#define PP_KERNEL		(0x08 << 6)		/* 0x200 */
#define PP_READABLE             0

/* ***************************************************************** */
/* Basic L4 Definitions */
#define VER_TCB_INTEL		0x04
#define VER_TCB_ALPHA		0x14
#define VER_TCB_MIPS		0x24

#define SIZE_TCB		0x800
#define SIZE_SCB		(16*8)

#define MAX_TASKS		1024
#define MAX_THREADS		 256
#define MAX_PRIOS		 256
	
#define TCB_MASK		0x000007ff
#define TASK_MASK		0x0007ffff

#define TASK_KERNEL		0
#define TASK_SIGMA0		1



/*******************************************************************
** Interrupt Table
**
** Each thread may have an interrupt table that looks like this
**
*/
#define IDT_MEMORY		0x0000		/* Memory Management */
#define IDT_INSTRUCTION		0x0001		/* Instruction Fault */
#define IDT_ARITHMETIC		0x0002		/* Arithmetic Fault */
#define IDT_UNALIGNED		0x0003		/* Unaligned Access */


#define IRQ_ATTACH		0x80
#define IRQ_MASK		0x1f




/*******************************************************************
** System Control Block
**
**	All single linked list, required for 
**	scheduling starts at system_cb + ...  
**	offsets are matching (bit position * 8), i.e. x << 4 
**	
**
*/

/* L)inked L)ist S)tate, describe in which list the tcb is */
#define LLS_BUSY_QUEUE		0x01
#define LLS_INTERRUPTED_QUEUE   0x02
#define LLS_SOON_WAKEUP_QUEUE   0x04
#define LLS_LATE_WAKEUP_QUEUE   0x08
#define LLS_POLLING_QUEUE       0x10
#define LLS_POLLED_QUEUE        0x20

#define LLS_WAKEUPS_VALID	0x40

#define LLS_PRESENT_QUEUE	0x80

 
#define SCB_BUSY_QUEUE		0x0000
#define SCB_INTERRUPT_QUEUE	0x0008
#define SCB_SOON_WAKEUP		0x0010
#define SCB_LATE_WAKEUP         0x0018
#define SCB_POLLING            	0x0020
#define SCB_POLLED             	0x0028
#define SCB_SYSTEM_MEMORY	0x0030
#define SCB_free2		0x0038

#define SCB_MEM_MAP_TREE	0x0040
#define SCB_FREE_FRAME		0x0048

#define SCB_FREE_MAPPING	0x0050
#define SCB_FREE_MAPPING_AREA	0x0058



#define IMP_MEMMAPTREE		SCB_MEM_MAP_TREE



/*******************************************************************
** Thread ID for Alpha
**
**	 +-.-.-.-.-.-.-.-:-.-.-.-.-.-.-.-;-.-.-.-.-.-.-.-:-.-.-.-.-.-.-.-+
**	 :ver1 | task_no           | thread_no     | ver0                | + 00
**	 +-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-+
**	 |0| depth | chief_no          | site_no                       | : + 04
**	 +-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-+
*/

#define TID_S_VER0		0
#define TID_M_VER0		0x7ff
#define TID_B_VER0		11

#define TID_S_THREAD		11
#define TID_M_THREAD		0x0ff
#define TID_B_THREAD		8

#define TID_S_TASK		19
#define TID_M_TASK		0x3ff
#define TID_B_TASK		10

#define TID_S_VER1		29
#define TID_M_VER1		0x00f
#define TID_B_VER1		4

#define TID_S_SITE		33
#define TID_M_SITE		0x0ffff
#define TID_B_SITE		16

#define TID_S_CHIEF		49
#define TID_M_CHIEF		0x3ff
#define TID_B_CHIEF		10

#define TID_S_DEPTH		59
#define TID_M_DEPTH		0x0f
#define TID_B_DEPTH		4

#define TID_S_TASKTHREAD	11
#define TID_M_TASKTHREAD	0x3ffff
#define TID_B_TASKTHREAD	18


/* Control Prio */
#define MCP_LOW			0
#define MCP_NORMAL		127
#define MCP_HIGH		255

/* Schedule Prio */
#define SCP_LOW			0
#define SCP_NORMAL		127
#define SCP_HIGH		MAX_PRIO

#define MCP_DISPATCHER		MCP_HIGH
#define SCP_DISPATCHER		SCP_LOW

		
/*
Polled_queue is the partner, polling_queue is the sender */


/*
**  Thread state definitions, fine and coarse states state are 8 bit, 
**  so loadable via bis and comparable via cmpXXX r, state, rx !
*/


/*
** Fine thread states from Intel L4 
** load a state via			bis	zero, state, r
** or for better code scheduling	lda	r, state(zero)
** but states can be compared with	cmpxx	r, state, x
**	the NEG was removed.
** 
** Thread States are now changed
** Since the upper most bit in thread id is always zero, we can
** have much easier checks
** Thread state is
**	thread_id : waiting for (closed wait)
**	-1 : waiting for any (open wait)
**	one of the values below : running ...
** since these values are 'negativ' values (bit cleared means feature set)
** there are no problems and conflicts
**	bic	p0, TFS_RUNNING, p1
** Since the scheduler is not public (TASK 0.0) and its version number is greater 
** than 8. No valid thread gets a result of zero !
*/

#define TSB_BUSY		0x01
#define TSB_POLLING		0x02
#define TSB_LOCKED		0x04


/*      STATE                     TSB_LOCKED + TSB_POLLING + TSB_BUSY*/
/*-------------------------------------------------------------------*/
#define TFS_RUNNING               (TSB_LOCKED + TSB_POLLING           )
#define TFS_LOCKED_WAITING        (             TSB_POLLING + TSB_BUSY)
#define TFS_LOCKED_RUNNING        (             TSB_POLLING	      )
#define TFS_POLLING               (TSB_LOCKED +               TSB_BUSY)
#define TFS_ABORTED               (TSB_LOCKED + TSB_POLLING + TSB_BUSY)


/* Coarse state bits */
#define TCS_USED		0x01
#define TCS_BLOCKED		0x02
#define TCS_DEAD		0x04

/* TCB Structure definitions, offsets */
#define TCB_MYSELF		0x0000			/* Q: myself ID				*/
#define TCB_WAIT_FOR		0x0008			/* Q: Polling for ...  			*/
#define TCB_KSP			0x0010			/* Q: Kernel Stack			*/
#define TCB_RESTART		0x0018			/* Q Restart address			*/

#define TCB_COMM_ADDRESS	0x0020			/* Q: Partners mapping address		*/
#define TCB_THREAD_STATE	0x0028			/* Q: Thread State     			*/
#define TCB_COMM_PARTNER	0x0030			/* Q: Communication Partner		*/
#define TCB_LIST_STATE		0x0038			/* L: State of lists			*/
#define TCB_COARSE_STATE	0x003C			/* L: Coarse state			*/

#define TCB_TIMEOUT		0x0040			/* Q: When to wake up			*/
#define TCB_WAKEUP_QUEUE	0x0048			/* Q: Wakeup Queue			*/

#define TCB_BUSY_QUEUE		0x0050			/* QQ: Busy Queue			*/
#define TCB_BUSY_NEXT		0x0050
#define TCB_BUSY_PREV		0x0058

#define TCB_SEND_ROOT           0x0060                  /* QQ: Send Queue Root                  */
#define TCB_SEND_QUEUE		0x0070			/* QQ: Send Queue			*/

#define TCB_PAGER		0x0080		       	/* Q: Pager of this thread		*/
#define TCB_PREEMPTER		0x0088			/* Q: Preempter of this thread		*/

#define TCB_SCHED_PARAM		0x0090			/* L: Schedule param			*/
#define TCB_SCHED_SCP		0x0090			/* L: Schedule low			*/
#define TCB_SCHED_MCP		0x0094			/* L: Maximum Controlled Prio		*/
#define TCB_SCHED_ACCOUNT      	0x0098			/* Q: Accounting Information		*/ 

#define TCB_PRESENT_QUEUE	0x00A0			/* QQ: Present Queue Next + Prev	*/
#define TCB_IDT			0x00B0			/* Q: Interrupt Table			*/
#define TCB_INTERRUPT_MASK     	0x00B8

#define TCB_MDB_ACCOUNT		0x00C0			/* Q: Thread 0 used for accounting	*/

// I hope the space here is actually free (it appears to be)
// These next two are used for delete. These values are only of any use in Thread 0

#define TCB_CHILD_TASK		0x00C8			/* Q: Thread 0, first child task	*/
#define TCB_SISTER_TASK		0x00D0			/* QQ: Thr 0, next + prev task in clan	*/
#define TCB_THREAD_NEXT		0x00E0			/* Q: what the present queue should be	*/

#define TCB_IDENT		0x0100			/* L: ident TCB				*/

#define TCB_STACKTOP		(SIZE_TCB-4*8)

/* IPC, each thread of a task has it's own copy area for temp mapping */
/* only for info */
#define IPC_MAPPING_AREA	0xffffffff10000000

#define IPC_TIMEOUT_NEVER	0

#define MSG_O_FLEXPAGE		0x00
#define MSG_O_STRUCT_DOPE	0x08
#define MSG_O_SEND_DOPE		0x10
#define MSG_O_MWORDS		0x18

#define MVS_M_DECEIT		0x01
#define MVS_M_FLEXPAGE		0x02

#define MVR_M_OPENCLOSE		0x01
#define MVR_M_FLEXPAGE		0x02

#define MVR_CLOSEDWAIT		0x00
#define MVR_OPENWAIT		0x01
#define MVR_FLEXPAGE		0x02
#define MVS_DECEIT		0x01
#define MVS_FLEXPAGE		0x02


#define MD_S_RESULT		0
#define MD_M_RESULT	       	0xff
#define MD_B_RESULT		8

#define MD_S_STRINGS		8
#define MD_M_STRINGS		0x3f
#define MD_B_STRINGS		6

#define MD_S_MWORDS		14	
#define MD_M_MWORDS		0x3ffff	
#define MD_B_MWORDS		18

#define MSG_DOPE(mwords, strings)	\
	((strings & MD_M_STRINGS) << MD_S_STRINGS) | ((mwords & MD_M_MWORDS) << MD_S_MWORDS)

/* dope
**
**	 +-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-+
**	 |             mwords                |  strings  |    (error)    |
**	 +-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-+
**
** 
*/




/* IPC Results, can be loaded via bis */

#define IPC_SUCCESS             zero			// zero register is = 0.
#define IPC_NOTEXIST		0x10

#define IPC_R_TIMEOUT		0x20			// Timeout
#define IPC_S_TIMEOUT		0x30

#define IPC_R_CANCELLED		0x40			// Cancelled before started
#define IPC_S_CANCELLED		0x50

#define IPC_R_MAP_FAILED	0x60			// Mapping failed
#define IPC_S_MAP_FAILED	0x70

#define IPC_R_SPF_TIMEOUT	0x80			// Send Pagefault TO
#define IPC_S_SPF_TIMEOUT	0x90
#define IPC_R_RPF_TIMEOUT	0xA0			// Receive Pagefault TO
#define IPC_S_RPF_TIMEOUT	0xB0

#define IPC_R_ABORTED		0xC0			// Aborted while transfer
#define IPC_S_ABORTED		0xD0

#define IPC_R_CUT		0xE0			// String buffer cut
#define IPC_S_CUT		0xF0


/* result types */
#define L4_NC_SAME_CLAN		0x00	/* destination resides within the */
					/* same clan */
#define L4_NC_INNER_CLAN	0x0C	/* destination is in an inner clan */
#define L4_NC_OUTER_CLAN	0x04	/* destination is outside the */
					/* invoker's clan */

#define L4_IPC_ERROR_MASK 	0xF0
#define L4_IPC_DECEIT_MASK	0x01
#define L4_IPC_FPAGE_MASK	0x02
#define L4_IPC_REDIRECT_MASK	0x04
#define L4_IPC_SRC_MASK		0x08
#define L4_IPC_SND_ERR_MASK	0x10



#define MTE_FREE	0x0000
#define MTE_ROOT	0x0004

#define MDB_M_BACK	0x01
#define MDB_M_VALID	0x02
#define MDB_M_EMPTY	0x04

/* offset for mapping-entries */
#define MDB_O_NEXT                 0
#define MDB_O_PREV                 4
#define MDB_O_CHILD               24
#define MDB_O_VADDR                8
#define MDB_O_TASKID              14
#define MDB_O_PREVINTASK          16
#define MDB_O_NEXTINTASK          20
#define MDB_O_LOCKING_THREAD      28
#define MDB_O_LOCKING_SEMAPHORE   28


#define ptPageBase		pt0				/* Page Base of AS		*/
#define ptPrevPal		pt1                             /* Previous PAL Base		*/
#define ptKSP			pt2
#define ptUSP			pt3
#define ptCurrentTime		pt4
#define ptCurrentTicks		pt5

#define tr0			pt8
#define tr1			pt9
#define tr2			pt10
#define tr3			pt11
#define tr4			pt12
#define tr5			pt13
#define tr6			pt14
#define tr7			pt15


#define tb0			pt16
#define tb1			pt17
#define tb2			pt18
#define tb3			pt19
#define tb4			pt20
#define tb5			pt21
#define tb6			pt22
#define tb7			pt23


#define PTE_V_ASM		4
#define PTE_M_ASM		(1 << PTE_V_ASM)		

#endif

#endif




















































