#ifndef __PALCALLS_H
#define __PALCALLS_H

/* $id$ */

/* Privileged and Unprivileged Entry points */
#define PAL_HALT_ENTRY		0x0000			/* Halt, enter console */
#define PAL_RETPAL_ENTRY       	0x0001			/* return from kernel mode */
#define	PAL_RETURN_ENTRY	0x0002			/* return to previous mode */

#define L4_IMB_ENTRY		0x0086			/* REQ: IMB */

#define L4_IPC_ENTRY		0x00B0
#define L4_FP_UNMAP_ENTRY       0x00B1
#define L4_ID_MYSELF_ENTRY	0x00B2
#define L4_SWITCH_ENTRY		0x00B3
#define L4_SCHEDULE_ENTRY	0x00B4
#define L4_LTHREAD_EX_REGS	0x00B5
#define L4_TASK_NEW_ENTRY	0x00B6

#define L4_CONFIG_ENTRY		0x00B7
# define CNF_SETIDT		0x0000

#define L4_RETURN_ENTRY		0x00B8


#define UDBG_PRINT_HEX		0x00BA
#define UDBG_PRINT_STR		0x00BB
#define UDBG_PRINT_CHAR		0x00BC
#define UDBG_GET_CHAR		0x00BD
#define UDBG_SYSHALT		0x00BE
#define UDBG_DEBUG		0x00BF

#define KDBG_PRINT_HEX		0x0010
#define KDBG_PRINT_STR		0x0011
#define KDBG_PRINT_CHAR		0x0012
#define KDBG_GET_CHAR		0x0013
#define KDBG_PRINT_DTB		0x0014
#define KDBG_PRINT_ITB		0x0015


#endif // __PALCALLS_H
