/* 
 * $Id $
 *
 * Defines useful assert() function that can be used to invoke the debugger.
 */

#include <l4/types.h>
#include <l4/assert.h>
#include <l4/kdebug.h>

#include <stdio.h>

void __assert(const char *msg, const char *file, int line) {
    /* We print out everything on one line, in hex numbers */
    char buf[65];
    int n;
    print_string("Asserting..\n\r");
//    print_hex(strlen(msg),32);
//    print_hex(strlen(file),32);
    n = sprintf(buf, "ASSERT: %s, %s:0x%x\n\r\0", msg, file, line);
//    print_hex(n,32);
    print_string(buf);
    
    enter_kdebug();
}
