#include <regdef.h>
#include <pal/palcalls.h>

	.text

	.globl	l4dbg_write_string
	.globl	l4dbg_debug
	.globl	l4dbg_print_hex
	.globl	l4dbg_print_char

	.set noreorder

#define pal	.long
	

#define save\
	subq	sp, 0x50, sp;\
	stq	gp, 0x00(sp);\
	stq	pv, 0x08(sp);\
	stq	ra, 0x10(sp);\
	stq	s0, 0x18(sp);\
	stq	s1, 0x20(sp);\
	stq	s2, 0x28(sp);\
	stq	s3, 0x30(sp);\
	stq	s4, 0x38(sp);\
	stq	s5, 0x40(sp);\
	stq	s6, 0x48(sp);	

#define load\
	ldq	gp, 0x00(sp);\
	ldq	pv, 0x08(sp);\
	ldq	ra, 0x10(sp);\
	ldq	s0, 0x18(sp);\
	ldq	s1, 0x20(sp);\
	ldq	s2, 0x28(sp);\
	ldq	s3, 0x30(sp);\
	ldq	s4, 0x38(sp);\
	ldq	s5, 0x40(sp);\
	ldq	s6, 0x48(sp);\
	addq	sp, 0x50, sp;

	

	.text

l4dbg_write_string:
	save
	pal	UDBG_PRINT_STR
	load
	ret	(ra)
	
	

l4dbg_debug:
	pal	UDBG_DEBUG
	ret	(ra)


l4dbg_print_hex:
	save
	pal	UDBG_PRINT_HEX
	load
	ret	(ra)

l4dbg_print_char:
	save
	pal	UDBG_PRINT_CHAR
	load
	ret	(ra)
	