/*
** IO Functions for Alpha
*/


#define __mb__ __asm__ ("mb;mb");

void outb (const int port, const int value)
{
  volatile int *pw = (int *)(0x00008580000000 + (port << 5));  
  register int w = (value & 0xff) << (8 * (port & 0x03));
  __mb__
  *pw = w;
  __mb__
}

int inb (const int port)
{
  volatile int *pw = (int *)(0x00008580000000 + (port << 5));  
  int res;

  __mb__;
  res = (*pw >> (port & 0x03)) & 0xff;
  __mb__;
}


void pokeb (void *addr, char data)
{
  volatile char *add = (0x0000008000000000 + ((0xb8000 << 5) + (0x01 << 3)));

  __mb__;
  *add = data;
  __mb__;
}

char pokeb (void *addr)
{
  volatile char *add = (0x0000008000000000 + ((0xb8000 << 5) + (0x01 << 3)));
  char res;

  __mb__;
  res = *add;
  __mb__;
  return res;
}






