#include <regdef.h>
#include <pal/palcalls.h>

	.text

	.globl	l4_alpha_ipc_call
	.globl	l4_alpha_ipc_send
	.globl	l4_alpha_ipc_wait
	.globl	l4_alpha_ipc_receive
	.globl	l4_alpha_ipc_reply_and_wait

	.globl	l4_alpha_ipc_send_deceiting
	.globl  l4_alpha_ipc_reply_deceiting_and_wait

	.globl  l4_alpha_ipc_chief_send
	.globl	l4_alpha_ipc_chief_wait
	.globl	l4_alpha_ipc_chief_receive
	.globl	l4_alpha_ipc_chief_call
	.globl	l4_alpha_ipc_chief_reply_and_wait

	.set noreorder


#define pal	.long
		

#define save\
	subq	sp, 0x50, sp;\
	stq	gp, 0x00(sp);\
	stq	pv, 0x08(sp);\
	stq	ra, 0x10(sp);\
	stq	s0, 0x18(sp);\
	stq	s1, 0x20(sp);\
	stq	s2, 0x28(sp);\
	stq	s3, 0x30(sp);\
	stq	s4, 0x38(sp);\
	stq	s5, 0x40(sp);\
	stq	s6, 0x48(sp);	

#define load\
	ldq	gp, 0x00(sp);\
	ldq	pv, 0x08(sp);\
	ldq	ra, 0x10(sp);\
	ldq	s0, 0x18(sp);\
	ldq	s1, 0x20(sp);\
	ldq	s2, 0x28(sp);\
	ldq	s3, 0x30(sp);\
	ldq	s4, 0x38(sp);\
	ldq	s5, 0x40(sp);\
	ldq	s6, 0x48(sp);\
	addq	sp, 0x50, sp;

	
/*  PAL IPC interface uses these registers:	
**      a0      - receiver id
**
**      a1      - snd_msg_vect
**
**      a2      - rec_msg_vect
**
**      a3      - msg_timeout = (receive = 63..32 | send = 31..00)
**
**	a4	- virtual sender id
**
**	a5	- return message dope		
**
**      t0..t6,t8  - msg0 .. msg7
*/

/*	
int
l4_alpha_ipc_call(l4_threadid_t dest, 
		  const void *snd_msg,
		  const l4_ipcregs_t *snd_regs,
		  void *rcv_msg, 
		  l4_ipcregs_t *rcv_regs,
		  l4_timeout_t timeout
		  l4_msgdope_t *result);
*/
	
l4_alpha_ipc_call:
	save
		
	beq	a2, 1f
	ldq	t0, 0x00(a2)
	ldq	t1, 0x08(a2)
	ldq	t2, 0x10(a2)
	ldq	t3, 0x18(a2)
	ldq	t4, 0x20(a2)
	ldq	t5, 0x28(a2)
	ldq	t6, 0x30(a2)
	ldq	t8, 0x38(a2)
1:

	subq	sp, 8, sp
	stq	a4, 0(sp)
	
	mov	a3, a2
	mov	a5, a3
	mov	a0, a5
	mov	zero, a4
	bic	a2, 1, a2
	
	pal	L4_IPC_ENTRY

	ldq	a4, 0(sp)
	addq	sp, 8, sp

	ldq	fp, 0x50(sp)
	stq	v0, 0(fp)

	beq	a4, 1f
	stq	t0, 0x00(a4)
	stq	t1, 0x08(a4)
	stq	t2, 0x10(a4)
	stq	t3, 0x18(a4)
	stq	t4, 0x20(a4)
	stq	t5, 0x28(a4)
	stq	t6, 0x30(a4)
	stq	t8, 0x38(a4)
1:		
	load
	
	ret	(ra)


	
/*
int
l4_alpha_ipc_reply_and_wait(l4_threadid_t dest, 
			    const void *snd_msg, 
			    const l4_ipcregs_t *snd_regs,
			    l4_threadid_t *src,
			    void *rcv_msg, 
			    l4_ipcregs_t *rcv_regs,
			    l4_timeout_t timeout
			    l4_msgdope_t *result);
*/
l4_alpha_ipc_reply_and_wait:
	save
	lda	fp, 0x50(sp)
	
	beq	a2, 1f
	ldq	t0, 0x00(a2)
	ldq	t1, 0x08(a2)
	ldq	t2, 0x10(a2)
	ldq	t3, 0x18(a2)
	ldq	t4, 0x20(a2)
	ldq	t5, 0x28(a2)
	ldq	t6, 0x30(a2)
	ldq	t8, 0x38(a2)
1:

	subq	sp, 16, sp
	stq	a5, 0(sp)	// rcv_regs
	stq	a3, 8(sp)	// *src

	mov	a4, a2		// rcv_msg
	clr	a4
	mov	a0, a5
	
	ldq	a3, 0(fp)	// timeout
	or	a2, 1, a2

	pal	L4_IPC_ENTRY

	cmovne  a4, a4, pv 	// deceited?
	
	ldq	a5, 0(sp)	
	ldq	a3, 8(sp)
	addq	sp, 16, sp

	stq	pv, 0(a3)

	ldq	fp, 0x58(sp)		
	stq	v0, 0(fp)
		
	beq	a5, 1f
	stq	t0, 0x00(a5)
	stq	t1, 0x08(a5)
	stq	t2, 0x10(a5)
	stq	t3, 0x18(a5)
	stq	t4, 0x20(a5)
	stq	t5, 0x28(a5)
	stq	t6, 0x30(a5)
	stq	t8, 0x38(a5)
1:		
	load
	
	ret	(ra)

/*		
l4_msgdope_t
l4_i386_ipc_reply_deceiting_and_wait(const l4_ipc_deceit_ids_t ids,
				     const void *snd_msg, 
				     dword_t snd_dword0, dword_t snd_dword1,
				     l4_threadid_t *src,
				     void *rcv_msg, 
				     dword_t *rcv_dword0, dword_t *rcv_dword1, 
				     l4_timeout_t timeout, 
				     l4_msgdope_t *result);
*/

	
/* 
l4_msgdope_t 
l4_alpha_ipc_reply_deceiting_and_wait(l4_threadid_t dest, 
	       			      l4_threadid_t vsend,
				      const void *snd_msg,
				      l4_ipcregs_t *snd_reg,
				      l4_threadid_t *src,
				      void *rcv_msg,
				      l4_ipcregs_t *rcv_reg,
				      l4_timeout_t timeout,
				      l4_msgdope_t *result); 
*/
	
l4_alpha_ipc_reply_deceiting_and_wait:
	save
	
	beq	a3, 1f
	ldq	t0, 0x00(a3)
	ldq	t1, 0x08(a3)
	ldq	t2, 0x10(a3)
	ldq	t3, 0x18(a3)
	ldq	t4, 0x20(a3)
	ldq	t5, 0x28(a3)
	ldq	t6, 0x30(a3)
	ldq	t8, 0x38(a3)
1:

	ldq	a3, 0x58(sp)	// timeout

	subq	sp, 8, sp
	stq	a4, 0(sp)	// *src

	mov	a1, a4		// vsend to a4
	mov	a2, a1		// smd_msg to a1
	mov	a5, a2		// rcv_msg to a2
	mov	a0, a5
	
	or	a2, 1, a2

	pal	L4_IPC_ENTRY

	cmovne  a4, a4, pv 	// deceited?
	
	ldq	a4, 0(sp)	// src
	addq	sp, 8, sp

	ldq	a3, 0x50(sp)	// rcv_regs, a3 is our scratch

	stq	pv, 0(a4)

	ldq	fp, 0x60(sp)		
	stq	v0, 0(fp)
		
	beq	a3, 1f
	stq	t0, 0x00(a3)
	stq	t1, 0x08(a3)
	stq	t2, 0x10(a3)
	stq	t3, 0x18(a3)
	stq	t4, 0x20(a3)
	stq	t5, 0x28(a3)
	stq	t6, 0x30(a3)
	stq	t8, 0x38(a3)
1:		
	load
	
	ret	(ra)


/*
l4_msgdope_t
l4_alpha_ipc_send_deceiting(l4_threadid_t dest, 
	       		    l4_threadid_t vsend,
			    const void *snd_msg,
			    l4_ipcregs_t *snd_reg,
			    l4_timeout_t timeout,
			    l4_msgdope_t *result); 
AND
	
int
l4_alpha_ipc_chief_send(l4_threadid_t dest,
 		       l4_threadid_t vsend,
 		       const void *snd_msg,
 		       l4_ipc_reg_msg_t *snd_reg,
 		       l4_timeout_t timeout,
 		       l4_msgdope_t *result);
*/
l4_alpha_ipc_send_deceiting:
l4_alpha_ipc_chief_send:
	save
	
	beq	a3, 1f
	ldq	t0, 0x00(a3)
	ldq	t1, 0x08(a3)
	ldq	t2, 0x10(a3)
	ldq	t3, 0x18(a3)
	ldq	t4, 0x20(a3)
	ldq	t5, 0x28(a3)
	ldq	t6, 0x30(a3)
	ldq	t8, 0x38(a3)
1:

	subq	sp, 8, sp
	stq	a5, 0(sp)
	
	mov	a4, a3
	mov 	a1, a4
	mov 	a2, a1
	mov	a0, a5
	
	subq	zero,1,a2
	bis	zero,1,a1		// BUG HERE??
	
	pal	L4_IPC_ENTRY
	
	ldq	a4, 0(sp)
	addq	sp, 8, sp

	stq	v0, 0(a4)
	
	load
	ret	(ra)
	

	
		
/*	
int
l4_alpha_ipc_send(l4_threadid_t dest, 
		  const void *snd_msg,
		  const l4_ipcregs_t *snd_regs,
		  l4_timeout_t timeout,
		  l4_msgdope_t *result); 
*/
l4_alpha_ipc_send:
	save
	
	beq	a2, 1f
	ldq	t0, 0x00(a2)
	ldq	t1, 0x08(a2)
	ldq	t2, 0x10(a2)
	ldq	t3, 0x18(a2)
	ldq	t4, 0x20(a2)
	ldq	t5, 0x28(a2)
	ldq	t6, 0x30(a2)
	ldq	t8, 0x38(a2)
1:

	subq	sp, 8, sp
	stq	a4, 0(sp)
	
        mov	a0, a5
	clr	a4
	
	subq	zero,1,a2

	pal	L4_IPC_ENTRY

	ldq	a4, 0(sp)
	addq	sp, 8, sp
	stq	v0, 0(a4)
	
	load
	ret	(ra)
	
/*
l4_msgdope_t
l4_alpha_ipc_wait(l4_threadid_t *src,
		  void *rcv_msg,
		  l4_ipcregs_t *rcv_regs,
		  l4_timeout_t timeout,
		  l4_msgdope_t *result); 
*/

l4_alpha_ipc_wait:
	save
	
	subq	sp, 24, sp
	stq	a2, 0(sp)
	stq	a0, 8(sp)
	stq	a4, 16(sp)

	clr	a4
	clr	a5
	
	or	a1, 1, a2	/* open rcv_msg */
	subq	zero, 1, a1	/* snd_msg */

	pal	L4_IPC_ENTRY

	cmovne  a4, a4, pv 	// deceited?
	
	ldq	a2, 0(sp)
	ldq	a0, 8(sp)
	ldq	a4, 16(sp)

	addq	sp, 24, sp
	
	stq	pv, 0(a0)
	stq	v0, 0(a4)
	
	beq	a2, 1f
	stq	t0, 0x00(a2)
	stq	t1, 0x08(a2)
	stq	t2, 0x10(a2)
	stq	t3, 0x18(a2)
	stq	t4, 0x20(a2)
	stq	t5, 0x28(a2)
	stq	t6, 0x30(a2)
	stq	t8, 0x38(a2)
	
1:
	load
	ret	(ra)

	

/*
int
l4_alpha_ipc_receive(l4_threadid_t src,
		     void *rcv_msg,
		     l4_ipcregs_t *rcv_regs,
		     l4_timeout_t timeout,
		     l4_msgdope_t *result);
*/

l4_alpha_ipc_receive:
	save
	
	subq	sp, 16, sp
	stq	a2, 0(sp)
	stq	a4, 8(sp)

	clr	a4
	clr	a5
	
	or	a1, 0, a2	/* closed rcv_msg */
	subq	zero, 1, a1	/* snd_msg */

	pal	L4_IPC_ENTRY
	
	ldq	a2, 0(sp)
	ldq	a4, 8(sp)
	
	addq	sp, 16, sp

	stq	v0, 0(a4)
	
	beq	a2, 1f
	stq	t0, 0x00(a2)
	stq	t1, 0x08(a2)
	stq	t2, 0x10(a2)
	stq	t3, 0x18(a2)
	stq	t4, 0x20(a2)
	stq	t5, 0x28(a2)
	stq	t6, 0x30(a2)
	stq	t8, 0x38(a2)
1:
	load
	ret	(ra)


/* FIXME:	
int
l4_mips_ipc_chief_wait(l4_threadid_t *src,
		       l4_threadid_t *real_dst,
 		       void *rcv_msg,
 		       l4_ipc_reg_msg_t *rcv_reg,
 		       l4_timeout_t timeout,
 		       l4_msgdope_t *result);
*/
l4_alpha_ipc_chief_wait:
	save
	
	subq	sp, 32, sp
	stq	a0, 0(sp)
	stq	a1, 8(sp)
	stq	a3, 16(sp)
	stq	a5, 24(sp)

	mov	a4, a3
	
	clr	a4
	clr	a5
	
	or	a2, 1, a2	/* open rcv_msg */
	subq	zero, 1, a1	/* snd_msg */

	pal	L4_IPC_ENTRY

	cmovne  a4, a4, pv 	// deceited?
	
	ldq	a0, 0(sp)
	ldq	a1, 8(sp)
	ldq	a3, 16(sp)
	stq	a5, 0(a1)	// write orig_sender
	ldq	a5, 24(sp)
	addq	sp, 32, sp
	
	stq	pv, 0(a0)
	stq	v0, 0(a5)
	
	beq	a3, 1f
	stq	t0, 0x00(a3)
	stq	t1, 0x08(a3)
	stq	t2, 0x10(a3)
	stq	t3, 0x18(a3)
	stq	t4, 0x20(a3)
	stq	t5, 0x28(a3)
	stq	t6, 0x30(a3)
	stq	t8, 0x38(a3)
	
1:
	load
	ret	(ra)

		
		
/* FIXME:
int
l4_alpha_ipc_chief_receive(l4_threadid_t src,
 			  l4_threadid_t *real_dst,
 			  void *rcv_msg,
 			  l4_ipc_reg_msg_t *rcv_reg,
 			  l4_timeout_t timeout,
 			  l4_msgdope_t *result);
*/	

l4_alpha_ipc_chief_receive:
	save
	
	subq	sp, 24, sp
	stq	a1, 0(sp)
	stq	a3, 8(sp)
	stq	a5, 16(sp)

	mov	a4, a3
	
	clr	a4
	clr	a5
	
	or	a2, 0, a2	/* closed rcv_msg */
	subq	zero, 1, a1	/* snd_msg */

	pal	L4_IPC_ENTRY

	ldq	a1, 0(sp)	
	ldq	a3, 8(sp)
	stq	a5, 0(a1)
	ldq	a5, 16(sp)
	
	addq	sp, 24, sp

	//bis	a5, v0, a5
	//stq	a5, 0(a4)
	stq	v0, 0(a5)
		
	beq	a3, 1f
	stq	t0, 0x00(a3)
	stq	t1, 0x08(a3)
	stq	t2, 0x10(a3)
	stq	t3, 0x18(a3)
	stq	t4, 0x20(a3)
	stq	t5, 0x28(a3)
	stq	t6, 0x30(a3)
	stq	t8, 0x38(a3)
1:
	load
	ret	(ra)

	
/* FIXME:
int
l4_alpha_ipc_chief_call(l4_threadid_t dest,
 		       l4_threadid_t vsend,
 		       const void *snd_msg,
 		       l4_ipc_reg_msg_t *snd_reg,
 		       l4_threadid_t *real_dst,
 		       void *rcv_msg,
 		       l4_ipc_reg_msg_t *rcv_reg,
 		       l4_timeout_t timeout,
 		       l4_msgdope_t *result);
*/		

l4_alpha_ipc_chief_call:
	save
		
	beq	a3, 1f
	ldq	t0, 0x00(a3)
	ldq	t1, 0x08(a3)
	ldq	t2, 0x10(a3)
	ldq	t3, 0x18(a3)
	ldq	t4, 0x20(a3)
	ldq	t5, 0x28(a3)
	ldq	t6, 0x30(a3)
	ldq	t8, 0x38(a3)
1:

	ldq	a3, 0x58(sp)	// load timeout
	
	subq	sp, 8, sp
	stq	a4, 0(sp)	// real_dst

	mov	a1, a4
	mov	a2, a1
	mov	a5, a2
	mov	a0, a5
	bic	a2, 1, a2

	pal	L4_IPC_ENTRY

	ldq	a4, 0(sp)
	addq	sp, 8, sp

	stq	a5, 0(a4)	// check for NULL?

	ldq	a5, 0x50(sp)
	ldq	fp, 0x60(sp)
	stq	v0, 0(fp)
	
	beq	a5, 1f
	stq	t0, 0x00(a5)
	stq	t1, 0x08(a5)
	stq	t2, 0x10(a5)
	stq	t3, 0x18(a5)
	stq	t4, 0x20(a5)
	stq	t5, 0x28(a5)
	stq	t6, 0x30(a5)
	stq	t8, 0x38(a5)
1:		
	load
	
	ret	(ra)


	
/*
int
l4_alpha_ipc_chief_reply_and_wait(l4_threadid_t dest,
 				 l4_threadid_t vsend,
 				 const void *snd_msg,
 				 l4_ipc_reg_msg_t *snd_reg,
 				 l4_threadid_t *src,
 				 l4_threadid_t *real_dst,

 				 void *rcv_msg,
 				 l4_ipc_reg_msg_t *rcv_reg,
 				 l4_timeout_t timeout,
 				 l4_msgdope_t *result);
*/
	
l4_alpha_ipc_chief_reply_and_wait:
	save
	lda	fp, 0x50(sp)
		
	beq	a3, 1f
	ldq	t0, 0x00(a3)
	ldq	t1, 0x08(a3)
	ldq	t2, 0x10(a3)
	ldq	t3, 0x18(a3)
	ldq	t4, 0x20(a3)
	ldq	t5, 0x28(a3)
	ldq	t6, 0x30(a3)
	ldq	t8, 0x38(a3)
1:

	subq	sp, 16, sp
	stq	a4, 0(sp)	// *src
	stq	a5, 8(sp)
	
	mov	a1, a4		// vsend to a4
	mov	a2, a1		// smd_msg to a1
	mov	a0, a5		// orig_dest
	ldq	a2, 0(fp)	// rcv_msg to a2	
	ldq	a3, 0x10(fp)	// timeout
	
	or	a2, 1, a2

	pal	L4_IPC_ENTRY

	cmovne  a4, a4, pv 	// deceited?
	
	ldq	a4, 0(sp)	// src
	ldq	a1, 8(sp)	// orig_dest
	addq	sp, 16, sp

	ldq	a3, 0x58(sp)	// rcv_regs, a3 is our scratch

	stq	pv, 0(a4)
	stq	a5, 0(a1)

	ldq	fp, 0x68(sp)	// msgdope
	stq	v0, 0(fp)
		
	beq	a3, 1f
	stq	t0, 0x00(a3)
	stq	t1, 0x08(a3)
	stq	t2, 0x10(a3)
	stq	t3, 0x18(a3)
	stq	t4, 0x20(a3)
	stq	t5, 0x28(a3)
	stq	t6, 0x30(a3)
	stq	t8, 0x38(a3)
1:		
	load
	
	ret	(ra)

/* l4_alpha_ipc_chief_send() implemented above */