/* printf.c
 * Daniel Potts 990811
 *
 * A very simple printf with real checking done. Write your own.
 */

#include <l4/types.h>
#include <l4/syscalls.h>
#include <l4/ipc.h>

#include <string.h>
#include <stdarg.h>

//#include <printf.h>
#include <stdio.h>

#include <l4/kdebug.h>

static const l4_threadid_t SERIAL_TID = {0x0802000000100001};

#define BUF_SIZE 64

//static struct {
//  qword_t buf[BUF_SIZE];
//} Printbuf;

int printf(const char *fmt, ...) {
  va_list      ap;
  int          len;
  l4_ipc_reg_msg_t pmsg;
  qword_t pad;
  l4_msgdope_t result;

  va_start (ap, fmt);
  len = vsprintf ((char*)&pmsg, fmt, ap);
  va_end (ap);

  if(len >64) print_string("printf: violation\n\r");

  if((len>0) && ((char *)&pmsg)[len-1] == '\n') {
      ((char*)&pmsg)[len++] = '\r';
      ((char*)&pmsg)[len++] = 0;
  }

  if(len >64) print_string("printf: violation\n\r");

  l4_alpha_ipc_send(SERIAL_TID, NULL, &pmsg, L4_IPC_NEVER, &result);

  return len;

}
