#include <regdef.h>
#include <pal/palcalls.h>
#include <pal/l4pal.h>
	
	.text

	.globl	l4_fpage_unmap
	.globl	l4_myself
	.globl	l4_nchief
	.globl	l4_id_nearest
	.globl	l4_thread_ex_regs
	.globl	l4_task_new
	.globl	l4_thread_switch

	.globl	l4_schedule
	
	.set noreorder

#define pal	.long
	

#define save\
	subq	sp, 0x50, sp;\
	stq	gp, 0x00(sp);\
	stq	pv, 0x08(sp);\
	stq	ra, 0x10(sp);\
	stq	s0, 0x18(sp);\
	stq	s1, 0x20(sp);\
	stq	s2, 0x28(sp);\
	stq	s3, 0x30(sp);\
	stq	s4, 0x38(sp);\
	stq	s5, 0x40(sp);\
	stq	s6, 0x48(sp);	

#define load\
	ldq	gp, 0x00(sp);\
	ldq	pv, 0x08(sp);\
	ldq	ra, 0x10(sp);\
	ldq	s0, 0x18(sp);\
	ldq	s1, 0x20(sp);\
	ldq	s2, 0x28(sp);\
	ldq	s3, 0x30(sp);\
	ldq	s4, 0x38(sp);\
	ldq	s5, 0x40(sp);\
	ldq	s6, 0x48(sp);\
	addq	sp, 0x50, sp;

	

	.text

l4_fpage_unmap:
	save
	pal	L4_FP_UNMAP_ENTRY
	load
	ret	(ra)
	
l4_myself:
	save
	subq	zero, 1, a0
	pal	L4_ID_MYSELF_ENTRY
	load
	ret	(ra)
	
l4_nchief:
	save
	subq	sp, 8, sp
	stq	a1, 0(sp)
	pal	L4_ID_MYSELF_ENTRY
	ldq	a1, 0(sp)
	addq	sp, 8, sp
	beq	a1, 1f
	stq	a0, 0(a1)		// a0 is where result is..
1:	
	load
	ret	(ra)


l4_id_nearest:
	save
	clr	a5
	subq	sp, 8, sp
	stq	a1, 0(sp)
	pal	L4_ID_MYSELF_ENTRY
	ldq	a1, 0(sp)
	addq	sp, 8, sp
	beq	a1, 1f
	stq	a0, 0(a1)	// a0 is where result id is

1:	
	load
	ret	(ra)


		
/*
**	a0	- lthread no
**	a1	- preempter
**	a2	- pager
**	a3	- pc
**	a4	- sp

L4_INLINE void
l4_thread_ex_regs(qword_t destination, qword_t pc, qword_t sp,
		  l4_threadid_t *preempter, l4_threadid_t *pager,
		  qword_t *old_pc, 
			qword_t *old_sp);
	
*/

	
	
l4_thread_ex_regs:
	save

	ldq	t1, 0x50 (sp)		
	subq	sp, 32, sp
	
	stq	a3, 0(sp)	/* prrempter */
	stq	a4, 8(sp)
	stq	a5, 16(sp)
	stq	t1, 24(sp)	/* old sp */


	mov	a1, t1
	mov	a3, a1
	mov	t1, a3	 
	
	mov	a2, t1
	mov	a4, a2
	mov	t1, a4

	srl	a0, TID_S_THREAD, a0	/* prepare a0 - call expects THREAD number */
	
	ldq	a1, 0(a1)	/* Load preempter */
	ldq	a2, 0(a2)	/* Load pager */

	pal	L4_LTHREAD_EX_REGS
	
	ldq	t0, 0(sp)
	stq	a1, 0(t0)
	ldq	t0, 8(sp)
	stq	a2, 0(t0)

	ldq	t0, 16(sp)
	stq	a3, 0(t0)
	ldq	t0, 24(sp)
	stq	a4, 0(t0)

	addq	sp, 32, sp
	load
	ret	(ra)	

/* 
** L4_INLINE l4_taskid_t 
** l4_task_new (l4_taskid_t destination, qword_t mcp_or_new_chief, 
**       	qword_t usp, qword_t pc, l4_threadid_t pager);
**	
**	a0	- lthread no
**	a1	- preempter
**	a2	- pager
**	a3	- pc
**	a4	- sp	
*/		
l4_task_new:	
	save

	mov	a2, v0
	mov	a4, a2
	mov	v0, a4
	
	pal	L4_TASK_NEW_ENTRY
	load
	ret	(ra)
	
	
	
l4_thread_switch:
	save
	pal	L4_SWITCH_ENTRY
	load
	ret	(ra)

	
l4_schedule:
	save
	pal	L4_SCHEDULE_ENTRY
	load
	ret	(ra)

