/*
**	Copyright (c) 1995, Sebastian Schoenberg 
**	E-mail : ss10@irz.inf.tu-dresden.de
**
**	University of Technology Dresden, Department of Computer Science
**	Institute for Operating Systems, Databases and Computer Networks
**
**	$Id: ipc.S,v 5.5 1999/11/09 00:42:14 danielp Exp $
**
*/

#if !defined(lint)
	.data
	.asciz	"$Id: ipc.S,v 5.5 1999/11/09 00:42:14 danielp Exp $"
#endif


#include <pal/predef.h>	

#include <pal/dc21164.h>
#include <pal/regdef.h>
#include <pal/macros.h>

#include <pal/l4pal.h>

#include <pal/gasp.h>

	
#include <pal/debug.h>	

#include <pal/platform.h>

	.globl	ipc_transfer_long
	.globl	ipc_has_send
	.globl  ipc_receive_only

	.globl	ret_ipc_send_long

	.globl	ret_send_chief

	.globl ret_nchief_call
	
	.text

/*------------------------------------------------------------------------------------------------------
** Continuation of IPC
**
**
**      a0      - receiver id
**
**      a1      - snd_msg_vect
**
**      a2      - rec_msg_vect
**
**      a3      - msg_timeout = (receive = 63..32 | send = 31..00)
**
**	a4	- virtual sender id
**
**	a5	- original destination (for chief calls)
**
**      t0..t6, t8  - msg0 .. msg7
**
** OUTPUT PARAMETERS:  
**
**      v0 - message transfer result (full message dope)
**      pv - transferred dope
**
** SIDE EFFECTS
**	thread + task switches occures, so TLB misses cannot be avoided
**
** QUEUES:
**	polled_queue :	queue of receiver (TCB_SEND_ROOT)
**	polling_queue:	queue through sender
**	
** GENRAL:
**	p0 :	 myself
**	p1 :	 partner
*/

	
	ALIGN_BRANCH
ipc_has_send:
	ldiq	p3, TID_M_VER0
	tcb_dispatcher p1						// ldah p1, 0xe000(zero)

	// 3 * send_msg_vect != NIL -> run through, if data to be send 
	ldq_a	p7, TCB_MYSELF (p0)

	or	p1, a0, p1

	ldq_a	p2, (TCB_MYSELF+0x20)(p0)				// Was NOP -> Touch second cacheline
	bic	p1, p3, p1						// These two instructions are single pipelined
		
	ldq_a	p4, TCB_MYSELF (p1)					// p0 = ID, loaded in TCB		
	xor	p7, a0, p3
	// this |tcb_ptr a0, p1| has been splitted			// p1 = TCB of target TID.

	ldq_a	p2, TCB_THREAD_STATE (p1)				// 
	srl	p3, TID_S_SITE, p3					// Bits above 33 must be identical



	xor	p4, a0, p3
	and	v0, zero, v0						// was nop
	bne	p3, ipc_not_exist					// no, jump to ipc_send_dest_not_exist
	nop

	bne	p3, ipc_send_chief					// no, jump to ipc_send_chief

ipc_send_from_redir:  //ALIGNED
	// If I return here, I need to make sure these registers have valid contents...
	// Our reciever id, a0 may have changed to the new reciever of this message...
	// need to worry about a0, p4, p7, p2.. make sure ax are original values..

//	xor	p4, a0, p3
//	bne	p3, ipc_not_exist					// no, jump to ipc_send_dest_not_exist

	// check long ipc or deceit
	nop
	bne	a1, ipc_deceit_long

ipc_deceit_return:			
	
	// -----------------------------------------------------------------------------------
	// ipc_send operation
	// * partner in open or closed wait
	xor	p2, p7, p4						// p4 is result of waiting-for check
									// p4 < 0 if waiting for any
									// p4 = 0 if waiting for this thread
									// p4 > 0 if not waiting, or waiting not for me (or vsend if deceiting)
		
	bgt	p4, ipc_send_enqueue					// fall through is open or closed wait

	// could be waiting for our virtual sender - we need to check this????

	
ipc_send_exec:	//ALINED
	// * Only a short message is handled here
	stq_a	p0, TCB_COMM_PARTNER (p1)
	bne	a1, ipc_send_long					// must be zero for short msg, if deceited or
			
									// anything else, go to long
ipc_send_exec_from_long: //ALIGNED
	// * Only a send operation
	extll	a3, 0, p2						// receive timeout
	IFGE	a2							// does a receive operation exist 
		// ** stall **
		ldl_a	p3, TCB_LIST_STATE (p0)
		bne	p2, Xsend_timeout				// If not timeout never
		
		stq_a	a2, TCB_COMM_ADDRESS(p0)			// save my comm address
		nop
	
		and	p3, LLS_WAKEUPS_VALID, p2
		bne	p2, Xclear_wakeup

XRclear_wakeup:		
XRsend_timeout:
		IFLBC	a2						// is it an open call
			stq_a	a0, TCB_THREAD_STATE (p0)		// We are in CLOSED_WAIT for a0
			switch_context p1, p2
			switch_thread_ipc p0, p1, ipc_call_ok, ipc_call_ok	// Switch to partner, if we come back, jump to ipc_send_ok
			// --> to ipc_send_ok
		ELSE
			lda	p3, TCB_SEND_ROOT (p0)
	
			ldq_a	p2, 0(p3)
			xor	p2, p3, p3				// Is there a thread waiting
			IFZ	p3	
				subq	zero, 1, p3
				stq_a	p3, TCB_THREAD_STATE (p0)
		
				switch_context p1, p2
				switch_thread_ipc p0, p1, ipc_call_ok, ipc_call_ok	// Switch thread to receiver
				// --> to ipc_send_ok					// which is now ready
			XENDIF
			push	p_p0|p_p1|p_p2
			ldiq	p5, TFS_LOCKED_RUNNING
			enqueue_busy (p0, p6, p3, p4)
			stq_a	p5, TCB_THREAD_STATE (p0) 
					
			switch_context p1, p2
			switch_thread_ipc p0, p1, ipc_is_sender2, ipc_is_sender2	// Switch thread to receiver
ipc_is_sender2:
		pop	p_p0|p_p1|p_p2
		br	ipc_is_sender

		XENDIF
	
	ENDIF


	ldiq	p5, TFS_RUNNING						// ok, partner can now be started again; 
	enqueue_busy (p0, p2, p3, p4)					// enqueue in busy queue
	stq_a	p5, TCB_THREAD_STATE (p0)  
		
	switch_context p1, p2
	switch_thread_ipc p0, p1, ipc_send_ok, ipc_send_ok	// Switch thread to receiver
	
	/* NEVER REACHED */
	ALIGN_BRANCH
	.globl	ipc_receive_ok
ipc_receive_ok:
ipc_call_ok:
	ldiq	p0, TCB_MASK
	bis	v0, IPC_SUCCESS, v0			// IPC, ok
	bic	sp, p0, p0

	// 1 * set waked up 
	ldiq	p5, TFS_RUNNING				// ok, partner can now be started again; 
	stq_a	p5, TCB_THREAD_STATE (p0) 
	
	ldq_a	pv, TCB_COMM_PARTNER (p0)		// Get partner of action
	ldq_a	pv, TCB_MYSELF (pv)
	close_frame
	
#ifdef PERFORMANCE
	ldl_a	p1, 8(sp)
	ldq_a	p0, 0(sp)
	beq	p1, 9f
	mtpr	p1, ips

	addq	sp, 24, sp
	mtpr	sp, ptKSP
	ldq_a	sp, -8(sp)
	mtpr	p0, excAddr

	mtpr	p1, dtbCm	
	nop
	nop

	 	mfpr	p1, PmCtr
		nop
		nop
		ldq_p	p0, PERF1 (zero)
		cmpult	p1, p0, AT
		IF	AT
			stq_p	p1, PERF1 (zero)
		ENDIF
	
	hw_rei_stall

	ALIGN_BRANCH
9:	mtpr	p0, excAddr
	addq	sp, 16, sp
	STALL
	 	mfpr	p1, PmCtr
		nop
		nop
		ldq_p	p0, PERF1 (zero)
		cmpult	p1, p0, AT
		IF	AT
			stq_p	p1, PERF1 (zero)
		ENDIF
	hw_rei_stall
#else	

	close_frame
#endif	


	ALIGN_BRANCH
ipc_send_ok:
	bis	zero, IPC_SUCCESS, v0			// IPC, ok
	close_frame

	ALIGN_BRANCH
Xclear_wakeup:	
	bic	p3, LLS_WAKEUPS_VALID, p3
	stl_a	p3, TCB_LIST_STATE (p0)
	br	XRclear_wakeup
	
		
		
	/* Exported functionality */
	ALIGN_BRANCH
Xsend_timeout:
	stq_a	a2 , TCB_COMM_ADDRESS(p0)			// save my comm address
	extwl	p2, 2, p4				// get m(r)
	mfpr	p6, ptCurrentTime
	s4addq	p2, 0, p5				// get e(r) << 3
	sll	p4, p5, p4				// m(r) * 16^e(r)
	addq	p4, p6, p4				// p4 is absolute time
	stq_a	p4, TCB_TIMEOUT (p0)
	and	p3, LLS_SOON_WAKEUP_QUEUE, AT
	bne	AT, XRsend_timeout
		bis	p3, LLS_SOON_WAKEUP_QUEUE|LLS_WAKEUPS_VALID, p5
#ifdef SORTED_SOON_WAKEUP
		stl_a	p5, TCB_LIST_STATE (p0)
		insert_soon_wakeup_timeout p0, p4, p3, p5
#else		
		krn_addr p3, system_cb
		stl_a	p5, TCB_LIST_STATE (p0)
		lda	p3, SCB_SOON_WAKEUP (p3)
		lda	p4, TCB_WAKEUP_QUEUE (p0)		// enqueue this in soon_wakeup_queue
		ldq_a	p5, 0(p3)
		stq_a	p5, 0(p4)
		stq_a	p4, 0(p3)
#endif
		br	XRsend_timeout
	
	ALIGN_BRANCH
ipc_send_chief:
	// * Implement sending via chief comes here
	pal_addr p3, ret_send_chief				// specify return position
//	addq	a5, 1, a5

	push	p_p1|p_p2|p_p3|p_p4|p_p7|p_t0|p_t1|p_t2|p_t3|p_t4|p_t5|p_t6|p_t8|p_a1|p_a2|p_a3|p_a4|p_a5

	bis	zero, 2, a5
	
	kernel	l4_id_nearest
	
	ALIGN_BRANCH
nchief_call:				// uses v0 for return location
	push	p_p1|p_p2|p_p3|p_p4|p_p7|p_t0|p_t1|p_t2|p_t3|p_t4|p_t5|p_t6|p_t8|p_a1|p_a2|p_a3|p_a4|p_a5

	bis	zero, 2, a5
	
	kernel	l4_id_nearest
	

	ALIGN_BRANCH
ret_nchief_call:
	tcb	p0
       	pop	p_p1|p_p2|p_p3|p_p4|p_p7|p_t0|p_t1|p_t2|p_t3|p_t4|p_t5|p_t6|p_t8|p_a1|p_a2|p_a3|p_a4|p_a5

	// need to STALL?
	STALL
	STALL
	STALL

//	subq	a5, 1, a5
	jmp	zero, (p3), ret_send_chief		// a guess..
	
	ALIGN_BRANCH
ret_send_chief:
	// Our result is in a0 - thread to send to
	//bis	v0, zero, v0				// set msgdope bits
	cmoveq	v0, L4_IPC_SRC_MASK, v0			// if SAME (00) then flip bit
	xor	v0, L4_IPC_SRC_MASK, v0			// xor result to flip bit
	xor	a0, a5, p3				// check intended destination
	sll	p3, TID_S_TASK, p3
	cmoveq	p3, zero, v0
	
	// start of new STUFF
	ldiq	p3, TID_M_VER0
	tcb_dispatcher p1						// ldah p1, 0xe000(zero)	
	or	p1, a0, p1
	bic	p1, p3, p1
	ldq_a	p4, TCB_MYSELF (p1)
	ldq_a	p2, TCB_THREAD_STATE (p1)
	// end of new STUFF
	// We dont care about p1, p2, p3 and p4 (so we dont need to put them on the stack!)
	
		
	br	zero, ipc_send_from_redir

	
	ALIGN_BRANCH
ipc_is_sender:
	// * p2 first of send_queue is acceptable sender
	sra	p2, 35, p4				// Check for IRQ
	delete_ll (p2, p1, p3, ISLIST)			// delete p2 from list
	
	addq	p4, 1, p1				// mask >= 0xffffffffe0000000 ?
	IF	p1
		stq_a	zero, 0(p2)
		stq_a	zero, 8(p2)
	
		// data from IRQ !
		krn_addr p1, interrupt_queue			// start of irq list ...
		bis	zero, IPC_SUCCESS, v0			// state is OK
		subq	p2, p1, pv				// offset int list
		bis	zero, zero, t0				// Prevent hidden channels during IRQ ?
		sll	pv, 4, pv				// irq number
		clr	t1
		tcb	t1
		ldq_a	t1, TCB_INTERRUPT_MASK(t1)
		clr	t2
		clr	t3
		clr	t4
		clr	t5
		clr	t6
		close_frame

	XENDIF
	// entry is a tcb	
	ldiq	AT, TCB_MASK
	bis	zero, TFS_LOCKED_WAITING, p3		// set myself to locked waiting
	bic	p2, AT, p1				// p1 is now TCB which wants to send

	stq_a	p3, TCB_THREAD_STATE (p0)
	stq_a	p1, TCB_COMM_PARTNER (p0)
	
	bis	zero, TFS_LOCKED_RUNNING, p2		// and partner to locked running
	stq_a	p0, TCB_COMM_PARTNER (p1)		// store partner
	stq_a	p2, TCB_THREAD_STATE (p1)	

	ldl_a	p2, TCB_LIST_STATE (p1)
	bic	p2, LLS_POLLING_QUEUE, p2
	stl_a	p2, TCB_LIST_STATE (p1)

	// clear list bit
	switch_context p1, p2
	switch_thread_pal p0, p1, ipc_receive_ok
	/* NEVER REACHED */
	
	ALIGN_BRANCH
ipc_send_enqueue:
	// Receiver does not wait, enqueue in receivers p1 queue
	extll	a3, 4, p2
	insert_sender (p0, p1, p4, p3)			// Insert sender (p0) into rec's queue p1
	IF	p2						// timeout != never
		extwl	p2, 2, p4				// get m(r)
		mfpr	p3, ptCurrentTime
		s4addq	p2, 0, p5				// get e(r) << 3
		sll	p4, p5, p4				// m(r) * 16^e(r)
		addq	p4, p3, p4				// p4 is absolute time
		ldl_a	p3, TCB_LIST_STATE (p0)
		stq_a	p4, TCB_TIMEOUT (p0)
		and	p3, LLS_SOON_WAKEUP_QUEUE, AT
		IFZ	AT
			bis	p3, LLS_SOON_WAKEUP_QUEUE|LLS_WAKEUPS_VALID, p5
#ifdef SORTED_SOON_WAKEUP
			stl_a	p5, TCB_LIST_STATE (p0)
			insert_soon_wakeup_timeout p0, p4, p3, p5
#else		
			krn_addr p3, system_cb
			stl_a	p5, TCB_LIST_STATE (p0)
			lda	p3, SCB_SOON_WAKEUP (p3)
			lda	p4, TCB_WAKEUP_QUEUE (p0)		// enqueue this in soon_wakeup_queue
			ldq_a	p5, 0(p3)
			stq_a	p5, 0(p4)
			stq_a	p4, 0(p3)
#endif	
		ENDIF
	ELSE
		ldl_a	p3, TCB_LIST_STATE (p0)
		bic	p3, LLS_WAKEUPS_VALID, p3
		stl_a	p3, TCB_LIST_STATE (p0)
	ENDIF
	
	bis	zero, TFS_POLLING, p2
        stq_a   a0, TCB_WAIT_FOR (p0)                   // which thread am I waiting for
	stq_a	p2, TCB_THREAD_STATE (p0)			// set myself to polling

	push	p_p1|p_t0|p_t1|p_t2|p_t3|p_t4|p_t5|p_t6|p_t8|p_a0|p_a1|p_a2|p_a3|p_a5|p_fp|p_v0
	// p_a4 gets trashed... (sometimes)
	
	switch_dispatcher p0, ipc_send_eq			// switch to dispatcher need no context switch

	ALIGN_BRANCH
ipc_send_eq:						// Ok, we're back
	tcb	p0

	ldl_a	p4, TCB_LIST_STATE (p0)
	pop	p_p1|p_t0|p_t1|p_t2|p_t3|p_t4|p_t5|p_t6|p_t8|p_a0|p_a1|p_a2|p_a3|p_a5|p_fp|p_v0

	and	p4, LLS_POLLING_QUEUE, p2
	IF	p2
		lda	AT, TCB_SEND_QUEUE (p0)			// delete this entry from send queue
		delete_ll (AT, p2, p3, ISLIST)

		bic	p4, LLS_POLLING_QUEUE, p4
	
		stl_a	p4, TCB_LIST_STATE (p0)
	ENDIF

	br	zero, ipc_send_exec	

	
	ALIGN_BRANCH
//ipc_send_long:
ipc_deceit_long:	
	and	a1, MVS_M_DECEIT, p3
	nop
	IF	a4	//was p3 FIX!! (put p3 back!!)
		// FIXME:   might be nice to move this whole section to kernel mode.
//		tcb_ptr a4, p3
//		ldq	p3, TCB_MYSELF(p3)
//		beq	p3, ipc_not_exist		// check vsend valid

// The above three lines produce a bug for some reason..
	
		push p_v0
			
		pal_addr	p3, ret_nchief_call1
		br	zero, nchief_call
		ALIGN_BRANCH
ret_nchief_call1:
		bis	v0, zero, p4
		// nchief vsend

		bis	a0, zero, p3				// put a0 in temp reg, put a4 (vsend) in its place.
		bis	a4, zero, a0		

		push	p_p3|p_p4				//<- p4 DO WE REALLY NEED TO DO THIS?
		pal_addr p3, ret_nchief_call2
		br	zero, nchief_call
		ALIGN_BRANCH
ret_nchief_call2:
		pop	p_p3|p_p4

       		bis	p3, zero, a0	
      	       	//bis	a5, L4_IPC_DECEIT_MASK, p3		
		xor	p4, v0, v0				// check okay
		and	v0, L4_IPC_SRC_MASK, v0

		cmoveq	v0, zero, a4				// not deceit
		cmovne	v0, a4, p7

		pop p_v0
		cmovne	a4, L4_IPC_DECEIT_MASK, p3		// deceited? mark dope
		bis	p3, v0, v0
	
	ENDIF

	br zero, ipc_deceit_return
	
	
//	branch?	
	ALIGN_BRANCH
ipc_send_long:		
	
        ldq_a	p2, TCB_COMM_ADDRESS(p1)		// call kernel only, if something to xfer
	bic	p2, MVR_M_OPENCLOSE, p2			// Clear open/close flag
	beq	p2, ipc_send_exec_from_long
							// Now its either a flexpage rec, or a buffer is given
		
	bic	a1, MVS_M_DECEIT, p2
	beq	p2, ipc_send_exec_from_long		// if only deceited, then do transfer

	bis	zero, TFS_LOCKED_RUNNING, p2		// set myself to locked running
	bis	zero, TFS_LOCKED_WAITING, p3		// and partner to locked waiting

	stq_a	p1, TCB_COMM_PARTNER (p0)
	stq_a	p2, TCB_THREAD_STATE (p0)
	stq_a	p3, TCB_THREAD_STATE (p1)	

	push	p_p1|p_t0|p_t1|p_t2|p_t3|p_t4|p_t5|p_t6|p_t8|p_a0|p_a1|p_a2|p_a3|p_a4|p_a5

	kernel	ipc_transfer_long

	ALIGN_BRANCH
ret_ipc_send_long:
	tcb	p0
	
	pop	p_p1|p_t0|p_t1|p_t2|p_t3|p_t4|p_t5|p_t6|p_t8|p_a0|p_a1|p_a2|p_a3|p_a4|p_a5
//	mtpr	zero, dtbIap					// Flush the temporary mapped area, some of the 
	STALL							// current TCB entries are flushed, but they 
	STALL							// would be flushed also due to the thread switch.
	STALL
	br	zero, ipc_send_exec_from_long

	

/*=====================================================================================================
**
** The receive-only part is responsible for
**
** Closed wait to myself with timeout never
** removes the TCB from all queues.
**	
** - close-wait
**	wait for a message from source
**	wait for an interrupt from source
**	associate interrupt
**
** - open-wait
**	wait for any message
**	wait for any interrupt
**
*/
	ALIGN_BRANCH
ipc_receive_only:
	stq_a	a2, TCB_COMM_ADDRESS(p0)			// store my comm address
	IFLBS	a2						// Bit[0] set -> open wait
		lda	p2, TCB_SEND_ROOT (p0)
		ldq_a	p1, 0(p2)
		xor	p1, p2, p2
		IFZ	p2					// Send root not empty

			subq	zero, 1, p2			// There is no one waiting...
			mov	p0, p1				// trick, use myself as partner, which cannot run

			stq_a	p2, TCB_THREAD_STATE (p0)	// Set current thread to open wait
			br	ipc_wait_for_rec_or_time	// go there
		XENDIF						// Take the first from the queue

		sra	p1, 35, p4				// Check for IRQ	
		first_sender (p1, p0, p2, p3)			// Root entry of send queue

		addq	p4, 1, p4				// mask >= 0xffffffffe0000000 ?
		IF	p4
			stq_a	zero, 0(p1)
			stq_a	zero, 8(p1)
	
			// data from IRQ !
			krn_addr p2, interrupt_queue		// start of irq list ...
			clr	t0				// Prevent hidden channels during IRQ ?
			subq	p1, p2, pv			// offset int list
			clr	t1
			srl	pv, 4, pv			// irq number
			bis	zero, IPC_SUCCESS, v0		// state is OK

			tcb	t1
			ldq_a	t1, TCB_INTERRUPT_MASK(t1)
	
			clr	t2
			clr	t3
			clr	t4
			clr	t5
			clr	t6
			close_frame
		XENDIF						// entry is an tcb

		ldiq	AT, TCB_MASK
		bic	p1, AT, p1				// p1 is now TCB

		ldl_a	p3, TCB_LIST_STATE (p1)
		bic	p3, LLS_POLLING_QUEUE, p3
		stl_a	p3, TCB_LIST_STATE (p1)
	
		enqueue_busy (p1, p2, p3, p4)

		bis	zero, TFS_LOCKED_WAITING, p2		// set myself to locked waiting
		bis	zero, TFS_LOCKED_RUNNING, p3		// and partner to locked running
		stq_a	p1, TCB_COMM_PARTNER (p0)
		stq_a	p2, TCB_THREAD_STATE (p0)

		stq_a	p0, TCB_COMM_PARTNER (p1)		// Save partner
		stq_a	p3, TCB_THREAD_STATE (p1)	

		switch_context p1, p2
		switch_thread_pal p0, p1, ipc_receive_ok
		/* NEVER REACHED */
	XENDIF

	/*
	** This is closed wait for a message or
	** an interrupt
	*/
	bic	a0, IRQ_ATTACH|IRQ_MASK, p2			// a0 <= 0xff --> IRQ
	IFZ	p2			

		and	a0, IRQ_ATTACH, p3			// Attach bit set ?		
		bne	p3, ipc_associate_int			// Attach to intr p2
	
		/* 
		** No attaching, wait for an IRQ.
		** The IRQ waiting for is coded in bits 8..15
		*/
		and	a0, IRQ_MASK, p3
	
		ldq_a	p1, TCB_SEND_ROOT (p0)				// Root of send queue

		krn_addr p4, interrupt_queue

		subq	p1, p4, p4
		srl	p4, 4, p4					// Is the requested INT pending ?
	
		xor	p4, p3, p4				
		beq	p4, ipc_intr_pending				// Yes, than take that INT 

		
		insbl	p3, 1, p3					// No, than insert wait-request interrupt into queue
	
		stq_a	p3, TCB_THREAD_STATE (p0)
		switch_dispatcher p0, ipc_wait_interrupt		// Yes, dispatch dispatcher in
		/* NEVER REACHED */
	ELSE
		/* 
		** Waiting for an TCB
		*/
		tcb_ptr a0, p1						// p1 = TCB of target TID.
		ldq_a	p2, TCB_MYSELF (p1)				// p0 = ID, ppushd in TCB
		xor	p2, a0, p3					// target id == id of (target) ?
		bne	p3, ipc_not_exist				// no, jump to ipc_src_not_exist

		// who are we actually going to receive this message from - deceited?
	
		// FIX:	 what we want to do is examine the send queue and check each
		// entries virtual sender field (we will make one) to see if it matches
		// with our intended destination. Perhaps we should add this into the TCB..
	
		ldq_a	p2, TCB_THREAD_STATE (p1)			// is partner polling
		xor	p2, TFS_POLLING, p2			
		IFZ	p2
			ldq_a	p2, TCB_WAIT_FOR (p1)			// is it polling for me ?
			ldq_a	p3, TCB_MYSELF (p0)
			xor	p2, p3, p3			
			IFZ	p3					// no, so we have to wait

				lda	AT, TCB_SEND_QUEUE (p1)		// delete this entry from send queue
				delete_ll (AT, p2, p3, ISLIST)
	
				ldl_a	p3, TCB_LIST_STATE (p1)
	
				bic	p3, LLS_POLLING_QUEUE, p3
	
				stl_a	p3, TCB_LIST_STATE (p1)

				enqueue_busy (p1, p2, p3, p4)

				bis	zero, TFS_LOCKED_WAITING, p2		// set myself to locked waiting
				bis	zero, TFS_LOCKED_RUNNING, p3		// and partner to locked running
		
				stq_a	p2, TCB_THREAD_STATE (p0)	
				stq_a	p3, TCB_THREAD_STATE (p1)	

				stq_a	p0, TCB_COMM_PARTNER (p1)		// Save partner
				stq_a	p1, TCB_COMM_PARTNER (p0)
		
				switch_context p1, p2
				switch_thread_pal p0, p1, ipc_receive_ok
				/* NEVER REACHED */
			XENDIF
		ENDIF
	ENDIF

								// partner is not polling, so 
	stq_a	a0, TCB_THREAD_STATE (p0)			// Set current thread to closed wait fo a0
ipc_wait_for_rec_or_time:					// Wait for receiver or timeout

	extll	a3, 0, p2
	IF	p2						// timeout != never
		extwl	p2, 2, p4				// get m(r)
		mfpr	p3, ptCurrentTime
		s4addq	p2, 0, p5				// get e(r) << 3
		sll	p4, p5, p4				// m(r) * 16^e(r)
		addq	p4, p3, p4				// p4 is absolute time
		ldl_a	p3, TCB_LIST_STATE (p0)
		stq_a	p4, TCB_TIMEOUT (p0)
		and	p3, LLS_SOON_WAKEUP_QUEUE, AT
		IFZ	AT
			bis	p3, LLS_SOON_WAKEUP_QUEUE|LLS_WAKEUPS_VALID, p5
#ifdef SORTED_SOON_WAKEUP
			stl_a	p5, TCB_LIST_STATE (p0)
			insert_soon_wakeup_timeout p0, p4, p3, p5
#else	
			krn_addr p3, system_cb
			stl_a	p5, TCB_LIST_STATE (p0)
			lda	p3, SCB_SOON_WAKEUP (p3)
			lda	p4, TCB_WAKEUP_QUEUE (p0)		// enqueue this in soon_wakeup_queue
			ldq_a	p5, 0(p3)
			stq_a	p5, 0(p4)
			stq_a	p4, 0(p3)
#endif	
		ENDIF
	ELSE
		ldl_a	p3, TCB_LIST_STATE (p0)
		bic	p3, LLS_WAKEUPS_VALID, p3
		stl_a	p3, TCB_LIST_STATE (p0)	
	ENDIF
	
	// p0 = myself, p1 = partner			
	ldq_a	p2, TCB_THREAD_STATE (p1)
	bic	p2, TFS_RUNNING, p3				// Is partner dispatchable ?
	IFZ	p3	
		switch_context p1, p2
		switch_thread_pal p0, p1, ipc_receive_ok	// Yes, dispatch in

	XENDIF							// No, it isn't
	switch_dispatcher p0, ipc_receive_ok			// Yes, dispatch dispatcher in
	/* NEVER REACHED */

	
	// if we come here, p5 is the interrupt, since
	// we have been waked up by the 'interrupt'
ipc_wait_interrupt:
	mov	p5, pv
	tcb	v0
	ldiq	p0, TFS_RUNNING
	stq_a	p0, TCB_THREAD_STATE (v0)
	
	bis	zero, IPC_SUCCESS, v0				// state is OK
	
	clr	t1
	tcb	t1
	ldq_a	t1, TCB_INTERRUPT_MASK(t1)
	clr	t2
	clr	t3
	clr	t4
	clr	t5
	clr	t6
	close_frame

	
	// The interrupt is already pending
	// Take this out from the queue
	ALIGN_BRANCH
ipc_intr_pending:
	mov	p3, t1

	first_sender (p1, p0, p2, p3)			// Root entry of send queue

	stq_a	zero, 0(p1)
	stq_a	zero, 8(p1)

	mov	IPC_SUCCESS, v0				// state is OK
	ldiq	v0, 0

	tcb	t1
	ldq_a	t1, TCB_INTERRUPT_MASK(t1)
	
	clr	t2
	clr	t3
	clr	t4
	clr	t5
	clr	t6
	close_frame


/*
** IPC Sender or Receiver does not exist
*/	
	ALIGN_BRANCH
ipc_not_exist:
	NewCom2SerialPutChar(0x78,p1,p2) //x
	bis	zero, IPC_NOTEXIST, v0
	close_frame


/*
** General Timeout Entry Point
** If this thread has been waked up due to a timeout
** the interrupted state has been pushed onto the stack
*/
	ALIGN_BRANCH
	.globl	ipc_ret_timeout
ipc_ret_timeout:
	pop	p_v0
	bic	v0, TFS_POLLING, p0
	cmovne	p0, IPC_R_TIMEOUT, v0
	IFZ	p0
		// Remove from queue (It's the right thing to do)
		tcb	p0
		lda	AT, TCB_SEND_QUEUE (p0)			// delete this entry from send queue
		delete_ll (AT, p2, p3, ISLIST)
	
		ldiq	v0, IPC_S_TIMEOUT
		lda	sp, 16*8(sp)	 /* was 14 */
	ENDIF
	close_frame

/*
** Cancel IPC
** This is called by lthread_ex_regs
** This is really a mess to setup the stack correctly
*/
	ALIGN_BRANCH
	.globl	ipc_ret_abort
ipc_ret_abort:
	pop	p_v0
	bic	v0, TFS_RUNNING, p0
	cmovne	p0, IPC_R_ABORTED, v0
	cmoveq	p0, IPC_S_ABORTED, v0
	
	close_frame
/*
** Cancel IPC
** This is called by lthread_ex_regs
** This is really a mess to setup the stack correctly
*/
	ALIGN_BRANCH
	.globl	ipc_ret_cancel_polling
ipc_ret_cancel_polling:
	ldiq	v0, IPC_S_CANCELLED
	close_frame

	ALIGN_BRANCH
	.globl	ipc_ret_cancel_wait
ipc_ret_cancel_wait:
	ldiq	v0, IPC_R_CANCELLED
	close_frame
	
	

/*
** Associate a hardware interrupt to a tread
** Unlink previously associated interrupt
*/
ipc_associate_int:
	pal_addr p1, interrupt_owner
	ldiq	p2, 16
	REPEAT
		subq	p2, 1, p2
		ldq_p	p3, 0(p1)		// Load owner of this int
 		xor	p3, p0, p4
		IFZ	p4
			stq_p	zero, 0(p1)
			EXIT
		ENDIF
		addq	p1, 8, p1
		CONT	p2
	ENDR
	pal_addr p1, interrupt_owner		// Address of attaching area
	bic	a0, IRQ_ATTACH, p3			
	s8addq	p3, p1, p1
	ldq_p	p3, 0(p1)
	IFZ	p3
		stq_p	p0, 0(p1)
		clr	v0
		close_frame				// Association done
	ELSE
		ldiq	v0, 1
		close_frame
	ENDIF
	
	
/*------------------------------------------------------------------------------
** FUNCTION: ipc_transfer_long
**
**	runs in sender context
**
** INPUT PARAMETERS:  
**
**	a0      - receiver id
**
**      a1      - snd_msg_vect
**
**	a3, a4  - res.
**
** OUTPUT PARAMTERES:
**
**	return via PAL ret to
**	IPC_LONG_RETURN
**
** USABLE
**	t0, t1, t2, t3, t4, t5, t6, t8
**
** SIDE EFFECTS
**	scratches (A LOT)
**
** PERSISTENT REGISTERS
**	t0	tcb_myself
**	t1	tcb receiver
**	t8	send buffer
**	
**	 
*/

	ALIGN_BRANCH
ipc_transfer_long:
	push	p_ra
	mov	t0, s0					// Flexpage 0.low
	mov	t1, s1					// Flexpage 0.hig
	tcb	t0
	xor	sp, a0, t2
	ldiq	t3, TID_M_TASK
	srl	t2, TID_S_TASK, t2

	tcb_ptr	a0, t1
	and	t2, t3, t2				// t2 != 0, if cross-as-xfer
	ldq	t8, TCB_COMM_ADDRESS (t1)		

#if 0
	// make friendler reorder.
	bic	a1, 3, t3
	IF	t3
		ldq_u	t3, MSG_O_SEND_DOPE (t3)
		srl	t3, MD_S_STRINGS, t3
		and	t3, MD_M_STRINGS, t3			// if snd_hdr->snd_dope.md.strings != 0
		bne	t3, transfer_strings
	ENDIF
#endif
		
	
	and	a1, MVS_M_FLEXPAGE, t3			// Send flexpages ?
	beq	t3, transfer_mwords			
	
	and	t8, MVR_M_FLEXPAGE, t3			// t3 != 0, if t8 describes a flexpage rcv.
	mov	t8, t6
	IFZ	t3					// yes, it is a flexpage
		IF	t2				
			sll	sp, TID_S_THREAD, t2	// local thread no decides, which slot is taken	
			ldiq	t3, TID_M_THREAD
			and	t2, t3, t2		// get thread no.

			sll	t2, 23, t2		// start of thread copy area offset
			ldah	t3, 0x9000(zero)	// ffffffff,90000000 - 0x00800000*thread_nr
			subq	t3, t2, t2		// resulting mapping area starts at s0, keep this !

			ldiq	t3, 0x7fffff		// creat offset mask (8MB) 00000000,007fffff
			and	t8, t3, t8
			addq	t2, t8, t8		// t8 is now offset of receiver transferred into xfer-buffer
		ENDIF
		ldq	t6, MSG_O_MWORDS(t8)		// Load flexpage offset
	ENDIF

/*-------------------------------------------------------------
**
** Treat all MWORDS as flexpages
**
**	t0:	myself
**	t1:	partner
**	t6:	receive flexpage descriptor
**	t8:	receiver message struct
*/	
transfer_flexpages:
	bic	a1, 3, a1				// clear descriptor bits
	ldiq	t2, 1					// If no descriptor exists, 1 flexpage
	IF	a1
		ldq	t2, MSG_O_SEND_DOPE(a1)
		srl	t2, MD_S_MWORDS, t2		// t2 mwords to send
	
		ldq	t3, MSG_O_STRUCT_DOPE(a1)	// ignore bit 0..2 !
		srl	t3, MD_S_MWORDS, t3		// t3	mwords of snd_struct_dope
		cmpult	t2, t3, AT			// AT = (t2 < t3) 
		cmovne	AT, t3, t2			// more to send => t2 min (flexpages to send)
	
		addq	a1, MSG_O_MWORDS, t5
	ENDIF

/*-------------------------------------------------------------
**
** Treat all MWORDS as flexpages
**
**	t0:	myself
**	t1:	partner
**	t2:	flexpages to send
**	t3, t4:	free
**	t5:	source structure
**	t6:	receive flexpage descriptor
**	t7:	counter
**	t8:	receiver message struct
*/	
	
ipc_XFER_flexpages:
	task_nr	t1, t3
	cmpeq	t3, TASK_SIGMA0, t3
	IF	t3					// Mapping INTO Sigma 0 is not allowed
		pop	p_ra
		return	ret_ipc_send_long
	ENDIF
	
	REPEAT
		push	p_t2
	
		srl	t6, 2, t4
		subq	t4, PAGEBITS, t4
		IFGT	t4					// At least one page to be sent
			and	t4, 0x3f, t7
	
			ldiq	AT, PAGESIZE			// 0x2000 = (1 << PAGEBITS)
			sll	AT, t4, AT			// receive fp size
			subq	AT, 1, t10			// Size Mask of receive fpage in t10
			
			srl	s0, 2, t4
			subq	t4, PAGEBITS, t4
			IFGT	t4
				and	t4, 0x3f, t9
				ldiq	AT, PAGESIZE		// 0x2000 = (1 << PAGEBITS)
				sll	AT, t4, AT		// send fp size
				subq	AT, 1, t11		// Size Mask of send fpage in t11

				bic	t6, t10, t6		// t6 is Aligned Receive Offset
				
				bic	s0, t11, s0		// t3 is Aligned Send Offset

				subq	t10, t11, AT		// AT > 0, if send page > receive page
	
				IFLE	AT
					xor	t10, t11, AT	// AT = 000000xxx0000 bits
					and	t6, AT, t4
					or	t4, s0, s0	// Send offset adjusted
				ELSE				// Send page is less than rpage
					xor	t10, t11, AT	// AT = 000000xxx0000 bits
					and	s1, AT, s1
					or	s1, t6, t6	// Receive Base adjusted
					mov	t9, t7

				ENDIF
				ldiq	t9, 1
				sll	t9, t7, t7			// Number of pages
				// NOW:	t3 = adjusted send base, t6 = adjusted receive base, t7=pages

				REPEAT		
					push	p_t0|p_t1|p_t3|p_t5|p_t6|p_t7|p_t8

					
					push	p_t1
					push	p_t6
					ldiq	t6, PP_INTREE			// t6 required attribute
										// t0 task
										// t3 virtual address
					mov	s0, t3
					bsr	ra, mem_translate_address
					mov	t7, t2
					pop	p_a0
					pop	p_t1

					IFLBC	s0
						// t6 is receiver descriptor
						// mem_map_page (virt_addr=a0, page frame=a1, 
						//	target tcb=t1, t2=src pte)
						bsr	ra, mem_map_page
						bne	v0, ipc_cancel
						or	s1, L4_IPC_FPAGE_MASK, s1
					ELSE
						push	p_a0|p_a1
						khex	s0
						kmsg	" someone grants\n\r"
						debug
						pop	p_a0|p_a1	
	
						task_nr	t1, t9
						cmpeq	t9, TASK_SIGMA0, t9
						IFN	t9	
							// Granting from Sigma 0 is not allowed
							// mem_grant_page (virt_addr=a0, page frame=a1, 
							//	target tcb=t1, t2=src pte, t3 virt src. address)
							bsr	ra, mem_grant_page
						ENDIF
					ENDIF
					pop	p_t0|p_t1|p_t3|p_t5|p_t6|p_t7|p_t8
					ldiq	t9, PAGESIZE
					addq	s0, t9, s0		// Next Page in source
					addq	a0, t9, a0		// Next Page in dest
					subq	t7, 1, t7
					CONT	t7
				ENDR
			ENDIF
		ENDIF

		pop	p_t2

		subq	t2, 1, t2
		EXITZ	t2
	
		ldq	s1, 0x0(t5)			// Send base
		ldq	s0, 0x8(t5)			// Flexpage send descriptor
		addq	t5, 16, t5			// flexpage descriptor 
		CONT

	ENDR
	pop	p_ra
	return	ret_ipc_send_long

ipc_cancel:
	addq	sp, 8*8, sp				// Remove all that crap from stack
	pop	p_ra

	return	ret_ipc_send_long
	
	
ipc_halt:
	halt
	
/************************************************************/

transfer_mwords:
	// Now let's copy mwords
	ldq	t11, MSG_O_SEND_DOPE (a1)
	srl	t11, MD_S_MWORDS, t11			// t11   mwords of snd_data_dope
	ldq_u	t10, MSG_O_STRUCT_DOPE(a1)		// ignore bit 0..2 !
	srl	t10, MD_S_MWORDS, t10			// t10	mwords of snd_struct_dope
	cmpult	t10, t11, AT				// AT = (t10 < t11)
	cmovne	AT, t10, t11				// t11 = min (t9, t10)

	
	ldq	t10, MSG_O_SEND_DOPE(t8)
	srl	t10, MD_S_MWORDS, t10
	cmpult	t10, t11, AT				// t9 = (t10 < t11)
	cmovne	AT, t10, t11				// t11 = min
	ldq_u	t10, MSG_O_STRUCT_DOPE (t8)
	srl	t10, MD_S_MWORDS, t10
	cmpult	t10, t11, AT				// t9 = (t10 < t11)
	cmovne	AT, t10, t11				// t11 = min
					 	
	addq	a1, MSG_O_MWORDS, t9			// t9 = start of mwords
	addq	t8, MSG_O_MWORDS, t10			// t10 = dest of mwords

	/*
	** Copy t11 qwords from t9 to t10, upwards
	*/
ipc_XFER_mwords:

	IF	t11
		bic	t9, 3, t9
		bic	t10, 3, t10
		REPEAT
			addq	s5, 1, s5
			ldq	AT, 0(t9)
			addq	t9, 8, t9
			subq	t11, 1, t11
			stq	AT, 0(t10)
			addq	t10, 8, t10			// fill the stall slot
			CONT	t11
		ENDR
	ENDIF
	return	ret_ipc_send_long

transfer_strings:	
	ldiq	a0, 0xface
	halt	


	
.END

	






