/*
**	Copyright (c) 1995, Sebastian Schoenberg 
**	E-mail : ss10@irz.inf.tu-dresden.de
**
**	University of Technology Dresden, Department of Computer Science
**	Institute for Operating Systems, Databases and Computer Networks
**
**	$Id: kdebug.S,v 5.0 1999/03/01 05:26:36 danielp Exp $
**
**
*/

#if !defined(lint)
	.data
	.asciz	"$Id: kdebug.S,v 5.0 1999/03/01 05:26:36 danielp Exp $"
#endif


#include <pal/predef.h>

#include <pal/dc21164.h>
#include <pal/macros.h>
#include <pal/regdef.h>

#include <pal/l4pal.h>

#include <pal/debug.h>

#include <pal/gasp.h>
	
	.globl	debug_dtb
	.globl	debug_itb

	.globl	debug_console
	
	.text
#define ESC	27


.MACRO put_hdr str
	br	a0, 9f
	.byte	ESC
	.ascii	"[1;1H"
	.byte	ESC
	.ascii	"[1m\str"
	.byte	ESC
	.asciz	"[0m"
	.align	3
9:	pal	UDBG_PRINT_STR
.ENDM	 

.MACRO put_status str
	br	a0, 9f
	.byte	ESC
	.ascii	"[24;1H"
	.byte	ESC
	.ascii	"[7m\str"
	.byte	ESC
	.ascii	"[0K"
	.byte	ESC
	.asciz	"[0m"
	.align	3
9:	pal	UDBG_PRINT_STR
.ENDM	 

	
.MACRO put_str x,y,str
	br	a0, 9f

	.byte	ESC
	.ascii	"[\y;\x"
	.asciz	"H\str"
	.align	3
9:	pal	UDBG_PRINT_STR
.ENDM

.MACRO goto x,y
	br	a0, 9f

	.byte	ESC
	.ascii	"[\y;\x"
	.asciz	"H"
	.align	3

9:	pal	UDBG_PRINT_STR
.ENDM

	
.MACRO put_hex x,y,data,bits=64
	push	p_a1
	mov	\data, a1
	push	p_a1
	br	a0, 9f

	.byte	ESC
	.ascii	"[\y;\x"
	.asciz	"H"
	.align	3

9:	pal	UDBG_PRINT_STR
	pop	p_a0
	ldiq	a1, \bits
	pal	UDBG_PRINT_HEX
	pop	p_a1
.ENDM


.MACRO put_text str
	br	a0, 9f

	.byte	ESC
	.asciz	"\str"
	.align	3
9:	pal	UDBG_PRINT_STR
.ENDM


.MACRO put_hex2 data,bits=64
	push	p_a0|p_a1
	mov	\data, a0
	ldiq	a1, \bits
	pal	UDBG_PRINT_HEX
	pop	p_a0|p_a1
.ENDM
	

.MACRO get_char 
	pal	UDBG_GET_CHAR
.ENDM
		
.MACRO clrscr
	br	a0, 9f

	.byte	ESC
	.asciz	"[2J"
	.align	3

9:	pal	UDBG_PRINT_STR
.ENDM
	
.MACRO clreol
	br	a0, 9f

	.byte	ESC
	.asciz	"[0K"
	.align	3

9:	pal	UDBG_PRINT_STR
.ENDM

.MACRO put_cr
	br	a0, 9f
	.asciz	"\n\r"
	.align	3

9:	pal	UDBG_PRINT_STR
.ENDM

.MACRO	put_space
	ldiq	a0, 0x20
	pal	UDBG_PRINT_CHAR
.ENDM

/* v0 - thread address */
debug_thread:
	push	p_ra

	clrscr

	tcb	t1
	cmpeq	v0, t1, t1
	IF	t1
		put_hdr	"Thread Control Block (current)"
	ELSE
		tcb_dispatcher t1
		cmpeq	v0, t1, t1
		IF	t1
			put_hdr	"Thread Control Block (dispatcher)"
		ELSE
			put_hdr	"Thread Control Block"
		ENDIF
	ENDIF	
	put_str	1, 2,"Thread ID"
	ldq	t0, TCB_MYSELF (v0)
	put_hex	20, 2, t0

	put_str	1, 3,"Pager ID"
	ldq	t0, TCB_PAGER (v0)
	put_hex	20, 3, t0

	put_str	1, 4,"Schedule address"
	ldq	t0, TCB_RESTART (v0)
	put_hex	20, 4, t0
	
	put_str	1, 5, "Kernel Stack"
	ldq	t0, TCB_KSP (v0)
	put_hex	20, 5, t0
	
	put_str	1, 6, "Thread State"
	ldq	t0, TCB_THREAD_STATE (v0)
	put_hex	20, 6, t0

	put_str	1, 7, "Wait For"
	ldq	t0, TCB_WAIT_FOR (v0)
	put_hex	20, 7, t0


	
	put_str	1, 8, "scp/mcp/Acct"
	ldl	t0, TCB_SCHED_SCP (v0)
	put_hex	20, 8, t0, 8
	ldl	t0, TCB_SCHED_MCP (v0)
	put_hex	23, 8, t0, 8

	ldq	t0, TCB_SCHED_ACCOUNT (v0)
	put_hex	26, 8, t0, 32
	

	// *** Right side of the screen - lists ***
	

	// *** Present Queue ***
	put_str	40, 2, "Present Queue"
	ldl	t1, TCB_LIST_STATE (v0)
	and	t1, LLS_PRESENT_QUEUE, t2
	
	IF	t2
		ldq	t0, TCB_PRESENT_QUEUE (v0)
		put_hex	70, 2, t0, 32
		ldq	t0, (TCB_PRESENT_QUEUE+8) (v0)
		put_hex	60, 2, t0, 32
	ELSE
		put_str	60, 2, "none"
	ENDIF


	// *** Busy queue ***
	put_str	40, 3, "Busy Queue"
	ldl	t1, TCB_LIST_STATE (v0)
	and	t1, LLS_BUSY_QUEUE, t2

	IF	t2
		ldq	t0, TCB_BUSY_QUEUE (v0)
		put_hex	70, 3, t0, 32
		ldq	t0, (TCB_BUSY_QUEUE+8) (v0)
		put_hex	60, 3, t0, 32
	ELSE
		put_str	60, 3, "none"
	ENDIF



	// *** send root ***
	put_str	40, 4, "Send Root"

	lda	t1, TCB_SEND_ROOT (v0)
	ldq	t2, 0(t1)
	xor	t2, t1, t2
	IF	t2
		ldq	t0, TCB_SEND_ROOT (v0)
		put_hex	70, 4, t0, 32
		ldq	t0, (TCB_SEND_ROOT+8) (v0)
		put_hex	60, 4, t0, 32
	ELSE
		put_str	60, 4, "none"
	ENDIF

	// *** send queue ***	
	put_str	40, 5, "Send Queue"
	ldl	t1, TCB_LIST_STATE (v0)
	and	t1, LLS_POLLING_QUEUE, t2
	
	IF	t2
		ldq	t0, TCB_SEND_QUEUE (v0)
		put_hex	70, 5, t0, 32
		ldq	t0, (TCB_SEND_QUEUE+8) (v0)
		put_hex	60, 5, t0, 32
	ELSE
		put_str	60, 5, "none"
	ENDIF


	put_str	40, 7, "PTRoot"
	task_nr	v0, t0
	lda	t1, pal_ptroots
	s8addq	t0, t1, t1
	ldl	t0, 0(t1)
	put_hex	60, 7, t0, 32

	put_str	1, 10, "UIP :"
	lda	t1, TCB_STACKTOP(v0)
	ldq	t2, -24(t1)
	put_hex	8, 10, t2

	put_str	41, 10, "KIP :"
	mfpr	t1, tr0
	STALL
	STALL
	put_hex	48, 10, t1

	put_str	1, 11, "USP :"
	lda	t1, TCB_STACKTOP(v0)	
	ldq	t2, -8(t1)
	put_hex	8, 11, t2

		
	tcb	t1
	cmpeq	v0, t1, t1
	IF	t1
		put_str	1, 13, "Register Dump"
		goto	5, 14
		bsr	ra, debug_regs
	ENDIF
				
	pop	p_ra
	ret	(ra)


debug_irq:
	push	p_ra
	clrscr
	put_hdr	"Associated Interrupts"
	goto	1,3
	clr	t3
	ldiq	t0, 31
	lda	t1, interrupt_owner
	REPEAT
		cmpeq	t3, 22, t4
		IF	t4
			kmsg	"(realtime clock)"
		ELSE
			ldq	a0, 0(t1)
			IF	a0
				ldq	a0, TCB_MYSELF(a0)
				ldiq	a1, 64
				pal	UDBG_PRINT_HEX
			ELSE
				kmsg	". . . . . . none"
			ENDIF
		ENDIF
		addq	t1, 8, t1
	
		subq	t0, 1, t0
	
		addq	t3, 1, t3
		and	t3, 3, a0
		IFN	a0
			ldiq	a0, 0x0d
			pal	UDBG_PRINT_CHAR
			ldiq	a0, 0x0a
			pal	UDBG_PRINT_CHAR
		ELSE
			ldiq	a0, 0x20
			pal	UDBG_PRINT_CHAR
			ldiq	a0, 0x20
			pal	UDBG_PRINT_CHAR
		ENDIF
		CONT	t0
	ENDR
	
	pop	p_ra
	ret	(ra)
	
debug_help:	
	push	p_ra
	clrscr
	put_hdr	"Debugger Help"

	goto	1,2

	lda	a0, MSG_help
	pal	UDBG_PRINT_STR
	
	pop	p_ra	
	ret	(ra)	


debug_regs:
	push	p_ra

	clr	t3
	ldiq	t0, 30
	mov	fp, t1
	REPEAT
		ldq	a0, 0(t1)
		addq	t1, 8, t1
		ldiq	a1, 64
		pal	UDBG_PRINT_HEX

		subq	t0, 1, t0
	
		addq	t3, 1, t3
		and	t3, 3, a0
		IFN	a0
			lda	a0, MSG_regsnl
			pal	UDBG_PRINT_STR
		ELSE
			ldiq	a0, 0x20
			pal	UDBG_PRINT_CHAR
			ldiq	a0, 0x20
			pal	UDBG_PRINT_CHAR
		ENDIF
		CONT	t0
	ENDR
	lda	a0, ((30+4)*8)(fp)
	addq	t1, 8, t1
	ldiq	a1, 64
	pal	UDBG_PRINT_HEX
	
	put_str	1, 14, "r0"
	put_str	1, 15, "r4"
	put_str	1, 16, "r8"
	put_str	1, 17, "r12"
	put_str	1, 18, "r16"
	put_str	1, 19, "r20"
	put_str	1, 20, "r24"
	put_str	1, 21, "r28"
				
	pop	p_ra
	ret	(ra)
	

debug_readhex:
	push	p_ra
	clr	t2
	REPEAT
		get_char
		cmpeq	v0, 0x0d, t1
		EXIT	t1
		cmplt	v0, 0x30, t1
		CONT	t1
		cmple	v0, 0x39, t1
		IFZ	t1
			cmplt	v0, 0x61, t1
			CONT	t1
			cmple	v0, 0x66, t1
			CONTZ	t1
		ENDIF
		mov	v0, a0
		pal	UDBG_PRINT_CHAR
		subq	v0, 0x30, v0
		cmple	v0, 0x09, t1
		IFZ	t1
			subq	v0, 0x27, v0
		ENDIF

		s4addq	t2, 0, t2
		s4addq	t2, v0, t2
		CONT
	ENDR
	mov	t2, v0
	
	pop	p_ra
	ret	(ra)

debug_memorydump:
	push	p_ra
	mov	v0, t8			// save the tcp_ptr
	clrscr
	put_hdr	"Memory-Dump (virtual)"
	put_str	1, 2,"Thread ID"
	ldq	t0, TCB_MYSELF (v0)
	put_hex	20, 2, t0
	put_str	1, 4, "V. Address : "
	put_str	20, 4, "................"
	goto	20, 4
	bsr	ra, debug_readhex
	bic	v0, 0x07, v0

	ldiq	t1, 0x1fff
	and	v0, t1, t1
	push	p_t1
	
	mov	v0, t3
	mov	t8, t0			// restore tcb-address
	ldiq	t6, PP_INTREE
	bsr	ra, mem_translate_address

	pop	p_t1
	
	IF	a1
		srl	a1, 32, a1
		sll	a1, 13, t0		// t0 has the phys. addr.
		or	t0, t1, t0

		put_hex 40, 4, t0
	
		goto	1, 5
		ldiq	t1, 16
		REPEAT
			ldiq	a1, 64
			mov	v0, a0
			pal	UDBG_PRINT_HEX		// out the addr.

			put_space
			put_space

			ldq_p	a0, 0(t0)
			ldiq	a1, 64
			pal	UDBG_PRINT_HEX

			put_space
			put_space

			ldq_p	a0, 8(t0)
			ldiq	a1, 64
			pal	UDBG_PRINT_HEX

			put_space
			put_space

			ldq_p	t2, 0(t0)
			clr	t3
			REPEAT
				extbl	t2, t3, a0
				cmplt	a0, 32, t4
				IF	t4
					ldiq	a0, 31
				ENDIF
				cmplt	a0, 128, t4
				IFZ	t4
					ldiq	a0, 31
				ENDIF
				pal	UDBG_PRINT_CHAR
				addq	t3, 1, t3
				cmplt	t3, 8, t4
				CONT	t4
			ENDR

			put_space
	
			ldq_p	t2, 8(t0)
			clr	t3
			REPEAT
				extbl	t2, t3, a0
				cmplt	a0, 32, t4
				IF	t4
					ldiq	a0, 31
				ENDIF
				cmplt	a0, 128, t4
				IFZ	t4
					ldiq	a0, 31
				ENDIF
				pal	UDBG_PRINT_CHAR
				addq	t3, 1, t3
				cmplt	t3, 8, t4
				CONT	t4
			ENDR
			
			put_cr
			addq	t0, 0x10, t0		// increment the phys. addr.
			addq	v0, 0x10, v0		// inc. the virt. addr.
			subq	t1, 1, t1
			CONT	t1
		ENDR
	ELSE
		put_str	1, 6, "memory not mapped"
	ENDIF
	mov	t8, v0			// restore tcb-ptr for debugger		
	pop	p_ra
	ret (ra)


debug_showmappingtree:
	push	p_ra
	mov	v0, t8				// save the tcp_ptr
	clrscr
	put_hdr	"Show the mapping-tree"
	put_str	1, 2,"Thread ID"
	ldq	t0, TCB_MYSELF (v0)
	put_hex	20, 2, t0
	put_str	1, 4, "V. Address : "
	put_str	20, 4, "................"
	goto	20, 4
	bsr	ra, debug_readhex
	bic	v0, 0x07, t3
	put_hex	20, 4, t3

	mov	t8, t0				// restore tcb-address
	ldiq	t6, PP_INTREE
	bsr	ra, mem_translate_address
	// t7 is the last page table ptr
	IF	a1
		IF	t7
			ldq_p	t1, 8(t7)			// ptr to mapping data base

			and	t1, 0xff, t2			// create ptr to the mapping-entry
			extwl	t1, 2, t1			// from the used bits of the tlb-entry
			inswl	t1, 1, t1
			or	t1, t2, t1
			sll	t1, 4, t1
	
			ldah	t1, MDB_KBASE(t1)		// create address ffffffff.dxxxyyyz
			bic	t1, 0x0f, t5
		// t5 is THE mapping-entry
			goto	1,6
			ldiq	t6,1
			bsr	ra, debug_show_subtree
		ELSE
			put_str	1,6,"sigma 0 has no page-table!"
		ENDIF
	
	ELSE
		put_str	1,6,"memory not mapped!"
	ENDIF
	
	
	mov	t8, v0				// restore tcb-ptr for debugger		
	pop	p_ra
	ret	(ra)
// ---------------------------------------------------
// t5 is the parent-entry of the tree
// t6 is the depth
debug_show_subtree:
	push	p_ra
	push	p_t0|p_t1
	// first print out the parent-entry
1:	
	put_hex2	t5
	put_text	" :"
	mov	t6, t1		// the depth
	REPEAT
		put_text "   "
		subq	t1, 1, t1
		CONT	t1
	ENDR
	ldq	t0, 8(t5)
	put_hex2	t0
	put_cr

	// now the sub-items...
	ldl	t0, MDB_O_CHILD(t5)
	IF	t0
		push	p_t5|p_t6
		addq	t6, 1, t6		// increase the depth
		bic	t0, 0x0f, t5		// set the child as active
		bsr	ra, debug_show_subtree
		pop	p_t5|p_t6
	ENDIF
	// now the next item
	ldl	t0, MDB_O_NEXT(t5)			// the next-entry
	IFLBS	t0
		// it was the last entry - so leave the subroutine
		br	2f
	ENDIF
	bic	t0, 0x0f, t5
	br	1b
2:
	pop	p_t0|p_t1
	pop	p_ra
	ret	(ra)

debug_check_free_list:
	push	p_ra|p_t0|p_t1
	clrscr
	put_hdr "Check the free list"
	goto	1, 5
	lda	t0, system_cb
	ldq	t1, SCB_FREE_MAPPING(t0)
	IFZ	t1
		put_str	"No valid unused entry"
		pop	p_ra|p_t0|p_t1
		ret	(ra)
	XENDIF
1:	
	put_hex2	t1
	put_text	"     "
	ldl	t1, 0(t1)
	IF	t1
		sra	t1, 32, t2
		addq	t2, 1, t2
		IF	t2
			put_str "\n\rError on next address\n\r"
			pop p_ra|p_t0|p_t1
			ret (ra)
		XENDIF
	ELSE
		pop	p_ra|p_t0|p_t1
		ret	(ra)
	ENDIF
	br	1b
	
		
debug_prios:	
	push	p_ra
	push	p_a0|p_a1|p_t0

	clrscr
	put_hdr	"Prio Queue"

	goto 1, 3
	pal_addr t0, thread_priorities+(MAX_PRIOS*4)
	ldiq	t1, MAX_PRIOS
	REPEAT
		ldl_p	t2, 0(t0)
		khex t2, 32
		kmsg "  "
		EXITZ	t1
		subq	t0, 4, t0
		subq	t1, 1, t1
		CONT
	ENDR
	
		
	pop	p_a0|p_a1|p_t0
	pop	p_ra
	ret	(ra)		 

debug_kerneldata:	
	push	p_ra
	push	p_a0|p_a1|p_t0

	clrscr
	put_hdr	"Kernel Data"
	
	put_str 1, 3, "Free Map : "
	lda	t1, system_cb
	ldq	t2, SCB_FREE_MAPPING(t1)
	put_hex 20, 3, t2

	put_str 1,4, "Free MapArea : "
	ldq	t2, SCB_FREE_MAPPING_AREA(t1)
	put_hex 20, 4, t2

	put_str 1, 5, "Soon Wakeup : "
	lda	t1, system_cb
	ldq	t2, SCB_SOON_WAKEUP(t1)
	put_hex 20, 5, t2
	
	put_str 1, 6, "System Memory : "
	lda	t1, system_cb
	ldq	t2, SCB_SYSTEM_MEMORY(t1)
	put_hex 20, 6, t2
	
	put_str 1, 12, "System Time :	"
	mfpr	t2, ptCurrentTime
	STALL
	STALL
	put_hex 20, 12, t2
	
	
	pop	p_a0|p_a1|p_t0
	pop	p_ra
	ret	(ra)		 
	
	
/*------------------------------------------------------------------------------
** FUNCTION: debug_console
**
** MODE:
**
** INPUT PARAMETERS:  
**
** OUTPUT PARAMTERES:
** 
** SIDE EFFECTS:
**
*/
	ALIGN_BRANCH
debug_console:	
	push	p_all

	mov	sp, fp

	disable_int
	mfpr	t0, tr0
	STALL 
	STALL
	put_hex	1, 1, t0 
	put_str	17, 1 " Press a key to start debugger or h to halt ..."
	
	get_char	
	cmpeq	v0, 0x68, t0				// halt
	IF	t0
		halt
	ENDIF

		
	clrscr
	tcb	v0
	bsr	ra, debug_thread
	put_status	"L4 Kernel Debugger, V1.0"
	REPEAT
		push	p_v0
		put_str	1, 23, "L4alpha: "
		clreol	
		get_char
		mov	v0, a0
		pal	UDBG_PRINT_CHAR

		pop	p_v0

		cmpeq	a0, 0x20, t0
		IF	t0
			bsr	ra, debug_thread
			CONT
		ENDIF

		cmpeq	a0, 0x74, t0
		IF	t0
			push	p_v0
			put_str 1, 23 "Thread ID "
			put_str	12,23, "................"
			goto	12,23
			bsr	ra, debug_readhex
			tcb_ptr	v0, t3
			push	p_t3
			ldiq	t6, PP_INTREE
			tcb_dispatcher	t0
			bsr	ra, mem_translate_address
			srl	a1, 32, a0
			IF	a0
				pop	p_v0			// new v0
				pop	p_t0			// old v0
				
				bsr	ra, debug_thread
				
			ELSE
				put_status "Thread not mapped"
				pop	p_t0			// new v0
				pop	p_v0			// old v0
			ENDIF
			CONT
		ENDIF
	
		cmpeq	a0, 0x61, t0
		IF	t0
			push	p_v0
			push	p_v0
			clrscr
			put_hdr	"Address translation"

			put_str	1, 3,"Address Space :"
			mov	v0, t0
			srl	t0, TID_S_TASK, t0
			ldiq	t1, TID_M_TASK
			and	t0, t1, t0
			put_hex	20, 3, t0, 12

			IFZ	t0
				put_str 25, 3, "Kernel AS"
			ENDIF
			cmpeq	t0, 1, t0
			IF	t0
				put_str 25, 3, "Sigma 0 AS"
			ENDIF
			
	
			put_str	1, 4, "V. Address : "

			put_str	20, 4, "................"
			goto	20, 4
			bsr	ra, debug_readhex

			put_hex	20, 4, v0
			
			ldiq	a0, 32
			pal	UDBG_PRINT_CHAR

			mov	v0, t3
			ldiq	t6, PP_INTREE
			pop	p_t0
			bsr	ra, mem_translate_address

			srl	a1, 32, a1				// Clear the address bits for testing
			IF	a1
				sll	a1, 13, a0

				push	p_a0
				put_str	1, 5, "P. Address : "
				pop	p_a0
				put_hex	20, 5, a0
			ELSE				
				put_str	1, 5, "P. Address : "
				put_str	20, 5, "not mapped"
			ENDIF

			pop	p_v0
			CONT		
		ENDIF
	
		cmpeq	a0, 0x68, t0				// halt
		IF	t0
			halt
		ENDIF

		cmpeq	a0, 0x6e, t0				// next present
		IF	t0
			ldq	v0, TCB_PRESENT_QUEUE (v0)
			bsr	ra, debug_thread
			CONT
		ENDIF
		cmpeq	a0, 0x70, t0				// previous present
		IF	t0
			ldq	v0, (TCB_PRESENT_QUEUE+8) (v0)
			bsr	ra, debug_thread
			CONT
		ENDIF

		cmpeq	a0, 0x4e, t0				// next ready
		IF	t0
			bsr	ra, debug_prios
			CONT
		ENDIF

		cmpeq	a0, 0x73, t0
		IF	t0
			bsr	ra, debug_kerneldata
			CONT
		ENDIF
	
		cmpeq	a0, 0x77, t0
		IF	t0
			ldq	t0, (TCB_WAKEUP_QUEUE)(v0)
			CONTZ	t0
	
			ldiq	v0, TCB_MASK
			bic	t0, v0, v0
			bsr	ra, debug_thread
			CONT
		ENDIF
			
	
		cmpeq	a0, 0x2e, t0				// previous present
		IF	t0
			tcb_dispatcher	v0
			bsr	ra, debug_thread
			CONT
		ENDIF
	
		cmpeq	a0, 0x67, t0				// go
		IF	t0
			EXIT
		ENDIF		

		cmpeq	a0, 0x3f, t0
		IF	t0
			bsr	ra, debug_help
			CONT
		ENDIF

		cmpeq	a0, 0x71, t0
		IF	t0
			bsr	ra, debug_irq
			CONT
		ENDIF

		cmpeq	a0, 0x63, t0
		IF	t0
			bsr	ra, debug_check_free_list
		ENDIF
	
		cmpeq	a0, 0x64, t0
		IF	t0
			clrscr
			put_hdr	"Data Translation Buffer"
			goto	1,3
			pal	0x14
			CONT
		ENDIF
		cmpeq	a0, 0x69, t0
		IF	t0
			clrscr
			put_hdr	"Instruction Translation Buffer"
			goto	1,3
			pal	0x15
			CONT
		ENDIF
		cmpeq	a0, 0x6d, t0		// m-key
		IF	t0
			bsr	ra, debug_memorydump
			CONT
		ENDIF
		cmpeq	a0, 0x4d, t0
		IF	t0
			bsr	ra, debug_showmappingtree
			CONT
		ENDIF 
		put_status "Unknown key"
		CONT	
	ENDR
	enable_int
	pop	p_all
	return	ret_debug

	ALIGN_BRANCH
ret_debug:	
	pop	p_gp|p_AT
	close_frame	
	
/*------------------------------------------------------------------------------
** FUNCTION: list_threads
**
** MODE:
**
** INPUT PARAMETERS:  
**
** OUTPUT PARAMTERES:
** 
** SIDE EFFECTS
**
*/
debug_dtb:
	ldiq	p0, 64
	mtpr	a1, tr0
	REPEAT
		mfpr	a0, dtbPte
		nop
		nop
		nop
		nop
		nop
		nop
		mtpr	p0, tr1
		mfpr	a0, dtbPteTemp
		ldiq	a1, 64
		nop
		nop
		pal	UDBG_PRINT_HEX
		mfpr	p0, tr1
		nop
		nop
		subq	p0, 1, p0
		and	p0, 3, p0
		IFN	p0
			ldiq	a0, 0x0d
			pal	UDBG_PRINT_CHAR
			ldiq	a0, 0x0a
			pal	UDBG_PRINT_CHAR
		ELSE
			ldiq	a0, 0x20
			pal	UDBG_PRINT_CHAR
			ldiq	a0, 0x20
			pal	UDBG_PRINT_CHAR
		ENDIF
		mfpr	p0, tr1
		subq	p0, 1, p0
		subq	p0, 1, a1
		CONT	a1
	ENDR
	mfpr	a1, tr0
	ret	zero, (ra)
	
debug_itb:
	ldiq	p0, 48
	mtpr	a1, tr0
	REPEAT
		mfpr	a0, itbPte
		nop
		nop
		nop
		nop
		nop
		nop
		mtpr	p0, tr1
		mfpr	a0, itbPteTemp
		ldiq	a1, 64
		nop
		nop
		pal	UDBG_PRINT_HEX
		mfpr	p0, tr1
		nop
		nop
		subq	p0, 1, p0
		and	p0, 3, p0
		IFN	p0
			ldiq	a0, 0x0d
			pal	UDBG_PRINT_CHAR
			ldiq	a0, 0x0a
			pal	UDBG_PRINT_CHAR
		ELSE
			ldiq	a0, 0x20
			pal	UDBG_PRINT_CHAR
			ldiq	a0, 0x20
			pal	UDBG_PRINT_CHAR
		ENDIF
		mfpr	p0, tr1
		subq	p0, 1, p0
		CONT	p0
	ENDR
	mfpr	a1, tr0
	ret	zero, (ra)
	

/*=============================================================================*/	
	.data

MSG_regsnl:
	.asciz	"\n\r    "
	
MSG_help:
	.ascii	"Defined keyboard commands\n\r"
	.ascii	" ? Help\n\r"
	.ascii	" SPC Reshow entire TCB\n\r"
	.ascii	"\n\r"
	.ascii	" t Select thread id\n\r"
	.ascii	" n Next from Present queue\n\r"
	.ascii	" p Previous from Present queue\n\r"
	.ascii	"\n\r"
	.ascii	" d Data Translation Buffer\n\r"
	.ascii	" i Instruction Translation Buffer\n\r"
	.ascii	"\n\r"
	.ascii	" a Translate Address in current thread context\n\r"
	.ascii	" m Dump 256 bytes from current address space\n\r"
	.ascii	" M Show mapping-tree from current task\n\r"
	.ascii	"\n\r"
	.ascii	" q Show associated interrupts\n\r"
	.ascii	" g continue at interrupted instruction\n\r"
	.ascii	" h halt and go to console\n\r"
	
	.asciz	""
	
	.text	
		
		
		
	.align	3
	


.END
