/*
**	Copyright (c) 1995, Sebastian Schoenberg 
**	E-mail : ss10@irz.inf.tu-dresden.de
**
**	University of Technology Dresden, Department of Computer Science
**	Institute for Operating Systems, Databases and Computer Networks
**
**	$Id: kernel.S,v 5.3 1999/11/09 00:42:14 danielp Exp $
**
*/

#if !defined(lint)
	.data
	.asciz	"$Id: kernel.S,v 5.3 1999/11/09 00:42:14 danielp Exp $"
#endif


/* Version.inc is generated automatically by make ! */	
#include "version.inc"
	
#include <pal/predef.h>

#include <pal/dc21164.h>
#include <pal/platform.h>
	
#include <pal/macros.h>
#include <pal/regdef.h>

#include <pal/l4pal.h>

#include <pal/gasp.h>

#include <pal/debug.h>

	
	.text

	.globl	l4_kernel_init
	
l4_kernel_init:
	lda	a0, MSG_welcome
	pal	UDBG_PRINT_STR

	bsr	ra, memory_init

	
	ldiq	t0, 0x300000
	ldiq	t1, 0x310000
	stq_p	t1, 0(t0)


// ----------------------------------------
// Test fuer Volkmar
	enable_int
	stq_p	zero, L4_LOCK(zero)
	lda	t1, system_cb			// system cb addresse

	ldah	t0, MDB_KBASE(zero)
	stq	t0, SCB_FREE_MAPPING_AREA(t1)
//	debug
	// set no entry in the mapping-db
	stq	zero, SCB_FREE_MAPPING(t1)
//	debug
//	halt/debug
//-----------------------------------------	
	disable_int
		
	bsr	ra, create_sigma0
#if defined(INIT_INTERRUPTS)		// only needed for non eb164 boards
	disable_int
	bsr	ra, init_interrupts
#endif	
	enable_int

// -------------
	
	kmsg	"\n\n\r------------------------------------------\n\r"

	ldiq	t0, 0x10000
2:
	enable_int
	ldiq	a0, 0
	pal	L4_SWITCH_ENTRY
	br	2b
	
testc:
	mtpr	zero, dcFlush
	
	.data
MSG_welcome:
	.ascii	"L4 Kernel for Digital Alpha 21164 - "
	VERSION_COMPILED, "\n\r"
	VERSION_BUILD, " - "
	VERSION_TIME, "\n\r\n\r"
		
#ifdef PERFORMANCE
	.ascii	"Code contains stuff for performance measurement\n\r"
#endif	
	.long	0
.END

