/*
**	Copyright (c) 1995, Sebastian Schoenberg 
**	E-mail : ss10@irz.inf.tu-dresden.de
**
**	University of Technology Dresden, Department of Computer Science
**	Inistute for Operating Systems, Databases and Computer Networks
**
**	$Id: memmap.S,v 5.1 1999/11/09 00:42:15 danielp Exp $
**
*/

/*	DEBUG			- validity-checks
	DEBUG_MSG		- important DEBUG-msgs
	DEBUG_MSG_1		- switch to thread if locked

	DEBUG_NOT_INCLUDING	- only flush excluding own address-space
*/
	
//#define DEBUG
//#define DEBUG_MSG
//#define DEBUG_MSG_1
//#define DEBUG_NOT_INCLUDING

#include <pal/predef.h>
#include <pal/dc21164.h>
#include <pal/regdef.h>
#include <pal/macros.h>

#include <pal/l4pal.h>

#include <pal/gasp.h>

	.text
	.globl	mdb_change_mapping
	.globl	mdb_add_mapping
	.globl	mdb_flush_mapping


.MACRO lock_mapping map_ptr, tmp1, tmp2 
#ifdef DEBUG
	ldl	\tmp2, MDB_O_LOCKING_THREAD(\map_ptr)
	ldiq	\tmp1, TID_M_TASKTHREAD
	and	\tmp2, \tmp1, \tmp2
	beq	\tmp2, 9f
	debug	
9:
#endif	
	tcb	\tmp1
	srl	\tmp1, TID_S_TASKTHREAD, \tmp1
	ldiq	\tmp2, TID_M_TASKTHREAD
	and	\tmp1, \tmp2, \tmp1
	ldl	\tmp2, MDB_O_LOCKING_THREAD(\map_ptr)
#if 0
	srl	\tmp2, TID_B_TASKTHREAD, \tmp2
	sll	\tmp2, TID_B_TASKTHREAD, \tmp2
#endif
	or	\tmp1, \tmp2, \tmp1	
	stl	\tmp1, MDB_O_LOCKING_THREAD(\map_ptr)
.ENDM

/* locks an entry and decrements the semaphore
   normaly called when the lock was taken from an entry and the thread rerun */
.MACRO	lock_and_dec map_ptr, remaining, tmp1
#ifdef DEBUG
	ldl	\remaining, MDB_O_LOCKING_THREAD(\map_ptr)
	ldiq	\tmp1, TID_M_TASKTHREAD
	and	\remaining, \tmp1, \remaining
	beq	\remaining, 9f
	debug	
9:
#endif
	tcb	\tmp1						// get the locking thread
	srl	\tmp1, TID_S_TASKTHREAD, \tmp1
	ldiq	\remaining, TID_M_TASKTHREAD
	and	\tmp1, \remaining, \tmp1			// mask the needed bits
	ldl	\remaining, MDB_O_LOCKING_THREAD(\map_ptr)	// load the old mapping
	or	\remaining, \tmp1, \remaining			// mix it, must be unlocked!!!
	ldiq	\tmp1, 1
	sll	\tmp1, TID_B_TASKTHREAD, \tmp1
	//ldiq	\tmp1, (1<<TID_B_TASKTHREAD)			// the semaphore is shifted to the left
	subl	\remaining, \tmp1, \remaining			// dec. the semaphore
	stl	\remaining, MDB_O_LOCKING_THREAD(\map_ptr)	// write it back
	srl	\remaining, TID_B_TASKTHREAD, \remaining	// return value!
.ENDM

	
		
.MACRO	unlock_mapping	map_ptr, remaining
	ldl	\remaining, MDB_O_LOCKING_THREAD(\map_ptr)
	srl	\remaining, TID_B_TASKTHREAD, \remaining	// mask the tid!
	sll	\remaining, TID_B_TASKTHREAD, \remaining	
	stl	\remaining, MDB_O_LOCKING_THREAD(\map_ptr)
#ifdef DEBUG
	srl	\remaining, TID_B_TASKTHREAD, \remaining
#endif
.ENDM

/* lock_entry is the value of MDB_O_LOCKINGTHREAD(<ptr>) */
.MACRO switch_to_locking_thread lock_entry
	ldiq	a0, TID_M_TASKTHREAD
	ldl	\lock_entry, MDB_O_LOCKING_THREAD(\lock_entry)
	and	\lock_entry, a0, \lock_entry
	beq	\lock_entry, 9f
	sll	\lock_entry, TID_S_TASKTHREAD, \lock_entry
	tcb_ptr	\lock_entry, a0
	push	p_a1|p_a2
	ldq	a1, TCB_MYSELF(a0)
	tcb_ptr	a1, a2
	xor	a2, a0, a2
	beq	a2, 8f
	debug
8:	
	pop	p_a1|p_a2
	pal	L4_SWITCH_ENTRY
9:	
.ENDM
	
.MACRO	inc_semaphore	map_ptr, tmp1, tmp2
	ldl	\tmp1, MDB_O_LOCKING_THREAD(\map_ptr)
	ldiq	\tmp2, 1
	sll	\tmp2, TID_B_TASKTHREAD, \tmp2
	addl	\tmp2, \tmp1, \tmp1
	stl	\tmp1, MDB_O_LOCKING_THREAD(\map_ptr)
	srl	\tmp1, TID_B_TASKTHREAD, \tmp1
.ENDM

.MACRO	dec_semaphore	map_ptr, count, tmp1
	ldl	\tmp1, MDB_O_LOCKING_THREAD(\map_ptr)
	ldiq	\count, 1
	sll	\count, TID_B_TASKTHREAD, \count
	subl	\tmp1, \count, \tmp1
	stl	\tmp1, MDB_O_LOCKING_THREAD(\map_ptr)
	srl	\count, TID_B_TASKTHREAD, \count
.ENDM

.MACRO	unlink_mapping	map_ptr, tmp1, tmp2, tmp3
	ldl	\tmp1, MDB_O_PREV(\map_ptr)
	blbc	\tmp1, 9f				// not the first entry
// the entry is the first and it is linked
	ldl	\tmp2, MDB_O_NEXT(\map_ptr)		// get the next-ptr
	xor	\tmp1, \tmp2, \tmp3			// are both entries equal?
	bne	\tmp3, 7f
	bic	\tmp1, 0x0f, \tmp1			// yes they are equal, so only unlink from parent
	beq	\tmp1, 8f				// if the parent is sigma0 or the entry is unlinked  the ptr. is NULL - finished
	stl	zero, MDB_O_CHILD(\tmp1)		
	br	8f

7:	bic	\tmp1, 0x0f, \tmp3			//tmp1 is the parent
	stl	\tmp2, MDB_O_CHILD(\tmp3)
	stl	\tmp1, MDB_O_PREV(\tmp2)		// set the previous ptr. of the new first to the parent
	br	8f
9:	ldl	\tmp2, MDB_O_NEXT(\map_ptr)		// link the entry to the next
	stl	\tmp2, MDB_O_NEXT(\tmp1)
	blbs	\tmp2, 8f				// the next is the parent, and this is ready linked
	stl	\tmp1, MDB_O_PREV(\tmp2)
8:
/*
	ldl	\tmp1, MDB_O_PREVINTASK(\map_ptr)
	ldl	\tmp2, MDB_O_NEXTINTASK(\map_ptr)
	blbc	\tmp1, 9f				// the previous is not the index-field

	ldah	\tmp3, 0xc000(zero)
	s4addq	\tmp3, \tmp1, \tmp1			// Generate 0xffffffff.........

	bic	\tmp1, 1, \tmp3				// the address of the index-field
	stl	\tmp2, 0(\tmp3)				// write the first entry new!
	br	8f
9:	stl	\tmp2, MDB_O_NEXTINTASK(\tmp1)
8:	beq	\tmp2, 9f				// the next entry is zero - don't link in
	stl	\tmp1, MDB_O_PREVINTASK(\tmp2)
9:*/	
			
.ENDM

.MACRO	add_to_free_list  list_ptr, map_ptr, tmp
	bne	\list_ptr, 8f
	mov	\map_ptr, \list_ptr
	stq	\map_ptr, 0(\map_ptr)
	br	9f
8:
	ldq	\tmp, 0(\list_ptr)	// next from listhead
	stq	\tmp, 0(\map_ptr)	// next to old next of the listhead
	stq	\map_ptr, 0(\list_ptr)
9:	stq	zero, 8(\map_ptr)
	stq	zero, 16(\map_ptr)
	stq	zero, 24(\map_ptr)
.ENDM

	
/*
.MACRO kmsg s
.ENDM

.MACRO khex x, y=0
.ENDM
*/

			
/*
** mapping entry:
**
**	+-.-.-.-.-.-.-.-:-.-.-.-.-.-.-.-;-.-.-.-.-.-.-.-:-.-.-.-.-.-.-.-+
**	|								|
**	+-.-.-.-.-.-.-.-:-.-.-.-.-.-.-.-;-.-.-.-.-.-.-.-:-.-.-.-.-.-.-.-+
**	|								|
**	+-.-.-.-.-.-.-.-:-.-.-.-.-.-.-.-;-.-.-.-.-.-.-.-:-.-.-.-.-.-.-.-+
**
**	---------------------------------------------------
**	| semaphore(32b)       |     locking thread (32b) |	+24
**	---------------------------------------------------
**	| next in task (32b)   | prev in task (32b)       |	+16
**	---------------------------------------------------
**
**	---------------------------------------------------
**	| nu (6) |  task nr 10b |	  v-addr 43b      |	+8
**	---------------------------------------------------
**	| child 28b            |xxx|c| next 28b   |x|r|v|l|	+0
**	---------------------------------------------------
**		l - last in hierarchie
**		v - invalid (flushing process is running...)
**		r - root - flushing bit
**		c - child is valid
**
**	empty-list:	
**	---------------------------------------------------
**	|                unknown                          |
**	---------------------------------------------------
**	|                   next                          |
**	___________________________________________________
**		the last entry has 0000.0000.0000.0000 as next
*/



/*------------------------------------------------------------------------------
** FUNCTION:mdb_change_mapping
**	change mapping entry in data base
**	to task given in a4
**  
** INPUT PARAMETERS:  
**	a0  - virt. Address
**	a2  - pte* src
**	a3  - pte* dest
**	a4  - TCB dest
**	
**
** OUTPUT PARAMTERES:
** 
** SIDE EFFECTS
**	Scratches:	t0, t1, t2, t3, t4, t5 
*/	
mdb_change_mapping:
	// int's must be disabled
	push p_ra
	IFZ a2			// granting from sigma 0 is not allowed
		kmsg	"Tried to grant from Sigma0 - not allowed\n\r"
		halt
	ENDIF
	// create the ptr to the mapping db in t5
	ldq_p	t1, 8(a2)			// ptr to mapping data base
	and	t1, 0xff, t2			// create ptr to the mapping-entry
	extwl	t1, 2, t1			// from the used bits of the tlb-entry
	inswl	t1, 1, t1
	or	t1, t2, t1
	sll	t1, 4, t1
	
	ldah	t1, MDB_KBASE(t1)		// create address ffffffff.dxxxyyyz
	bic	t1, 0x0f, t5
	ldl	t0, MDB_O_LOCKING_THREAD(t5)	// check for lockings...
	beq	t0, 1f				// no lock and int's are disabled - go on, it's atomic!
	ldq	t0, MDB_O_VADDR(t5)		// get the virtual address and check for the operation holding the lock
	blbs	t0, mdb_mapping_error		// the virtual address is set to -1, so there is a flush o the way!
1:	
// t5 is the mapping-entry-pointer
	
	// take the entry out of the old task-list!
	// names: entry1 <-> entry2 <-> entry3
	ldl	t0, MDB_O_PREVINTASK(t5)	// prev in task
	ldl	t1, MDB_O_NEXTINTASK(t5)	// next in task
	IFLBS	t0
		IF	t1
			stl	t1, MDB_O_NEXTINTASK(t0)	// entry1.next=entry3
			stl	t0, MDB_O_PREVINTASK(t1)	// entry3.prev=entry1
		ELSE
			stl	zero, MDB_O_NEXTINTASK(t0)	// entry1.next=0 - no next
		ENDIF
	ELSE							// the granted entry was the first of the list
		IF t1						// was it the only one???
			stl	zero, MDB_O_PREVINTASK(t1)	// entry3.prev=0
		ENDIF
		// because the entry1 is zero - and so entry2 was the firt one - 
		// we have to set entry3 as first in task!
		tcb	t2
		srl	t2, TID_S_TASK, t2
		ldiq	t3, TID_M_TASK
		and	t2, t3, t2

		lda	t4, pal_ptmaps
		s8addq	t2, t4, t4		// t4 is the ptr to the first in task-entry
		stl	t1, 0(t4)
	ENDIF

// the entry is now out of the old task-list - now put it on the top of the receiver!
	// first set the virtual address and task-id
	srl	a4, TID_S_TASK, t2		// generate the task-id for the entry
	ldiq	t3, TID_M_TASK
	and	t2, t3, t2

	lda	t4, pal_ptmaps
	s8addq	t2, t4, t4			// t4 is phys address of ptmap's per task.
		
	sll	t2, 48, t2			// task nr is in bit 48 to 58
	or	t2, a0, t2			// and the virtual addr.
	stq	t2, MDB_O_VADDR(t5)		// write the entry to the list
	// Ok - the new task-id and virtual address is set. now the pointers...

	ldl	t3, 0(t4)			// the old first entry
	stl	t3, MDB_O_NEXTINTASK(t5)	// set the next-in-task-value
	IF	t3				// if the next is not NULL, store the new as prev.
		stl	t5, MDB_O_PREVINTASK(t3)
	ENDIF
	or	t4, 1, t4			// previous is the index-entry - so set bit 1
	stl	t4, MDB_O_PREVINTASK(t5)	// set the prev-in-task-value of the new entry to zero
	enable_int
	clr	v0				// set return value to ok!
	
	pop	p_ra
	ret	(ra)


	

	
/*------------------------------------------------------------------------------
** FUNCTION:mdb_add_mapping
**	insert a mapping entry into the "tree", using the free entry or
**	an entry from the free-list
**  
** INPUT PARAMETERS:  
**	a0  - virt. Address
**	a2  - pte* src
**	a3  - pte* dest
**	a4  - TCB dest
**	
**
** OUTPUT PARAMTERES:
** 
** SIDE EFFECTS
**	Scratches:	t0, t1, t2, t3, t4, t5, t12 
*/

.MACRO scb_test reg
		beq	\reg, 7f
			zap	\reg, 0xf, AT
			IFZ	AT
				kmsg	"SCB Failed"
				debug
			ENDIF
7:	
.ENDM	

	
mdb_add_mapping:
	// int's are disabled!!!
	push	p_ra
	// rpcc	t0
	// push	p_t0
	IF	a2
		ldq_p	t1, 8(a2)			// ptr to mapping data base

		and	t1, 0xff, t2			// create ptr to the mapping-entry
		extwl	t1, 2, t1			// from the used bits of the tlb-entry
		inswl	t1, 1, t1
		or	t1, t2, t1
		sll	t1, 4, t1
	
		ldah	t1, MDB_KBASE(t1)		// create address ffffffff.dxxxyyyz
		bic	t1, 0x0f, t5			// -- '' --        ffffffff.dxxxyyy0
#ifdef PTEFAIL
		debug
#endif	
		ldl	t0, MDB_O_LOCKING_THREAD(t5)	// t0=thread-id and semaphore of the locking thread
		beq	t0, 1f
		ldq	t0, MDB_O_VADDR(t5)		// load the virtual address to check the type of flush!
		blbs	t0, mdb_mapping_error		// the virtual address is unaligned so there is a flush on the run!
	ENDIF
1:	
	lda	v0, system_cb
	ldq	t0, SCB_FREE_MAPPING(v0)	// the ptr of the first free entry
	IFZ	t0
		ldq	t0, SCB_FREE_MAPPING_AREA(v0)	// the ptr of the first free mapping in the mapping area
		addq	t0, 32, t6			// set to the next entry
		stq	t6, SCB_FREE_MAPPING_AREA(v0)	// write back the new address
	ELSE
		// t0 is the ptr to the first free mapping
		ldq	t1, 0(t0)			// the ptr of the second free entry
		stq	t1, SCB_FREE_MAPPING(v0)	// store the "new" first-ptr
		mov	t6, zero
	ENDIF
	// security!!!
	stq	zero, 0(t0)
	stq	zero, 8(t0)
	stq	zero, 16(t0)
	stq	zero, 24(t0)
	
// t0 - ptr to the free entry
	ldq_p	t1, 8(a3)			//  from the PTE-entry of the dest. task
	IFZ	t1
		kmsg "ist null!!!\n\r"
		debug
	ENDIF
	
	zap	t1, 0x0d, t1			// clear bits from PTE
	srl	t0, 4, t3
	and	t3, 0xff, t2
	or	t2, t1, t1
	extwl	t3, 1, t2
	inswl	t2, 2, t2
	or	t2, t1, t1			// set the new address
	stq_p	t1, 8(a3)			// write the new mapping entry into the PTE
	
// t0 - destination map-entry-pointer
// t5 - source map-entry-pointer

// now generate the new entry (+8) in t2 (task and v-addr.)
	srl	a4, TID_S_TASK, t2
	ldiq	t3, TID_M_TASK
	and	t2, t3, t2

	lda	t4, pal_ptmaps
	s8addq	t2, t4, t4			// t4 is phys address of ptmap's per task.
		
	sll	t2, 48, t2			// task nr is in bit 48 to 58
	or	t2, a0, t2			// and the virtual addr.
	stq	t2, MDB_O_VADDR(t0)		// write the entry to the list


// relinking the task-mapping-list	
//	t4 = task_mapping_ptr
	ldl	t3, 0(t4)			// t3 = first mapping entry of the task
	stl	t0, 0(t4)			// now the new entry is the first of the list

	IF t3					// only to set if there was already an entry
		stl	t0, MDB_O_PREVINTASK(t3)	// the prev of the old first is set
	ENDIF
	stl	t3, MDB_O_NEXTINTASK(t0)	// the next-of-task in the new entry to the old first
	or	t4, 1, t2			// the first entry points to the index-field for easy unlink! 
	stl	t2, MDB_O_PREVINTASK(t0)	// write the entry to the mapping
	stl	zero, MDB_O_LOCKING_THREAD(t0)	// clear the flush-in-progress-field
	
// now the lowest part of the mapping entry in t2
// first - change the child-pointer of the source-task
	IF	a2				// not Sigma0 ?
		ldl	t2, MDB_O_CHILD(t5)			// t2 = source.child

#ifdef PTEFAIL	
		debug
#endif	
		IF	t2				// the child-entry is valid
			// create the new next entry from the old child.
			stl	t2, MDB_O_NEXT(t0)	// save old child ptr in new's next entry
			ldl	t1, MDB_O_PREV(t2)	// get the prev-pointer of the old first child (should point to parent with lowest bit set!)
			stl	t0, MDB_O_PREV(t2)	// set the prev. entry of the old first one
			stl	t1, MDB_O_PREV(t0)	// the first entry points to the parent
			stl	t0, MDB_O_CHILD(t5)	// write the new child-addr. to parents entry

		// the child addr. is invalid
		ELSE					
			stl	t0, MDB_O_CHILD(t5)	// store the new child in parent entry
			or	t5, 1, t1		// next address with lowest bit set for up in hierarchy
			stl	t1, MDB_O_NEXT(t0)
			stl	t1, MDB_O_PREV(t0)	// the first and the last entry points to the parent
		ENDIF					// write t2 back to the new entry...
		stl	zero, MDB_O_CHILD(t0)		// clear child-entry of the new field
#ifdef PTEFAIL	
		debug
#endif
	ELSE
		stl	zero, MDB_O_CHILD(t0)		// no child entry
		ldiq	t1, 1				// last, but no valid ptr.
		stl	t1, MDB_O_NEXT(t0)		// write next entry
		stl	t1, MDB_O_PREV(t0)		// write prev. entry
	ENDIF

	// accounting-information for task
	ldiq	t0, (TID_M_THREAD << TID_S_THREAD)
	bic	a4, t0, t0
	ldq	t1, TCB_MDB_ACCOUNT(t0)
	addq	t1, 1, t1
	stq	t1, TCB_MDB_ACCOUNT(t0)
		
	enable_int				// ei

	// for real-time capabilities touch the new first entry of the mapping-db
	/*lda	t0, system_cb
	ldq	t0, SCB_FREE_MAPPING_AREA(t0)
	ldq	t0, 0(t0)*/
	
	clr	v0				// return-code
	pop	p_ra
	ret	(ra)


mdb_mapping_error:
	enable_int
	ldiq	v0, 1				// return-code
	kmsg	"*"
#ifdef DEBUG_MSG
	kmsg	"Map: Parent ("
	khex	t5, 64
	kmsg	") locked by "
	ldl	t1, MDB_O_LOCKING_THREAD(t5)
	ldiq	t2, TID_M_TASKTHREAD
	and	t1, t2, t1
	sll	t1, TID_S_TASKTHREAD, t1
	khex	t1, 32
	kmsg	"\n\r"
#endif
	pop	p_ra
	ret	(ra)
	

/*--------------------------------------------------------------------------------------
** FUNCTION:	mdb_flush_mapping
** 	flush the given mapping of the current task and all sub-mappings
**	from the current address space
**
** PARAMETERS:
**	t3	- virtual address
**	t7	- page table entry (current task)
**	a0	- flexpage mask				
**		bit 1 set - ro |  bit 0 unset flush;  
**		bit 0 set including | bit 1 unset excluding own as.
**
** SCRATCH:
**	t0, t1, t2, t5
*/
mdb_flush_mapping:
	// this function is called with disabled int's
#ifdef DEBUG_NOT_INCLUDING
	clr	a0				// for test only
#endif
	push	p_ra
	beq	t7, mdb_sigma0error		// is it NOT sigma0?
	ldq_p	t1, 8(t7)			// ptr to mapping data base

	IFZ	t1
		kmsg "PTE is clean"
		debug
	ENDIF

	
	and	t1, 0xff, t2			// create ptr to the mapping-entry
	extwl	t1, 2, t1			// from the used bits of the tlb-entry
	inswl	t1, 1, t1
	or	t1, t2, t1
	sll	t1, 4, t1

	ldah	t1, MDB_KBASE(t1)		// create address ffffffff.dxxxyyyz
	bic	t1, 0x0f, t5

	// check if already flushing in progress...
	ldl	t2, MDB_O_LOCKING_THREAD(t5)	// check, if the mapping is in a flush...
	ldiq	t1, TID_M_TASKTHREAD
	and	t2, t1, t2
	IF	t2
		inc_semaphore	t5, t1, t2
#ifdef	DEBUG_MSG
		khex	t5, 64
		kmsg	" - entry is locked by "
		khex	t1, 16
		kmsg	" threads\n\r"
#endif
1:	
		enable_int		
		push	p_a0|p_a1|p_t5|p_t6
		switch_to_locking_thread	t5
		pop	p_a0|p_a1|p_t5|p_t6
		disable_int
		ldl	t2, MDB_O_LOCKING_THREAD(t5)
		ldiq	t1, TID_M_TASKTHREAD
		and	t2, t1, t2
#ifdef	DEBUG_MSG_1
		IF	t2
			kmsg	"switching to thread: "
			sll	t2, TID_S_TASKTHREAD, t1
			khex	t1, 32
			kmsg	"\n\r"
		ENDIF
#endif
		bne	t2, 1b
		kmsg	"locking gone... "	
		lock_and_dec	t5, t1, t2
#ifdef	DEBUG_MSG
		kmsg	"lock: "
		khex	t5, 64
		kmsg	"remaining: "
		khex	t1, 16
		kmsg	"\n\r"
#endif
		ldq	t3, MDB_O_VADDR(t5)
		IFLBS	t3	// the addr. is invalid don't process the entry
			IFZ	t1	// am i the last in the semaphore - it's my job
				unlink_mapping	t5, t1, t2, t3
				stq	zero, 8(t5)
				stq	zero, 16(t5)
				stq	zero, 24(t5)
#ifdef	DEBUG_MSG
				kmsg "put mapping in free-list\n\r"
#endif
				lda	v0, system_cb
				ldq	t2, SCB_FREE_MAPPING(v0)
				stq	t2, 0(t5)
				//scb_test t5
				stq	t5, SCB_FREE_MAPPING(v0)

			ELSE
				unlock_mapping	t5, t1
#ifdef DEBUG
				kmsg "locked semaphore and entry already invalid - don't do anything, remaining: "
				khex	t1, 16
#endif
			ENDIF
			//debug
			enable_int
			pop	p_ra
			ret (ra)
		XENDIF
	ELSE
		lock_mapping	t5, t1, t2
	ENDIF
	clr	t6
	ldl	t0, MDB_O_CHILD(t5)
	and	a0, 2, t3
	IF	t3		// it's only the ro-call
		enable_int
		IF	t0
			push	p_a0|p_t5
			kmsg	"mdb_flush_tree_ro not implemented yet!"
			debug
			bsr	ra, mdb_flush_tree_ro
			pop	p_a0|p_t5
		ENDIF
		IFLBS	a0	// including own address-space
			kmsg "call flush ro in bastels routine... :-o"
		ENDIF
	ELSE
		IFLBS	a0					// if it is a flush including own AS
			ldq	t1, MDB_O_VADDR(t5)
			or	t1, 1, t1			// first set the vaddr to invalid, that no new mappings
			stq	t1, MDB_O_VADDR(t5)		// can be established!
		ENDIF
		IF	t0
			stl	zero, MDB_O_CHILD(t5)		// first unlink the subtree!!!
			enable_int				// now map and grant are allowed!
			push	p_a0|p_t5
			bsr	ra, mdb_flush_tree_remove
			pop	p_a0|p_t5
		ENDIF
		IFLBS	a0		// flush tree including own address-space - set entry to invalid
			push	p_t5|p_t6				
			ldq	t3, MDB_O_VADDR(t5)
			bic	t3, 1, t3
			srl	t3, 48, t0				// double-shifting for masking
			sll	t0, TID_S_TASK, t0
			zapnot	t3, 0x3f, t3				// t3 is the virtual address
			ldiq	t6, PP_INTREE
			bsr	ra, mem_translate_address		// translate the address for flush!
			IFZ	a1
				kmsg	"mdb_flush_mapping: mem_translate_address fail\n\r"
				pop	p_t5|p_t6
				debug
			ELSE
				mov	t7, a2
				bsr	mem_flush_tlbpte
				pop	p_t5|p_t6
			ENDIF
// now remove the entry
// if someone is waiting in the semaphore, don't unlink the item, for db consistency!
			disable_int
			ldl	t0, MDB_O_LOCKING_THREAD(t5)
			srl	t0, TID_B_TASKTHREAD, t0
			IFZ	t0	// no more waiting threads? So unlink the entry!!!
				//kmsg "flush_inc: no waiting threads"
				unlink_mapping	t5, t0, t1, t2
				add_to_free_list	t6, t5, t0
				br	1f	
			ELSE
				kmsg "flush_inc: waiting threads"
				khex	t5, 64
				//debug
			ENDIF
		ENDIF
	ENDIF
	disable_int
	unlock_mapping	t5, t0
#ifdef DEBUG
	IF	t0
		kmsg "unlock semaphore for waiting threads\n\r"
	ENDIF
#endif
1:	
	IF	t6					// relink the free-list
		disable_int
		lda	v0, system_cb
		ldq	t0, SCB_FREE_MAPPING(v0)	// the ptr of the first free entry
		ldq	t2, 0(t6)			// t2=t6.next of the ring-list - our new first entry		
		stq	t0, 0(t6)
		stq	t2, SCB_FREE_MAPPING(v0)
	ENDIF
	enable_int
	pop	p_ra
	ret	(ra)

mdb_sigma0error:	
	nop
	kmsg	"Sigma 0 cannot flush !\n\r"
	ldiq	v0, 2
	pop	p_ra
	ret	(ra)

// increase the semphore and look after a while if the other one is ready
// t2 is the locking thread

	


/* ----------------------------------------------------------------------------------
**	FUNCTION:	flush the subtree, and wait, if the items are locked, until
**			locking thread is ready
**	PARAMETERS:	t0 - the first entry in the child-list,
**			t6 - ring-list for freed entries, at startup zero
**
**	SIDE-EFFECTS:
**		scratches:	t0, t1,t2, t3, t4
**
*/
mdb_flush_tree_remove:
	push	p_ra
mdb_flush_loop:
	IFZ	t0
		kmsg	"flush-entry is invalid"
		debug
	ENDIF
	disable_int
	ldl	t1, MDB_O_LOCKING_THREAD(t0)
	ldiq	t2, TID_M_TASKTHREAD
	and	t1, t2, t1
	IF	t1			// is there any one flushing this entry?
#ifdef DEBUG
		kmsg "entry locked\n\r"
		//debug
#endif
		inc_semaphore	t0, t1, t2
mdb_flush_lock_loop:
		enable_int		
		push	p_t0|p_t6|p_t5		// save the ptr to the mapping entry
		switch_to_locking_thread t0
		pop	p_t0|p_t6|p_t5
		disable_int
		ldl	t1, MDB_O_LOCKING_THREAD(t0)
		ldiq	t2, TID_M_TASKTHREAD
		and	t1, t2, t1
#ifdef DEBUG_MSG_1
		IF	t1
			kmsg	"Switching to thread "
			sll	t1, TID_S_TASKTHREAD, t2
			khex	t2, 32
			kmsg	"\n\r"
		ENDIF
#endif
		bne	t1, mdb_flush_lock_loop			// is the flushing thread on the run - switch to them...
		lock_and_dec	t0, t1, t2
		kmsg	"got lock\n\r"
	ELSE
		lock_mapping	t0, t1, t2
	ENDIF

	ldq	t3, MDB_O_VADDR(t0)
	IFLBC	t3
		or	t3, 1, t3
		stq	t3, MDB_O_VADDR(t0)			// entry will be flushed
		enable_int
		ldl	t2, MDB_O_CHILD(t0)
		IF	t2					// is there a child?
			stl	zero, MDB_O_CHILD(t0)		// unlink the child-ptr
			bic	t2, 0x0f, t0
			br	mdb_flush_loop			// tag subtree
		XENDIF
#ifdef PTEFAIL
		khex t3
		kmsg "no more childs..."
		debug
#endif	
mdb_flush_no_lock_loop:	
		ldq	t3, MDB_O_VADDR(t0)
		bic	t3, 1, t3
		push	p_t0|p_t6|p_t5
		srl	t3, 48, t0				// double-shifting for masking
		sll	t0, TID_S_TASK, t0
		zapnot	t3, 0x3f, t3				// t3 is the evirtual address
		ldiq	t6, PP_INTREE
		disable_int
		bsr	ra,mem_translate_address		// translate the address for flush!
		IFZ	a1
			pop	p_t0|p_t6|p_t5
			kmsg	"mdb_flush_tree: mem_translate_address returned with fail\n\r"
			debug
		ELSE
#ifdef DEBUG
			pop	p_t5
			push	p_t5
			tcb	t2
			srl	t2, TID_S_TASKTHREAD, t2
			ldiq	t3, TID_M_TASKTHREAD
			and	t2, t3, t2
			ldl	t4, MDB_O_LOCKING_THREAD(t5)
			and	t4, t3, t4
			cmpeq	t2, t4, t3
			IFZ	t3
				kmsg	"locking thread is not the flusher!"
			ENDIF
#endif
#ifdef PTEFAIL	
#if 0 
			kmsg	"flush:	"
			khex	t3, 64
			kmsg	"\n\r"
#else 
			kmsg	"."
#endif
#endif	
			mov	t7, a2
			bsr	mem_flush_tlbpte
			pop	p_t0|p_t6|p_t5					// restore ptr!
		ENDIF
	ELSE
#ifndef DEBUG_MSG
		kmsg "entry flushed by another thread"
#endif
	ENDIF

	ldl	t2, MDB_O_NEXT(t0)			// the next-ptr
	unlock_mapping	t0, t1
	IFZ	t1					// no waiting thread - so put the entry into the ring-list
		add_to_free_list	t6, t0, t1
	ELSE						// there are waiting thread - don't care about the entry
//#ifdef DEBUG_MSG
		kmsg "freed entry is locked"
//#endif!
		ldiq	t1, 1
		stl	t1, MDB_O_NEXT(t0)
		stl	t1, MDB_O_PREV(t0)
	ENDIF
	bic	t2, 0x0f, t0
	cmpeq	t0, t5, t3
	IF	t3		// the entries are equal we are back on top - return!!!
		pop	p_ra
		ret	(ra)
	XENDIF
	blbc	t2, mdb_flush_loop	// it's not the last on this level - we to check
	br	mdb_flush_no_lock_loop	


mdb_flush_tree_ro:
	push	p_ra
mdb_flush_loop_ro:
	IFZ	t0
		kmsg "mdb_flush_ro: invalid child"
		pop	p_ra
		ret	(ra)
	ENDIF
	disable_int
	ldl	t1, MDB_O_LOCKING_THREAD(t0)
	ldiq	t2, TID_M_TASKTHREAD
	and	t1, t2, t1
	IF	t1			// is there any one flushing this entry?
		inc_semaphore	t0, t1, t2
mdb_flush_lock_loop_ro:
		enable_int		
		push	p_t0|p_t6|p_t5		// save the ptr to the mapping entry
		switch_to_locking_thread t0
		pop	p_t0|p_t6|p_t5
		disable_int
		ldl	t1, MDB_O_LOCKING_THREAD(t0)
		ldiq	t2, TID_M_TASKTHREAD
		and	t1, t2, t1
		bne	t1, mdb_flush_lock_loop			// is the flushing thread on the run - switch to them...
		lock_and_dec	t0, t1, t2
	ELSE
		lock_mapping	t0, t1, t2
	ENDIF
	ldq	t3, MDB_O_VADDR(t0)
	IFLBC	t3
		ldl	t2, MDB_O_CHILD(t0)
		IF	t2
			mov t2, t0
			br	mdb_flush_loop_ro
		XENDIF

mdb_flush_no_lock_loop_ro:
		ldq	t3, MDB_O_VADDR(t0)
		push	p_t0|p_t6|p_t5
		srl	t3, 48, t0				// double-shifting for masking
		sll	t0, TID_S_TASK, t0
		zapnot	t3, 0x3f, t3				// t3 is the evirtual address
		ldiq	t6, PP_INTREE
		disable_int
		bsr	ra, mem_translate_address		// translate the address for flush!
		IFZ	a1
			pop	p_t0|p_t6|p_t5
			kmsg	"mdb_flush_tree: mem_translate_address returned with fail\n\r"
			debug
		ELSE
			mov	t7, a2
			//bsr	mem_flush_tlbpte
			kmsg	"add: flush_ro"
			pop	p_t0|p_t6|p_t5					// restore ptr!
		ENDIF
	ENDIF
	ldl	t2, MDB_O_NEXT(t0)
	unlock_mapping	t0, t1
	bic	t2, 0x0f, t0
	cmpeq	t0, t5, t3
	IF	t3
		pop	p_ra
		ret	(ra)
	XENDIF
	blbc	t2, mdb_flush_loop_ro
	br	mdb_flush_no_lock_loop_ro
			
			
.END		



