/*
**	Copyright (c) 1995, Sebastian Schoenberg 
**	E-mail : ss10@irz.inf.tu-dresden.de
**
**	University of Technology Dresden, Department of Computer Science
**	Institute for Operating Systems, Databases and Computer Networks
**
**	$Id: pagefault.S,v 5.1 1999/07/22 06:33:01 danielp Exp $
**
*/

#if !defined(lint)
	.data
	.asciz	"$Id: pagefault.S,v 5.1 1999/07/22 06:33:01 danielp Exp $"
#endif


#include <pal/predef.h>

#include <pal/dc21164.h>
#include <pal/regdef.h>
#include <pal/macros.h>

#include <pal/l4pal.h>

#include <pal/gasp.h>	

/*
**	Page Fault handling in L4 alpha
**	===============================
**
**	The Guarded Page Tables, completely written in PALcode try to parse the GPT tree.
**	If this is not possible, one of the following entrypoints is entered. Which one is selected,
**	depends on the cause of the fault.
**
**	(i/d)tb_guard_fault
**	-------------------
**	During parsing the tree a missmatch between exception address and guard is occured. The handler
**	can communicate with an external pager to receive a flexpage, which one will be mapped at the address.
**	
**	(i/d)tb_protection_fault
**	---------------------
**	The entry in the guarded page table is valid, but does not match the required protection, i.e. access
**	to a page in kernel area, while running in user mode, or a write access to a read-only page.
**
**	(i/d)tb_access_fault
**	--------------------
**	Originally, this entry does not belong to the both above, but depends on TB entries. This entry is
**	always called, if an entry in the TB is valid, but satisfies not the required permissions. I.e. a page 
**	is read-only in the GPT. The first access was a read access. After that, the TB contains the entry, marked
**	as the GPT permission it requires as read-only. Hence, a further write access leads NOT to an 
**	(i/d)tb_proetection_fault but to an (i/d)tb_access_fault
**
**
**	Input arguments
**	===============
**
**	Input arguments for
**
**	(i/d)tb_guard_fault
**	-------------------
**		a0:	fault_address
**		a1:	instruction address on D-faults
**		a2:	fault mask
**	
**	Return from code
**	================
**
**	The code has to return to PALcode, immediately after handling the fault to the entry point with following
**	sequence. 
**	
**		return	(ret_itb_fill)
**		return	(ret_itb_schedule)
**		return	(ret_itb_rerun)
**
**	for an ITB fault or
**
**		return	(ret_dtb_fill)
**		return	(ret_dtb_schedule)
**		return	(ret_dtb_rerun)
**
**	for a DTB fault.
**
**	ret_*tb_fill:	
**		a0 :	virtual address
**		a1 :	TB entry
**	
**		bit's [63..00] contain an entry, valid to write into the TB
**		the fault-causing instruction will be rerunned.
**
**	ret_*tb_schedule:	
**		the scheduler is invoked, The return address points to the old instruction
**		Usefull, if thread is aborted or state has been changed.
**
**	ret_*tb_flush:	
**		the DTB/ITB cache will be flushed, the instruction will be rerunned.
**			
**
**	ret_*tb_rerun:	
**		rerun the instruction
**	
**	Code requirements
**	=================
**
**	The handler code has to be reentrant, must not contain semaphores, that denies nested processing while
**	processing code, that is protected by this semaphore.
**
**	All registers, excepting a0, a1 and a2 must be preserved across the handler.
**
**	The stack pointer has to point to oringinal address !
**
**	Messages
**	========
**		t0:	Fault address |0|w|I
**		t1:	instruction address
*/


	.globl	l4_itb_guard_fault
	.globl	l4_itb_protection_fault
	.globl	l4_itb_access_fault

	.globl	l4_dtb_guard_fault
	.globl	l4_dtb_protection_fault
	.globl	l4_dtb_access_fault

	.globl	l4_dtb_tcb_fault
	
	.text

	
/*------------------------------------------------------------------------------
** FUNCTION:
**
**	itb_guard_faults will be handled here
**	this means, the page is not present.
**
** INPUT PARAMETERS:  
**
**	a0:	exception_address
**	a1:	guard fault type
**
** OUTPUT PARAMTERES:
**
** SIDE EFFECTS
**
*/
	ALIGN_BRANCH
l4_itb_guard_fault:
	store	(4)
	kpush	(a0, 0)
	kpush	(a1, 1)
	kpush	(t0, 2)
	kpush	(t1, 3)
	srl	sp, TID_S_TASK, t0		// Check for sigma 0 task !
	ldiq	t1, TID_M_TASK
	and	t0, t1, t0
	cmpeq	t0, TASK_SIGMA0, t0
	IF	t0
		extll	a0, 4, a1
		addl	a1, 1, a1
		IF	a1			// ffffffff.xxxxxxxx addresses don't belong to sigma 0
						// Ok, sigma 0 prot fault.
			ldiq	a1, P_SIGMA0BASE
			cmplt	a0, a1, a1
			IFZ	a1  

				srl	a0, 13, a1			// PFN
				sll	a1, 32, a1			// insert PFN into a1
				ldiq	t0, 0x0f00			// attributes
				or	t0, a1, a1

				kpop	(t0, 2)
				kpop	(t1, 3)
				load	(4)
				return	ret_itb_fill
			XENDIF
		ENDIF
		khex	a0
		kmsg	" - Invalid Sigma0 I-access\n\r"
		debug
		halt
	ENDIF

	kpop	(a0, 0)
	kpop	(a1, 1)
	kpop	(t0, 2)
	kpop	(t1, 3)
	load	(4)

	// Wow, send an IPC to the pagefault handler
	push	p_all
	tcb	t1
	mov	a0, t0						// first parameter = PF address
	ldq	a0, TCB_PAGER (t1)				// get my pager
	addq	a0, 1, AT
	IF	AT
		mov	t0, t1					// Set address
		bic	t0, 3, t0	
		or	t0, 0x01, t0				// Set IFault
	
		clr	a1					// send msg vect
		ldiq	a2, (0 << 13)|(63 << 2)|(MVR_CLOSEDWAIT | MVR_FLEXPAGE)	// receive paramter
		ldiq	a3, IPC_TIMEOUT_NEVER			// timeout never

		mov	zero, a4
		mov	zero, a5
	
		ldiq	t3, 1

		pal	L4_IPC_ENTRY				// receive the page
		pop	p_all
		return	ret_itb_rerun
	XENDIF
	pop	p_all
	kmsg	"\n\rThread I1 ("
	khex	t1
	kmsg	") doesn't have a pager.\n\r"
	pop	p_all
	debug
	halt

	tcb	t0
	bis	zero, TFS_ABORTED, t1
	stq	t1, TCB_THREAD_STATE (t0)
	return	ret_itb_schedule

	
/*
 *	ITB Protection Fault.
 */
	ALIGN_BRANCH
l4_itb_protection_fault:
	store	(4)
	kpush	(a0, 0)
	kpush	(a1, 1)
	kpush	(t0, 2)
	kpush	(t1, 3)
	srl	sp, TID_S_TASK, t0		// Check for sigma 0 task !
	ldiq	t1, TID_M_TASK
	and	t0, t1, t0
	cmpeq	t0, TASK_SIGMA0, t0
	IF	t0
		extll	a0, 4, a1
		addl	a1, 1, a1
		IF	a1			// ffffffff.xxxxxxxx addresses don't belong to sigma 0
						// Ok, sigma 0 prot fault.
			ldiq	a1, P_SIGMA0BASE
			cmplt	a0, a1, a1
			IFZ	a1  
	
				srl	a0, 13, a1			// PFN
				sll	a1, 32, a1			// insert PFN into a1
				ldiq	t0, 0x0f00			// attributes
				or	t0, a1, a1

				kpop	(t0, 2)
				kpop	(t1, 3)
				load	(4)
				return	ret_itb_fill
			XENDIF
		ENDIF
		khex	a0	
		kmsg	" - Invalid Sigma0 I-access\n\r"
		debug
		halt
	ENDIF

	kpop	(a0, 0)
	kpop	(a1, 1)
	kpop	(t0, 2)
	kpop	(t1, 3)
	load	(4)
	// Wow, send an IPC to the pagefault handler

	push	p_all
	tcb	t1
	mov	a0, t0						// first parameter = PF address
	ldq	a0, TCB_PAGER (t1)				// get my pager
	addq	a0, 1, AT
	IF	AT						// t0 has a page, jippee
		mov	t0, t1					// Set address
		bic	t0, 3, t0	
		or	t0, 0x01, t0				// Set IFault

		clr	a1					// send msg vect
		ldiq	a2, (0 << 13)|(63 << 2)|(MVR_CLOSEDWAIT | MVR_FLEXPAGE)	// receive paramter
		ldiq	a3, IPC_TIMEOUT_NEVER			// timeout never

		clr	a4
		clr	a5
	
		ldiq	t3, 2
	
		pal	L4_IPC_ENTRY				// receive the page
//		kmsg	"I-Prot has replied\n\r"
		pop	p_all
		return	ret_itb_rerun
	XENDIF
	kmsg	"\n\rThread I2 ("
	khex	t1
	kmsg	") doesn't have a pager\n\r"
	pop	p_all
	debug
	halt
	tcb	t0
	bis	zero, TFS_ABORTED, t1
	stq	t1, TCB_THREAD_STATE (t0)
	return	ret_itb_schedule



/*==============================================================================*/

	ALIGN_BRANCH
l4_itb_access_fault:
	subq	sp, 16, sp
	stq	a0, 0(sp)
	stq	a1, 8(sp)

	kmsg	"\n\rThis is an ITB access fault :	"

	ldq	a0, 8(sp)
	ldiq	a1, 64	
	pal	UDBG_PRINT_HEX
	
	ldq	a1, 8(sp)
	ldq	a0, 0(sp)
	addq	sp, 16, sp
	ldiq	a1, 64	
	pal	UDBG_PRINT_HEX

	tcb	t0
	bis	zero, TFS_ABORTED, t1
	stq	t1, TCB_THREAD_STATE (t0)
	bis	zero, zero, a0
	br	k_simple_switch

	


/*****************************************************************************
** Guard faults may occure in Sigma 0 or in any other task.
** In sigma 0 we create TB entries on the fly
*/	

	ALIGN_BRANCH
l4_dtb_guard_fault:
	store	(4)
	kpush	(a0, 0)
	kpush	(a1, 1)
	kpush	(t0, 2)
	kpush	(t1, 3)
	srl	sp, TID_S_TASK, t0		// Check for sigma 0 task !
	ldiq	t1, TID_M_TASK
	and	t0, t1, t0
	cmpeq	t0, TASK_SIGMA0, t0
	IF	t0

		extll	a0, 4, t0
		addl	t0, 1, t0
		IF	t0				// ffffffff.xxxxxxxx addresses don't belong to sigma 0

			ldiq	a1, P_SIGMA0BASE
			cmplt	a0, a1, a1
			IFZ	a1  
							// Ok, sigma 0 prot fault.
				srl	a0, 13, a1			// PFN
				sll	a1, 32, a1			// insert PFN into a1
				ldiq	t0, 0x0ff00			// attributes, 4MB Pages useful ? than 0xff60
				or	t0, a1, a1

				kpop	(t0, 2)
				kpop	(t1, 3)
				load	(4)
				return	ret_dtb_fill
			XENDIF
		ENDIF
		kpop	(a0, 0)
		kpop	(a1, 1)
	
		push	p_a0|p_a1
		khex	a1
		kmsg	" - "
		pop	p_a0|p_a1
		khex	a0	
		kmsg	" - Invalid Sigma0 Dg-access\n\r"
		debug
		halt
	ENDIF

	kpop	(a0, 0)
	kpop	(a1, 1)
	kpop	(t0, 2)
	kpop	(t1, 3)
	load	(4)
		
	push	p_all
	tcb	t1
	mov	a0, t0						// first parameter = PF address
	ldq	a0, TCB_PAGER (t1)				// get my pager
	addq	a0, 1, AT
	IF	AT
		bic	t0, 3, t0
		and	a2, 1, t1
		addq	t1, t1, t1				// t1 = mm_stat << 1
		or	t0, t1, t0				// Set IFault
			
		mov	a1, t1					// t0 has a page, jippee
		clr	a1					// send msg vect 
		ldiq	a2, (0 << 13)|(63 << 2)|(MVR_CLOSEDWAIT | MVR_FLEXPAGE)	// receive paramter
		ldiq	a3, IPC_TIMEOUT_NEVER			// timeout never

		ldiq	t3, 3

		clr	a4
		clr	a5
		
		pal	L4_IPC_ENTRY				// receive the page
		pop	p_all
		return	ret_dtb_rerun
	XENDIF
	push	p_a0|p_a1
	kmsg	"\n\rThread D1 ("
	khex	t1
	kmsg	") doesn't have a pager\n\r"
	pop	p_all
	debug
	halt
	tcb	t0
	bis	zero, TFS_ABORTED, t1
	stq	t1, TCB_THREAD_STATE (t0)
	return	ret_dtb_schedule

	
	ALIGN_BRANCH	
l4_dtb_protection_fault:
	store	(4)
	kpush	(a0, 0)
	kpush	(a1, 1)
	kpush	(t0, 2)
	kpush	(t1, 3)
	srl	sp, TID_S_TASK, t0		// Check for sigma 0 task !
	ldiq	t1, TID_M_TASK
	and	t0, t1, t0
	cmpeq	t0, TASK_SIGMA0, t0
	IF	t0
	
		extll	a0, 4, t0
		addl	t0, 1, t0
		IF	t0				// ffffffff.xxxxxxxx addresses don't belong to sigma 0

			ldiq	a1, P_SIGMA0BASE
			cmplt	a0, a1, a1
			IFZ	a1  
							// Ok, sigma 0 prot fault.
				srl	a0, 13, a1			// PFN
				sll	a1, 32, a1			// insert PFN into a1
				ldiq	t0, 0x0ff00			// attributes, 4MB Pages useful ? than 0xff60
				or	t0, a1, a1

				kpop	(t0, 2)
				kpop	(t1, 3)
				load	(4)
				return	ret_dtb_fill
			XENDIF
		ENDIF
		push	p_a0|p_a1
		khex	a1
		pop	p_a0|p_a1
		khex	a0	
		kmsg	" - Invalid Sigma0 Dp-access\n\r"
		debug
		halt
	ENDIF

	kpop	(a0, 0)
	kpop	(a1, 1)
	kpop	(t0, 2)
	kpop	(t1, 3)
	load	(4)
	
	push	p_all
	tcb	t1
	mov	a0, t0						// first parameter = PF address
	ldq	a0, TCB_PAGER (t1)				// get my pager
	addq	a0, 1, AT
	IF	AT	
		bic	t0, 3, t0
		and	a2, 1, t1
		addq	t1, t1, t1				// t1 = mm_stat << 1
		or	t0, t1, t0				// Set IFault

		mov	a1, t1					// t0 has a page, jippee
		clr	a1					// send msg vect
		ldiq	a2, (0 << 13)|(63 << 2)|(MVR_CLOSEDWAIT | MVR_FLEXPAGE)	// receive paramter
		ldiq	a3, IPC_TIMEOUT_NEVER			// timeout never

		ldiq	t3, 4

		clr	a4
		clr	a5
	
		pal	L4_IPC_ENTRY				// receive the page
		pop	p_all
		return	ret_dtb_rerun
	XENDIF
	kmsg	"\n\rThread D2("
	khex	t1
	kmsg	") doesn't have a pager\n\r"
	pop	p_all
	debug
	halt
	tcb	t0
	bis	zero, TFS_ABORTED, t1
	stq	t1, TCB_THREAD_STATE (t0)
	return	ret_dtb_schedule


	ALIGN_BRANCH
l4_dtb_access_fault:
	subq	sp, 16, sp
	stq	a0, 0(sp)
	stq	a1, 8(sp)

	kmsg	"\n\rThis is a DTB access fault :	"

	ldq	a0, 8(sp)
	ldiq	a1, 64	
	pal	UDBG_PRINT_HEX

	ldiq	a0, 0x20
	pal	UDBG_PRINT_CHAR
	
	ldq	a0, 0(sp)
	ldq	a1, 8(sp)
	addq	sp, 16, sp
	ldiq	a1, 64	
	pal	UDBG_PRINT_HEX

	halt
	
	tcb	t0
	bis	zero, TFS_ABORTED, t1
	stq	t1, TCB_THREAD_STATE (t0)
	bis	zero, zero, a0
	br	k_simple_switch


/***********************************************************************************************/

l4_dtb_tcb_fault:
	store	(19)
	kpush	(t0, 0)
	kpush	(t1, 1)
	kpush	(t2, 2)
	kpush	(t3, 3)
	kpush	(t4, 4)
	kpush	(t5, 5)
	kpush	(t6, 6)
	kpush	(t7, 7)
	kpush	(t8, 8)
	kpush	(t9, 9)
	kpush	(t10, 10)
	kpush	(t11, 11)	
	kpush	(ra, 12)
	kpush	(v0, 13)
	kpush	(a0, 14)
	kpush	(a1, 15)
	kpush	(a2, 16)
	kpush	(a3, 17)
	kpush	(a4, 18)

	
	
	// No sigma 1 installed means, we try to access a TCB
	// during startup
	bsr	ra, mem_grab_frame			// Page is empty !

	srl	v0, 13, v0
	sll	v0, 32, v0
	lda	a1, 0x00001100(v0)			// Page Mask
	bis	zero, 1, t0
	sll	t0, 63, t0
	or	t0, a1, a1
	
	tcb	t0	
	ldiq	t6, PP_WRITABLE
	bis	t6, t6, a4
	bis	zero, 13, a2

	bsr	ra, mem_insert_pte
	
	kpop	(t0, 0)
	kpop	(t1, 1)
	kpop	(t2, 2)
	kpop	(t3, 3)
	kpop	(t4, 4)
	kpop	(t5, 5)
	kpop	(t6, 6)
	kpop	(t7, 7)
	kpop	(t8, 8)
	kpop	(t9, 9)
	kpop	(t10, 10)
	kpop	(t11, 11)	
	kpop	(ra, 12)
	kpop	(v0, 13)
	kpop	(a0, 14)
	kpop	(a1, 15)
	kpop	(a2, 16)
	kpop	(a3, 17)
	kpop	(a4, 18)
	load	(19)
	return	ret_dtb_rerun

dtb_area_sigma:
	//	MSG	("Trying to talk to Sigma 1\n")
	kpop	(t0, 0)
	kpop	(t1, 1)
	kpop	(t2, 2)
	kpop	(t3, 3)
	kpop	(t4, 4)
	kpop	(t5, 5)
	kpop	(t6, 6)
	kpop	(t7, 7)
	kpop	(t8, 8)
	kpop	(t9, 9)
	kpop	(t10, 10)
	kpop	(t11, 11)	
	kpop	(ra, 12)
	kpop	(v0, 13)
	kpop	(a0, 14)
	kpop	(a1, 15)
	kpop	(a2, 16)
	kpop	(a3, 17)
	kpop	(a4, 18)
	load	(19)
	halt
	
/*--------------------------------------------------------------------------------------
** Handle fault in IPC area
** Scan GPT of PARTNER and return it's physical address, or if this is not possible,
** treat it as a normal fault in partners address space.
** NEEDS TO BE REWRITTEN !!!
*/

dtb_ipc_area:
	store	(9)
	kpush	(t0, 0)
	kpush	(t1, 1)
	kpush	(t2, 2)
	kpush	(t3, 3)
	kpush	(t4, 4)
	kpush	(t5, 5)
	kpush	(t6, 6)
	kpush	(ra, 7)
	kpush	(t7, 8)
	ldiq	t1, 0x7fffff
	and	a0, t1, t2					// offset into region
	tcb	t0
	ldq	t0, TCB_COMM_PARTNER (t0)			// Partner
	ldq	t3, TCB_COMM_ADDRESS (t0)			// Partner's base
	bic	t3, t1, t3
	addq	t3, t2, t3
	ldiq	t6, PP_WRITABLE | PP_INTREE			// PP_INTREE protection required
	bsr	ra, mem_translate_address

	kpop	(t0, 0)
	kpop	(t1, 1)
	kpop	(t2, 2)
	kpop	(t3, 3)
	kpop	(t4, 4)
	kpop	(t5, 5)
	kpop	(t6, 6)
	kpop	(ra, 7)
	kpop	(t7, 8)	
	load	(9)

	IF	a1
		bic	a1, PTE_M_ASM, a1			// clear ASM bit, must be flushable by mtpr zero, dtbAsm
		return	ret_dtb_fill
	ENDIF
	//	MSG	("\n\rInvalid IPC Address\n")
	halt
	tcb	t0
	bis	zero, TFS_ABORTED, t1
	stq	t1, TCB_THREAD_STATE (t0)
	return	ret_dtb_schedule


	
dtb_unknown:
	kmsg	"Unknown DTB Fault\n\r"
	tcb	t0
	bis	zero, TFS_ABORTED, t1
	stq	t1, TCB_THREAD_STATE (t0)
	return	ret_dtb_schedule

.END
