/*
**
**	Copyright (c) 1995, Sebastian Schoenberg 
**	E-mail : ss10@irz.inf.tu-dresden.de
**
**	University of Technology Dresden, Department of Computer Science
**	Institute for Operating Systems, Databases and Computer Networks
**
**	$Id: platform.S,v 5.5 1999/11/09 00:42:16 danielp Exp $
**
**
**      Revision 4.3 danielp 1999/02/04
**	Added BWX instruction set support. (21164a)	
*/

#if !defined(lint)
	.data
	.asciz	"$Id: platform.S,v 5.5 1999/11/09 00:42:16 danielp Exp $"
#endif


#include <pal/predef.h>

#include <pal/dc21164.h>
#include <pal/platform.h>
	
#include <pal/macros.h>
#include <pal/regdef.h>

	
#include <pal/l4pal.h>

#include <pal/gasp.h>

#include <pal/handlers/sys_interrupts.h>
	
//#undef HARDHALT

			
#define IPL_K_HIGH	7

	.text

	.base	zero
	
	.globl	sys_halt
	.globl	sys_putchar
	.globl	sys_getchar
	.globl	sys_cwrite
	.globl	sys_Pcwrite

	.globl	sys_interrupt_cont

	.globl	sys_reset


sys_reset:		
/*
** Initialize the serial ports
**
**	Baud rate:	9600 baud
**	Word length:	8 bit characters
**	Stop bits:	1 stop bit
**	Parity:		No parity
**	Modem control:	DTR, RTS active, OUT1 lov, UART interrupts enabled
*/

/*
** Initialize COM1
*/
	OutPortByte(COM1_LCR,LCR_M_DLAB,t0,p7)	// Access clock divisor latch.
	OutPortByte(COM1_DLL,DLA_K_BRG,t0,p7)	// Set the baud rate.
	OutPortByte(COM1_DLH,0,t0,p7)
	OutPortByte(COM1_LCR,LCR_K_INIT,t0,p7)	// Set line control register.
	OutPortByte(COM1_MCR,MCR_K_INIT,t0,p7)	// Set modem control register.
#if 0
	OutPortByte(COM1_IER,0x0F,t0,p7)	// Turn on interrupts.
#else
	OutPortByte(COM1_IER,0x00,t0,p7)	// Turn on interrupts.
#endif
/*
** Flush COM1's receive buffer
*/
Sys_ResetFlushCom1:
	InPortByte(COM1_LSR,t0,p7)		// Read the line status.
	blbc	t0, Sys_ResetCom1Done		// Are we done yet?
	InPortByte(COM1_RBR,t0,p7)		// Read receive buffer reg.
	br	zero, Sys_ResetFlushCom1	// Loop till done.

Sys_ResetCom1Done:
	mb

		
/*
** Initialize COM2
*/
	OutPortByte(COM2_LCR,LCR_M_DLAB,t0,p7)	// Access clock divisor latch.
	OutPortByte(COM2_DLL,DLA_K_BRG,t0,p7)	// Set the baud rate.
	OutPortByte(COM2_DLH,0,t0,p7)
	OutPortByte(COM2_LCR,LCR_K_INIT,t0,p7)	// Set line control register.
	OutPortByte(COM2_MCR,MCR_K_INIT,t0,p7)	// Set modem control register.
#if 0
	OutPortByte(COM2_IER,0x0F,t0,p7)	// Turn on interrupts.
#else
	OutPortByte(COM2_IER,0x00,t0,p7)	// Turn on interrupts.
#endif
/*
** Flush COM2's receive buffer
*/
Sys_ResetFlushCom2:
	InPortByte(COM2_LSR,t0,p7)		// Read the line status.
	blbc	t0, Sys_ResetCom2Done		// Are we done yet?
	InPortByte(COM2_RBR,t0,p7)		// Read receive buffer reg.
	br	zero, Sys_ResetFlushCom2	// Loop till done.

Sys_ResetCom2Done:
	mb

#if 0
/*
** Turn on Byte/Word instruction support in the Chip-Set
*/

	bis	r31, 0x21, t0		/* Load t0 with Byte/word enable bits */
	lda	t1, 0x874(r31)		/* Load t1 with the CIA_CNFG address */
	sll	t1, 28, t1		/* 87.4000.0140 */
	lda	t1, 0x140(t1)
	stl_p	t0, 0(t1)		/* write			 */
	mb				/* make sure it's not queued.	 */
	ldl_p	t0, 0(t1)		/* read to make sure it is there */

/*
** Turn on Byte/Word instruction support in the CPU
*/
	mfpr	t0, icsr		/* read the current icsr value   */
	ldah	t1, (1<<(ICSR_V_BSE-16))(r31) /* Load t1 with the BSE bit*/
	bis	t0, t1, t0		/* Merge the bit patterns	 */
	mtpr	t0, icsr		/* update the icsr		 */ 
	
#endif /* 21164_BWX */
			
/*
**
** The SIO provides an ISA compatible interrupt controller which incorporates
** the functionality of two 82C59 interrupts controllers. The
** controllers are cascaded.
**
** We need to intialize the interrupt controller.
**
** INITIALIZATION COMMAND WORDS (ICW)
**
** Whenever a command is issued with A0=0 and D4=1, this is interpreted as
** Initialization Command Word 1 (ICW1).  ICW1 starts the initialization
** sequence.
** 
** INITIALIZATION COMMAND WORD 1 FORMAT (ICW1):
**
**   A0     D7  D6  D5  D4  D3  D2  D1  D0
** +---+  +---+---+---+---+---+---+---+---+
** | 0 |  | 0 | 0 | 0 | 1 | x | 0 | 0 | 1 |
** +---+  +---+---+---+---+---+---+---+---+
**                          ^   ^   ^   ^
**                          |   |   |   |
**                          |   |   |   +---- ICW4 needed 
**                          |   |   |
**                          |   |   +-------- Cascade mode
**                          |   |
**                          |   +------------ Call address interval of 8
**                          |
**                          +---------------- 0 = Edge triggered mode (INT2)
**                                            1 = Level triggered mode (INT1)
** 
** INITIALIZATION COMMAND WORD 2 FORMAT (ICW2):
**
**   A0     D7  D6  D5  D4  D3  D2  D1  D0
** +---+  +---+---+---+---+---+---+---+---+
** | 1 |  | 0 | 0 | 0 | 0 | 1 | 0 | 0 | 0 |
** +---+  +---+---+---+---+---+---+---+---+
**          ^   ^   ^   ^   ^
**          |   |   |   |   |
**          +---+---+---+---+---------------- T7 - T3 of interrupt vector byte
**
**
** INITIALIZATION COMMAND WORD 3 FORMAT (ICW3):
**
**   A0     D7  D6  D5  D4  D3  D2  D1  D0
** +---+  +---+---+---+---+---+---+---+---+
** | 1 |  | 0 | 0 | 0 | 0 | 0 | 1 | 1 | 0 |
** +---+  +---+---+---+---+---+---+---+---+
**                              ^   ^
**                              |   |
**                              |   +-------- Slave ID: 00110011 (INT2)
**                              |
**                              +------------ IRQ2 input has a slave (INT1)
*/

/* INITIALIZATION COMMAND WORD 4 FORMAT (ICW4):
**
**   A0     D7  D6  D5  D4  D3  D2  D1  D0
** +---+  +---+---+---+---+---+---+---+---+
** | 1 |  | 0 | 0 | 0 | 0 | 0 | 0 | 0 | 1 |
** +---+  +---+---+---+---+---+---+---+---+
**                      ^   ^   ^   ^   ^
**                      |   |   |   |   |
**                      |   +-+-+   |   +---- 80C86/80C88 mode
**                      |     |     |
**                      |     |     +-------- Normal end of interrupt (EOI)
**                      |     |
**                      |     +-------------- Non-buffered mode
**                      |    
**                      +-------------------- Not special fully nested mode
**
** OPERATION CONTROL WORD 1 FORMAT (OCW1):
**
**   A0     D7  D6  D5  D4  D3  D2  D1  D0
** +---+  +---+---+---+---+---+---+---+---+
** | 1 |  | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 |
** +---+  +---+---+---+---+---+---+---+---+
**          ^   ^   ^   ^   ^   ^   ^   ^
**          |   |   |   |   |   |   |   |
**          +---+---+---+---+---+---+---+---- Interrupt mask
**                                            All channels inhibited
**
** OPERATION CONTROL WORD 2 FORMAT (OCW2):
**
**   A0     D7  D6  D5  D4  D3  D2  D1  D0
** +---+  +---+---+---+---+---+---+---+---+
** | 1 |  | 0 | 0 | 1 | 0 | 0 | 0 | 0 | 0 |
** +---+  +---+---+---+---+---+---+---+---+
**          ^   ^   ^
**          |   |   |
**          +---+---+
**              |
**              +---------------------------- Non-specific EOI command
**
**
** See the SD164 Engineering Specification for information on memory 
** address bit definitions and encodings for accessing ISA I/O space.
**
*/

/*
** Initialize the 82C59A priority interrupt controller (PIC)
*/

	OutPortByte(PIC2_ICW1,0x11,t0,p7)
	OutPortByte(PIC2_ICW2,0x08,t0,p7)
	OutPortByte(PIC2_ICW3,0x02,t0,p7)
	OutPortByte(PIC2_ICW4,0x01,t0,p7)

	OutPortByte(PIC2_OCW1,0xFF,t0,p7)

	OutPortByte(PIC1_ICW1,0x11,t0,p7)
	OutPortByte(PIC1_ICW2,0x00,t0,p7)
	OutPortByte(PIC1_ICW3,0x04,t0,p7)
	OutPortByte(PIC1_ICW4,0x01,t0,p7)

	OutPortByte(PIC1_OCW1,0xFF,t0,p7)

/*
** Send -INTA pulses to clear any pending interrupts ...
*/
	IACK(t0,p7)

	
/*
** Finish writing the 82C59A PIC Operation Control Words ...
*/
	OutPortByte(PIC2_OCW2,0x20,t0,p7)
	OutPortByte(PIC1_OCW2,0x20,t0,p7)

/*
** Initialize the real-time clock (RTC)
**
** Index into RTC Control Register A to set periodic interrupt rate
** to 488.281
*/

	
	OutPortByte(RTCADD,0x0A,t0,p7)
	OutPortByte(RTCDAT,0x25,t0,p7)

	
/*
** Index into RTC Control Register B and then enable periodic
** interrupts.
*/

	OutPortByte(RTCADD,0x0B,t0,p7)
	InPortByte(RTCDAT,p5,p7)
	ldiq	t0, 0x40		// Periodic interrupt bit
	bis	p5, t0, p5		// Merge it in

	OutPortByte(RTCADD,0x0B,t0,p7)
	OutPortByteReg(RTCDAT,p5,t0,p7)
	
	
/*
** Initialize the CIA Control Register
*/
	lda	t0, 1(zero)		// Get a 1
	sll	t0, 39, t0		// Place in bit 39
	lda	p7, CIA_BASE(zero)	// Form 87.4000.0100 - CIA_CTRL
	sll	p7, 28, p7
	lda	p7, CIA_CTRL(p7)	// Offset 0x100
	bis	p7, t0, p7		// Do bit 39
	LDLI(p5, CIA_CTRL_K_INIT)	// Load up Initial CIA_CTL value
	stl_p	p5, 0(p7)		// Write CIA_CTRL

	ldiq	p5, 0x02000000
	stq_p	p5, 0x60(zero)

/*
** Enable INTS
*/
	ret	(ra)

	OutPortByte(PIC1_OCW1,0x00,t0,p7)
	OutPortLongReg(INT_SRC_804, zero, t0, p7)

	ret	zero, (ra)	
			
/*-----------------------------------------------------------------------------
** PAL Halt, restore all DM-registers, 
** Write PREG-able register file AT register is scratched !
** Goto Debugging Console
*/

	ALIGN_BRANCH	
sys_halt:

	NewCom2SerialPutChar(0x68,p6,p7) //h	
	
	mtpr	zero, dtbCm
	mtpr	zero, ips
	NOP
	NOP
	
	nop
	br	r0, 1f
	.quad	0	
1:	mfpr	r1, excAddr
	nop
	nop
	stq_p	r1, 0(r0)
	nop
	nop
	//debug
	
	mtpr	zero, dtbCm
	mtpr	zero, ips
	NOP
	NOP
	mtpr	r0, pt23
#ifdef HARDHALT
	ldiq	r0, 0xb000
#else	
	ldiq	r0, 0xa000
#endif	
	
	stq_p	r1, 0x118(r0)
	stq_p	r2, 0x120(r0)
	stq_p	r3, 0x128(r0)
	stq_p	r4, 0x130(r0)
	stq_p	r5, 0x138(r0)
	stq_p	r6, 0x140(r0)
	stq_p	r7, 0x148(r0)
	stq_p	r8, 0x150(r0)
	stq_p	r9, 0x158(r0)
	stq_p	r10, 0x160(r0)
	stq_p	r11, 0x168(r0)
	stq_p	r12, 0x170(r0)
	stq_p	r13, 0x178(r0)
	stq_p	r14, 0x180(r0)
	stq_p	r15, 0x188(r0)
	stq_p	r16, 0x190(r0)
	stq_p	r17, 0x198(r0)
	stq_p	r18, 0x1a0(r0)
	stq_p	r19, 0x1a8(r0)
	stq_p	r20, 0x1b0(r0)
	stq_p	r21, 0x1b8(r0)
	stq_p	r22, 0x1c0(r0)
	stq_p	r23, 0x1c8(r0)
	stq_p	r24, 0x1d0(r0)
	stq_p	r25, 0x1d8(r0)
	stq_p	r26, 0x1e0(r0)
	stq_p	r27, 0x1e8(r0)
	mfpr	r1, pt23
	mfpr	r2, excAddr
	mfpr	r3, ptKSP

	stq_p	r28, 0x1f0(r0)
	stq_p	r29, 0x1f8(r0)
	stq_p	r1, 0x110(r0)
	
	ldiq	AT, 0x200
	addq	r0, AT, r0	

	stq_p	r30,(0x200 - 0x200)(r0)
	stq_p	r3, (0x208 - 0x200)(r0)
 
	subq	r2, 4, r2			# Point to exception raising instruction

	ldiq	AT, 0x200
	addq	r0, AT, r0	

	stq_p	r2, (0x410 - 0x400)(r0)

	mfpr	t2, ptPrevPal
	
	STALL
        STALL
        STALL
	mtpr	t2, palBase

	mfpr	t0, ptPtbr		# Get the physical page table base.
	bis	t0, 1, t0		# Enable physical mode translation.
	mtpr	t0, ptPtbr		# Update the chip.

	LDLI	(sp,0x00FFE000)		# Initialize the kernel stack pointer.

	mtpr	sp, ptKsp		# Update the saved KSP value.

	lda	ps, IPL_K_HIGH(zero)	# Set PS shadow - Kernel mode, IPL=7
	lda	t0, 0x1F(zero)		# Set internal IPL=1F
	mtpr	t0, ipl
	mtpr	zero, ips		# Set Ibox mode to kernel
	mtpr	zero, dtbCm		# Set Mbox mode to kernel

	mtpr	zero, dtbIa		# Flush the DTB
	mtpr	zero, itbIa		# Flush the ITB
	mtpr	zero, astrr		# Clear all ASTs ...
	mtpr	zero, aster
	mtpr	zero, sirr		# Clear all software interrupts.

	LDLI	(sp,0x00FFE000)		# Initialize the kernel stack pointer.

	mtpr	sp, ptKsp		# Update the saved KSP value.


	ldiq	AT, 0x878787
	stq_p	AT, 0x20(zero)	
	
        ldiq     AT, 0x10000

#ifdef HARDHALT
	ldiq	AT, 1
#endif
	mtpr	AT, excAddr
	bis	zero, 7, t0
	STALL
	STALL
	hw_rei_stall



/*
 *	a0 :	character (byte)
 *	a1 :	offset
 */
			
	ALIGN_BRANCH
sys_putchar:
#if 1


	
1:	
        InPortByte(COM2_LSR,p6,p7)

        srl     p6, LSR_V_THRE, p6
        blbc    p6, 1b

        OutPortByteReg(COM2_THR,a0,p6,p7)
	

/*
	NewCom2SerialPutCharReg(a0,p6,p7)
*/

	
        ret	zero, (ra)
#else	
	NOP
	br	t0, 1f

	.long	((0xb8000 << 5) + (0x01 << 3))
	.long	0x00000080
1:	
	ldq_p	t1, 0(t0)			# Load the base address
	sll	a1, 6, t2			# offset into the screen
	addq	t1, t2, t2
	
	ldl_p	t0, 0(t2)
	and	a0, 0xff, t1
	ldiq	t3, 0x1e00
	or	t3, t1, t1			# t1 is character
	
	blbs	a1, 1f
	# lower part to change
	srl	t0, 16, t0
	sll	t0, 16, t0
	or	t0, t1, t0
	stl_p	t0, 0(t2)
	ret	zero, (ra)
	
1:	# higher part
	sll	t0, 48, t0
	srl	t0, 48, t0
	sll	t1, 16, t1
	or	t0, t1, t0
	stl_p	t0, 0(t2)
	ret	zero, (ra)
#endif



	/* v0 :	 character read from console */
	
sys_getchar:
2:	
        InPortByte(COM2_LSR,p6,p7)
	blbc    p6, 2b
	STALL
	STALL
        InPortByte(COM2_THR,v0,p6)
        ret	zero, (ra)
		
	
/*
 *	a0 :	pointer to string
 *	a1 :	start address
 */	
	ALIGN_BRANCH
sys_cwrite:
	push	p_ra|p_t0|p_t1|p_t2|p_a0|p_a1
	bis	a0, a0, t0
	and	a0, 7, t1
	sll	t1, 3, t1
	bis	t0, t0, t2
	
3:	bic	t2, 7, t0
	push	p_p0|p_p1|p_p2|p_p3|p_p4|p_p5|p_p6
	
	ldq_u	a0, 0(t0)
	pop	p_p0|p_p1|p_p2|p_p3|p_p4|p_p5|p_p6	
	srl	a0, t1, a0
	
	and	a0, 0xff, a0
	IF	a0

		bsr	ra, sys_putchar
		addq	t2, 1, t2
		addq	t1, 8, t1
		br	3b
	ENDIF
	pop	p_ra|p_t0|p_t1|p_t2|p_a0|p_a1
	ret	(ra)
	
/*
 *	a0 :	pointer to string
 *	a1 :	start address
 */	
	ALIGN_BRANCH
sys_Pcwrite:
	bis	ra, ra, s3
	bis	a0, a0, s0
	and	a0, 7, s1
	sll	s1, 3, s1
	bis	s0, s0, s2

3:	bic	s2, 7, s0
	ldq_p	a0, 0(s0)
	srl	a0, s1, a0
	
	and	a0, 0xff, a0
	IF	a0

		bsr	ra, sys_putchar
		addq	a1, 1, a1
	
		addq	s2, 1, s2
		addq	s1, 8, s1
		br	3b
	ENDIF
	ret	zero, (s3)


	
	
/*------------------------------------------------------------------------------
** FUNCTION: enqueue_interrupt
**	Enqueue interrupt in p5
**
** MODE: P
**
** INPUT PARAMETERS:
**	p5:	Interrupt NR
**
** OUTPUT PARAMTERES:
** 
** SIDE EFFECTS
**	returns to user
*/
	ALIGN_BRANCH
pal_enqueue_interrupt:
	open_frame

	pal_addr p0, interrupt_owner
	krn_addr p1, interrupt_queue
	s8addq	p5, p0, p0				// Get owner
	ldq_p	p0, 0(p0)

	sll	p5, 4, p4
	addq	p1, p4, p1				// P1 = queue pointer
	
	IF	p0			
		InPortByte (INT_SRC_804, p2, p6)
		and	p2, 0xff, p2
		mov	p2, p4
		OutPortByteReg(INT_SRC_804, p2, p6, p7)
		
		InPortByte (INT_SRC_805, p2, p6)
		and	p2, 0xff, p2
		sll	p2, 8, p2
		or	p2, p4, p4
		OutPortByteReg(INT_SRC_805, p2, p6, p7)

		InPortByte (INT_SRC_806, p2, p6)
		and	p2, 0xff, p2
		sll	p2, 16, p2
		or	p2, p4, p4
		OutPortByteReg(INT_SRC_806, p2, p6, p7)

		IACK (p6, p2)	
		
		stl_a	p4, TCB_INTERRUPT_MASK(p0)
		stl_a	p6, (TCB_INTERRUPT_MASK+4)(p0)
	
		ldq_a	p2, TCB_THREAD_STATE (p0)
		insbl	p5, 1, p6
		mov	p0, p3				// keep target TCB in p3
		cmpeq	p6, p2, p6			// Is the thread allready waiting
		IF	p6				//
			tcb	p0
			
			ldl_a	p2, TCB_SCHED_SCP (p0)	// Priority of myself
			ldl_a	p6, TCB_SCHED_SCP (p3)	// Priority of target
			cmple	p2, p6, p2		// p2 :	p2 <= p6
			IF	p2			// switch immediately if cSCP <= dSCP
				disable_int	p0
				push	p_gp|p_t0
				mov	p3, t0
				kernel	activate_interrupt
			ELSE
				ldiq	p2, TFS_RUNNING
				stq_a	p2, TCB_THREAD_STATE (p3)	// set p0 runnable
				enqueue_busy (p3, p7, p2, p4)		// enqueue in busy queue
			ENDIF				// If Priority is less than enqueue and IRQ and restart interrupted
		ENDIF	
		// NO it is not waiting, then enqueue
		lda	p0, TCB_SEND_ROOT(p0)

		ldq_a	p2, 0(p1)
		
		IFZ	p2
		
			ldq_a	p2, 0(p0)			// p2 = tcb->next
			stq_a	p2, 0(p1)			// Store old next in interrupt->next
			stq_a	p1, 0(p0)			// tcb->next = interrupt
		
			stq_a	p1, 8(p2)			// tcb->next->prev = interrupt; 
			stq_a	p0, 8(p1)			// interrupt->prev = root
		ELSE
			ldq_p	p0, 0x70(zero)
			addq	p0, 1, p0
			stq_p	p0, 0x70(zero)
		
		ENDIF
		close_frame
	ELSE
		InPortByte (INT_SRC_804, p2, p6)
		InPortByte (INT_SRC_805, p2, p6)
		InPortByte (INT_SRC_806, p2, p6)
		IACK (p6, p2)	
		close_frame				// Unexpected interrupt ???
	ENDIF



	ALIGN_BRANCH
activate_interrupt:
	push	p_all

	tcb	t1
	enqueue_busy (t1, t2, t3, t4)
	
	switch_context t0, t10
	switch_thread_kernel t0, activate_interrupt_rerun
	/* NEVER REACHED */
	ALIGN_BRANCH
activate_interrupt_rerun:		
	pop	p_all
	pop	p_gp|p_t0
	return_frame
	
/*------------------------------------------------------------------------------
** FUNCTION: sys_interrupt
**	EB164 specific interrupt handler
**	general interrupt handler
**	in pX register we got:
**
** MODE:
**
** INPUT PARAMETERS:  
**	p5:	target id of current intID
**	p6:	reference ID
**
** OUTPUT PARAMTERES:
** 
** SIDE EFFECTS
**
*/
	ALIGN_BRANCH
sys_interrupt_cont:

	/*
	** Check for a system machine check interrupt or internally 
	** correctable error interrupt ...
	*/
	cmpeq	p5, 31, p4			// Is it a level 31 interrupt?
	bne	p4, sys_error_handler
	/*
	** Check for a power fail interrupt ...
	*/
	cmpeq	p5, 30, p4			// Is it a level 30 interrupt?
	bne	p4, sys_power_fail_handler
	/*
	** Check for a performance counter interrupt ...
	*/
	cmpeq	p5, 29, p4			// Is it a level 29 interrupt?
	bne	p4, sys_perf_handler
	/*
	** Check for an external I/O interrupt ...
	*/
	cmpeq	p5, 23, p4			# Is it a level 23 interrupt?
	bne	p4, sys_int23_handler

	cmpeq	p5, 22, p4			# Is it a level 22 interrupt?
	bne	p4, sys_int22_handler

	cmpeq	p5, 21, p4			# Is it a level 21 interrupt?
	bne	p4, sys_int21_handler

	cmpeq	p5, 20, p4			# Is it a level 20 interrupt?
	bne	p4, sys_int20_handler

	sys_halt 0x2222
	

sys_error_handler:
       	NewCom2SerialPutChar(0x6d,p6,p7) //m	
	sys_halt 0x1234

	ALIGN_BRANCH
sys_power_fail_handler:
	sys_halt 0x2345

	ALIGN_BRANCH
sys_perf_handler:
	mfpr	p0, isr				// Get interrupt summary
	ldah	p1, 0x3800(zero)		// Get Mask for performance counters
	and	p0, p1, p0			// Clear out all other bits
	mtpr	p0, hwIntClr			// Clear performance counter interrupts
	br	pal_enqueue_interrupt


/*
** Int23 Handler
**
** On the EB164 PASS2, this interrupt is reserved. Just dismiss.
*/
sys_int23_handler:
	sys_halt 0x1023

/*
** Int22 Handler
**
** On the EB164, the Int22 Handler is for the Real Time Clock.
**
** The RTC internal registers are accessed using two registers
** located in ISA I/O space:
**
**	RTCADD	0x70	RTC Address Register
**	RTCDAT	0x71	RTC Data Register
**
** On the first access, the address of the desired internal
** register is loaded, and on the second, the data are read
** or written.
**
** After 256 ticks we're parsing the soon_wakeup_queue	

** p7 is used for timer
**
**	p7 = (currentTick << 1) | (some_one woken up)
	
*/

#define RTC_TIMER_TICKS		488

	
	ALIGN_BRANCH
sys_int22_handler:
	open_frame

	tcb	p1

	ldq_a	p3, TCB_SCHED_ACCOUNT(p1)	

	mfpr	p0, ptCurrentTime
	mfpr	p2, ptCurrentTicks

	// This code should probably be moved to INT22_ACK_HANDLER
	
	OutPortByte(RTCADD,0x0C,p6,p7)			// Set up RTCADD to index register C.
	InPortByte(RTCDAT,p6,p7)			// Read to clear interrupt.

	INT22_ACK_HANDLER(p6,p7)

	addq	p3, 1, p3
	stq_a	p3, TCB_SCHED_ACCOUNT(p1)

	ldiq	p1, RTC_TIMER_TICKS
	addq	p0, p1, p0
	mtpr	p0, ptCurrentTime			// in us.
	addq	p2, 1, p2
	mtpr	p2, ptCurrentTicks

	addq	p2, p2, p7				// p2 is current_time * 2
	
	and	p2, 0x3, p1	
	IFZ	p1
		zap	p2, 0xfc, p1
		beq	p1, parse_late_wakeup		
parse_soon_wakeup:					// timestamp is 0x********:******00

		krn_addr p3, system_cb
		lda	p3, SCB_SOON_WAKEUP (p3)
		
		REPEAT
			ldq_a	p5, ISLIST (p3)				// load next from queue
			beq	p5, parse_schedule	

			ldiq	p6, TCB_MASK
			bic	p5, p6, p1				// p1 = TCB start address

			ldl_a	p4, TCB_LIST_STATE (p1)
			and	p4, LLS_WAKEUPS_VALID, p2
			IF	p2

				ldq_a	p6, TCB_TIMEOUT (p1)

			       	cmplt	p0, p6, p6				// p6 = current_time < wakeup
			        cmovne	p6, p5, p3
#ifdef SORTED_SOON_WAKEUP
				bne	p6, parse_schedule
#else		
			        CONT	p6
#endif	
				ldq_a	p2, TCB_THREAD_STATE (p1)
				ldq_a	p6, TCB_KSP (p1)

				or	p7, 1, p7				// set lowest p7 bit
	
				subq	p6, 8, p6
				stq_a	p6, TCB_KSP (p1)
				stq_a	p2, 0(p6)

				pal_addr p2, ipc_ret_timeout+1
				stq_a	p2, TCB_RESTART(p1)			// change rerun address

				ldiq	p2, TFS_RUNNING
				stq_a	p2, TCB_THREAD_STATE (p1)

#ifdef _RTWAKEUP
			        ldl_a   p2, TCB_LIST_STATE (p1)     
			        and     p2, LLS_BUSY_QUEUE, p2     
				IF	p2 
					dequeue_busy (p1, p2, p6, p4)
				ENDIF
#endif				
				enqueue_busy (p1, p2, p6, p4)			// changes list state !

				ldl_a	p4, TCB_LIST_STATE (p1)			
	
			ENDIF
			bic	p4, LLS_SOON_WAKEUP_QUEUE|LLS_WAKEUPS_VALID, p4		// remove from wakeup queue
			stl_a	p4, TCB_LIST_STATE (p1)
		
			delete_l (p5, p3, p2, ISLIST)			// p1 need to be woken up (p3 is prev)

			CONT

		ENDR

parse_late_wakeup:					// timestamp is 0x********:****0000
		krn_addr p3, system_cb
		lda	p3, SCB_LATE_WAKEUP (p3)


		ldq_a	p1, ISLIST (p3)
		beq	p1, parse_soon_wakeup
		halt
		// Not yet implemented
	ENDIF
	close_frame


	ALIGN_BRANCH
parse_schedule:
	IFLBS	p7				/* Timeout ... */
1:		
		disable_int	p0		/* Prevent recoursive timer irq's */
		push	p_gp
		kernel	k_switch_thread	
	ENDIF
	and	p7, 0x3f, p7			/* or timeslice */
	beq	p7, 1b
	close_frame


	
/*-------------------------------------------------------------------------------
** Int21 Handler
**
** IRQ1 - The 'or' of 17 PCI interrupts (IPL3)
**
**	Each of these interrupts can be individually masked by
**	writing to three mask registers at ISA addresses 804h, 805h
**	and 806h.
**
**	A read of these registers will return the state of the
**	17 PCI interrupts and not the state of the MASKED
**	interrupts. Thus it is necessary to know the mask values
**	to determine the real source. The PALcode will let the
**	OS handle all this.
*/	
	ALIGN_BRANCH
sys_int21_handler:
	// We need to check it this is int0 first, if we need to redirect it
#if defined(CONFIG_RUFFIAN)
	ldiq	p6, P_IACK_SC_B
	sll	p6, P_IACK_SC_S, p6
	ldq_p	p7, 0x0(p6)
	and	p7, 0xff, p7
	IFZ	p7
		mb
		mb
		br	sys_int22_handler	// timer interrupt
	ENDIF
#endif
	
	mb
	mb
	br	pal_enqueue_interrupt


/*
** Int20 Handler
**
** NEED TO FIX -
**
** IRQ0 - Corrected system error. Corrected ECC error detected by CIA.
**	  We just take a system machine check (0x660), instead of cleaning up
**	  the error and taking a system correctable machine check (0x620), as
**	  we really should do.
*/
	ALIGN_BRANCH
sys_int20_handler:
	sys_halt	0x120

.END
