/*
**	Copyright (c) 1999, Daniel Potts  danielp@cse.unsw.edu.au
**
**	University of New South Wales, 
**	Department of Computer of Science and Engineering
**
**	This file is distributed under the GPL.
**	See www.gnu.org for more information.
**
**	$Id: sys_miata.S,v 5.2 1999/11/09 00:42:16 danielp Exp $
**
*/

/* Code supporting Miata (EV56 + PYXIS) */

#include <pal/predef.h>

#include <pal/dc21164.h>
#include <pal/macros.h>
#include <pal/regdef.h>
#include <pal/platform.h>

#include <pal/l4pal.h>

#include <pal/debug.h>

#include <pal/gasp.h>

#include <pal/pyxis.h>	
		
	.globl init_interrupts
	

/*----------------------------------------------------------------------------
** FUNCTION: init_interrupts
**	Initialises chipsets involved in timer (and other) interrupts
**
** MODE: K
**
** INPUT PARAMETERS:  
**
** OUTPUT PARAMTERES:
** 
** SIDE EFFECTS:	
**	You get timer interrupts :)
** C-CODE:	
**
**
*/

	ALIGN_BRANCH
init_interrupts:
	kmsg "Enabling Miata (EV56 + PYXIS) interrupts"

	kmsg 	"\n\n\rPYXIS....REQ: "
	ldiq	t0, P_INT_BASE_B
	sll	t0, P_INT_BASE_S, t1
		
	khex	t1, 64

	kmsg	"  reading mask: "
	ldq_p	t2, PO_INT_MASK(t1)
	khex	t2, 64

	// compute mask..
	ldiq	t2, 0x40000000
	sll	t2, 32, t2

	ldiq	t3, ((1<<6)|(1<<7))
	
	// set req lines
	ldq_p	t4, PO_INT_REQ(t1)
	kmsg	" reading Req: "
	khex	t4, 64

	// clear upper timer
	ldiq	t4, 0x00000180
	or	t2, t4, t4
	stq_p	t4, PO_INT_REQ(t1)
	mb
	
	// set mask on chip..
	kmsg	"  writing INT_MASK: "
	khex	t3, 64
	stq_p	t3, PO_INT_MASK(t1)
	mb
	kmsg	"\n new INT_MASK: "
	ldq_p	t3, PO_INT_MASK(t1)
	khex	t3, 64
	
	kmsg	"\n\r....done...\n\r"

#if 0
	/*
	** Initialize the real-time clock (RTC)
**
** Index into RTC Control Register A to set periodic interrupt rate
** to 488.281
*/

	
	OutPortByte(RTCADD,0x0A,t0,p7)
	OutPortByte(RTCDAT,0x25,t0,p7)

	
/*
** Index into RTC Control Register B and then enable periodic
** interrupts.
*/

	OutPortByte(RTCADD,0x0B,t0,p7)
	InPortByte(RTCDAT,p5,p7)
	ldiq	t0, 0x40		// Periodic interrupt bit
	bis	p5, t0, p5		// Merge it in

	OutPortByte(RTCADD,0x0B,t0,p7)
	OutPortByteReg(RTCDAT,p5,t0,p7)
	
	kmsg	"...done...\n\r"
#endif

	ret (ra)
			
.END
