/*
**	Copyright (c) 1999, Daniel Potts  danielp@cse.unsw.edu.au
**
**	University of New South Wales, 
**	Department of Computer of Science and Engineering
**
**	This file is distributed under the GPL.
**	See www.gnu.org for more information.
**
**	$Id: sys_ruffian.S,v 5.2 1999/11/09 00:42:17 danielp Exp $
**
*/

/* Code supporting Ruffian */

#include <pal/predef.h>

#include <pal/dc21164.h>
#include <pal/macros.h>
#include <pal/regdef.h>
#include <pal/platform.h>

#include <pal/l4pal.h>

#include <pal/debug.h>

#include <pal/gasp.h>

#include <pal/pyxis.h>	
		
	.globl init_interrupts
	

/*----------------------------------------------------------------------------
** FUNCTION: init_interrupts
**	Initialises chipsets involved in timer (and other) interrupts
**
** MODE: K
**
** INPUT PARAMETERS:  
**
** OUTPUT PARAMTERES:
** 
** SIDE EFFECTS:	
**	You get timer interrupts :)
** C-CODE:	
**	See linux 2.2.x code. (urr)
**
** NOTES:	
** We need to  do some yucky mask inversion of PYXIS  generally.  I have taken
** much of  this from the  linux code, and  tried to minimise it.   PYXIS only
** seems to care about the lower 32 bits being set, so we can ignore the upper
** bits  and safely assume  they need  to be  zero. We  should probably  use a
** PALtemp register  like pIntMask which  is free and  for the purpose  of the
** mask.   When we start  looking at  other interrupts,  particularly handling
** them in user space we should use this register to store our current mask.
**
*/

	ALIGN_BRANCH
init_interrupts:
	kmsg "Enabling Ruffian interrupts"

	OutPortByte(0x43,0xb6,t1,t2)
	OutPortByte(0x42,0x31,t1,t2)
	OutPortByte(0x42,0x13,t1,t2)
	
	ldiq	t0, P_INT_BASE_B
	sll	t0, P_INT_BASE_S, t0
	
	// Invert 6&7 for i82371
	ldiq	t1, 0x00c0
	stq_p	t1, PO_INT_HILO(t0)	// set HILO (invert bits)
	mb
	ldiq	t1, 0x2064		// set CNFG - should this 2 be set?
	stq_p	t1, PO_INT_CNFG(t0)
	mb
	stq_p	zero, PO_INT_MASK(t0)	// set MASK
	mb
	ldiq	t1, 0xffffffff		// set REQ - do this the proper way!
	stq_p	t1, PO_INT_REQ(t0)
	mb
	
	// The stuff below is done in platform.S, we need to do it here also.
	// (Re)Initialise the PICs.
	OutPortByte(PIC2_ICW1,0x11,t1,t2)
	OutPortByte(PIC2_ICW2,0x08,t1,t2)
	OutPortByte(PIC2_ICW3,0x02,t1,t2)
	OutPortByte(PIC2_ICW4,0x01,t1,t2)
	OutPortByte(PIC2_OCW1,0xFF,t1,t2)

	OutPortByte(PIC1_ICW1,0x11,t1,t2)
	OutPortByte(PIC1_ICW2,0x00,t1,t2)
	OutPortByte(PIC1_ICW3,0x04,t1,t2)
	OutPortByte(PIC1_ICW4,0x01,t1,t2)

	OutPortByte(PIC1_OCW1,0xFF,t1,t2)
	
	// Send PYXIS -INTA pulses to clear any pending interrupts
	ldiq	t1, P_IACK_SC_B
	sll	t1, P_IACK_SC_S, t1
	ldq_p	t2, 0(t1)

	// Finish writing the 82C59A PIC Operation Control Words,
	
	OutPortByte(PIC2_OCW2,0x20,t1,t2)
	OutPortByte(PIC1_OCW2,0x20,t1,t2)

	// Turn on interrupt controller and timer interrupt
	// Need to be really careful here.
	// Our alpha_irq_mask us currently ~0UL
	kmsg "upto here.."
		
	ldiq	t3, 0xff7fffff		// ~ (1 << 16 + 7)
	ldiq	t4, 0xffffffbf
	
	sll	t3, 16, t3
	not	t3, t3
	
	and	t3, t4, t4
	
	stq_p	t4, PO_INT_MASK(t0)
	mb
	// read it back to make sure it got written
	ldq_p	t4, PO_INT_MASK(t0)

	kmsg " upto part2..."
	
	// we need to invert bits 2 and 0
	OutPortByte(PIC1_OCW1,0xfb,t1,t2)	// enable 0

	kmsg " here we go.."

       	OutPortByte(PIC1_OCW1,0xfa,t1,t2)	// enable 2 <- should sum up above?
	
	kmsg	"\n\r....done...\n\r"

/*
** Initialize the real-time clock (RTC)
**
** Index into RTC Control Register A to set periodic interrupt rate
** to 488.281
*/

	
	OutPortByte(RTCADD,0x0A,t0,p7)
	OutPortByte(RTCDAT,0x25,t0,p7)

	
/*
** Index into RTC Control Register B and then enable periodic
** interrupts.
*/

	OutPortByte(RTCADD,0x0B,t0,p7)
	InPortByte(RTCDAT,p5,p7)
	ldiq	t0, 0x40		// Periodic interrupt bit
	bis	p5, t0, p5		// Merge it in

	OutPortByte(RTCADD,0x0B,t0,p7)
	OutPortByteReg(RTCDAT,p5,t0,p7)


	kmsg "....done...."

	
	ret zero, (ra)
	
.END