/*
**	Copyright (c) 1995, Sebastian Schoenberg 
**	E-mail : ss10@irz.inf.tu-dresden.de
**
**	University of Technology Dresden, Department of Computer Science
**	Institute for Operating Systems, Databases and Computer Networks
**
**	$Id: thread.S,v 5.7 1999/11/09 00:42:17 danielp Exp $
**
*/

#if !defined(lint)
	.data
	.asciz	"$Id: thread.S,v 5.7 1999/11/09 00:42:17 danielp Exp $"
#endif

	
#include <pal/predef.h>
	
#include <pal/dc21164.h>
#include <pal/macros.h>
#include <pal/regdef.h>
#include <pal/platform.h>
	
#include <pal/l4pal.h>

#include <pal/debug.h>

#include <pal/gasp.h>

	.globl	lthread_ex_regs
	.globl	task_new
	.globl	thread_schedule

	.globl	create_sigma0
	
	.globl	k_switch_thread
	.globl	k_simple_switch

	.globl	l4_id_nearest
	
	.text

#define BREAK_SPACE

#ifdef DBG_ERROR	
	.globl	thread_error

thread_error:	
	sys_halt	0xeeee	
#endif

	
							
/*------------------------------------------------------------------------------
** FUNCTION: k_thread_switch
**	switches to another thread.
**
** MODE: K called from interrupt !
**
** INPUT PARAMETERS:  
**
** OUTPUT PARAMTERES:
** 
** SIDE EFFECTS:	
**	all threads are stored button-up sorted by their priority.
**	hence, HERE we don't need to start from the highest priority since
**	no thread with MCP > current MCP is activatable.
**
** C-CODE:	
**	maxprio = current->priority;
**	for (n = current->next; ; n = n->prev) {
**		if (n->priority < maxprio) {
**			maxprio = MCP_LOW; 
**			n = dispatcher->next;
**			continue;
**		}
**	}
**
*/

	
	
	
	ALIGN_BRANCH
k_switch_thread:
	push	p_all
	tcb	t0

	enqueue_busy (t0, t1, t2, t3)

	pal_addr t2, thread_priorities
        ldl_a   t1, TCB_SCHED_SCP(t0)
        s4addq  t1, t2, t2
        stl_p   t0, 0(t2)
	
		
	ldiq	t7, MAX_PRIOS+1
	pal_addr t8, (thread_priorities+((MAX_PRIOS+1)*4))

	REPEAT
		EXITZ	t7
		subq	t8, 4, t8
		subq	t7, 1, t7
		ldl_p	t0, 0(t8)
		CONTZ	t0

		ldq	t0, TCB_BUSY_NEXT (t0)
		REPEAT
			ldq	t1, TCB_THREAD_STATE (t0)	
			bic	t1, TFS_RUNNING, t1	
			IFZ	t1					// scan present_queue until found RUNNING thread
				tcb	t2
				xor	t0, t2, t2			// DON'T ACTIVATE MYSELF !
				beq	t2, switch_preempted	

				tcb_dispatcher t1
				cmpeq	t1, t0, t1
				IFZ	t1	
					switch_context t0, t10
				ENDIF
				switch_thread_kernel t0, switch_preempted	
			XENDIF
			dequeue_busy (t0, t1, t2, t3)
			mov	t0, t1
			ldl_p	t0, 0(t8)
			CONT	t0
		ENDR
		CONT	t7
	ENDR	
	kmsg	"Scheduling Error - No Thread Ready\n\r"
	debug
	halt	
	
	ALIGN_BRANCH
switch_preempted:
	pop	p_all
	pop	p_gp					// pop gp since it has been stored BEFORE kernel call
switch_activated:
#ifdef BREAK_SPACE
	push	p_t6|p_t7
	
        InPortByte(COM1_LSR,t6,t7)

	blbc	t6, 9f
	mb
	mb
        InPortByte(COM1_THR,t6,t7)
	
	cmpeq	t6, 0x20, t6
	beq	t6, 9f
	debug
9:
	pop	p_t6|p_t7
#endif	
	return_frame


/*------------------------------------------------------------------------------
** FUNCTION: k_thread_switch
**	switches to another thread.
**
** MODE: P
**
** INPUT PARAMETERS:  
**
** OUTPUT PARAMTERES:
** 
** SIDE EFFECTS
**
*/
	ALIGN_BRANCH
k_simple_switch:
	tcb	t0

	enqueue_busy (t0, t1, t2, t3)		// If not in queue, insert

	pal_addr t2, thread_priorities
        ldl_a   t1, TCB_SCHED_SCP(t0)
        s4addq  t1, t2, t2
        stl_p   t0, 0(t2)
	
	tcb_dispatcher	t1

	IF	a0
		tcb_ptr	a0, t2
		
		ldq_a	t1, TCB_MYSELF (t2)
		cmpeq	t1, a0, t1			// Is a0 a valid thread ID ?
		IF	t1				// no, so take the first one of busy queue.

			xor	t2, t0, t0			// Target == current ?
			beq	t0, switch_activated
	
			ldq	t1, TCB_THREAD_STATE (t2)
			bic	t1, TFS_RUNNING, t1		// Is the current one runnable ?
			IF	t1			// no, so take first one from the busy queue
				switch_context t2, t10
				switch_thread_kernel t2, switch_activated
			XENDIF
		ENDIF		
	ENDIF	

	
	ldiq	t7, MAX_PRIOS+1
	pal_addr t8, (thread_priorities+((MAX_PRIOS+1)*4))

	REPEAT
		EXITZ	t7

		subq	t8, 4, t8
		subq	t7, 1, t7
		ldl_p	t0, 0(t8)
		CONTZ	t0

		ldq	t0, TCB_BUSY_NEXT (t0)
		REPEAT
			ldq	t1, TCB_THREAD_STATE (t0)	
			bic	t1, TFS_RUNNING, t1	
			IFZ	t1					// scan present_queue until found RUNNING thread
				tcb	t2
				xor	t0, t2, t2			// DON'T ACTIVATE MYSELF !
				beq	t2, switch_activated	

				tcb_dispatcher t1
				cmpeq	t1, t0, t1
				IFZ	t1	
					switch_context t0, t10
				ENDIF
				switch_thread_kernel t0, switch_activated	
			XENDIF
			dequeue_busy (t0, t1, t2, t3)
			mov	t0, t1
			ldl_p	t0, 0(t8)
			cmpeq	t0, t1, t2
			IF	t2
				IF	t0
					kmsg	"t0 == t1"
					debug
				ENDIF
			ENDIF
			CONT	t0
		ENDR
		CONT	t7
	ENDR	
	kmsg	"Scheduling Error - No Thread Ready in yield\n\r"
	halt	


/*------------------------------------------------------------------------------
** FUNCTION: scheduler
**
** MODE:
**
** INPUT PARAMETERS:  
**	a0 :	thread_id
**	a1 :	preempter
**	a2 :	parameter
**	
** OUTPUT PARAMTERES:
**	t0 :	partner_id
**	t1 :	old_preempter
**	t2 :	old_parameter
**	t3 :	time_slice
** 
** SIDE EFFECTS
**
*/
	ALIGN_BRANCH
thread_schedule:
	open_frame
	tcb_ptr	a0, v0
	ldq_a	p0, TCB_MYSELF (v0)
	cmpeq	p0, a0, p0
	IF	p0

		// ptest
		// prio test valid:
		ldl_a	p0, TCB_SCHED_MCP (v0)
		tcb	t0
		ldl_a	p1, TCB_SCHED_MCP (t0)			// Intel lte is a BUG ?
		cmpule	p0, p1, p1				// is target MCP <= current MCP
		IFN	p1
			ldiq	t1, -1				// sched param is -1 on error
			close_frame
		ENDIF
		IFZ	p0					// MCP == 0, then not controlable
			ldiq	t1, -1				// sched param is -1 on error
			close_frame
		ENDIF

		ldq_a	t0, TCB_COMM_PARTNER (v0)
		ldq_a	t1, TCB_SCHED_PARAM (v0)
		ldq_a	t2, TCB_PREEMPTER (v0)

		addq	a1, 1, p0
		IF	p0
			stq_a	a1, TCB_PREEMPTER (v0)
		ENDIF
		addq	a2, 1, p0
		IF	p0
			tcb	t4
			ldl_a	t4, TCB_SCHED_MCP (t4)			// current MCP
			and	a2, 0xff, t3
			cmplt	t4, t3, t4				// cnt MCP < new SCP
			IFN	t4
				dequeue_busy (v0, p0, p1, p2)
				stl_a	t3, TCB_SCHED_SCP (v0)		// includes priority
				enqueue_busy (v0, p0, p1, p2)
			ENDIF
		ENDIF
		ldq_a	v0, TCB_SCHED_ACCOUNT (v0)
	
	ENDIF
	close_frame


	
	
	
		
/*------------------------------------------------------------------------------
** FUNCTION: task_new
**	create or allocate new task / TCB structure
**
** MODE: K
**
** INPUT PARAMETERS:  
**	a0  - task id
**	a1  - new chief / MCP
**	a2  - pager id
**	a3  - intital IP
**	a4  - initial lthread0 user sp	(added 990511 danielp)
**
** OUTPUT PARAMTERES:
** 
** SIDE EFFECTS
**
*/
/*
**
** if permitted
**	if ptab-entry >= 0 then
**		delete all subtasks
**		delete this task
**	endif
**
**	if pager is NIL then
**		ptab-entry = tcb of task // less than zero
**	else
**		if ptab-entry is task of current tcb then
**			create active task
**		endif
** 	endif
** endif
**
*/
	ALIGN_BRANCH
task_new:
	open_frame
	kernel	task_new_kern
	
	ALIGN_BRANCH
task_new_kern:
	push	p_ra

	tcb	t0
	tcb_dispatcher t1
	xor	t0, t1, t1					// dispatcher can do everything.
	IF	t1
		ldq_a	t1, TCB_MYSELF (t0)			// get myself id

#ifdef CHIEFTASK
		srl	a0, TID_S_CHIEF, t2
		srl	t1, TID_S_TASK, t3
		ldiq	AT, TID_M_CHIEF				// Chief Mask
	       	xor	t2, t3, t3
		and	t2, AT, t2
		IF	t2						// if chief == 0, task is up for grabs
			and	t3, AT, AT				// AT is 0, if chief of a0 == myself
			bne	AT, tn_failed_permission
		ENDIF
#endif
		xor	a0, t1, t2
		// FIXME:	 what about depth/chief bits  ??
		srl	t2, TID_S_SITE, t2
		ldiq	AT, TID_M_SITE
		and	t2, AT, AT
		bne	AT, tn_failed_permission		// Failed if different site given
	ENDIF

	
	// Well, permissions are ok, now we have the right to modify
	// the task
	task_nr	a0, t0						// Get Task nr of given id

	pal_addr t1, pal_ptroots				// root pointer of ptabs
	s8addq	t0, t1, t0					// page base pointer to.
	ldl_p	t1, 0(t0)					// t0 now the page base	

	IFGE	t1						// there is a page table entry
		bsr	ra, task_delete				// first delete that task including subtasks
	ENDIF

	ldl_p	t1, 0(t0)		
	tcb	t2

	xor	t2, t1, t2
	srl	t2, TID_S_TASK, t2				// task doesn't have the right to create task

	IF	t2
		kmsg	"No permission to create task\n\r"
		pop	p_ra
		clr	v0
		return_frame
	XENDIF

	// Create now the address space from scratch
	IF	a2						// pager given, create active task
		bsr	ra, mem_grab_frame
	
		mov	v0, t0
		pal_addr t1, pal_ptbase

		ldiq	t2, 8
		REPEAT						// Copy the initial kernel page table
			ldq_p	AT, 0(t1)
			addq	t1, 8, t1
			subq	t2, 1, t2
			stq_p	AT, 0(t0)
			addq	t0, 8, t0
			CONT	t2	
		ENDR
		addq	v0, 64-2, v0
		task_nr	a0, t0					// Get Task nr

		pal_addr t1, pal_ptroots			// root pointer of ptabs
		s8addq	t0, t1, t0				// page base pointer t0.
		stl_p	v0, 0(t0)				// v0 now to the page base


		ldiq	AT, TID_M_THREAD
		bic	a0, AT, a0				// a0 is now task id
		tcb_ptr	a0, v0

//		clr	a4					// No sp given

		tcb	t1
		ldl	t2, TCB_SCHED_MCP (t1)
		and	a1, 0xff, a1				// MCP
		cmplt	t2, a1, t3				// cnt MCP < new MCP
		cmovne	t3, t2, a1				// yes a1 is cnt MCP
	
		inswl	a1, 4, a1				// MCP
		ldl	t2, TCB_SCHED_SCP (t1)
		or	a1, t2, a5				// Same SCP as current

		// set up tid correctly
		ldq	t4, TCB_MYSELF (v0)
		ldiq	t5, (TASK_SIGMA0 << TID_S_TASK)	
		sll	v0, (64-TID_S_VER1), t3		       	// == 35, Fabrique my TID
		srl	t3, (64-TID_S_VER1), t3		       	// == 35, Only task_no and thread_no now
	       	sll	t4, (64-TID_S_SITE), t4	
		srl	t4, (64-TID_S_SITE), t4			// Now have upper seg cleared (just incase)

		xor	t3, t5, t5				// check if this is sigma0
		IF	t5
			ldq	t5, TCB_MYSELF (t1)		// load current (chief) id
			srl	t5, TID_S_DEPTH, t2	      	// build depth bits
			addq	t2, 1, t2			// increment depth	
			srl	t5, TID_S_TASK, t5	       	// build chief bits
			sll	t2, TID_S_DEPTH, t2
			sll	t5, TID_S_CHIEF, t5
			or	t2, t4, t4
			or	t5, t4, t4
		ENDIF
//		stq	t4,	TCB_MYSELF(v0)

		ldq	t5, TCB_CHILD_TASK (t1)			// most recent child
		stq	v0, TCB_CHILD_TASK (t1)
		IF	t5
			stq	v0, (TCB_SISTER_TASK+8) (t5)		// set old's prev
		ENDIF
		stq	t5, (TCB_SISTER_TASK) (v0)		// new's next

		bsr	ra, thread_fill_tcb	
	ELSE							// no pager -> grant this task
		tcb_ptr	a1, t1					// now this task is inactive

		stl_p	t1, 0(t0)				
		clr	v0					// now the new task can create this task active
	ENDIF
	pop	p_ra
	return_frame


/*
** delete the task including all subtasks
** t0 is pointer to pt_root entry
** a0 is  task id
**
** t3 is parent if available (or we could put it in the TCB)
** t4, current task we are deleting	
** v0 points to original task always
**		
** execute in kernel mode		
*/	
task_delete:
#if 1	
	tcb	t1					// now the task right belongs to the the deleter
	stl_p	t1, 0(t0)					
	kmsg	"Task deletion not yet implemented\n\r"
	ret	(ra)
#else
	tcb_ptr a0, t4
	mov	t4, v0
task_delete_subtree:
	disable_int
	ldl	t5, TCB_COARSE_STATE(t4)
	ldiq	t2, TCB_DEAD
	cmpeq	t5, t4, t5			// already being deleted?
	bne	t5, task_delete_return
	stl	t2, TCB_COARSE_STATE(t4)
	enable_int

	// FIXME: Above might have priority problems! We should assist rather than ignore..
	
			
	push	p_ra
	push	p_t4

	/* Should probably start by deleting all subtasks first */
	// to do this, lets set the ptroots register to point to each subtask

	// we recurse down to deepest child task, this doesnt take up much stack space.
	
	// t4 = task that will be deleted
	// t2 = (first) subtask of t4

	ldq	t2, TCB_CHILD_TASK (t4)		// subtask of t4
	
	REPEAT
		IF t2				// if we have a subtask, lets go there
			mov	t2, t4
			ldq	t2, TCB_SISTER_TASK(t2)
			push	p_t2
			bsr	ra, task_delete_subtree
			pop	p_t2
			
			CONT
		ENDIF
	ENDR

	pop	p_t4
	ldq	t3, TCB_CHILD_TASK (v0)
	xor	t3, t4, t3
	
	IFZ	 t3				// we are deleting initial task now
		/*  unlink this task from our parent */
		disable_int
		tcb	t1
		ldq	AT, TCB_CHILD_TASK (t1)		// deleter's first child? faster to check NULL instead?
		ldq	t5, TCB_SISTER_TASK (t4)		// deleted's next handled below
		xor	AT, t4, AT
		IFZ	AT
			stq	t5, TCB_CHILD_TASK (t1)			// relink first entry
			clr	t6
		ELSE
			ldq	t6, (TCB_SISTER_TASK+8) (t4)		// deleted's prev
			stq	t5, TCB_SISTER_TASK (t6)
		ENDIF
		// FIXME: We can optimise this branch out iff it is more optimal to use a couple of cmov's
		IF	t5					// do we have a next?
			stq	t6, (TCB_SISTER_TASK+8) (t5)	// set next's prev (new first entry)
		ENDIF
	ENDIF

	/* okay lets kill this (t4) task - set to appropiate state.
	 * stop all threads. Can we really guarantee this without 
	 * destorying the state at this stage?
	 *
	 * The least we do at this stage as mark it as TCS_DEAD so we can scan for this.
	 * Not really a course state, but it will do.
	 */

	disable_int
	bis	zero, TCS_DEAD, t5
	bis	zero, t4, t3
	REPEAT						// while we have threads, lets mark them as dying
		stl	t5, TCB_COARSE_STATE (t3)
		ldq	t2, TCB_LIST_STATE (t3)
		and	t2, LLS_BUSY_QUEUE, t2
		IF      t2
			dequeue_busy(t3, t2, t6, AT)
		ENDIF
			
		ldq	t3, TCB_THREAD_NEXT (t3)	// next child
		CONT	t3
	ENDR

	// FIXME: might be possible to enable interrupts now, but we have to be
	//        sure that no one else enqueue's one of these threads.	

	bis	zero, t4, t3
	REPEAT	// for each thread in task (starting with lthread0)

		bsr	ra, thread_delete
		
		/* next thread */
		ldq	t3, TCB_THREAD_NEXT (t3)
		CONT	t3
	ENDR
	
	/* task and threads should now be unrunnable and invalid */

	/* clean up all busy/wait lists - including thread pending queues */

	/* clean up any other specific thread garbage */

	/* clean up task specific stuff */

	/* unmap address space - clean up mdb */

	// I think we need to loop around here deleting each mapping entry

	// mdb_flush_mapping expects t7 = page table entry, a0 = flexpage bits
	// we keep loopoing until 8(t0) is zero - then the PTE and MDB are clean.
	// we assume at least one mdb entry.
		
	REPEAT
		ldq_p	t1, 8(t0)
	
		mov	t0, t7				// our initial page table entry
		//mov	zero, a0			// full flush including own AS.
		ldiq	a0, 1

		IF	t1
			bsr     ra, mdb_flush_mapping
#ifdef DELETE_DEBUG
			kmsg	"+"
#endif		
			CONT
		ENDIF
	ENDR
	
#ifdef DELETE_DEBUG
	kmsg "\n\rMDB cleaned.\n\r"
#endif	
		
	/* delete address space - clean up gpt */

	// make sure t0 still points to pal_ptroots


	ldl_p	t1, 0(t0)					// t0 now the page base	
	
	/* Make sure our page table pointer is correct */
	ldq	t4, TCB_MYSELF(t4)
	task_nr	t4, t0						// Get Task nr of given id
	pal_addr t1, pal_ptroots				// root pointer of ptabs
	s8addq	t0, t1, t0					// page base pointer to.

	ldl_p	v0, 0(t0)
	tcb	t1				// now the task right belongs to the the deleter
	stl_p	t1, 0(t0)	
		
	enable_int

	bsr	ra, mem_free_tree		// do rest of tree
	
		
	/* flush ASID (do we need to??? The MMT may have already done it */

	mtpr	zero, dtbIa			// FIXME, what should these really be?
	mtpr	zero, itbIa
	
	/* free tcb's */
	
	// not sure if we really should bother.....
	
	/* now we can continue on our merry way - YIPPIE */

	pop	p_ra
task_delete_return:	
	enable_int	
	ret	(ra)
	
#endif
	
tn_failed_permission:
	kmsg	"Access denied\n\r"
	pop	p_ra
	clr	v0
	return_frame
	


/*------------------------------------------------------------------------------
** FUNCTION: lthread_ex_regs
**
** MODE: U
**
** INPUT PARAMETERS:  
**	a0 :	thread_number
**	a1 :	preempter
**	a2 :	pager
**	a3 :	pc
**	a4 :	sp
**
** OUTPUT PARAMTERES:
** 
** SIDE EFFECTS
**
*/
	ALIGN_BRANCH
lthread_ex_regs:
	open_frame
	kernel	lthread_ex_regs_kern

	ALIGN_BRANCH
lthread_ex_regs_kern:		
	push	p_ra
	sra	sp, TID_S_TASK, t0
	and	a0, TID_M_THREAD, a0
	sll	t0, TID_S_TASK, t0
	sll	a0, TID_S_THREAD, a0
	or	a0, t0, v0

	
	ldl	t2, TCB_COARSE_STATE (v0)			// Set Used bit in coarse state	
	IFLBC	t2
		addq	a3, 1, t0				// if a3 or a4 == -1 than exit
		IF	t0
			addq	a4, 1, t0
			IF	t0
				tcb	t0
				ldq	a5, TCB_SCHED_PARAM (t0)// Gets same prio current thread

				// Want to take chief bits of our parent.. put this in t4
				ldq	t4, TCB_MYSELF(t0)
				srl	t4, TID_S_SITE, t4
				sll	t4, TID_S_SITE, t4

				ldq	t2, TCB_THREAD_NEXT (t0)	// task's thread list
				stq	v0, TCB_THREAD_NEXT (t0)
				stq	t2, TCB_THREAD_NEXT (v0)
	
				bsr	ra, thread_fill_tcb	// if this TCB is not used, fill it.
				pop	p_ra
				return_frame
			XENDIF
		ENDIF		
		clr	a1
		clr	a2
		clr	a3

		pop	p_ra
		return_frame
		
	ENDIF
	addq	a1, 1, t0
	ldq	t1, TCB_PREEMPTER (v0)
	IF	t0
		stq	a1, TCB_PREEMPTER (v0)			// Save Preempter if not invalid
	ENDIF
	mov	t1, a1

	addq	a2, 1, t0
	ldq	t1, TCB_PAGER (v0)
	IF	t0
		stq	a2, TCB_PAGER (v0)			// Save pager, if not invalid
	ENDIF
	mov	t1, a2

	lda	t1, TCB_STACKTOP (v0)				// User SP and PC are always ontop
								// of the user stack
	addq	a3, 1, t0
	ldq	t2, -24(t1)
	IF	t0
		stq	a3, -24(t1)				// Load user mode pc

#if 1
		// this needs to be called in a more appropiate place (including stack modification)
		push	p_t1|p_t2|p_t3|p_t5|p_t6|p_t7
		mov	v0, t3
		disable_int
		bsr	ra, thread_delete
		enable_int
		pop	p_t1|p_t2|p_t3|p_t5|p_t6|p_t7
#endif	
	
	ENDIF
	mov	t2, a3
	
	addq	a4, 1, t0
	ldq	t2, -8(t1)

	// I dont know what this code really does..
	
	IF	t0
		stq	a4, -8(t1)					// Load old user mode ip
		mov	t2, a4
		/* now, there may be a in-kernel IPC operation that is going to be
		** terminated - otherwise, simply return
		*/
		ldq	t0, TCB_THREAD_STATE (v0)
		bic	t0, (TFS_LOCKED_WAITING|TFS_LOCKED_RUNNING), t1
		IFZ	t1						// state was locked somewhat 
			pal_addr t2, ipc_ret_abort+1
			lda	t1, (TCB_STACKTOP-4*8) (v0)
			stq	t0, 0(t1)					// "push" the old thread state
			br	ex_kernel
		ENDIF
		bic	t0, (TFS_POLLING), t1
		IFZ	t1
			pal_addr t2, ipc_ret_cancel_polling+1		// state was polling
			lda	t1, (TCB_STACKTOP-3*8) (v0)
			br	ex_kernel
		ENDIF
		bic	t0, (TFS_ABORTED), t1
		IF	t1
			pal_addr t2, ipc_ret_cancel_wait+1		// state was receiving (open/close)
			lda	t1, (TCB_STACKTOP-3*8) (v0)
			br	ex_kernel
		ENDIF
		pop	p_ra
		return_frame
	
	XENDIF
	mov	t2, a4
	pop	p_ra
	return_frame
	
ex_kernel:
	stq	t1, TCB_KSP (v0)
	
	stq	t2, TCB_RESTART (v0)

	ldiq	t2, TFS_RUNNING
	stq	t2, TCB_THREAD_STATE (v0)

	enqueue_busy (v0, t1, t2, t3)
	pop	p_ra
	return_frame
	
/*	
** Create new thread, strictly speaking, fill the TCB
**  
**	v0 - TCB address
**	a1 - preemptor
**	a2 - pager
**	a3 - ip
**	a4 - sp
**	a5 - TCB_SCHED_PARAM
**	t4 - proportion of new tid	
**
** RETURN:	
**	v0 - THREAD_ID
**			
*/		 
thread_fill_tcb:
	ldiq	t2, TCS_USED
	stl	t2, TCB_COARSE_STATE (v0)		// Set Used bit in coarse state

	ldiq	t2, VER_TCB_ALPHA	
	stl	t2, TCB_IDENT (v0)			// Mark TCB(v0) as valid

	stq	a1, TCB_PREEMPTER (v0)
	stq	a2, TCB_PAGER (v0)
	
	lda	t2, TCB_SEND_ROOT (v0)			// Init send queue
	stq	t2, TCB_SEND_ROOT (v0)
	stq	t2, (TCB_SEND_ROOT+8) (v0)

	stq	zero, TCB_WAKEUP_QUEUE (v0)
	

	ldiq	t2, TFS_RUNNING				// Set new thread running
	stq	t2, TCB_THREAD_STATE (v0)

	stq	a5, TCB_SCHED_PARAM(v0)
		
	tcb	t2
	
//	ldq	t4, TCB_MYSELF (v0)

	sll	v0, (64-TID_S_VER1), t3		       	// == 35, Fabrique my TID
	srl	t3, (64-TID_S_VER1), t3		       	// == 35, Only task_no and thread_no now
		
       	addq	t4, 1, t4
	or	t3, t4, t4				// Merge with the ver bits

	// FIXME - possible bug with chief bits when task is reused (they will already be in TCB_MYSELF())

	stq	t4, TCB_MYSELF (v0)			// t4 = thread id
			
	disable_int
	tcb_dispatcher	t2
	insert_ll (v0, t2, t3, TCB_PRESENT_QUEUE)	// Insert v0 into present list after t2, use t3 as temp

	stq	v0, TCB_BUSY_QUEUE (v0)		// Initialize busy queue
	stq	v0, (TCB_BUSY_QUEUE+8)(v0)
	

	bis	zero, LLS_PRESENT_QUEUE, t2
	stl	t2, TCB_LIST_STATE (v0)			// Set list state

	lda	t2, TCB_STACKTOP (v0)			// size of TCB - stack top

	lda	t1, _thread_startup			// Address of schedule in point
	subq	t2, 24, t2
	
	stq	a4, 16(t2)				// +16 stack	 

	subq	zero, 1, t0				// Set to user mode
	stq	t0, 8(t2)				// +8 mode

	bic	a3, 3, a3				// No PAL please !
	
	stq	a3, 0(t2)				// +0 user address
	stq	t2, TCB_KSP (v0)			// set new KSP
	stq	t1, TCB_RESTART (v0)

	enqueue_busy (v0, t1, t2, t3)
	mov	t4, v0
	enable_int
	ret	zero, (ra)



/*------------------------------------------------------------------------------
** FUNCTION: _thread_startup
**	loads the user address from kernel stack and starts that
**	code
**
** MODE: K
**
** SIDE EFFECTS:
**	currently, sets pv to the address of the procedure
**	that allows a simpler call of gcc generated func-
**	tions.
*/
	ALIGN_BRANCH
_thread_startup:
	tcb	a1
	stq_a	zero, TCB_RESTART (a1)
	
	nop
	nop
	ldq	pv, 0(sp)				// load procedure value register
	nop
	return_frame					// this is a gimick...

/*--------------------------------------------------------------
** danielp (original vu2)
** FUNCTION: l4_id_nearest
**	returns the nearest id of a chief for a given id of a task, or 
**	the id of the thread itself
**
** INPUT PARAMETERS:
**
**	a0 : NULL / dest-id
**
** OUTPUT PARAMETERS:
**
**	a0 : id
**      v0 : nesting class - tempory use	
**
** INTERNAL:
**
**	t0 : id_myself
**	t1 : id_dest    - will scratch
**	t2 : tcb_myself
**	t3 : tcb_dest
**
**	Above not really valid! :-/
**      t1 : tcb_id_myself's depth (most of the time)
**	t4 : tcb_id_myself
**	t5 : scratch	
*/

/*
** C-code:
** 	while (myself->depth < dest->depth)
**		dest=dest->chief;
**	if (myself->chief_id == dest->chief_id) return dest_id;
**	else return myself->chief_id;
**	
**  if(myself->chief_id == orig_dest->chief_id) SAME  (return orig_dest)
**  else { loop till depth... {if(myself == dest->chief_id) INNER (return dest_id)} }
**       also INNER if same chief - { if(myself->chief = dest->chief) INNER (return dest_id) }
**  else OUTER (return myself->chief_id)
*/

	.globl	l4_id_nearest		
l4_id_nearest:
	tcb 	t2
	bis 	zero, a0, t1	
	tcb_ptr	t1, t3
	clr	v0				// Clearing it make it look like L4_NC_SAME_CLAN

	ldq	t4, TCB_MYSELF(t2)		// myself
	ldq	a0, TCB_MYSELF(t3)		// orig_dest

       	// check if same chief	
	xor	t4, a0, t6
	srl	t6, TID_S_CHIEF, t6		// ->chief_id
	beq	t6, l4_id_nearest_complete	// myself->chief_id == orig_dest->chief_id then ret orig_dest

	// check if receiver is chief	dest->task_id == myself->chief_id
	ldiq	v0, L4_NC_OUTER_CLAN
	srl	a0, TID_S_TASK, t2
	and	t2, TID_M_TASK, t2
	srl	t4, TID_S_CHIEF, t6
	and	t6, TID_M_CHIEF, t6
	xor	t2, t6, t6
	beq	t6, l4_id_nearest_complete	
			
	// Loop while myself->depth < dest->depth
	srl	t4, TID_S_DEPTH, t1			// preparing the depth

	REPEAT
		srl	a0, TID_S_DEPTH, t5			// and the other 

       		cmpult	t1, t5, t6				// depth_dest>depth_myself
		IF 	t6

      			// check sender as chief
       			srl	t4, TID_S_TASK, t2
			srl	a0, TID_S_CHIEF, t5		// ->chief_id
			xor	t2, t5, t6
			ldiq	t2, TID_M_CHIEF
			and	t6, t2, t6			// apply mask.

			// FIXME - (try to) get rid of possible STALL!! a cmp will do here!
			// WE CAN PROBABLY MOVE THE INNER STUFF (to outside) - as it is..
			IFZ	t6
				ldiq v0, L4_NC_INNER_CLAN	// is this needed (see code below)?
				br zero, l4_id_nearest_complete	// replace with a inner_complete..
			ELSE
			       	// a loop, where the destination depth becomes the same like myself!
				and	t5, t2, t5			// t1 is just the TASK field
				sll	t5, TID_S_TASK, t2		// the new thread-id
				tcb_ptr	t2, t3
				ldq	a0, TCB_MYSELF(t3)
	
				CONT
			ENDIF
		ENDIF
	ENDR

       	// check same chief... myself->chief == dest->chief
	xor	t4, a0, t6
	srl	t6, TID_S_CHIEF, t6		// looking at the chief's ..
	and	t6, TID_M_CHIEF, t6	// NOT NEEDED?
	// FIXME - get rid of possible STALL!!!
	IFZ	t6				// (if t6==0) return dest_id
		ldiq	v0, L4_NC_INNER_CLAN
	ELSE			 		// return myself->chief_id
		ldiq	v0, L4_NC_OUTER_CLAN
     		srl	t4, TID_S_CHIEF, t4
		sll	t4, TID_S_TASK, t4
		tcb_ptr	t4, a0
		ldq	a0, TCB_MYSELF(a0)	// get the right id
       	ENDIF
	br	zero, l4_id_nearest_complete

	
	ALIGN_BRANCH
l4_id_nearest_complete:	
	IFZ a5
		return_frame
	ELSE
		return	ret_nchief_call
	ENDIF
	

/*------------------------------------------------------------------------------
** FUNCTION: create_sigma0
**	create the address space etc. for sigma 0
**
** MODE: K
**
** INPUT PARAMETERS:  
**
** OUTPUT PARAMTERES:
** 
** SIDE EFFECTS
**
*/
	
create_sigma0:
	push	p_ra
	ldiq	a0, (TASK_SIGMA0 << TID_S_TASK)
	ldiq	a1, MCP_HIGH			
	subq	zero, 1, a2
	ldiq	a3, P_SIGMA0BASE
	clr	a4
	pal	L4_TASK_NEW_ENTRY

	mov	v0, a0				// thread id
	ldiq	a1, -1
	ldiq	a2, SCP_NORMAL			// for fun... 
	pal	L4_SCHEDULE_ENTRY

	addq	t1, 1, t0
	IFZ	t0
		kmsg	"Cannot set Sigma0 prio ?"
		debug
	ENDIF
	
	pop	p_ra
	ret	zero, (ra)


/*------------------------------------------------------------------------------
** FUNCTION: thread_delete (danielp)
**	cleans up state of thread including related state queues
**
** MODE: K
**
** INPUT PARAMETERS:  
**      t3 = thread being changed
** OUTPUT PARAMTERES:
** 
** SIDE EFFECTS
**   Scratches:	t1, t2, t5, t6, t7, AT
**
** NOTES
**	Only really tested breaking off thread pending stuff (it works)
**	Other routines may need corrections to the ipc code, like I had to do 
**	for the above. 991012
*/	


#define THREAD_DELETE_DEBUG_MSG 1
	
thread_delete:	
	ldl	t1, TCB_LIST_STATE (t3)
	ldq	t2, TCB_THREAD_STATE (t3)

	disable_int
	
	/* remove if polling */
	and	t2, TFS_POLLING, t5			// This may not be correct op
	IF	t5
#ifdef THREAD_DELETE_DEBUG_MSG
		kmsg	"cleaning up polling thread\n\r"
#endif
		and     t1, LLS_POLLING_QUEUE, t5	// is it really still there?
		IF      t5
#ifdef THREAD_DELETE_DEBUG_MSG
			kmsg	"polling - remove send q entry\n\r"
#endif		
			lda	AT, TCB_SEND_QUEUE (t3)	// delete this entry from send queue
			delete_ll (AT, t5, t6, ISLIST)
		ENDIF
		
		// Normally parse_soon_wakeup fixes this up for us, we have to do it.
		and	t1, LLS_SOON_WAKEUP_QUEUE, t5
		IF	t5
#ifdef THREAD_DELETE_DEBUG_MSG
			kmsg	"cleaning polling thread timeout\n\r"
#endif
			bic     t2, LLS_SOON_WAKEUP_QUEUE|LLS_WAKEUPS_VALID, t2
			stl_a     t2, TCB_LIST_STATE (t3)
			remove_soon_wakeup_timeout t3, t5, t6, t7
		ENDIF
	ENDIF

	/* now break off threads pending for this thread */
	REPEAT
		lda	t6, TCB_SEND_ROOT (t3)
		ldq	t5, 0(t6)
		xor	t5, t6, t5
		IF	t5				// not empty
#ifdef THREAD_DELETE_DEBUG_MSG
			kmsg	"cleaning up polling (send to us)  thread\n\r"
#endif
	
			first_sender(t5 ,t3, t6, t7)	// pop a thread off
	
			ldiq	AT, TCB_MASK  // get tcb pointer
			bic	t5, AT, t5

#ifdef THREAD_DELETE_DEBUG_MSG
			khex	t5, 64
			kmsg	" is polling us\n\r"
#endif	
	
			/* restart them IFF they are not dying as well */
			ldl	t6, TCB_COARSE_STATE (t5)
			and	t6, TCS_DEAD, t6
			IFZ	t6			// not dying
#ifdef THREAD_DELETE_DEBUG_MSG
				kmsg	"thread not in dying state, requeuing\n\r"
#endif	
				/* I'm not sure about this */
				pal_addr t6, ipc_ret_cancel_polling+1	// state was polling
				lda	AT, (TCB_STACKTOP-3*8) (t5)

				stq_a	AT, TCB_KSP (t5)
				stq_a	t6, TCB_RESTART (t5)
				ldiq	t6, TFS_RUNNING
				stq_a	t6, TCB_THREAD_STATE (t5)

				ldl_a	t7, TCB_LIST_STATE (t5)
				and	t7, LLS_SOON_WAKEUP_QUEUE, t6
				IF	t6
#ifdef THREAD_DELETE_DEBUG_MSG
					kmsg	"polling thread timeout remove\n\r"
#endif		
					bic     t7, LLS_SOON_WAKEUP_QUEUE|LLS_WAKEUPS_VALID, t7
					stl_a	t7, TCB_LIST_STATE (t5)
					remove_soon_wakeup_timeout t5, t6, t7, t1
				ENDIF
#ifdef THREAD_DELETE_DEBUG_MSG
				kmsg	"polling thread enqueue\n\r"
#endif	
				enqueue_busy (t5, t6, t7, AT)
			ENDIF
			CONT
		ENDIF
	ENDR

	/* When are we LOCKED_WAITING or LOCKED_RUNNING - rare events perhaps */
	and	t2, TFS_LOCKED_WAITING|TFS_LOCKED_RUNNING, t5
	IF	t5
#ifdef THREAD_DELETE_DEBUG_MSG
		kmsg	"cleaning up locked waiting/running\n\r"
#endif
		ldq_a	t5, TCB_COMM_PARTNER (t3)	// thread to abort
		/* restart them IFF they are not dying as well */
		IF	t5
			ldq_a	t6, TCB_COARSE_STATE (t5)
			and	t6, TCS_DEAD, t6
			IFZ	t6			// not dying
				/* I'm not sure about this */
				pal_addr t6, ipc_ret_cancel_polling+1	// state was polling CORRECT???
				lda	AT, (TCB_STACKTOP-3*8) (t5)

				stq_a	AT, TCB_KSP (t5)
				stq_a	t6, TCB_RESTART (t5)
				ldiq	t6, TFS_RUNNING
				stq_a	t6, TCB_THREAD_STATE (t5)

				enqueue_busy (t5, t6, t7, AT)
			ENDIF
		ENDIF
	ENDIF
	
	ret	zero, (ra)
	

	.data
		
MSG_task_in_use:
	.asciz	"TCB is in use\n\r"

	
	.align	3
.END


