/*
**	Copyright (c) 1995, Sebastian Schoenberg 
**	E-mail : ss10@irz.inf.tu-dresden.de
**
**	University of Technology Dresden, Department of Computer Science
**	Inistute for Operating Systems, Databases and Computer Networks
**
**	$Id: head.S,v 5.0 1999/03/01 05:26:58 danielp Exp $
**
**	$Log: head.S,v $
**	Revision 5.0  1999/03/01 05:26:58  danielp
**	Added tree to CVS, set version to 5.
**	Includes preliminary l4_id_nearest code.
**	Includes UX/Ruffian bug fix.
**
**	Revision 1.1.1.1  1999/03/01 05:09:43  danielp
**	Imported sources
**
**	Revision 4.0  1998/01/12 16:07:18  schoenbg
**	Revision 4.0
**
**	Revision 3.0  1998/01/09 15:02:53  schoenbg
**	PALcall numbers modified
**	New Release
**
**	Revision 1.1  1997/10/16 09:38:18  schoenbg
**	New directory for Sigma0 (task #1)
**
**	It grants task creation rights for all tasks to task #2 and starts
**	task #2
**
**	Task #2 is started at 0x00222000
**
**	Revision 1.2  1997/06/10 12:35:56  schoenbg
**	... lots of changes ;-)
**
**	Revision 1.1  1997/04/14 13:24:32  schoenbg
**	Same sample applications
**
**	flexpage : send a flexpage from sigma 0 to an application in response of
**	a pagefault
**
**	idt: create an interrupt table and raise an exception
**
**	pingpong: create two threads playing ping pong using short messages
**
**	simple: ... hello world on l4 alpha
**
**	Revision 1.1.1.1  1997/01/13 15:56:48  schoenbg
**	L4 for ALpha 21164
**	
**
*/


/* 
** This is base for Sigma 0
** It hopefully fits into one page
*/
	

#include <regdef.h>
#include <pal/palcalls.h>

#define STACKSIZE	0x2000
		
	.text
	.align	3

        .globl  start
	
        .ent    start
 
start:
	nop
	br	pv, 1f
	
1:	ldgp    gp, 0(pv)		# Need a gp, for bootstrap
	nop
	lda	sp, start
	lda	sp, STACKSIZE (sp)
	lda     pv, main
	jsr     ra, (pv), main
	
2:	
	.long	UDBG_DEBUG
	br	zero, 2b

	.end	start

	
	














