/*
**
**	L4 Alpha Kernel
**	Copyright (c) 1996, Sebastian Schoenberg
**	University of Technology Dresden, University of Cambridge
**
*/



#include <l4/types.h>
#include <l4/syscalls.h>
#include <l4/ipc.h>
#include <l4/dit.h>
#include <l4/sigma0.h>

#include <l4/kdebug.h>

qword_t timeout_stack [1024];
Dit_Dhdr *dit_header_page;

#define PAGEMASK 0x1fff


inline void l4_grant_task (l4_threadid_t task, l4_taskid_t destination)
{
  l4_task_new (task, destination.thread_id, 0, 0, L4_NIL_ID);
}

#define SIGMA0_TASK	1	
#define USER0_TASK	2


l4_kernel_info *build_l4_kernel_info(void);
Dit_Dhdr *dump_DITblock(l4_kernel_info *);
Dit_Phdr *get_DITManager(void);
int startServers(l4_taskid_t, l4_threadid_t);

int main (void)
{
    l4_threadid_t myself, from, oid;
    l4_taskid_t tid, des;
    qword_t i, old = -1;
    l4_ipcregs_t regs;  
    l4_msgdope_t retn;
    int num_started = 0;
    Dit_Phdr *resource_manager;
    l4_kernel_info *k_info;
    
    print_string ("Sigma0: Startup.\n\r");
    
    des = tid = myself = l4_myself ();
    tid.id.task = USER0_TASK;
    
    print_string ("Sigma0: I am ");
    print_hex(myself.thread_id, 64); print_string("\n\r");

    /* 
     * Lets find our dit header and get some information.
     */
    
    k_info = build_l4_kernel_info();
    dit_header_page  = dump_DITblock(k_info);
    
    /*
     * Start initial servers.
     */
    
    print_string("Sigma0: Attempting to start initial servers\n\r");
    num_started = startServers(tid, myself);
    
    /*
     * If we have a resource manager specified, 
     * lets give it the right to create new tasks, otherwise only we can.
     */
    
    if((resource_manager = get_DITManager()) != NULL) {
	tid.id.task += num_started;
	/* Should we grant the resource manager rights to initial servers?? currently not */
	for(i = tid.id.task + 1; i < 1024; i++) {
	    des.id.task = i;
	    l4_grant_task (des, tid);
	}
	/* Maximum CP < current CP */ 
	print_string("Sigma0: Starting resource manager (main task)\n\r");
	l4_task_new (tid, 0xf0, 0, resource_manager->p_entry, myself);
    }
    else
	print_string("Sigma0: Warning: No resource manager started\n");
    
    print_string ("Sigma0: Requesting page faults\n\r");
    
    l4_alpha_ipc_wait (&from,
		       NULL,
		       &regs,
		     L4_IPC_NEVER, &retn);
  print_string("S0: wait mdope:");
  print_hex (retn.msgdope, 64);
  while (1) {
//      print_string ("SIGMA0: Request from ");print_hex(from.thread_id, 64);
//      print_string ("\n\rmsgdope=");print_hex(retn.msgdope, 64);
      
      if ((regs.val[0] == old) && (oid.id.task == from.id.task)) {
	  print_string ("Got addr 2 times\n\rAddr "); print_hex (old, 64); 
	  print_string (";  IP = "); print_hex (regs.val[1], 64);
	  print_string ("\n\rFaulting Thread is ");
	  print_hex (oid.thread_id, 64); print_string ("\n\r");
	  enter_kdebug();
      }

      if(regs.val[0] == (long) dit_header_page) {    /* Map read only */
	  print_string("Sigma0: Request for Dit page\n\r");
      }
      
      
      old = regs.val[0]; oid = from;
      regs.val[0] = 
	  regs.val[1] = (regs.val[0] & ~PAGEMASK) | (13 << 2) | 1;
      
//    print_string("\tS0: from = "); print_hex(from.thread_id,64);
//    print_string ("SIG0: Addr "); 
//    print_hex (regs.val[0], 64); print_string("SIG0: IP=");
//    print_hex(regs.val[1],64);print_string("\n\r"); 

    l4_alpha_ipc_reply_and_wait (from,
				 (void*)((qword_t)(NULL) | 0x02),
				 &regs,
				 &from,
				 NULL,
				 &regs,
				 L4_IPC_NEVER, &retn);
//  print_string("S0: replynwait mdope:");
//  print_hex (retn.msgdope, 64);
    if (L4_IPC_IS_ERROR(retn)) {
	print_string ("Cannot send, why ?\n\r");
	print_hex (retn.msgdope, 64);
    }

  }
}

/* HACK - will do (some of) this in kernel later */
l4_kernel_info *build_l4_kernel_info(void) {
    l4_kernel_info *k;
    k = (l4_kernel_info *)0x222000;
    k->dit_hdr = (qword_t) (((qword_t)k) + DIT_HEADER_OFFSET);

    ((char *)&k->magic)[0] = 'L';
    ((char *)&k->magic)[1] = '4';
    ((char *)&k->magic)[2] = 'u';
    ((char *)&k->magic)[3] = 'K';

    /* Fudge some values for mungi (for now) */

    k->memory_size = 0x4000000ULL; /* faked */
    k->kernel      = 0x0238000ULL; /*0x0300000ULL;*/ /*0x022a000ULL;*/
    k->kernel_data = 0x3000000ULL; /* gives it about 50Mb ram */
    return k;
}

Dit_Dhdr *dump_DITblock(l4_kernel_info *k) {
    /* DIT page is (hopefully) located at 0x222000, so lets have a
     * look, and print out the available information. 
     */

    int i;
    Dit_Dhdr *dit_header;
    Dit_Phdr *dit_entry = NULL;

    dit_header = (Dit_Dhdr *) (qword_t) k->dit_hdr;
    
    print_string("DIT: Apparent position:");
    print_hex(dit_header,64);

    if( (dit_header->d_ident[0] == 'd') && (dit_header->d_ident[1] == 'h')) {
        print_string("--\n\rDIT: header found at ");
        print_hex((qword_t)dit_header, 64);
        print_string(". Displaying contents:\n\r");
	dit_entry = (Dit_Phdr *)((qword_t)dit_header +
				(qword_t)dit_header->d_phoff);
	for(i=0;i<dit_header->d_phnum;i++) {
	    print_string(dit_entry[i].p_name);
	    print_string("\t- entry/base/size: ");
	    print_hex(dit_entry[i].p_entry,32);
	    print_hex(dit_entry[i].p_base,32);
	    print_hex(dit_entry[i].p_size,32);
	    if(dit_entry[i].p_flags & DIT_MANAGER)
		print_string(" *");
	    print_string("\n\r");
	}
	print_string("--\n\r");
    }
    else
        print_string("DIT: WARNING no header found.\n\r");

    return dit_header;
}


Dit_Phdr *get_DITManager(void) {
    int i = 0;
    Dit_Phdr *dit_entry = NULL;

    if(dit_header_page) {
        dit_entry = (Dit_Phdr *)((qword_t)dit_header_page + (qword_t)dit_header_page->d_phoff);
        for(;i<dit_header_page->d_phnum;i++) {
	    if(dit_entry[i].p_flags & DIT_MANAGER)
	        return &dit_entry[i];
        }
    }
    return NULL;
}


int startServers(l4_taskid_t initial_tid, l4_threadid_t pager) {
    /* Here we only start those images that are marked with DIT_RUN,
     * EXCEPT for (any) server marked with DIT_MANAGER.
     */
  
    int i = 0, num_servers_started = 0;
    Dit_Phdr *dit_entry = NULL;
    
    if(dit_header_page) {
        dit_entry = (Dit_Phdr *)((qword_t)dit_header_page + 
				 (qword_t)dit_header_page->d_phoff);
        for(;i<dit_header_page->d_phnum;i++) {
	    if((!(dit_entry[i].p_flags & DIT_MANAGER)) && (dit_entry[i].p_flags & DIT_RUN)) {
		l4_task_new(initial_tid, 0xf0, 0, (qword_t)dit_entry[i].p_entry, pager);
		num_servers_started++;
		initial_tid.id.task++;
	    }
        }
    }
    return num_servers_started;
}




