/*
**
**	L4 Alpha Kernel
**	Copyright (c) 1996, Sebastian Schoenberg
**	University of Technology Dresden, University of Cambridge
**
*/



#include <l4/types.h>
#include <l4/syscalls.h>
#include <l4/ipc.h>

#include <l4/kdebug.h>

inline volatile long rpcc ()
{
        register long ret;

#ifdef __alpha__
        __asm__ __volatile__ ("rpcc %0;" : "=r"(ret));
#endif

#ifdef __i386__
        __asm__ volatile ("pushl      %%edx\n"
                          ".byte 0x0f, 0x31\n"
                          "popl       %%edx\n"
                          : "=a" (ret)
                          );
#endif
        return ret;
}


inline void l4delay (l4_threadid_t id, l4_timeout_t to)
{
#ifdef __alpha__
        l4_alpha_ipc_receive (id, 0, 0, to);
#endif
#ifdef __i386__
        dword_t dummy;
        l4_msgdope_t dope;

        l4_i386_ipc_receive (id, 0, &dummy, &dummy, to, &dope);
#endif
}


#define THREADS  64

int stack[64*THREADS];

void loop (void)
{
  l4_threadid_t ms;
#ifdef __alpha__
  l4_schedule (l4_myself(), L4_INVALID_ID, 0x60);
#endif
#ifdef __i386__
  rmgr_set_prio(l4_myself(), 0x60);
#endif
  
  while (1) {
    ms = l4_myself();
  }
}

#ifdef __alpha__

void create_loop_thread (int nr)
{
  l4_threadid_t preempter, pager, pr, pg;
  qword_t oip, osp;

  preempter = pager = L4_INVALID_ID;

  l4_thread_ex_regs (0, -1, -1, &preempter, &pager, &oip, &osp);

  pr = preempter; pg = pager;
  l4_thread_ex_regs (nr, &loop, &stack[64*nr], 
		       &pr, &pg, &oip, &osp);
} 


#endif

#ifdef __i386__
void create_loop_thread (int nr)
{
  l4_threadid_t preempter, pager, id, pr, pg;
  dword_t oip, osp, efl;

  preempter = pager = L4_INVALID_ID;

  id = l4_myself ();
  oip = osp = efl = -1;
  l4_thread_ex_regs (id, -1, -1, &preempter, &pager, &efl, &oip, &osp);

  pr = preempter; pg = pager;
  id.id.lthread = nr;
  efl = -1;
  l4_thread_ex_regs (id, (dword_t)&loop, 
		     (dword_t)&stack[64*nr], 
		     &pr, &pg, &efl, &oip, &osp);

} 

#endif




#define TESTS 16384

int values[TESTS];

void l4dbg_write_string (const char *str);

#ifdef __alpha__
void printdec (int i)
{
        char str[32];
        int r;
        
        if (!i) {
                l4dbg_write_string ("0");
                return;
        }   
                
        str[31] = 0;
        str[30] = '0';
        for (r = 30; r && i; r--) {
                str[r] = '0' + (char)(i % 10);
                i = i / 10;
        }
        l4dbg_write_string (&(str[r+1]));
}
#endif

#ifdef __alpha__
#define ekd			enter_kdebug ()
#endif

#ifdef __i386__
#define printdec                outdec
#define l4dbg_write_string      kd_display         
#define ekd			enter_kdebug("ekd")
#endif
       
#define RAND_MAX	0x7ffffffUL

int rand(void)
{
  static unsigned int next = 1;

  next = next * 1103515245 + 12345;
  return (  (next >>16) & RAND_MAX);
}

#ifdef __alpha__
#define CYCLE 433UL
#endif
#ifdef __i386__
#define CYCLE 133UL
#endif


void wait_rand (void)
{
  unsigned rpe;

  rpe = (rand() % (2000*CYCLE)) + rpcc(); 
  while (rpcc() < rpe) __asm__ ("nop");
}





void main ()
{
        int i, j;
        register l4_threadid_t ms = l4_myself();

        volatile long old, new;

	l4dbg_write_string ("Start threads");

        l4dbg_write_string ("Starting tests\n\r");
        for (i = 0; i < TESTS; i++) {
                values[i] = 0;
        }

#ifdef __alpha__
        l4delay (ms, L4_IPC_TIMEOUT (0,0, 719, 1, 0,0));
#endif
#ifdef __i386__
        l4delay (ms, L4_IPC_TIMEOUT (0,0, 180, 12, 0,0));
#endif        

	for (j = 0; j < 64; j++) {
	  for (i = 0; i < 256; i++) {
	    old = rpcc();
#ifdef __alpha__
	    l4delay (ms, L4_IPC_TIMEOUT (0,0, 719, 1, 0,0));
#endif
#ifdef __i386__
	    l4delay (ms, L4_IPC_TIMEOUT (0,0, 180, 12, 0,0));
#endif        
	    new = rpcc ();
	    wait_rand ();

	    values[i+j*256] = new - old;
	  }
	  printdec (j+1); l4dbg_write_string (" is thread\n\r");
	  create_loop_thread (j+1);
	}

        l4dbg_write_string ("Tests done\n\r");
        for (i = 0; i < TESTS; i++) {
                printdec (values[i]);
                l4dbg_write_string ("\n\r");
        }
	ekd;
}
