/*
**
**	L4 Alpha Kernel
**	Copyright (c) 1996, Sebastian Schoenberg
**	University of Technology Dresden, University of Cambridge
**
*/



#include <l4/types.h>
#include <l4/syscalls.h>
#include <l4/ipc.h>

#include <l4/kdebug.h>

#include <thread.h>

#define PAGEMASK 0x1fff

qword_t timeout_stack [1024];

qword_t _new_thread1_stack[1024];
qword_t _new_thread2_stack[1024];
qword_t _new_thread3_stack[1024];


struct _flexpage_msg {
  qword_t rcv_flexpage;
  qword_t size_dope;
  qword_t send_dope;
  qword_t pl, ph;
};

volatile char *memory = (char *)0;
long int runsp = 0x800000;
long int oldsp;

struct _flexpage_msg flexpage_msg = {
  0,
  (1 << 14) | (0 << 8),
  (1 << 14) | (0 << 8),
  0x0000000000000000,
  0x0000000002000034,
};


volatile l4_threadid_t addr1_thread2;
volatile l4_threadid_t addr1_thread3;

#define NEW1	2
#define NEW2	1020
#define NEW3    1021

inline void l4_grant_task (l4_threadid_t task, l4_taskid_t destination)
{
  l4_task_new (task, destination.thread_id, 0, 0, L4_NIL_ID);
}

void new_thread2(void) {
    l4_msgdope_t result;
    l4_threadid_t from;

    addr1_thread2 = l4_myself();
    print_string("THREAD2: G'day\n\rTHREAD2: My id:");
    print_hex(l4_myself().thread_id, 64); print_string("\n\r");

    while(addr1_thread3.thread_id==-1) {
	print_string(".");
	l4_alpha_ipc_receive (l4_myself(),
                    NULL, NULL, L4_IPC_TIMEOUT (0, 0, 6250, 1, 0,0),&result);
    }

    /* lets see how our friend relates to us */
    print_string("THREAD2: direction of THREAD3=");
    print_hex(l4_id_nearest(addr1_thread3, &from),64); print_string("\n\r");

    /* now ping pong our friend */
    while(1) {
	l4_alpha_ipc_receive (l4_myself(),
                    NULL, NULL, L4_IPC_TIMEOUT (0, 0, 6250, 1, 0,0),&result);
//	l4_alpha_ipc_reply_and_wait(addr1_thread3, NULL, NULL, &from, NULL,
//				    NULL, L4_IPC_NEVER, &result);
	
	/* LETS TRY CLOSED WAITS HERE!!!- possible bug? */

	l4_alpha_ipc_send (addr1_thread3,
                    NULL, NULL, L4_IPC_NEVER, &result);
	print_string("s");
	l4_alpha_ipc_wait(&from, NULL, NULL, L4_IPC_NEVER, &result);
       	print_string("ping");
    }


}

void new_thread3(void) {
    l4_msgdope_t result;
    l4_threadid_t from;

    addr1_thread3 = l4_myself();
    print_string("THREAD3: G'day\n\rTHREAD3: My id:");
    print_hex(l4_myself().thread_id, 64); print_string("\n\r");

    while(addr1_thread2.thread_id==-1) {
	print_string(",");
	l4_alpha_ipc_receive (l4_myself(),
                    NULL, NULL, L4_IPC_TIMEOUT (0, 0, 6250, 1, 0,0),&result);
    }
   /* lets see how our friend relates to us */
    print_string("THREAD3: direction of THREAD2=");
    print_hex(l4_id_nearest(addr1_thread2, &from),64); print_string("\n\r");

    /* now ping pong our friend */
    l4_alpha_ipc_receive(addr1_thread2, NULL, NULL, L4_IPC_NEVER, &result);
    while(1) {
       	print_string("pong");
	l4_alpha_ipc_reply_and_wait(addr1_thread2, NULL, NULL, &from, NULL,
				    NULL, L4_IPC_NEVER, &result);
    }

}

void new_thread1(void) {
    l4_threadid_t root_main9_tid, sendtotest, from;
    l4_msgdope_t result;
    int direction;
    root_main9_tid.thread_id = 0x1fe00001;

    print_string("THREAD1: hi I'm here! :)\n\rTHREAD1: My id:");
    print_hex(l4_myself().thread_id, 64);
    
    print_string("\n\rTHREAD1: Chief idbits:");
    print_hex(l4_myself().id.chief, 32);
    print_string("\n\r");

    while(1) {print_string("q"); l4_alpha_ipc_receive (l4_myself(),
                    NULL, NULL, L4_IPC_TIMEOUT (0, 0, 6250, 1, 0,0),&result);}

}

void root_main9 (void)
{
  l4_threadid_t ms, pager, preempter, from,  new_thread1_tid;
  l4_taskid_t tid;
  qword_t dummy;
  l4_ipcregs_t regs;  
  l4_msgdope_t result;

  print_string("NEW2 running..YES YES YES\n\r");

  print_hex (l4_myself().thread_id, 64);
  print_string (" is a new task NEW2 G'day\n\r"); /* 000000001fe00001 */

  new_thread1_tid = l4_myself();
  new_thread1_tid.id.lthread = 10;

  /* lets create a new thread.. */
  CreateThread(10, 0, new_thread1, &_new_thread1_stack[1023],  (void*)10);
  print_string("NEW2: thread created!\n\r\n\r");

  while (1) {
     print_string("T");l4_alpha_ipc_receive (l4_myself(),
                    NULL, NULL, L4_IPC_TIMEOUT (0, 0, 6250, 1, 0,0),&result);
  }
}

/* root_main8() */
int main (void) 
{
  l4_threadid_t ms, pager, preempter, from, sigma0, oid;
  l4_taskid_t tid;
  qword_t dummy;
  l4_ipcregs_t regs;  
  l4_msgdope_t result;
  qword_t q, old;
  qword_t fault_addr;
  qword_t  *p;
  char d;

  __asm__ ("lda $0, oldsp; stq $30, 0($0)\n");
 
  __asm__ ("lda $0, runsp; ldq $30, 0($0)\n");
  runsp +=0x8000;
  print_string("STACK:_");print_hex(runsp,64);
  print_string("OLDSTACK:");print_hex(oldsp,64);

  old = -1;
  print_string("\n\rHi\n\r");
  ms = tid = l4_myself();

  sigma0.thread_id = 0x80001;

  if(tid.id.task == NEW2)
      root_main9();

  addr1_thread2.thread_id = -1;
  addr1_thread3.thread_id = -1;

  print_hex (l4_myself().thread_id, 64);
  print_string (" is a new task NEW1\n\r"); /* 0000000000100001 */


  print_string("\n\rNEW1: Creating our THREADs\n\r");
  CreateThread(10, 0, new_thread2, &_new_thread2_stack[1023],  (void*)10);
  CreateThread(11, 0, new_thread3, &_new_thread3_stack[1023],  (void*)11);
  print_string("\n\rNEW1: threads created!\n\r");

  print_string ("NEW1: Create New Task NEW2\n\r");

  tid.id.task = NEW2;
  tid.id.chief = 2;

  print_string("NEW1: This should be NEW2's id:");
  print_hex(tid.thread_id, 64); print_string("\n\r\n\r");

  l4_task_new (tid, 0xf0,  0x820000, root_main9, l4_myself());

  print_string ("NEW1: created task NEW2\n\r");

  l4_alpha_ipc_wait (&from,
		     NULL,
		     &regs,
		     L4_IPC_NEVER, &result);
  print_string("NEW1:wait dope:");
  print_hex (result.msgdope, 64);

  while (1) {
      print_string("waiting'ish\n\r");

      print_string ("NEW1: Request from ");print_hex(from.thread_id, 64);
      print_string ("\n\rNEW1dope=");print_hex(result.msgdope, 64);

      if ((regs.val[0] == old) && (oid.id.task == from.id.task)) {
	  print_string ("N1:Got addr 2 times\n\rAddr "); print_hex (old, 64); 
	  print_string (";  IP = "); print_hex (regs.val[1], 64);
	  print_string ("\n\rN:Faulting Thread is ");
	  print_hex (oid.thread_id, 64); print_string ("\n\r");
      }
      old = regs.val[0]; oid = from;
      d +=memory[regs.val[0]];
      regs.val[0] = 
	  regs.val[1] = ((regs.val[0]) & ~PAGEMASK) | (13 << 2) | 1;
      print_string ("NEW1: Addr "); print_hex (regs.val[0], 64); 

//#define SINGLE 1

#ifdef SINGLE    
    l4_alpha_ipc_send (from, 
		       (void*)((qword_t)(NULL) | 0x02),
		       &regs,
		       L4_IPC_NEVER, &result);
  print_string("NEW1: send mdope:");
  print_hex (result.msgdope, 64);
    if (L4_IPC_IS_ERROR(result)) {
	print_string ("Cannot send, why ?\n\r");
	print_hex (result.msgdope, 64);
    }
    print_string("\n\rNEW1:coolieo\n\r");
    l4_alpha_ipc_wait (&from,
		       NULL,
		       &regs,
		       L4_IPC_NEVER, &result);
  print_string("NEW1: wait mdope:");
  print_hex (result.msgdope, 64);
    if (L4_IPC_IS_ERROR(result)) {
	print_string ("Cannot wait, why ?\n\r");
	print_hex (result.msgdope, 64);
    }
#else

      l4_alpha_ipc_reply_and_wait (from,
				 (void*)((qword_t)(NULL) | 0x02),
				 &regs,
				 &from,
				 NULL,
				 &regs,
				 L4_IPC_NEVER, &result);
      print_string("NEW1:reply'n'wait dope:\n\r");
      print_hex (result.msgdope, 64);
    if (L4_IPC_IS_ERROR(result)) {
	print_string ("Cannot send, why ?\n\r");
	print_hex (result.msgdope, 64);
    }
    print_string ("Flexpage replyed taskNEW1\n\r");
#endif
  }

  print_string("NEW1: I SHOULDNT GET HERE\n\r");

  enter_kdebug ();
  while (1);

  return 0;
}

        


void timeout_thread (void)
{
    l4_msgdope_t result;

    l4_alpha_ipc_receive (l4_myself(), NULL, NULL, 
			  L4_IPC_TIMEOUT (0, 0, 6250, 1, 0,0),&result);
    print_string ("Emergency Timeout\n");
    enter_kdebug ();
    halt();
}



